/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.rendering.api;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ResourceValueImpl;
import com.android.ide.common.rendering.api.StyleItemResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.resources.ResourceType;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Collection;

public class StyleResourceValueImpl
extends ResourceValueImpl
implements StyleResourceValue {
    private String parentStyle;
    private final Table<ResourceNamespace, String, StyleItemResourceValue> styleItems = HashBasedTable.create();

    public StyleResourceValueImpl(ResourceNamespace namespace, String name2, String parentStyle, String libraryName) {
        super(namespace, ResourceType.STYLE, name2, null, libraryName);
        this.parentStyle = parentStyle;
    }

    public StyleResourceValueImpl(ResourceReference reference, String parentStyle, String libraryName) {
        super(reference, null, libraryName);
        assert (reference.getResourceType() == ResourceType.STYLE);
        this.parentStyle = parentStyle;
    }

    public static StyleResourceValueImpl copyOf(StyleResourceValue style) {
        StyleResourceValueImpl copy2 = new StyleResourceValueImpl(style.getNamespace(), style.getName(), style.getParentStyleName(), style.getLibraryName());
        for (StyleItemResourceValue item : style.getDefinedItems()) {
            copy2.addItem(item);
        }
        return copy2;
    }

    @Override
    public String getParentStyleName() {
        return this.parentStyle;
    }

    @Override
    public StyleItemResourceValue getItem(ResourceNamespace namespace, String name2) {
        return this.styleItems.get(namespace, name2);
    }

    @Override
    public StyleItemResourceValue getItem(ResourceReference attr) {
        assert (attr.getResourceType() == ResourceType.ATTR);
        return this.styleItems.get(attr.getNamespace(), attr.getName());
    }

    @Override
    public Collection<StyleItemResourceValue> getDefinedItems() {
        return this.styleItems.values();
    }

    public void addItem(StyleItemResourceValue item) {
        ResourceReference attr = item.getAttr();
        if (attr != null) {
            this.styleItems.put(attr.getNamespace(), attr.getName(), item);
        }
    }

    @Override
    public void replaceWith(ResourceValue style) {
        assert (style instanceof StyleResourceValueImpl) : style.getClass() + " is not StyleResourceValue";
        super.replaceWith(style);
        if (style instanceof StyleResourceValueImpl) {
            this.styleItems.clear();
            this.styleItems.putAll(((StyleResourceValueImpl)style).styleItems);
        }
    }
}

