/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.repository;

import com.android.ide.common.gradle.Dependency;
import com.android.ide.common.gradle.RichVersion;
import com.android.ide.common.gradle.Version;
import com.android.ide.common.gradle.VersionRange;
import com.android.ide.common.repository.AgpVersion;
import com.android.ide.common.repository.GoogleMavenRepository;
import com.android.ide.common.repository.GoogleMavenRepositoryKt;
import com.android.ide.common.repository.NetworkCache;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b&\u0018\u0000 /2\u00020\u0001:\u0003./0B1\b\u0007\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0002J$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016J\"\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u00142\u0010\b\u0002\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u001aJ*\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u00142\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u001a2\b\b\u0002\u0010\u001c\u001a\u00020\bJ:\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u0016\b\u0002\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b\u0018\u00010\u001d2\b\b\u0002\u0010\u001c\u001a\u00020\bJ2\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u001a2\b\b\u0002\u0010\u001c\u001a\u00020\bJ\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fJ\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\f0\u001f2\u0006\u0010\u0010\u001a\u00020\fJ\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0\u001fJ\u0018\u0010#\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\b\u0012\u00060\rR\u00020\u00000\u000bH\u0002J*\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b0\u001d2\u0014\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b\u0018\u00010\u001dH\u0002J\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00160\u001f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fJ\u000e\u0010&\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\fJ\u0012\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\fH\u0014J(\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020(2\u0016\u0010-\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\b\u0012\u00060\rR\u00020\u00000\u000bH\u0002R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\b\u0012\u00060\rR\u00020\u0000\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/android/ide/common/repository/GoogleMavenRepository;", "Lcom/android/ide/common/repository/NetworkCache;", "cacheDir", "Ljava/nio/file/Path;", "networkTimeoutMs", "", "cacheExpiryHours", "useNetwork", "", "(Ljava/nio/file/Path;IIZ)V", "packageMap", "", "", "Lcom/android/ide/common/repository/GoogleMavenRepository$PackageInfo;", "findArtifact", "Lcom/android/ide/common/repository/GoogleMavenRepository$ArtifactInfo;", "groupId", "artifactId", "findCompileDependencies", "", "Lcom/android/ide/common/gradle/Dependency;", "version", "Lcom/android/ide/common/gradle/Version;", "findVersion", "dependency", "filter", "Ljava/util/function/Predicate;", "predicate", "allowPreview", "Lkotlin/Function1;", "getAgpVersions", "", "Lcom/android/ide/common/repository/AgpVersion;", "getArtifacts", "getGroups", "getPackageMap", "getSnapshotVersionFilter", "getVersions", "hasGroupId", "readDefaultData", "Ljava/io/InputStream;", "relative", "readMasterIndex", "", "stream", "map", "ArtifactInfo", "Companion", "PackageInfo", "sdk-common"})
@SourceDebugExtension(value={"SMAP\nGoogleMavenRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoogleMavenRepository.kt\ncom/android/ide/common/repository/GoogleMavenRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,356:1\n1#2:357\n*E\n"})
public abstract class GoogleMavenRepository
extends NetworkCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Map<String, PackageInfo> packageMap;
    @NotNull
    public static final String MAVEN_GOOGLE_CACHE_DIR_KEY = "maven.google";

    @JvmOverloads
    public GoogleMavenRepository(@Nullable Path cacheDir, int networkTimeoutMs, int cacheExpiryHours, boolean useNetwork) {
        super(GoogleMavenRepositoryKt.GMAVEN_BASE_URL, MAVEN_GOOGLE_CACHE_DIR_KEY, cacheDir, networkTimeoutMs, cacheExpiryHours, useNetwork);
    }

    public /* synthetic */ GoogleMavenRepository(Path path, int n2, int n3, boolean bl2, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 1) != 0) {
            path = null;
        }
        if ((n4 & 2) != 0) {
            n2 = 3000;
        }
        if ((n4 & 4) != 0) {
            n3 = (int)TimeUnit.DAYS.toHours(1L);
        }
        if ((n4 & 8) != 0) {
            bl2 = true;
        }
        this(path, n2, n3, bl2);
    }

    public final boolean hasGroupId(@NotNull String groupId) {
        Intrinsics.checkNotNullParameter(groupId, "groupId");
        return this.getPackageMap().get(groupId) != null;
    }

    @Nullable
    public final Version findVersion(@NotNull Dependency dependency, @Nullable Predicate<Version> filter2) {
        Intrinsics.checkNotNullParameter(dependency, "dependency");
        return this.findVersion(dependency, filter2, dependency.getExplicitlyIncludesPreview());
    }

    public static /* synthetic */ Version findVersion$default(GoogleMavenRepository googleMavenRepository, Dependency dependency, Predicate predicate, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findVersion");
        }
        if ((n2 & 2) != 0) {
            predicate = null;
        }
        return googleMavenRepository.findVersion(dependency, predicate);
    }

    @Nullable
    public final Version findVersion(@NotNull Dependency dependency, @Nullable Predicate<Version> predicate, boolean allowPreview) {
        Function1 filter2;
        Intrinsics.checkNotNullParameter(dependency, "dependency");
        String string2 = dependency.getGroup();
        if (string2 == null) {
            return null;
        }
        String group = string2;
        Function1 function1 = filter2 = dependency.getHasExplicitDistinctUpperBound() ? (Function1)new Function1<Version, Boolean>(dependency, predicate){
            final /* synthetic */ Dependency $dependency;
            final /* synthetic */ Predicate<Version> $predicate;
            {
                this.$dependency = $dependency;
                this.$predicate = $predicate;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull Version v2) {
                boolean bl2;
                Intrinsics.checkNotNullParameter(v2, "v");
                if (GoogleMavenRepository.access$findVersion$predicate(this.$predicate, v2)) {
                    RichVersion richVersion = this.$dependency.getVersion();
                    if (richVersion != null ? richVersion.contains(v2) : true) {
                        bl2 = true;
                        return bl2;
                    }
                }
                bl2 = false;
                return bl2;
            }
        } : (Function1)new Function1<Version, Boolean>(dependency, predicate){
            final /* synthetic */ Dependency $dependency;
            final /* synthetic */ Predicate<Version> $predicate;
            {
                this.$dependency = $dependency;
                this.$predicate = $predicate;
                super(1);
            }

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public final Boolean invoke(@NotNull Version v2) {
                boolean bl2;
                Intrinsics.checkNotNullParameter(v2, "v");
                if (GoogleMavenRepository.access$findVersion$predicate(this.$predicate, v2)) {
                    RichVersion richVersion = this.$dependency.getVersion();
                    if (richVersion != null ? richVersion.accepts(v2) : true) {
                        bl2 = true;
                        return bl2;
                    }
                }
                bl2 = false;
                return bl2;
            }
        };
        if (Intrinsics.areEqual(group, "androidx.work")) {
            Range<Comparable> range = Range.closedOpen((Comparable)Version.Companion.parse("2.7"), (Comparable)Version.Companion.parse("2.7.0"));
            Intrinsics.checkNotNullExpressionValue(range, "range");
            VersionRange excludedRange = new VersionRange(range);
            RichVersion richVersion = dependency.getVersion();
            boolean bl2 = richVersion != null ? richVersion.accepts(Version.Companion.prefixInfimum("2.7.0")) : false;
            if (bl2) {
                ArtifactInfo artifactInfo = this.findArtifact(group, dependency.getName());
                if (artifactInfo == null) {
                    return null;
                }
                ArtifactInfo artifactInfo2 = artifactInfo;
                Function1<Version, Boolean> snapshotFilter = this.getSnapshotVersionFilter(null);
                Version version = SequencesKt.maxOrNull(SequencesKt.filter(SequencesKt.filter(SequencesKt.filter(artifactInfo2.getVersions(), (Function1)new Function1<Version, Boolean>(excludedRange, (Function1<? super Version, Boolean>)filter2){
                    final /* synthetic */ VersionRange $excludedRange;
                    final /* synthetic */ Function1<Version, Boolean> $filter;
                    {
                        this.$excludedRange = $excludedRange;
                        this.$filter = $filter;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Version v2) {
                        Intrinsics.checkNotNullParameter(v2, "v");
                        return !this.$excludedRange.contains(v2) && this.$filter.invoke(v2) != false;
                    }
                }), (Function1)new Function1<Version, Boolean>(allowPreview){
                    final /* synthetic */ boolean $allowPreview;
                    {
                        this.$allowPreview = $allowPreview;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Version it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return this.$allowPreview || !it.isPreview();
                    }
                }), (Function1)new Function1<Version, Boolean>(snapshotFilter){
                    final /* synthetic */ Function1<Version, Boolean> $snapshotFilter;
                    {
                        this.$snapshotFilter = $snapshotFilter;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Version it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return this.$snapshotFilter.invoke(it);
                    }
                }));
                if (version != null) {
                    Version it = version;
                    boolean bl3 = false;
                    return it;
                }
            }
        }
        Function1<Version, Boolean> compositeFilter = this.getSnapshotVersionFilter(filter2);
        return this.findVersion(group, dependency.getName(), compositeFilter, allowPreview);
    }

    public static /* synthetic */ Version findVersion$default(GoogleMavenRepository googleMavenRepository, Dependency dependency, Predicate predicate, boolean bl2, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findVersion");
        }
        if ((n2 & 4) != 0) {
            bl2 = false;
        }
        return googleMavenRepository.findVersion(dependency, predicate, bl2);
    }

    private final Function1<Version, Boolean> getSnapshotVersionFilter(Function1<? super Version, Boolean> filter2) {
        return new Function1<Version, Boolean>(filter2){
            final /* synthetic */ Function1<Version, Boolean> $filter;
            {
                this.$filter = $filter;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Version candidate) {
                Intrinsics.checkNotNullParameter(candidate, "candidate");
                return !candidate.isSnapshot() && (this.$filter == null || this.$filter.invoke(candidate) != false);
            }
        };
    }

    @Nullable
    public final Version findVersion(@NotNull String groupId, @NotNull String artifactId, @Nullable Predicate<Version> filter2, boolean allowPreview) {
        Intrinsics.checkNotNullParameter(groupId, "groupId");
        Intrinsics.checkNotNullParameter(artifactId, "artifactId");
        return this.findVersion(groupId, artifactId, (Function1<? super Version, Boolean>)new Function1<Version, Boolean>(filter2){
            final /* synthetic */ Predicate<Version> $filter;
            {
                this.$filter = $filter;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Version it) {
                Intrinsics.checkNotNullParameter(it, "it");
                Predicate<Version> predicate = this.$filter;
                return !(predicate != null ? !predicate.test(it) : false);
            }
        }, allowPreview);
    }

    public static /* synthetic */ Version findVersion$default(GoogleMavenRepository googleMavenRepository, String string2, String string3, Predicate predicate, boolean bl2, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findVersion");
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        return googleMavenRepository.findVersion(string2, string3, predicate, bl2);
    }

    @Nullable
    public final Version findVersion(@NotNull String groupId, @NotNull String artifactId, @Nullable Function1<? super Version, Boolean> filter2, boolean allowPreview) {
        Intrinsics.checkNotNullParameter(groupId, "groupId");
        Intrinsics.checkNotNullParameter(artifactId, "artifactId");
        ArtifactInfo artifactInfo = this.findArtifact(groupId, artifactId);
        if (artifactInfo == null) {
            return null;
        }
        ArtifactInfo artifactInfo2 = artifactInfo;
        return artifactInfo2.findVersion(filter2, allowPreview);
    }

    public static /* synthetic */ Version findVersion$default(GoogleMavenRepository googleMavenRepository, String string2, String string3, Function1 function1, boolean bl2, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findVersion");
        }
        if ((n2 & 4) != 0) {
            function1 = null;
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        return googleMavenRepository.findVersion(string2, string3, function1, bl2);
    }

    @NotNull
    public final Set<String> getGroups() {
        return CollectionsKt.toSet((Iterable)this.getPackageMap().keySet());
    }

    @NotNull
    public final Set<String> getArtifacts(@NotNull String groupId) {
        Intrinsics.checkNotNullParameter(groupId, "groupId");
        PackageInfo packageInfo = this.getPackageMap().get(groupId);
        Set<String> set = packageInfo != null ? packageInfo.artifacts() : null;
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    @NotNull
    public final Set<Version> getVersions(@NotNull String groupId, @NotNull String artifactId) {
        Intrinsics.checkNotNullParameter(groupId, "groupId");
        Intrinsics.checkNotNullParameter(artifactId, "artifactId");
        ArtifactInfo artifactInfo = this.findArtifact(groupId, artifactId);
        if (artifactInfo == null) {
            return SetsKt.emptySet();
        }
        ArtifactInfo artifactInfo2 = artifactInfo;
        return SequencesKt.toSet(artifactInfo2.getVersions());
    }

    @NotNull
    public final Set<AgpVersion> getAgpVersions() {
        ArtifactInfo artifactInfo = this.findArtifact("com.android.tools.build", "gradle");
        if (artifactInfo == null) {
            return SetsKt.emptySet();
        }
        ArtifactInfo artifactInfo2 = artifactInfo;
        return SequencesKt.toSet(artifactInfo2.getAgpVersions());
    }

    @NotNull
    public final List<Dependency> findCompileDependencies(@NotNull String groupId, @NotNull String artifactId, @NotNull Version version) {
        Intrinsics.checkNotNullParameter(groupId, "groupId");
        Intrinsics.checkNotNullParameter(artifactId, "artifactId");
        Intrinsics.checkNotNullParameter(version, "version");
        PackageInfo packageInfo = this.getPackageMap().get(groupId);
        if (packageInfo == null) {
            return CollectionsKt.emptyList();
        }
        PackageInfo packageInfo2 = packageInfo;
        ArtifactInfo artifactInfo = packageInfo2.findArtifact(artifactId);
        Object object = artifactInfo;
        if (object == null || (object = ((ArtifactInfo)object).findCompileDependencies(version, packageInfo2)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final ArtifactInfo findArtifact(String groupId, String artifactId) {
        PackageInfo packageInfo = this.getPackageMap().get(groupId);
        if (packageInfo == null) {
            return null;
        }
        PackageInfo packageInfo2 = packageInfo;
        return packageInfo2.findArtifact(artifactId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, PackageInfo> getPackageMap() {
        if (this.packageMap == null) {
            HashMap map2 = Maps.newHashMapWithExpectedSize(28);
            InputStream inputStream = this.findData("master-index.xml");
            if (inputStream != null) {
                Closeable closeable = inputStream;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue(map2, "map");
                    this.readMasterIndex(it, map2);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            }
            this.packageMap = map2;
        }
        Map<String, PackageInfo> map3 = this.packageMap;
        Intrinsics.checkNotNull(map3);
        return map3;
    }

    @Override
    @Nullable
    protected InputStream readDefaultData(@NotNull String relative) {
        Intrinsics.checkNotNullParameter(relative, "relative");
        return GoogleMavenRepository.class.getResourceAsStream("/versions-offline/" + relative);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void readMasterIndex(InputStream stream, Map<String, PackageInfo> map2) {
        try {
            Closeable closeable = stream;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl2 = false;
                KXmlParser parser = new KXmlParser();
                parser.setInput(it, "UTF-8");
                while (parser.next() != 1) {
                    int eventType = parser.getEventType();
                    if (eventType == 3 && parser.getDepth() > 1) {
                        String tag = parser.getName();
                        Intrinsics.checkNotNullExpressionValue(tag, "tag");
                        PackageInfo packageInfo = new PackageInfo(tag);
                        map2.put(tag, packageInfo);
                        continue;
                    }
                    if (eventType == 2) continue;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (XmlPullParserException xmlPullParserException) {
        }
        catch (IOException e2) {
            this.error(e2, null);
        }
    }

    @JvmOverloads
    public GoogleMavenRepository(@Nullable Path cacheDir, int networkTimeoutMs, int cacheExpiryHours) {
        this(cacheDir, networkTimeoutMs, cacheExpiryHours, false, 8, null);
    }

    @JvmOverloads
    public GoogleMavenRepository(@Nullable Path cacheDir, int networkTimeoutMs) {
        this(cacheDir, networkTimeoutMs, 0, false, 12, null);
    }

    @JvmOverloads
    public GoogleMavenRepository(@Nullable Path cacheDir) {
        this(cacheDir, 0, 0, false, 14, null);
    }

    @JvmOverloads
    public GoogleMavenRepository() {
        this(null, 0, 0, false, 15, null);
    }

    private static final boolean findVersion$predicate(Predicate<Version> $predicate, Version version) {
        Predicate<Version> predicate = $predicate;
        return predicate != null ? predicate.test(version) : true;
    }

    public static final /* synthetic */ boolean access$findVersion$predicate(Predicate $predicate, Version version) {
        return GoogleMavenRepository.findVersion$predicate($predicate, version);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J \u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0019\u001a\u00020\b2\n\u0010\u001a\u001a\u00060\u001bR\u00020\u001cJ(\u0010\u001d\u001a\u0004\u0018\u00010\b2\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u001f2\b\b\u0002\u0010 \u001a\u00020\u0016J\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\"J\t\u0010$\u001a\u00020%H\u00d6\u0001J\"\u0010&\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0019\u001a\u00020\b2\n\u0010\u001a\u001a\u00060\u001bR\u00020\u001cH\u0002J\t\u0010'\u001a\u00020\u0003H\u00d6\u0001R-\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006("}, d2={"Lcom/android/ide/common/repository/GoogleMavenRepository$ArtifactInfo;", "", "id", "", "versions", "(Ljava/lang/String;Ljava/lang/String;)V", "dependencyInfo", "Ljava/util/HashMap;", "Lcom/android/ide/common/gradle/Version;", "", "Lcom/android/ide/common/gradle/Dependency;", "getDependencyInfo", "()Ljava/util/HashMap;", "dependencyInfo$delegate", "Lkotlin/Lazy;", "getId", "()Ljava/lang/String;", "getVersions", "component1", "component2", "copy", "equals", "", "other", "findCompileDependencies", "version", "packageInfo", "Lcom/android/ide/common/repository/GoogleMavenRepository$PackageInfo;", "Lcom/android/ide/common/repository/GoogleMavenRepository;", "findVersion", "filter", "Lkotlin/Function1;", "allowPreview", "getAgpVersions", "Lkotlin/sequences/Sequence;", "Lcom/android/ide/common/repository/AgpVersion;", "hashCode", "", "loadCompileDependencies", "toString", "sdk-common"})
    private static final class ArtifactInfo {
        @NotNull
        private final String id;
        @NotNull
        private final String versions;
        @NotNull
        private final Lazy dependencyInfo$delegate;

        public ArtifactInfo(@NotNull String id2, @NotNull String versions) {
            Intrinsics.checkNotNullParameter(id2, "id");
            Intrinsics.checkNotNullParameter(versions, "versions");
            this.id = id2;
            this.versions = versions;
            this.dependencyInfo$delegate = LazyKt.lazy(dependencyInfo.2.INSTANCE);
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getVersions() {
            return this.versions;
        }

        private final HashMap<Version, List<Dependency>> getDependencyInfo() {
            Lazy lazy = this.dependencyInfo$delegate;
            return (HashMap)lazy.getValue();
        }

        @NotNull
        public final Sequence<Version> getVersions() {
            String[] stringArray = new String[]{","};
            return SequencesKt.map(StringsKt.splitToSequence$default((CharSequence)this.versions, stringArray, false, 0, 6, null), getVersions.1.INSTANCE);
        }

        @NotNull
        public final Sequence<AgpVersion> getAgpVersions() {
            String[] stringArray = new String[]{","};
            return SequencesKt.filterNotNull(SequencesKt.map(StringsKt.splitToSequence$default((CharSequence)this.versions, stringArray, false, 0, 6, null), getAgpVersions.1.INSTANCE));
        }

        @Nullable
        public final Version findVersion(@Nullable Function1<? super Version, Boolean> filter2, boolean allowPreview) {
            return SequencesKt.maxOrNull(SequencesKt.filter(SequencesKt.filter(this.getVersions(), (Function1)new Function1<Version, Boolean>(filter2){
                final /* synthetic */ Function1<Version, Boolean> $filter;
                {
                    this.$filter = $filter;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Version it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return this.$filter == null || this.$filter.invoke(it) != false;
                }
            }), (Function1)new Function1<Version, Boolean>(allowPreview){
                final /* synthetic */ boolean $allowPreview;
                {
                    this.$allowPreview = $allowPreview;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Version it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return this.$allowPreview || !it.isPreview();
                }
            }));
        }

        public static /* synthetic */ Version findVersion$default(ArtifactInfo artifactInfo, Function1 function1, boolean bl2, int n2, Object object) {
            if ((n2 & 2) != 0) {
                bl2 = false;
            }
            return artifactInfo.findVersion(function1, bl2);
        }

        @NotNull
        public final List<Dependency> findCompileDependencies(@NotNull Version version, @NotNull PackageInfo packageInfo) {
            Intrinsics.checkNotNullParameter(version, "version");
            Intrinsics.checkNotNullParameter(packageInfo, "packageInfo");
            List<Dependency> list2 = this.getDependencyInfo().get(version);
            if (list2 == null) {
                list2 = this.loadCompileDependencies(version, packageInfo);
            }
            return list2;
        }

        private final List<Dependency> loadCompileDependencies(Version version, PackageInfo packageInfo) {
            if (this.findVersion((Function1<? super Version, Boolean>)new Function1<Version, Boolean>(version){
                final /* synthetic */ Version $version;
                {
                    this.$version = $version;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Version it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return Intrinsics.areEqual(it, this.$version);
                }
            }, true) == null) {
                return CollectionsKt.emptyList();
            }
            List<Dependency> dependencies = packageInfo.loadCompileDependencies(this.id, version);
            ((Map)this.getDependencyInfo()).put(version, dependencies);
            return dependencies;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.versions;
        }

        @NotNull
        public final ArtifactInfo copy(@NotNull String id2, @NotNull String versions) {
            Intrinsics.checkNotNullParameter(id2, "id");
            Intrinsics.checkNotNullParameter(versions, "versions");
            return new ArtifactInfo(id2, versions);
        }

        public static /* synthetic */ ArtifactInfo copy$default(ArtifactInfo artifactInfo, String string2, String string3, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string2 = artifactInfo.id;
            }
            if ((n2 & 2) != 0) {
                string3 = artifactInfo.versions;
            }
            return artifactInfo.copy(string2, string3);
        }

        @NotNull
        public String toString() {
            return "ArtifactInfo(id=" + this.id + ", versions=" + this.versions + ")";
        }

        public int hashCode() {
            int result2 = this.id.hashCode();
            result2 = result2 * 31 + this.versions.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ArtifactInfo)) {
                return false;
            }
            ArtifactInfo artifactInfo = (ArtifactInfo)other;
            if (!Intrinsics.areEqual(this.id, artifactInfo.id)) {
                return false;
            }
            return Intrinsics.areEqual(this.versions, artifactInfo.versions);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/ide/common/repository/GoogleMavenRepository$Companion;", "", "()V", "MAVEN_GOOGLE_CACHE_DIR_KEY", "", "sdk-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u0003J\u001c\u0010\u0015\u001a\u00020\u00102\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0017H\u0002J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001cJ\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0003H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\"\u001a\u00020#H\u0002J$\u0010$\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0017H\u0002R'\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006%"}, d2={"Lcom/android/ide/common/repository/GoogleMavenRepository$PackageInfo;", "", "pkg", "", "(Lcom/android/ide/common/repository/GoogleMavenRepository;Ljava/lang/String;)V", "artifacts", "", "Lcom/android/ide/common/repository/GoogleMavenRepository$ArtifactInfo;", "getArtifacts", "()Ljava/util/Map;", "artifacts$delegate", "Lkotlin/Lazy;", "getPkg", "()Ljava/lang/String;", "", "check", "", "item", "name", "findArtifact", "id", "initializeIndex", "map", "", "loadCompileDependencies", "", "Lcom/android/ide/common/gradle/Dependency;", "version", "Lcom/android/ide/common/gradle/Version;", "readCompileDependenciesFromPomFile", "stream", "Ljava/io/InputStream;", "file", "readCompileDependency", "parser", "Lorg/kxml2/io/KXmlParser;", "readGroupData", "sdk-common"})
    @SourceDebugExtension(value={"SMAP\nGoogleMavenRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoogleMavenRepository.kt\ncom/android/ide/common/repository/GoogleMavenRepository$PackageInfo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,356:1\n1549#2:357\n1620#2,3:358\n1#3:361\n*S KotlinDebug\n*F\n+ 1 GoogleMavenRepository.kt\ncom/android/ide/common/repository/GoogleMavenRepository$PackageInfo\n*L\n253#1:357\n253#1:358,3\n*E\n"})
    private final class PackageInfo {
        @NotNull
        private final String pkg;
        @NotNull
        private final Lazy artifacts$delegate;

        public PackageInfo(String pkg) {
            Intrinsics.checkNotNullParameter(pkg, "pkg");
            this.pkg = pkg;
            this.artifacts$delegate = LazyKt.lazy((Function0)new Function0<HashMap<String, ArtifactInfo>>(this){
                final /* synthetic */ PackageInfo this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final HashMap<String, ArtifactInfo> invoke() {
                    HashMap<String, ArtifactInfo> map2 = new HashMap<String, ArtifactInfo>();
                    PackageInfo.access$initializeIndex(this.this$0, map2);
                    return map2;
                }
            });
        }

        @NotNull
        public final String getPkg() {
            return this.pkg;
        }

        private final Map<String, ArtifactInfo> getArtifacts() {
            Lazy lazy = this.artifacts$delegate;
            return (Map)lazy.getValue();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Set<String> artifacts() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.getArtifacts().values();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ArtifactInfo artifactInfo = (ArtifactInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getId());
            }
            return CollectionsKt.toSet((List)destination$iv$iv);
        }

        @Nullable
        public final ArtifactInfo findArtifact(@NotNull String id2) {
            Intrinsics.checkNotNullParameter(id2, "id");
            return this.getArtifacts().get(id2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final List<Dependency> loadCompileDependencies(@NotNull String id2, @NotNull Version version) {
            Object object;
            block9: {
                block8: {
                    List<Dependency> list2;
                    Intrinsics.checkNotNullParameter(id2, "id");
                    Intrinsics.checkNotNullParameter(version, "version");
                    String file2 = StringsKt.replace$default(this.pkg, '.', '/', false, 4, null) + "/" + id2 + "/" + version + "/" + id2 + "-" + version + ".pom";
                    InputStream stream = GoogleMavenRepository.this.findData(file2);
                    object = stream;
                    if (object == null) break block8;
                    Closeable closeable = (Closeable)object;
                    Throwable throwable = null;
                    try {
                        InputStream it = (InputStream)closeable;
                        boolean bl2 = false;
                        List<Dependency> list3 = this.readCompileDependenciesFromPomFile(stream, file2);
                        list2 = list3;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally(closeable, throwable);
                    }
                    object = list2;
                    if (list2 != null) break block9;
                }
                object = CollectionsKt.emptyList();
            }
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void initializeIndex(Map<String, ArtifactInfo> map2) {
            InputStream stream;
            InputStream inputStream = stream = GoogleMavenRepository.this.findData(StringsKt.replace$default(this.pkg, '.', '/', false, 4, null) + "/group-index.xml");
            if (inputStream != null) {
                Closeable closeable = inputStream;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl2 = false;
                    this.readGroupData(stream, map2);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            }
        }

        private final void readGroupData(InputStream stream, Map<String, ArtifactInfo> map2) {
            try {
                KXmlParser parser = new KXmlParser();
                parser.setInput(stream, "UTF-8");
                while (parser.next() != 1) {
                    int eventType = parser.getEventType();
                    if (eventType != 2) continue;
                    String artifactId = parser.getName();
                    String versions = parser.getAttributeValue(null, "versions");
                    if (versions == null) continue;
                    Intrinsics.checkNotNullExpressionValue(artifactId, "artifactId");
                    ArtifactInfo artifactInfo = new ArtifactInfo(artifactId, versions);
                    map2.put(artifactId, artifactInfo);
                }
            }
            catch (XmlPullParserException parser) {
            }
            catch (Exception e2) {
                GoogleMavenRepository.this.error(e2, null);
            }
        }

        private final List<Dependency> readCompileDependenciesFromPomFile(InputStream stream, String file2) {
            List<Dependency> list2;
            try {
                List dependencies = new ArrayList();
                KXmlParser parser = new KXmlParser();
                parser.setInput(stream, "UTF-8");
                while (parser.next() != 1) {
                    Dependency dependency;
                    int eventType = parser.getEventType();
                    if (eventType != 2 || !Intrinsics.areEqual(parser.getName(), "dependency") || (dependency = this.readCompileDependency(parser)) == null) continue;
                    dependencies.add(dependency);
                }
            }
            catch (XmlPullParserException e2) {
                list2 = CollectionsKt.emptyList();
            }
            catch (Exception e3) {
                GoogleMavenRepository.this.error(e3, "Problem reading POM file: " + file2);
                list2 = CollectionsKt.emptyList();
            }
            return list2;
        }

        private final Dependency readCompileDependency(KXmlParser parser) {
            String groupId = "";
            String artifactId = "";
            String version = "";
            String scope = "";
            block16: while (parser.next() != 1) {
                switch (parser.getEventType()) {
                    case 2: {
                        String string2 = parser.getName();
                        if (string2 == null) continue block16;
                        int n2 = -1;
                        switch (string2.hashCode()) {
                            case 293428218: {
                                if (string2.equals("groupId")) {
                                    n2 = 1;
                                }
                                break;
                            }
                            case 109264468: {
                                if (string2.equals("scope")) {
                                    n2 = 2;
                                }
                                break;
                            }
                            case 240640653: {
                                if (string2.equals("artifactId")) {
                                    n2 = 3;
                                }
                                break;
                            }
                            case 351608024: {
                                if (string2.equals("version")) {
                                    n2 = 4;
                                }
                                break;
                            }
                        }
                        switch (n2) {
                            case 1: {
                                Intrinsics.checkNotNullExpressionValue(parser.nextText(), "parser.nextText()");
                                break;
                            }
                            case 3: {
                                Intrinsics.checkNotNullExpressionValue(parser.nextText(), "parser.nextText()");
                                break;
                            }
                            case 4: {
                                Intrinsics.checkNotNullExpressionValue(parser.nextText(), "parser.nextText()");
                                break;
                            }
                            case 2: {
                                Intrinsics.checkNotNullExpressionValue(parser.nextText(), "parser.nextText()");
                            }
                        }
                        continue block16;
                    }
                    case 3: {
                        if (!Intrinsics.areEqual(parser.getName(), "dependency")) continue block16;
                        this.check(groupId, "groupId");
                        this.check(artifactId, "artifactId");
                        this.check(version, "version");
                        return Intrinsics.areEqual(scope, "compile") ? new Dependency(groupId, artifactId, RichVersion.Companion.parse(version), null, null, 24, null) : null;
                    }
                }
            }
            throw new RuntimeException("Unexpected end of file");
        }

        private final void check(String item, String name2) {
            if (((CharSequence)item).length() == 0) {
                throw new RuntimeException("Missing " + name2 + " field");
            }
        }

        public static final /* synthetic */ void access$initializeIndex(PackageInfo $this, Map map2) {
            $this.initializeIndex(map2);
        }
    }
}

