/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.repository;

import com.android.ide.common.gradle.Component;
import com.android.ide.common.gradle.Module;
import com.android.ide.common.gradle.Version;
import com.android.io.CancellableFileIo;
import com.android.repository.io.FileOpUtils;
import com.google.common.collect.ImmutableSortedSet;
import java.io.File;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;

public class MavenRepositories {
    private static final String MAVEN_METADATA_FILE_NAME = "maven-metadata.xml";

    private MavenRepositories() {
    }

    public static Component getHighestInstalledVersion(String groupId, String artifactId, Path repository, Predicate<Version> filter2, boolean allowPreview) {
        Path versionDir = MavenRepositories.getArtifactIdDirectory(repository, groupId, artifactId);
        Path[] versions = FileOpUtils.listFiles(versionDir);
        Component highest = null;
        for (Path dir : versions) {
            if (!CancellableFileIo.isDirectory(dir, new LinkOption[0])) continue;
            Version version = Version.parse(dir.getFileName().toString());
            Component component = new Component(groupId, artifactId, version);
            if (!allowPreview && MavenRepositories.isPreview(component) || filter2 != null && !filter2.test(version) || highest != null && version.compareTo(highest.getVersion()) <= 0) continue;
            highest = component;
        }
        return highest;
    }

    public static Version getHighestVersion(Path versionDir, Predicate<Version> filter2, boolean allowPreview) {
        Path[] versionDirs = FileOpUtils.listFiles(versionDir);
        Version maxVersion = null;
        for (Path dir : versionDirs) {
            String name2;
            if (!CancellableFileIo.isDirectory(dir, new LinkOption[0]) || (name2 = dir.getFileName().toString()).isEmpty() || !Character.isDigit(name2.charAt(0))) continue;
            Version version = Version.parse(name2);
            if (!allowPreview && version.isPreview() || filter2 != null && !filter2.test(version) || maxVersion != null && version.compareTo(maxVersion) <= 0) continue;
            maxVersion = version;
        }
        return maxVersion;
    }

    public static boolean isPreview(Component component) {
        if (component.getVersion().isPreview()) {
            return true;
        }
        return "com.google.android.gms".equals(component.getGroup()) && "play-services".equals(component.getName()) && component.getVersion().equals(Version.parse("5.2.08"));
    }

    public static boolean isAndroidX(String groupId) {
        return groupId.startsWith("androidx.");
    }

    public static Path getArtifactIdDirectory(Path repository, String groupId, String artifactId) {
        return MavenRepositories.getModuleDirectory(repository, new Module(groupId, artifactId));
    }

    public static Path getModuleDirectory(Path repository, Module module) {
        return repository.resolve(module.getGroup().replace('.', File.separatorChar) + File.separator + module.getName());
    }

    public static Path getArtifactDirectory(Path repository, Component component) {
        Path artifactIdDirectory = MavenRepositories.getArtifactIdDirectory(repository, component.getGroup(), component.getName());
        return artifactIdDirectory.resolve(component.getVersion().toString());
    }

    public static Set<Version> getAllVersions(Path repository, Module module) {
        Path moduleDirectory = MavenRepositories.getModuleDirectory(repository, module);
        if (!CancellableFileIo.isDirectory(moduleDirectory, new LinkOption[0])) {
            return Collections.emptySet();
        }
        Path[] versionDirs = FileOpUtils.listFiles(moduleDirectory);
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        for (Path dir : versionDirs) {
            String name2;
            if (!CancellableFileIo.isDirectory(dir, new LinkOption[0]) || (name2 = dir.getFileName().toString()).isEmpty()) continue;
            builder.add(Version.parse(name2));
        }
        return builder.build();
    }
}

