/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.repository;

import com.android.annotations.concurrency.Slow;
import com.android.io.CancellableFileIo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0002$%B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0003H$J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u0003H\u0015J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u0003H$J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020#H%R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/android/ide/common/repository/NetworkCache;", "", "baseUrl", "", "cacheKey", "cacheDir", "Ljava/nio/file/Path;", "networkTimeoutMs", "", "cacheExpiryHours", "networkEnabled", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/nio/file/Path;IIZ)V", "getCacheDir", "()Ljava/nio/file/Path;", "lastReadSourceType", "Lcom/android/ide/common/repository/NetworkCache$DataSourceType;", "getLastReadSourceType", "()Lcom/android/ide/common/repository/NetworkCache$DataSourceType;", "setLastReadSourceType", "(Lcom/android/ide/common/repository/NetworkCache$DataSourceType;)V", "error", "", "throwable", "", "message", "findData", "Ljava/io/InputStream;", "relative", "readDefaultData", "readUrlData", "Lcom/android/ide/common/repository/NetworkCache$ReadUrlDataResult;", "url", "timeout", "lastModified", "", "DataSourceType", "ReadUrlDataResult", "sdk-common"})
@SourceDebugExtension(value={"SMAP\nNetworkCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkCache.kt\ncom/android/ide/common/repository/NetworkCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,170:1\n1#2:171\n*E\n"})
public abstract class NetworkCache {
    @NotNull
    private final String baseUrl;
    @NotNull
    private final String cacheKey;
    @Nullable
    private final Path cacheDir;
    private final int networkTimeoutMs;
    private final int cacheExpiryHours;
    private final boolean networkEnabled;
    @NotNull
    private DataSourceType lastReadSourceType;

    public NetworkCache(@NotNull String baseUrl, @NotNull String cacheKey, @Nullable Path cacheDir, int networkTimeoutMs, int cacheExpiryHours, boolean networkEnabled) {
        Intrinsics.checkNotNullParameter(baseUrl, "baseUrl");
        Intrinsics.checkNotNullParameter(cacheKey, "cacheKey");
        this.baseUrl = baseUrl;
        this.cacheKey = cacheKey;
        this.cacheDir = cacheDir;
        this.networkTimeoutMs = networkTimeoutMs;
        this.cacheExpiryHours = cacheExpiryHours;
        this.networkEnabled = networkEnabled;
        this.lastReadSourceType = DataSourceType.UNKNOWN_SOURCE;
    }

    public /* synthetic */ NetworkCache(String string2, String string3, Path path, int n2, int n3, boolean bl2, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 4) != 0) {
            path = null;
        }
        if ((n4 & 8) != 0) {
            n2 = 3000;
        }
        if ((n4 & 0x10) != 0) {
            n3 = (int)TimeUnit.DAYS.toHours(7L);
        }
        if ((n4 & 0x20) != 0) {
            bl2 = true;
        }
        this(string2, string3, path, n2, n3, bl2);
    }

    @Nullable
    public final Path getCacheDir() {
        return this.cacheDir;
    }

    @NotNull
    protected final DataSourceType getLastReadSourceType() {
        return this.lastReadSourceType;
    }

    protected final void setLastReadSourceType(@NotNull DataSourceType dataSourceType) {
        Intrinsics.checkNotNullParameter((Object)dataSourceType, "<set-?>");
        this.lastReadSourceType = dataSourceType;
    }

    @Slow
    @NotNull
    protected abstract ReadUrlDataResult readUrlData(@NotNull String var1, int var2, long var3);

    @Nullable
    protected abstract InputStream readDefaultData(@NotNull String var1);

    protected abstract void error(@NotNull Throwable var1, @Nullable String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Slow
    @Nullable
    protected InputStream findData(@NotNull String relative) {
        Intrinsics.checkNotNullParameter(relative, "relative");
        if (this.cacheDir != null) {
            long lastModified = 0L;
            Path path = this.cacheDir;
            synchronized (path) {
                CharSequence charSequence;
                boolean bl2 = false;
                Path path2 = this.cacheDir;
                CharSequence charSequence2 = relative;
                if (charSequence2.length() == 0) {
                    Path path3 = path2;
                    boolean bl3 = false;
                    charSequence = this.cacheKey;
                    path2 = path3;
                } else {
                    charSequence = charSequence2;
                }
                Path file2 = path2.resolve((String)charSequence);
                try {
                    lastModified = CancellableFileIo.getLastModifiedTime(file2, new LinkOption[0]).toMillis();
                    long now = System.currentTimeMillis();
                    long expiryMs = TimeUnit.HOURS.toMillis(this.cacheExpiryHours);
                    if (!this.networkEnabled || lastModified == 0L || now - lastModified <= expiryMs) {
                        this.lastReadSourceType = lastModified != 0L ? (now - lastModified > expiryMs ? DataSourceType.CACHE_FILE_EXPIRED_NO_NETWORK : DataSourceType.CACHE_FILE_RECENT) : DataSourceType.CACHE_FILE_EXPIRED_UNKNOWN;
                        return CancellableFileIo.newInputStream(file2, new OpenOption[0]);
                    }
                }
                catch (NoSuchFileException noSuchFileException) {
                    // empty catch block
                }
                if (this.networkEnabled) {
                    try {
                        FileTime time = FileTime.fromMillis(System.currentTimeMillis());
                        ReadUrlDataResult result2 = this.readUrlData(this.baseUrl + relative, this.networkTimeoutMs, lastModified);
                        if (!result2.getModifiedSince()) {
                            this.lastReadSourceType = DataSourceType.CACHE_FILE_NOT_MODIIFED_SINCE;
                            Files.setLastModifiedTime(file2, time);
                            return CancellableFileIo.newInputStream(file2, new OpenOption[0]);
                        }
                        byte[] byArray = result2.getData();
                        if (byArray != null) {
                            Path path4;
                            byte[] data = byArray;
                            boolean bl4 = false;
                            this.lastReadSourceType = DataSourceType.CACHE_FILE_NEW;
                            Path path5 = path4 = file2.getParent();
                            if (path5 != null) {
                                Intrinsics.checkNotNullExpressionValue(path5, "parent");
                                Path it = path4;
                                boolean bl5 = false;
                                Files.createDirectories(it, new FileAttribute[0]);
                            }
                            Files.write(file2, data, new OpenOption[0]);
                            return new ByteArrayInputStream(data);
                        }
                    }
                    catch (AssertionError e2) {
                        throw e2;
                    }
                    catch (Throwable e3) {
                        try {
                            this.lastReadSourceType = DataSourceType.CACHE_FILE_EXPIRED_NETWORK_ERROR;
                            return CancellableFileIo.newInputStream(file2, new OpenOption[0]);
                        }
                        catch (NoSuchFileException noSuchFileException) {
                        }
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        InputStream result3 = this.readDefaultData(relative);
        this.lastReadSourceType = DataSourceType.DEFAULT_DATA;
        return result3;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/android/ide/common/repository/NetworkCache$DataSourceType;", "", "(Ljava/lang/String;I)V", "UNKNOWN_SOURCE", "TEST_DATA", "CACHE_FILE_EXPIRED_NO_NETWORK", "CACHE_FILE_EXPIRED_NETWORK_ERROR", "CACHE_FILE_EXPIRED_UNKNOWN", "CACHE_FILE_RECENT", "CACHE_FILE_NEW", "CACHE_FILE_NOT_MODIIFED_SINCE", "DEFAULT_DATA", "sdk-common"})
    public static final class DataSourceType
    extends Enum<DataSourceType> {
        public static final /* enum */ DataSourceType UNKNOWN_SOURCE = new DataSourceType();
        public static final /* enum */ DataSourceType TEST_DATA = new DataSourceType();
        public static final /* enum */ DataSourceType CACHE_FILE_EXPIRED_NO_NETWORK = new DataSourceType();
        public static final /* enum */ DataSourceType CACHE_FILE_EXPIRED_NETWORK_ERROR = new DataSourceType();
        public static final /* enum */ DataSourceType CACHE_FILE_EXPIRED_UNKNOWN = new DataSourceType();
        public static final /* enum */ DataSourceType CACHE_FILE_RECENT = new DataSourceType();
        public static final /* enum */ DataSourceType CACHE_FILE_NEW = new DataSourceType();
        public static final /* enum */ DataSourceType CACHE_FILE_NOT_MODIIFED_SINCE = new DataSourceType();
        public static final /* enum */ DataSourceType DEFAULT_DATA = new DataSourceType();
        private static final /* synthetic */ DataSourceType[] $VALUES;

        public static DataSourceType[] values() {
            return (DataSourceType[])$VALUES.clone();
        }

        public static DataSourceType valueOf(String value) {
            return Enum.valueOf(DataSourceType.class, value);
        }

        static {
            $VALUES = dataSourceTypeArray = new DataSourceType[]{DataSourceType.UNKNOWN_SOURCE, DataSourceType.TEST_DATA, DataSourceType.CACHE_FILE_EXPIRED_NO_NETWORK, DataSourceType.CACHE_FILE_EXPIRED_NETWORK_ERROR, DataSourceType.CACHE_FILE_EXPIRED_UNKNOWN, DataSourceType.CACHE_FILE_RECENT, DataSourceType.CACHE_FILE_NEW, DataSourceType.CACHE_FILE_NOT_MODIIFED_SINCE, DataSourceType.DEFAULT_DATA};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/android/ide/common/repository/NetworkCache$ReadUrlDataResult;", "", "data", "", "modifiedSince", "", "([BZ)V", "getData", "()[B", "getModifiedSince", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "sdk-common"})
    public static final class ReadUrlDataResult {
        @Nullable
        private final byte[] data;
        private final boolean modifiedSince;

        public ReadUrlDataResult(@Nullable byte[] data, boolean modifiedSince) {
            this.data = data;
            this.modifiedSince = modifiedSince;
        }

        @Nullable
        public final byte[] getData() {
            return this.data;
        }

        public final boolean getModifiedSince() {
            return this.modifiedSince;
        }

        @Nullable
        public final byte[] component1() {
            return this.data;
        }

        public final boolean component2() {
            return this.modifiedSince;
        }

        @NotNull
        public final ReadUrlDataResult copy(@Nullable byte[] data, boolean modifiedSince) {
            return new ReadUrlDataResult(data, modifiedSince);
        }

        public static /* synthetic */ ReadUrlDataResult copy$default(ReadUrlDataResult readUrlDataResult, byte[] byArray, boolean bl2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                byArray = readUrlDataResult.data;
            }
            if ((n2 & 2) != 0) {
                bl2 = readUrlDataResult.modifiedSince;
            }
            return readUrlDataResult.copy(byArray, bl2);
        }

        @NotNull
        public String toString() {
            return "ReadUrlDataResult(data=" + Arrays.toString(this.data) + ", modifiedSince=" + this.modifiedSince + ")";
        }

        public int hashCode() {
            int result2 = this.data == null ? 0 : Arrays.hashCode(this.data);
            result2 = result2 * 31 + Boolean.hashCode(this.modifiedSince);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ReadUrlDataResult)) {
                return false;
            }
            ReadUrlDataResult readUrlDataResult = (ReadUrlDataResult)other;
            if (!Intrinsics.areEqual(this.data, readUrlDataResult.data)) {
                return false;
            }
            return this.modifiedSince == readUrlDataResult.modifiedSince;
        }
    }
}

