/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.repository;

import com.android.ide.common.repository.MavenRepositories;
import com.android.io.CancellableFileIo;
import java.io.File;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public enum SdkMavenRepository {
    ANDROID("android"),
    GOOGLE("google");

    private final String mDir;

    private SdkMavenRepository(String dir) {
        this.mDir = dir;
    }

    public Path getRepositoryLocation(Path sdkHome, boolean requireExists) {
        if (sdkHome != null) {
            Path dir = sdkHome.resolve("extras" + File.separator + this.mDir + File.separator + "m2repository");
            if (!requireExists || CancellableFileIo.isDirectory(dir, new LinkOption[0])) {
                return dir;
            }
        }
        return null;
    }

    public String getPackageId() {
        return String.format("extras;%s;%s", this.mDir, "m2repository");
    }

    public static SdkMavenRepository find(Path sdkLocation, String groupId, String artifactId) {
        for (SdkMavenRepository repository : SdkMavenRepository.values()) {
            Path artifactIdDirectory;
            Path repositoryLocation = repository.getRepositoryLocation(sdkLocation, true);
            if (repositoryLocation == null || !CancellableFileIo.exists(artifactIdDirectory = MavenRepositories.getArtifactIdDirectory(repositoryLocation, groupId, artifactId), new LinkOption[0])) continue;
            return repository;
        }
        return null;
    }

    public String getDirName() {
        return this.mDir;
    }
}

