/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.repository;

import com.android.ide.common.gradle.Dependency;
import com.android.ide.common.gradle.RichVersion;
import com.android.ide.common.repository.AliasStyle;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\f\n\u0002\b\u0004\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a4\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u00062\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001\u0018\u00010\bH\u0002\u001a\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006H\u0002\u001a\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\"\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\b2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006H\u0002\u001a\"\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\b2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006H\u0002\u001a\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u0016\u001a\u00020\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0018\u001a\u00020\u0001\u001a\u0010\u0010\u0019\u001a\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u0001H\u0002\u001a$\u0010\u001b\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u00122\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006\u001a\u001c\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u00012\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006\u001a\u001c\u0010 \u001a\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u00012\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006\u001a\u001c\u0010!\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006\u001a\f\u0010\"\u001a\u00020\u0012*\u00020\u000eH\u0002\u001a\f\u0010#\u001a\u00020\u0012*\u00020\u0001H\u0002\u001a\f\u0010$\u001a\u00020%*\u00020%H\u0002\u001a\f\u0010&\u001a\u00020%*\u00020%H\u0002\u001a\f\u0010'\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\f\u0010(\u001a\u00020\u0001*\u00020\u0001H\u0001\u00a8\u0006)"}, d2={"cutDomainPrefix", "", "group", "generateWithSuffix", "prefix", "reserved", "", "transform", "Lkotlin/Function1;", "getAliasStyle", "Lcom/android/ide/common/repository/AliasStyle;", "reservedAliases", "getGroupPrefix", "dependency", "Lcom/android/ide/common/gradle/Dependency;", "getMaybeTransformToCamelCase", "getMaybeTransformVersionToCamelCase", "isAfterDelimiter", "", "index", "", "s", "keysMatch", "keyText", "reference", "maybeLowCamelTransform", "name", "pickLibraryVariableName", "includeVersionInKey", "caseSensitiveReserved", "pickPluginVariableName", "pluginId", "pickPluginVersionVariableName", "pickVersionVariableName", "isAndroidX", "isCommonDomain", "normalize", "", "normalizeIgnoreCase", "toSafeHyphenKey", "toSafeKey", "sdk-common"})
@SourceDebugExtension(value={"SMAP\nVersionCatalogNamingUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VersionCatalogNamingUtil.kt\ncom/android/ide/common/repository/VersionCatalogNamingUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,423:1\n1747#2,3:424\n1064#3,2:427\n1#4:429\n*S KotlinDebug\n*F\n+ 1 VersionCatalogNamingUtil.kt\ncom/android/ide/common/repository/VersionCatalogNamingUtilKt\n*L\n59#1:424,3\n181#1:427,2\n*E\n"})
public final class VersionCatalogNamingUtilKt {
    private static final boolean isAndroidX(Dependency $this$isAndroidX) {
        String string2 = $this$isAndroidX.getGroup();
        return string2 != null ? StringsKt.startsWith$default(string2, "androidx.", false, 2, null) : false;
    }

    @NotNull
    public static final String pickLibraryVariableName(@NotNull Dependency dependency, boolean includeVersionInKey, @NotNull Set<String> caseSensitiveReserved) {
        String name2;
        String groupId;
        String full;
        String fullSafe;
        String artifactId;
        String artifactKey;
        String versionSuffix;
        Function1<String, String> transform2;
        TreeSet<String> reserved;
        block20: {
            String key;
            block21: {
                boolean bl2;
                block19: {
                    Object object;
                    Intrinsics.checkNotNullParameter(dependency, "dependency");
                    Intrinsics.checkNotNullParameter(caseSensitiveReserved, "caseSensitiveReserved");
                    reserved = new TreeSet<String>(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE));
                    reserved.addAll((Collection<String>)caseSensitiveReserved);
                    transform2 = VersionCatalogNamingUtilKt.getMaybeTransformToCamelCase((Set<String>)reserved);
                    RichVersion richVersion = dependency.getVersion();
                    String versionIdentifier = richVersion != null ? richVersion.toIdentifier() : null;
                    if (versionIdentifier == null) {
                        object = "";
                    } else if (!includeVersionInKey) {
                        object = "";
                    } else {
                        CharSequence charSequence = versionIdentifier;
                        Regex regex = new Regex("[^A-Za-z0-9]");
                        String string2 = "";
                        object = versionSuffix = "-" + VersionCatalogNamingUtilKt.toSafeKey("v" + regex.replace(charSequence, string2));
                    }
                    if (!VersionCatalogNamingUtilKt.isAndroidX(dependency)) break block20;
                    if (reserved.isEmpty()) break block21;
                    Iterable $this$any$iv = reserved;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl3 = false;
                            Intrinsics.checkNotNullExpressionValue(it, "it");
                            if (!StringsKt.startsWith$default(it, "androidx-", false, 2, null)) continue;
                            bl2 = true;
                            break block19;
                        }
                        bl2 = false;
                    }
                }
                if (!bl2) break block20;
            }
            if (!reserved.contains(key = transform2.invoke("androidx-" + VersionCatalogNamingUtilKt.toSafeKey(dependency.getName()) + versionSuffix))) {
                return key;
            }
        }
        if (!reserved.contains(artifactKey = transform2.invoke((artifactId = VersionCatalogNamingUtilKt.toSafeKey(dependency.getName())) + versionSuffix))) {
            return artifactKey;
        }
        String string3 = dependency.getGroup();
        if (string3 == null || (string3 = StringsKt.substringAfterLast$default(string3, '.', null, 2, null)) == null || (string3 = VersionCatalogNamingUtilKt.toSafeKey(string3)) == null) {
            string3 = "nogroup";
        }
        String groupSuffix = string3;
        String withGroupSuffix = transform2.invoke(groupSuffix + "-" + artifactId + versionSuffix);
        if (!StringsKt.startsWith$default(artifactId, groupSuffix, false, 2, null) && !reserved.contains(withGroupSuffix)) {
            return withGroupSuffix;
        }
        String groupPrefix = VersionCatalogNamingUtilKt.getGroupPrefix(dependency);
        String withGroupPrefix = transform2.invoke(groupPrefix + "-" + artifactId + versionSuffix);
        if (!reserved.contains(withGroupPrefix)) {
            return withGroupPrefix;
        }
        String string4 = dependency.getGroup();
        if (string4 == null || (string4 = VersionCatalogNamingUtilKt.toSafeKey(string4)) == null) {
            string4 = "nogroup";
        }
        if (!reserved.contains(fullSafe = transform2.invoke(full = (groupId = string4) + "-" + artifactId + versionSuffix))) {
            return fullSafe;
        }
        int id2 = 2;
        while (reserved.contains(name2 = transform2.invoke(full + (((CharSequence)versionSuffix).length() > 0 ? "-x" : "") + id2++))) {
        }
        return name2;
    }

    private static final Function1<String, String> getMaybeTransformToCamelCase(Set<String> reserved) {
        AliasStyle aliasStyle = VersionCatalogNamingUtilKt.getAliasStyle(reserved);
        boolean haveCamelCase = aliasStyle.component1();
        boolean haveHyphen = aliasStyle.component2();
        boolean camelCaseOutput = haveCamelCase && !haveHyphen;
        return new Function1<String, String>(camelCaseOutput){
            final /* synthetic */ boolean $camelCaseOutput;
            {
                this.$camelCaseOutput = $camelCaseOutput;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull String alias) {
                String string2;
                Intrinsics.checkNotNullParameter(alias, "alias");
                String safeAlias = VersionCatalogNamingUtilKt.toSafeHyphenKey(alias);
                if (this.$camelCaseOutput && StringsKt.contains$default((CharSequence)safeAlias, "-", false, 2, null)) {
                    String string3 = CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, VersionCatalogNamingUtilKt.toSafeHyphenKey(alias));
                    string2 = string3;
                    Intrinsics.checkNotNullExpressionValue(string3, "{\n            CaseFormat\u2026afeHyphenKey())\n        }");
                } else {
                    string2 = alias;
                }
                return string2;
            }
        };
    }

    private static final Function1<String, String> getMaybeTransformVersionToCamelCase(Set<String> reserved) {
        AliasStyle aliasStyle = VersionCatalogNamingUtilKt.getAliasStyle(reserved);
        boolean haveCamelCase = aliasStyle.component1();
        boolean haveHyphen = aliasStyle.component2();
        boolean camelCaseOutput = haveCamelCase || !haveHyphen;
        return new Function1<String, String>(camelCaseOutput){
            final /* synthetic */ boolean $camelCaseOutput;
            {
                this.$camelCaseOutput = $camelCaseOutput;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull String version) {
                String string2;
                Intrinsics.checkNotNullParameter(version, "version");
                if (this.$camelCaseOutput) {
                    String string3 = CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, version);
                    string2 = string3;
                    Intrinsics.checkNotNullExpressionValue(string3, "LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, version)");
                } else {
                    string2 = version;
                }
                return string2;
            }
        };
    }

    @NotNull
    public static final String pickPluginVariableName(@NotNull String pluginId, @NotNull Set<String> caseSensitiveReserved) {
        Intrinsics.checkNotNullParameter(pluginId, "pluginId");
        Intrinsics.checkNotNullParameter(caseSensitiveReserved, "caseSensitiveReserved");
        TreeSet<String> reserved = new TreeSet<String>(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE));
        reserved.addAll((Collection<String>)caseSensitiveReserved);
        Function1<String, String> transform2 = VersionCatalogNamingUtilKt.getMaybeTransformToCamelCase((Set<String>)reserved);
        String plugin = VersionCatalogNamingUtilKt.cutDomainPrefix(pluginId);
        String shortName = transform2.invoke(VersionCatalogNamingUtilKt.toSafeHyphenKey(plugin));
        if (!reserved.contains(shortName)) {
            return shortName;
        }
        String fullName = transform2.invoke(VersionCatalogNamingUtilKt.toSafeHyphenKey(pluginId));
        if (!reserved.contains(fullName)) {
            return fullName;
        }
        return VersionCatalogNamingUtilKt.generateWithSuffix(fullName + "X", (Set<String>)reserved, transform2);
    }

    private static final String maybeLowCamelTransform(String name2) {
        String string2;
        if (StringsKt.contains$default((CharSequence)name2, "-", false, 2, null)) {
            String string3 = CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, name2);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, name)");
        } else {
            string2 = name2;
        }
        return string2;
    }

    @VisibleForTesting
    @NotNull
    public static final String toSafeKey(@NotNull String $this$toSafeKey) {
        int n2;
        Intrinsics.checkNotNullParameter($this$toSafeKey, "<this>");
        if (((CharSequence)$this$toSafeKey).length() == 0) {
            return "empty";
        }
        if ($this$toSafeKey.length() == 1 && Character.isLowerCase(Character.toLowerCase($this$toSafeKey.charAt(0)))) {
            return Character.toLowerCase($this$toSafeKey.charAt(0)) + "x";
        }
        if ($this$toSafeKey.length() == 1) {
            return "xx";
        }
        if (Character.isLowerCase($this$toSafeKey.charAt(0))) {
            boolean bl2;
            block13: {
                CharSequence $this$all$iv = $this$toSafeKey;
                boolean $i$f$all = false;
                for (n2 = 0; n2 < $this$all$iv.length(); ++n2) {
                    char element$iv;
                    char it = element$iv = $this$all$iv.charAt(n2);
                    boolean bl3 = false;
                    if (VersionCatalogNamingUtilKt.toSafeKey$isSafe(it)) continue;
                    bl2 = false;
                    break block13;
                }
                bl2 = true;
            }
            if (bl2) {
                return $this$toSafeKey;
            }
        }
        StringBuilder sb = new StringBuilder();
        char c2 = Character.toLowerCase($this$toSafeKey.charAt(0));
        boolean bl4 = false;
        sb.append(Character.isLowerCase(c2) ? c2 : (char)'x');
        String string2 = $this$toSafeKey.substring(1);
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        String string3 = string2;
        int n3 = string3.length();
        for (n2 = 0; n2 < n3; ++n2) {
            char c3 = string3.charAt(n2);
            boolean afterSeparator = VersionCatalogNamingUtilKt.toSafeKey$isSeparator(sb.charAt(sb.length() - 1));
            if (Character.isDigit(c3) && afterSeparator) {
                sb.append('x');
                continue;
            }
            if (VersionCatalogNamingUtilKt.toSafeKey$isSafe(c3)) {
                sb.append(c3);
                continue;
            }
            if (VersionCatalogNamingUtilKt.toSafeKey$isSafe(Character.toLowerCase(c3))) {
                sb.append(Character.toLowerCase(c3));
                continue;
            }
            if (VersionCatalogNamingUtilKt.toSafeKey$isSeparator(c3)) {
                if (afterSeparator) continue;
                sb.append(c3);
                continue;
            }
            if (c3 == '.') {
                if (afterSeparator) continue;
                sb.append('-');
                continue;
            }
            if (afterSeparator) continue;
            sb.append('_');
        }
        if (sb.length() == 1 || VersionCatalogNamingUtilKt.toSafeKey$isSeparator(sb.charAt(sb.length() - 1))) {
            sb.append('z');
        }
        String string4 = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string4, "sb.toString()");
        return string4;
    }

    @NotNull
    public static final String toSafeHyphenKey(@NotNull String $this$toSafeHyphenKey) {
        Intrinsics.checkNotNullParameter($this$toSafeHyphenKey, "<this>");
        return StringsKt.replace$default(VersionCatalogNamingUtilKt.toSafeKey($this$toSafeHyphenKey), "_", "-", false, 4, null);
    }

    private static final String getGroupPrefix(Dependency dependency) {
        String string2 = dependency.getGroup();
        if (string2 == null) {
            return "nogroup";
        }
        String group = string2;
        String groupPrefix = VersionCatalogNamingUtilKt.toSafeKey(StringsKt.substringBefore$default(group, '.', null, 2, null));
        if (VersionCatalogNamingUtilKt.isCommonDomain(groupPrefix)) {
            return VersionCatalogNamingUtilKt.toSafeKey(StringsKt.substringBefore$default(StringsKt.substringAfter$default(group, '.', null, 2, null), '.', null, 2, null));
        }
        return VersionCatalogNamingUtilKt.toSafeKey(groupPrefix);
    }

    private static final boolean isCommonDomain(String $this$isCommonDomain) {
        return Intrinsics.areEqual($this$isCommonDomain, "com") || Intrinsics.areEqual($this$isCommonDomain, "org") || Intrinsics.areEqual($this$isCommonDomain, "io");
    }

    private static final String cutDomainPrefix(String group) {
        String groupPrefix = VersionCatalogNamingUtilKt.toSafeKey(StringsKt.substringBefore$default(group, '.', null, 2, null));
        if (VersionCatalogNamingUtilKt.isCommonDomain(groupPrefix) || Intrinsics.areEqual(groupPrefix, "androidx")) {
            return VersionCatalogNamingUtilKt.toSafeKey(StringsKt.substringAfter$default(group, '.', null, 2, null));
        }
        return VersionCatalogNamingUtilKt.toSafeKey(groupPrefix);
    }

    @NotNull
    public static final String pickVersionVariableName(@NotNull Dependency dependency, @NotNull Set<String> caseSensitiveReserved) {
        String groupId;
        String withGroupId;
        String transformedWithGroupId;
        String artifactName;
        Intrinsics.checkNotNullParameter(dependency, "dependency");
        Intrinsics.checkNotNullParameter(caseSensitiveReserved, "caseSensitiveReserved");
        String artifact = VersionCatalogNamingUtilKt.toSafeKey(dependency.getName());
        TreeSet<String> reserved = new TreeSet<String>(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE));
        reserved.addAll((Collection<String>)caseSensitiveReserved);
        Function1<String, String> transform2 = VersionCatalogNamingUtilKt.getMaybeTransformVersionToCamelCase((Set<String>)reserved);
        if (reserved.isEmpty()) {
            return transform2.invoke(artifact);
        }
        if (!((Collection)reserved).isEmpty()) {
            String withVersion;
            String string2 = reserved.first();
            Intrinsics.checkNotNullExpressionValue(string2, "reserved.first()");
            String string3 = string2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
            if (StringsKt.endsWith$default(string3, "version", false, 2, null) && !reserved.contains(withVersion = transform2.invoke(artifact + "-version"))) {
                return withVersion;
            }
        }
        if (!reserved.contains(artifactName = transform2.invoke(artifact))) {
            return artifactName;
        }
        String withVersion = transform2.invoke(artifact + "-version");
        if (!reserved.contains(withVersion)) {
            return withVersion;
        }
        String groupPrefix = VersionCatalogNamingUtilKt.getGroupPrefix(dependency);
        String withGroupIdPrefix = transform2.invoke(groupPrefix + "-" + artifact);
        if (!reserved.contains(withGroupIdPrefix)) {
            return withGroupIdPrefix;
        }
        String withGroupIdPrefixVersion = transform2.invoke(groupPrefix + "-" + artifact + "-version");
        if (!reserved.contains(withGroupIdPrefixVersion)) {
            return withGroupIdPrefixVersion;
        }
        String string4 = dependency.getGroup();
        if (string4 == null || (string4 = VersionCatalogNamingUtilKt.toSafeKey(string4)) == null) {
            string4 = "nogroup";
        }
        if (!reserved.contains(transformedWithGroupId = transform2.invoke(withGroupId = (groupId = string4) + "-" + artifact))) {
            return transformedWithGroupId;
        }
        return VersionCatalogNamingUtilKt.generateWithSuffix(withGroupId, (Set<String>)reserved, transform2);
    }

    private static final AliasStyle getAliasStyle(Set<String> reservedAliases) {
        boolean haveCamelCase = false;
        boolean haveHyphen = false;
        for (String name2 : reservedAliases) {
            int n2 = name2.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = name2.charAt(i2);
                if (c2 == '-') {
                    haveHyphen = true;
                    continue;
                }
                if (i2 <= 0 || !Character.isUpperCase(c2) || !Character.isLowerCase(name2.charAt(i2 - 1)) || !Character.isLowerCase(name2.charAt(0))) continue;
                haveCamelCase = true;
            }
        }
        return new AliasStyle(haveCamelCase, haveHyphen);
    }

    private static final String generateWithSuffix(String prefix, Set<String> reserved, Function1<? super String, String> transform2) {
        Function1<? super String, String> function1;
        Function1<? super String, String> maybeUpdatedName;
        int id2 = 2;
        do {
            String name2 = prefix + id2++;
            function1 = transform2;
            if (function1 != null && (function1 = function1.invoke(name2)) != null) continue;
            function1 = name2;
        } while (reserved.contains(maybeUpdatedName = function1));
        return maybeUpdatedName;
    }

    @NotNull
    public static final String pickPluginVersionVariableName(@NotNull String pluginId, @NotNull Set<String> caseSensitiveReserved) {
        String transformedName;
        Intrinsics.checkNotNullParameter(pluginId, "pluginId");
        Intrinsics.checkNotNullParameter(caseSensitiveReserved, "caseSensitiveReserved");
        TreeSet<String> reserved = new TreeSet<String>(StringsKt.getCASE_INSENSITIVE_ORDER(StringCompanionObject.INSTANCE));
        reserved.addAll((Collection<String>)caseSensitiveReserved);
        String plugin = VersionCatalogNamingUtilKt.cutDomainPrefix(pluginId);
        String safeKey = VersionCatalogNamingUtilKt.toSafeHyphenKey(plugin);
        if (reserved.isEmpty()) {
            return safeKey;
        }
        Function1<String, String> transform2 = VersionCatalogNamingUtilKt.getMaybeTransformVersionToCamelCase((Set<String>)reserved);
        if (!((Collection)reserved).isEmpty()) {
            String withVersion;
            String string2 = reserved.first();
            Intrinsics.checkNotNullExpressionValue(string2, "reserved.first()");
            String string3 = string2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
            if (StringsKt.endsWith$default(string3, "version", false, 2, null) && !reserved.contains(withVersion = transform2.invoke(plugin + "-version"))) {
                return withVersion;
            }
        }
        if (!reserved.contains(transformedName = transform2.invoke(plugin))) {
            return transformedName;
        }
        String withVersion = transform2.invoke(plugin + "-version");
        if (!reserved.contains(withVersion)) {
            return withVersion;
        }
        String fullName = transform2.invoke(VersionCatalogNamingUtilKt.toSafeKey(pluginId));
        if (!reserved.contains(fullName)) {
            return fullName;
        }
        return VersionCatalogNamingUtilKt.generateWithSuffix(fullName, (Set<String>)reserved, transform2);
    }

    public static final boolean keysMatch(@Nullable String keyText, @NotNull String reference) {
        Intrinsics.checkNotNullParameter(reference, "reference");
        if (keyText == null) {
            return false;
        }
        if (keyText.length() != reference.length()) {
            return false;
        }
        int n2 = keyText.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!(VersionCatalogNamingUtilKt.isAfterDelimiter(i2, keyText) ? VersionCatalogNamingUtilKt.normalizeIgnoreCase(keyText.charAt(i2)) != VersionCatalogNamingUtilKt.normalize(reference.charAt(i2)) : VersionCatalogNamingUtilKt.normalize(keyText.charAt(i2)) != VersionCatalogNamingUtilKt.normalize(reference.charAt(i2)))) continue;
            return false;
        }
        return true;
    }

    private static final boolean isAfterDelimiter(int index2, String s2) {
        return index2 > 0 && VersionCatalogNamingUtilKt.normalize(s2.charAt(index2 - 1)) == '.';
    }

    private static final char normalizeIgnoreCase(char $this$normalizeIgnoreCase) {
        if ($this$normalizeIgnoreCase == '-' || $this$normalizeIgnoreCase == '_') {
            return '.';
        }
        return Character.toLowerCase($this$normalizeIgnoreCase);
    }

    private static final char normalize(char $this$normalize) {
        if ($this$normalize == '-' || $this$normalize == '_') {
            return '.';
        }
        return $this$normalize;
    }

    private static final boolean toSafeKey$isSafe(char $this$toSafeKey_u24isSafe) {
        return Character.isLowerCase($this$toSafeKey_u24isSafe) || Character.isDigit($this$toSafeKey_u24isSafe);
    }

    private static final boolean toSafeKey$isSeparator(char $this$toSafeKey_u24isSeparator) {
        return $this$toSafeKey_u24isSeparator == '_' || $this$toSafeKey_u24isSeparator == '-';
    }
}

