/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.DataFile;
import com.android.ide.common.resources.DataMerger;
import com.android.ide.common.resources.GeneratedResourceSet;
import com.android.ide.common.resources.MergeConsumer;
import com.android.ide.common.resources.MergedResourceMergerItem;
import com.android.ide.common.resources.MergingException;
import com.android.ide.common.resources.NodeUtils;
import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceMergerItem;
import com.android.ide.common.resources.ResourceSet;
import com.android.ide.common.resources.ValueResourceParser2;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.resources.ResourceType;
import com.android.utils.Pair;
import com.google.common.base.MoreObjects;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceMerger
extends DataMerger<ResourceMergerItem, ResourceFile, ResourceSet> {
    private static final String NODE_MERGED_ITEMS = "mergedItems";
    private int mMinSdk;
    private Set<String> mRejectCache;
    protected final Map<String, Map<String, ResourceMergerItem>> mMergedItems = new HashMap<String, Map<String, ResourceMergerItem>>();

    public ResourceMerger(int minSdk) {
        this.mMinSdk = minSdk;
    }

    public ResourceMerger(int minSdk, DocumentBuilderFactory factory) {
        super(factory);
        this.mMinSdk = minSdk;
    }

    @Override
    protected ResourceSet createFromXml(Node node, String aaptEnv) throws MergingException {
        String fromDependency;
        String generated = NodeUtils.getAttribute(node, "generated");
        ResourceNamespace aaptNamespace = null;
        String namespaceUri = NodeUtils.getAttribute(node, "aapt-namespace");
        if (namespaceUri != null) {
            aaptNamespace = ResourceNamespace.fromNamespaceUri(namespaceUri);
        }
        aaptNamespace = MoreObjects.firstNonNull(aaptNamespace, ResourceNamespace.RES_AUTO);
        ResourceSet set = "true".equals(generated) ? new GeneratedResourceSet("", aaptNamespace, null, aaptEnv) : new ResourceSet("", aaptNamespace, null, true, aaptEnv);
        ResourceSet newResourceSet = (ResourceSet)set.createFromXml(node, aaptEnv);
        String generatedSetName = NodeUtils.getAttribute(node, "generated-set");
        if (generatedSetName != null) {
            for (ResourceSet resourceSet : this.getDataSets()) {
                if (!resourceSet.getConfigName().equals(generatedSetName)) continue;
                newResourceSet.setGeneratedSet(resourceSet);
                break;
            }
        }
        if ("true".equals(fromDependency = NodeUtils.getAttribute(node, "from-dependency"))) {
            newResourceSet.setFromDependency(true);
        }
        return newResourceSet;
    }

    @Override
    protected boolean requiresMerge(String dataItemKey) {
        return dataItemKey.startsWith(ResourceType.STYLEABLE.getName() + "/");
    }

    @Override
    protected void mergeItems(String dataItemKey, List<ResourceMergerItem> items, MergeConsumer<ResourceMergerItem> consumer2) throws MergingException {
        boolean touched = false;
        boolean removed = true;
        for (ResourceMergerItem item : items) {
            touched |= item.isTouched();
            removed &= item.isRemoved();
        }
        ResourceMergerItem sourceItem = items.get(0);
        String itemName = sourceItem.getName();
        String qualifier = sourceItem.getQualifiers();
        String libraryName = sourceItem.getLibraryName();
        ResourceNamespace namespace = sourceItem.getNamespace();
        ResourceMergerItem previouslyWrittenItem = this.getMergedItem(qualifier, itemName);
        try {
            if (touched || previouslyWrittenItem == null && !removed) {
                ResourceMergerItem newItem = sourceItem;
                if (items.size() > 1) {
                    DocumentBuilder builder = this.mFactory.newDocumentBuilder();
                    Document document = builder.newDocument();
                    Element declareStyleableNode = document.createElementNS(null, "declare-styleable");
                    Attr nameAttr = document.createAttribute("name");
                    nameAttr.setValue(itemName);
                    declareStyleableNode.getAttributes().setNamedItem(nameAttr);
                    HashSet<String> attrs = Sets.newHashSet();
                    for (ResourceMergerItem item : items) {
                        Node oldDeclareStyleable;
                        if (item.isRemoved() || (oldDeclareStyleable = item.getValue()) == null) continue;
                        NodeList children2 = oldDeclareStyleable.getChildNodes();
                        for (int i2 = 0; i2 < children2.getLength(); ++i2) {
                            String name2;
                            NamedNodeMap attributes;
                            Node attrNode = children2.item(i2);
                            if (attrNode.getNodeType() != 1 || "eat-comment".equals(attrNode.getLocalName()) || (nameAttr = (Attr)(attributes = attrNode.getAttributes()).getNamedItemNS(null, "name")) == null || attrs.contains(name2 = nameAttr.getNodeValue())) continue;
                            attrs.add(name2);
                            Node newAttrNode = NodeUtils.duplicateNode(document, attrNode);
                            declareStyleableNode.appendChild(newAttrNode);
                        }
                    }
                    newItem = new MergedResourceMergerItem(itemName, namespace, sourceItem.getType(), qualifier, declareStyleableNode, libraryName);
                }
                if (previouslyWrittenItem == null || !NodeUtils.compareElementNode(newItem.getValue(), previouslyWrittenItem.getValue(), false)) {
                    newItem.setTouched();
                }
                this.addMergedItem(qualifier, newItem);
                consumer2.addItem(newItem);
            } else if (previouslyWrittenItem != null) {
                if (removed) {
                    consumer2.removeItem(previouslyWrittenItem, null);
                } else {
                    consumer2.addItem(previouslyWrittenItem);
                }
            }
        }
        catch (ParserConfigurationException e2) {
            throw MergingException.wrapException(e2).build();
        }
    }

    private ResourceMergerItem getMergedItem(String qualifiers, String name2) {
        Map<String, ResourceMergerItem> map2 = this.mMergedItems.get(qualifiers);
        if (map2 != null) {
            return map2.get(name2);
        }
        return null;
    }

    @Override
    protected String getAdditionalDataTagName() {
        return NODE_MERGED_ITEMS;
    }

    @Override
    protected void loadAdditionalData(Node mergedItemsNode, boolean incrementalState) throws MergingException {
        if (!incrementalState) {
            return;
        }
        NodeList configurationList = mergedItemsNode.getChildNodes();
        int n2 = configurationList.getLength();
        for (int j2 = 0; j2 < n2; ++j2) {
            Attr qualifierAttr;
            Node configuration = configurationList.item(j2);
            if (configuration.getNodeType() != 1 || !"configuration".equals(configuration.getLocalName()) || (qualifierAttr = (Attr)configuration.getAttributes().getNamedItem("qualifiers")) == null) continue;
            String qualifier = qualifierAttr.getValue();
            NodeList itemList = configuration.getChildNodes();
            int n3 = itemList.getLength();
            for (int k2 = 0; k2 < n3; ++k2) {
                MergedResourceMergerItem item;
                Node itemNode = itemList.item(k2);
                if (itemNode.getNodeType() != 1 || (item = ResourceMerger.getMergedResourceMergerItem(itemNode, qualifier)) == null) continue;
                this.addMergedItem(qualifier, item);
            }
        }
    }

    @Override
    protected void writeAdditionalData(Document document, Node rootNode) {
        Element mergedItemsNode = document.createElement(this.getAdditionalDataTagName());
        rootNode.appendChild(mergedItemsNode);
        for (String qualifier : this.mMergedItems.keySet()) {
            Map<String, ResourceMergerItem> itemMap = this.mMergedItems.get(qualifier);
            Element qualifierNode = document.createElement("configuration");
            NodeUtils.addAttribute(document, qualifierNode, null, "qualifiers", qualifier);
            mergedItemsNode.appendChild(qualifierNode);
            for (ResourceMergerItem item : itemMap.values()) {
                Node adoptedNode = item.getDetailsXml(document);
                if (adoptedNode == null) continue;
                qualifierNode.appendChild(adoptedNode);
            }
        }
    }

    private void addMergedItem(String qualifier, ResourceMergerItem item) {
        Map<String, ResourceMergerItem> map2 = this.mMergedItems.get(qualifier);
        if (map2 == null) {
            map2 = Maps.newHashMap();
            this.mMergedItems.put(qualifier, map2);
        }
        map2.put(item.getName(), item);
    }

    static MergedResourceMergerItem getMergedResourceMergerItem(Node node, String qualifiers) throws MergingException {
        ResourceType type = ValueResourceParser2.getType(node, null);
        String name2 = ValueResourceParser2.getName(node);
        if (name2 != null && type != null) {
            return new MergedResourceMergerItem(name2, ResourceNamespace.TODO(), type, qualifiers, node, null);
        }
        return null;
    }

    @Override
    public void addDataSet(ResourceSet resourceSet) {
        super.addDataSet(resourceSet);
    }

    @Override
    public void mergeData(MergeConsumer<ResourceMergerItem> consumer2, boolean doCleanUp) throws MergingException {
        this.clearFilterCache();
        super.mergeData(consumer2, doCleanUp);
    }

    @Override
    protected boolean filterAccept(ResourceMergerItem dataItem) {
        if (this.mRejectCache == null) {
            this.buildCache();
        }
        boolean accepted = !this.mRejectCache.contains(dataItem.getKey());
        return accepted;
    }

    private void buildCache() {
        this.mRejectCache = Sets.newHashSet();
        HashBasedTable<CallSite, FolderConfiguration, Pair<Integer, ResourceMergerItem>> itemCache = HashBasedTable.create();
        HashSet<String> acceptCache = Sets.newHashSet();
        for (ResourceSet resourceSet : this.getDataSets()) {
            ListMultimap map2 = resourceSet.getDataMap();
            for (ResourceMergerItem resourceItem : map2.values()) {
                FolderConfiguration qualifierWithoutSdk;
                int resourceMinSdk;
                String resourceKey = resourceItem.getKey();
                if (acceptCache.contains(resourceKey) || this.mRejectCache.contains(resourceKey)) continue;
                if (resourceItem.getSourceType() != DataFile.FileType.SINGLE_FILE) {
                    acceptCache.add(resourceKey);
                    continue;
                }
                FolderConfiguration config = resourceItem.getConfiguration();
                if (!ResourceQualifier.isValid(config.getVersionQualifier())) {
                    resourceMinSdk = 0;
                    qualifierWithoutSdk = config;
                } else {
                    resourceMinSdk = config.getVersionQualifier().getVersion();
                    qualifierWithoutSdk = FolderConfiguration.copyOf(config);
                    qualifierWithoutSdk.removeQualifier(qualifierWithoutSdk.getVersionQualifier());
                }
                if (resourceMinSdk > this.mMinSdk) {
                    acceptCache.add(resourceKey);
                    continue;
                }
                String resourceCacheId = resourceItem.getType().getName() + "-" + resourceItem.getName();
                Pair<Integer, ResourceMergerItem> selectedResource = (Pair<Integer, ResourceMergerItem>)itemCache.get(resourceCacheId, qualifierWithoutSdk);
                if (selectedResource == null) {
                    selectedResource = Pair.of(resourceMinSdk, resourceItem);
                    itemCache.put((CallSite)((Object)resourceCacheId), qualifierWithoutSdk, selectedResource);
                    acceptCache.add(resourceKey);
                    continue;
                }
                if ((Integer)selectedResource.getFirst() > resourceMinSdk) {
                    this.mRejectCache.add(resourceKey);
                    continue;
                }
                String removeKey = selectedResource.getSecond().getKey();
                acceptCache.remove(removeKey);
                this.mRejectCache.add(removeKey);
                acceptCache.add(resourceKey);
                selectedResource = Pair.of(resourceMinSdk, resourceItem);
                itemCache.put((CallSite)((Object)resourceCacheId), qualifierWithoutSdk, selectedResource);
            }
        }
    }

    private void clearFilterCache() {
        this.mRejectCache = null;
    }
}

