/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.ide.common.blame.Message;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.DataFile;
import com.android.ide.common.resources.DataSet;
import com.android.ide.common.resources.FileResourceNameValidator;
import com.android.ide.common.resources.GeneratedResourceMergerItem;
import com.android.ide.common.resources.IdGeneratingResourceParser;
import com.android.ide.common.resources.MergeConsumer;
import com.android.ide.common.resources.MergingException;
import com.android.ide.common.resources.NoOpResourcePreprocessor;
import com.android.ide.common.resources.NodeUtils;
import com.android.ide.common.resources.ResourceFile;
import com.android.ide.common.resources.ResourceMergerItem;
import com.android.ide.common.resources.ResourcePreprocessor;
import com.android.ide.common.resources.ValueResourceParser2;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.utils.ILogger;
import com.android.utils.SdkUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceSet
extends DataSet<ResourceMergerItem, ResourceFile> {
    public static final String ATTR_GENERATED_SET = "generated-set";
    public static final String ATTR_FROM_DEPENDENCY = "from-dependency";
    public static final String ATTR_AAPT_NAMESPACE = "aapt-namespace";
    private final String mLibraryName;
    private final ResourceNamespace mNamespace;
    private ResourceSet mGeneratedSet;
    private ResourcePreprocessor mPreprocessor;
    private boolean mIsFromDependency;
    private boolean mShouldParseResourceIds;
    private boolean mDontNormalizeQualifiers;
    private boolean mTrackSourcePositions = true;
    private boolean mCheckDuplicates = true;

    public ResourceSet(String name2, ResourceNamespace namespace, String libraryName, boolean validateEnabled, String aaptEnv) {
        super(name2, validateEnabled, aaptEnv);
        this.mNamespace = namespace;
        this.mPreprocessor = NoOpResourcePreprocessor.INSTANCE;
        this.mLibraryName = libraryName;
    }

    public String getLibraryName() {
        return this.mLibraryName;
    }

    public void setGeneratedSet(ResourceSet generatedSet) {
        this.mGeneratedSet = generatedSet;
    }

    public void setPreprocessor(ResourcePreprocessor preprocessor) {
        this.mPreprocessor = Preconditions.checkNotNull(preprocessor);
    }

    public void setShouldParseResourceIds(boolean shouldParse) {
        this.mShouldParseResourceIds = shouldParse;
    }

    public void setDontNormalizeQualifiers(boolean dontNormalizeQualifiers) {
        this.mDontNormalizeQualifiers = dontNormalizeQualifiers;
    }

    public void setTrackSourcePositions(boolean shouldTrack) {
        this.mTrackSourcePositions = shouldTrack;
    }

    public void setCheckDuplicates(boolean value) {
        this.mCheckDuplicates = value;
    }

    @Override
    protected DataSet<ResourceMergerItem, ResourceFile> createSet(String name2, String aaptEnv) {
        return new ResourceSet(name2, this.mNamespace, this.mLibraryName, true, aaptEnv);
    }

    @Override
    protected ResourceFile createFileAndItems(File sourceFolder, File file2, ILogger logger, DocumentBuilderFactory factory) throws MergingException {
        FolderData folderData = this.getFolderData(file2.getParentFile());
        if (folderData == null) {
            return null;
        }
        return this.createResourceFile(file2, folderData, logger, factory);
    }

    @Override
    protected ResourceFile createFileAndItemsFromXml(File file2, Node fileNode) throws MergingException {
        String qualifier = MoreObjects.firstNonNull(NodeUtils.getAttribute(fileNode, "qualifiers"), "");
        String typeAttr = NodeUtils.getAttribute(fileNode, "type");
        FolderConfiguration folderConfiguration = FolderConfiguration.getConfigForQualifierString(qualifier);
        if (folderConfiguration == null) {
            return null;
        }
        if (NodeUtils.getAttribute(fileNode, "preprocessing") != null) {
            NodeList childNodes = fileNode.getChildNodes();
            int childCount = childNodes.getLength();
            ArrayList<ResourceMergerItem> resourceItems = Lists.newArrayListWithCapacity(childCount);
            for (int i2 = 0; i2 < childCount; ++i2) {
                String qualifers;
                Node childNode = childNodes.item(i2);
                String path = NodeUtils.getAttribute(childNode, "path");
                if (path == null) continue;
                File generatedFile = new File(path);
                String resourceType = NodeUtils.getAttribute(childNode, "type");
                if (resourceType == null || (qualifers = NodeUtils.getAttribute(childNode, "qualifiers")) == null) continue;
                resourceItems.add(new GeneratedResourceMergerItem(ResourceSet.getNameForFile(generatedFile), this.mNamespace, generatedFile, FolderTypeRelationship.getRelatedResourceTypes(ResourceFolderType.getTypeByName(resourceType)).get(0), qualifers, this.mLibraryName));
            }
            return ResourceFile.generatedFiles(file2, resourceItems, folderConfiguration);
        }
        if (typeAttr == null) {
            ResourceFolderType folderType;
            ArrayList<ResourceMergerItem> resourceList = Lists.newArrayList();
            NodeList resNodes = fileNode.getChildNodes();
            int i3 = 0;
            File parent = file2.getParentFile();
            if (parent != null && (folderType = ResourceFolderType.getFolderType(parent.getName())) != ResourceFolderType.VALUES && resNodes.getLength() > 0) {
                ResourceType resourceType;
                Node firstChild = resNodes.item(0);
                String name2 = NodeUtils.getAttribute(firstChild, "name");
                String type = NodeUtils.getAttribute(firstChild, "type");
                if (name2 != null && type != null && (resourceType = ResourceType.fromClassName(type)) != null) {
                    resourceList.add(new IdGeneratingResourceParser.IdResourceMergerItem(name2, this.mNamespace, resourceType, this.mLibraryName));
                    ++i3;
                }
            }
            int nodesCount = resNodes.getLength();
            while (i3 < nodesCount) {
                ResourceMergerItem r2;
                Node resNode = resNodes.item(i3);
                if (resNode.getNodeType() == 1 && (r2 = ValueResourceParser2.getResource(resNode, file2, this.mNamespace, this.mLibraryName)) != null) {
                    resourceList.add(r2);
                    if (r2.getType() == ResourceType.STYLEABLE) {
                        try {
                            ValueResourceParser2.addStyleableItems(resNode, resourceList, null, file2, this.mNamespace, this.mLibraryName);
                        }
                        catch (MergingException e2) {
                            throw new AssertionError(null, e2);
                        }
                    }
                }
                ++i3;
            }
            return new ResourceFile(file2, resourceList, folderConfiguration);
        }
        ResourceType type = ResourceType.fromClassName(typeAttr);
        if (type == null) {
            return null;
        }
        String nameAttr = NodeUtils.getAttribute(fileNode, "name");
        if (nameAttr == null) {
            return null;
        }
        if (this.getValidateEnabled()) {
            FileResourceNameValidator.validate(file2, ResourceFolderType.getFolderType(file2.getParentFile().getName()));
        }
        ResourceMergerItem item = new ResourceMergerItem(nameAttr, this.mNamespace, type, null, this.mIsFromDependency, this.mLibraryName);
        return new ResourceFile(file2, item, folderConfiguration);
    }

    @Override
    protected void readSourceFolder(File sourceFolder, ILogger logger, DocumentBuilderFactory factory) throws MergingException {
        ArrayList<Message> errors = Lists.newArrayList();
        File[] folders = sourceFolder.listFiles();
        if (folders != null) {
            for (File folder : folders) {
                FolderData folderData;
                if (!folder.isDirectory() || this.isIgnored(folder) || (folderData = this.getFolderData(folder)) == null) continue;
                try {
                    this.parseFolder(sourceFolder, folder, folderData, logger, factory);
                }
                catch (MergingException e2) {
                    errors.addAll(e2.getMessages());
                }
            }
        }
        MergingException.throwIfNonEmpty(errors);
    }

    @Override
    protected boolean isValidSourceFile(File sourceFolder, File file2) {
        if (!super.isValidSourceFile(sourceFolder, file2)) {
            return false;
        }
        File resFolder = file2.getParentFile();
        return resFolder.getParentFile().equals(sourceFolder) && !this.isIgnored(resFolder) && ResourceFolderType.getFolderType(resFolder.getName()) != null;
    }

    @Override
    protected ResourceFile handleNewFile(File sourceFolder, File file2, ILogger logger, DocumentBuilderFactory factory) throws MergingException {
        ResourceFile resourceFile = this.createFileAndItems(sourceFolder, file2, logger, factory);
        this.processNewResourceFile(sourceFolder, resourceFile);
        return resourceFile;
    }

    @Override
    protected boolean handleRemovedFile(File removedFile) {
        if (this.mGeneratedSet != null && this.mGeneratedSet.getDataFile(removedFile) != null) {
            return this.mGeneratedSet.handleRemovedFile(removedFile);
        }
        return super.handleRemovedFile(removedFile);
    }

    @Override
    protected boolean handleChangedFile(File sourceFolder, File changedFile, ILogger logger, DocumentBuilderFactory factory) throws MergingException {
        boolean needsPreprocessing;
        FolderData folderData = this.getFolderData(changedFile.getParentFile());
        if (folderData == null) {
            return true;
        }
        ResourceFile resourceFile = (ResourceFile)this.getDataFile(changedFile);
        if (this.mGeneratedSet == null) {
            this.doHandleChangedFile(changedFile, resourceFile, factory);
            return true;
        }
        ResourceFile generatedSetResourceFile = (ResourceFile)this.mGeneratedSet.getDataFile(changedFile);
        boolean bl2 = needsPreprocessing = !this.getResourceMergerItemsForGeneratedFilesIfNotFromDependency(changedFile).isEmpty();
        if (resourceFile != null && generatedSetResourceFile == null && needsPreprocessing) {
            this.handleRemovedFile(changedFile);
            this.mGeneratedSet.handleNewFile(sourceFolder, changedFile, logger, factory);
        } else if (resourceFile == null && generatedSetResourceFile != null && !needsPreprocessing) {
            this.mGeneratedSet.handleRemovedFile(changedFile);
            this.handleNewFile(sourceFolder, changedFile, logger, factory);
        } else if (resourceFile == null && generatedSetResourceFile != null && needsPreprocessing) {
            this.mGeneratedSet.handleChangedFile(sourceFolder, changedFile, logger, factory);
        } else if (resourceFile != null && !needsPreprocessing && generatedSetResourceFile == null) {
            this.doHandleChangedFile(changedFile, resourceFile, factory);
        } else {
            throw MergingException.withMessage("In DataSet '%s', no data file for changedFile. This is an internal error in the incremental builds code; to work around it, try doing a full clean build.", this.getConfigName()).withFile(changedFile).build();
        }
        return true;
    }

    private void doHandleChangedFile(File changedFile, ResourceFile resourceFile, DocumentBuilderFactory factory) throws MergingException {
        switch (resourceFile.getType()) {
            case SINGLE_FILE: {
                ((ResourceMergerItem)resourceFile.getItem()).setTouched();
                break;
            }
            case GENERATED_FILES: {
                this.handleChangedItems(resourceFile, this.getResourceMergerItemsForGeneratedFiles(changedFile));
                break;
            }
            case XML_VALUES: {
                ValueResourceParser2 parser = new ValueResourceParser2(changedFile, this.mNamespace, this.mLibraryName);
                parser.setTrackSourcePositions(this.mTrackSourcePositions);
                parser.setCheckDuplicates(this.mCheckDuplicates);
                List<ResourceMergerItem> parsedItems = parser.parseFile(factory);
                this.handleChangedItems(resourceFile, parsedItems);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void handleChangedItems(ResourceFile resourceFile, List<ResourceMergerItem> currentItems) throws MergingException {
        HashMap oldItems = Maps.newHashMap(resourceFile.getItemMap());
        HashMap<String, ResourceMergerItem> addedItems = Maps.newHashMap();
        for (ResourceMergerItem resourceMergerItem : currentItems) {
            resourceMergerItem.setSourceFile(resourceFile);
        }
        for (ResourceMergerItem resourceMergerItem : currentItems) {
            String newKey = resourceMergerItem.getKey();
            ResourceMergerItem oldItem = (ResourceMergerItem)oldItems.get(newKey);
            if (oldItem == null) {
                resourceMergerItem.setTouched();
                addedItems.put(newKey, resourceMergerItem);
                continue;
            }
            oldItems.remove(oldItem.getKey());
            if (((ResourceFile)oldItem.getSourceFile()).getType() == DataFile.FileType.XML_VALUES) {
                if (oldItem.compareValueWith(resourceMergerItem)) continue;
                oldItem.setValue(resourceMergerItem);
                continue;
            }
            oldItem.setTouched();
        }
        for (ResourceMergerItem resourceMergerItem : oldItems.values()) {
            resourceMergerItem.setRemoved();
        }
        for (Map.Entry entry : addedItems.entrySet()) {
            ((ResourceMergerItem)entry.getValue()).setSourceFile(null);
            this.addItem((ResourceMergerItem)entry.getValue(), (String)entry.getKey());
        }
        resourceFile.addItems(addedItems.values());
    }

    private void parseFolder(File sourceFolder, File folder, FolderData folderData, ILogger logger, DocumentBuilderFactory factory) throws MergingException {
        File[] files2 = folder.listFiles();
        if (files2 != null && files2.length > 0) {
            for (File file2 : files2) {
                if (!file2.isFile() || this.isIgnored(file2)) continue;
                ResourceFile resourceFile = this.createResourceFile(file2, folderData, logger, factory);
                this.processNewResourceFile(sourceFolder, resourceFile);
            }
        }
    }

    private void processNewResourceFile(File sourceFolder, ResourceFile resourceFile) throws MergingException {
        if (resourceFile != null) {
            if (resourceFile.getType() == DataFile.FileType.GENERATED_FILES && this.mGeneratedSet != null) {
                this.mGeneratedSet.processNewDataFile(sourceFolder, resourceFile, true);
            } else {
                this.processNewDataFile(sourceFolder, resourceFile, true);
            }
        }
    }

    private ResourceFile createResourceFile(File file2, FolderData folderData, ILogger logger, DocumentBuilderFactory factory) throws MergingException {
        if (this.getValidateEnabled()) {
            FileResourceNameValidator.validate(file2, folderData.folderType);
        }
        if (folderData.type != null) {
            List<ResourceMergerItem> generatedFiles = this.getResourceMergerItemsForGeneratedFilesIfNotFromDependency(file2);
            if (!generatedFiles.isEmpty()) {
                return ResourceFile.generatedFiles(file2, generatedFiles, folderData.folderConfiguration);
            }
            if (this.mShouldParseResourceIds && folderData.isIdGenerating && SdkUtils.endsWithIgnoreCase(file2.getPath(), ".xml")) {
                List<ResourceMergerItem> items;
                String resourceName = ResourceSet.getNameForFile(file2);
                if (resourceName.isEmpty()) {
                    items = Collections.emptyList();
                } else {
                    IdGeneratingResourceParser parser = new IdGeneratingResourceParser(file2, resourceName, folderData.type, this.mNamespace, this.mLibraryName);
                    Collection<ResourceMergerItem> idItems = parser.getIdResourceMergerItems();
                    ResourceMergerItem fileItem = parser.getFileResourceMergerItem();
                    items = new ArrayList<ResourceMergerItem>(idItems.size() + 1);
                    items.add(fileItem);
                    items.addAll(idItems);
                }
                return new ResourceFile(file2, items, folderData.folderConfiguration);
            }
            return new ResourceFile(file2, new ResourceMergerItem(ResourceSet.getNameForFile(file2), this.mNamespace, folderData.type, null, this.mIsFromDependency, this.mLibraryName), folderData.folderConfiguration);
        }
        try {
            ValueResourceParser2 parser = new ValueResourceParser2(file2, this.mNamespace, this.mLibraryName);
            parser.setTrackSourcePositions(this.mTrackSourcePositions);
            parser.setCheckDuplicates(this.mCheckDuplicates);
            List<ResourceMergerItem> items = parser.parseFile(factory);
            return new ResourceFile(file2, items, folderData.folderConfiguration);
        }
        catch (MergingException e2) {
            logger.error(e2, "Failed to parse %s", file2.getAbsolutePath());
            throw e2;
        }
    }

    private List<ResourceMergerItem> getResourceMergerItemsForGeneratedFilesIfNotFromDependency(File file2) throws MergingException {
        if (this.mIsFromDependency) {
            return Collections.emptyList();
        }
        return this.getResourceMergerItemsForGeneratedFiles(file2);
    }

    private List<ResourceMergerItem> getResourceMergerItemsForGeneratedFiles(File file2) throws MergingException {
        Collection<File> filesToBeGenerated;
        try {
            filesToBeGenerated = this.mPreprocessor.getFilesToBeGenerated(file2);
        }
        catch (IOException e2) {
            throw new MergingException(e2, new Message[0]);
        }
        ArrayList<ResourceMergerItem> resourceItems = new ArrayList<ResourceMergerItem>(filesToBeGenerated.size());
        for (File generatedFile : filesToBeGenerated) {
            FolderData generatedFileFolderData = this.getFolderData(generatedFile.getParentFile());
            Preconditions.checkState(generatedFileFolderData != null, "Can't determine folder type for %s", (Object)generatedFile.getPath());
            resourceItems.add(new GeneratedResourceMergerItem(ResourceSet.getNameForFile(generatedFile), this.mNamespace, generatedFile, generatedFileFolderData.type, generatedFileFolderData.folderConfiguration.getQualifierString(), this.mLibraryName));
        }
        return resourceItems;
    }

    private static String getNameForFile(File file2) {
        String name2 = file2.getName();
        int pos = name2.indexOf(46);
        if (pos >= 0) {
            name2 = name2.substring(0, pos);
        }
        return name2;
    }

    public boolean isFromDependency() {
        return this.mIsFromDependency;
    }

    public void setFromDependency(boolean fromDependency) {
        this.mIsFromDependency = fromDependency;
    }

    private FolderData getFolderData(File folder) throws MergingException {
        FolderData fd = new FolderData();
        String folderName = folder.getName();
        int pos = folderName.indexOf(45);
        if (pos != -1) {
            fd.folderType = ResourceFolderType.getTypeByName(folderName.substring(0, pos));
            if (fd.folderType == null) {
                return null;
            }
            FolderConfiguration folderConfiguration = FolderConfiguration.getConfigForFolder(folderName);
            if (folderConfiguration == null) {
                throw MergingException.withMessage("Invalid resource directory name", new Object[0]).withFile(folder).build();
            }
            if (!this.mDontNormalizeQualifiers) {
                folderConfiguration.normalizeByAddingImpliedVersionQualifier();
            }
            fd.folderConfiguration = folderConfiguration;
        } else {
            fd.folderType = ResourceFolderType.getTypeByName(folderName);
        }
        if (fd.folderType != null && fd.folderType != ResourceFolderType.VALUES) {
            fd.type = FolderTypeRelationship.getNonIdRelatedResourceType(fd.folderType);
            fd.isIdGenerating = FolderTypeRelationship.isIdGeneratingFolderType(fd.folderType);
        }
        return fd;
    }

    @Override
    void appendToXml(Node setNode, Document document, MergeConsumer<ResourceMergerItem> consumer2, boolean includeTimestamps) {
        if (this.mGeneratedSet != null) {
            NodeUtils.addAttribute(document, setNode, null, ATTR_GENERATED_SET, this.mGeneratedSet.getConfigName());
        }
        if (this.mIsFromDependency) {
            NodeUtils.addAttribute(document, setNode, null, ATTR_FROM_DEPENDENCY, "true");
        }
        NodeUtils.addAttribute(document, setNode, null, ATTR_AAPT_NAMESPACE, this.mNamespace.getXmlNamespaceUri());
        super.appendToXml(setNode, document, consumer2, includeTimestamps);
    }

    public ResourceNamespace getNamespace() {
        return this.mNamespace;
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        ResourceSet that = (ResourceSet)o2;
        return this.mIsFromDependency == that.mIsFromDependency && this.mShouldParseResourceIds == that.mShouldParseResourceIds && this.mDontNormalizeQualifiers == that.mDontNormalizeQualifiers && this.mTrackSourcePositions == that.mTrackSourcePositions && Objects.equals(this.mNamespace, that.mNamespace) && Objects.equals(this.mLibraryName, that.mLibraryName) && Objects.equals(this.mGeneratedSet, that.mGeneratedSet) && Objects.equals(this.mPreprocessor, that.mPreprocessor);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.mLibraryName, this.mGeneratedSet, this.mPreprocessor, this.mIsFromDependency, this.mNamespace, this.mShouldParseResourceIds, this.mDontNormalizeQualifiers, this.mTrackSourcePositions);
    }

    private static class FolderData {
        FolderConfiguration folderConfiguration = new FolderConfiguration();
        ResourceType type = null;
        ResourceFolderType folderType = null;
        boolean isIdGenerating = false;

        private FolderData() {
        }
    }
}

