/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.sampledata;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class CSVReader {
    private BufferedReader br;
    private boolean hasNext = true;
    private char separator;
    private char quotechar;
    private int skipLines;
    private boolean linesSkiped;
    public static final char DEFAULT_SEPARATOR = ',';
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';
    public static final int DEFAULT_SKIP_LINES = 0;

    public CSVReader(Reader reader) {
        this(reader, ',');
    }

    public CSVReader(Reader reader, char separator) {
        this(reader, separator, '\"');
    }

    public CSVReader(Reader reader, char separator, char quotechar) {
        this(reader, separator, quotechar, 0);
    }

    public CSVReader(Reader reader, char separator, char quotechar, int line) {
        this.br = new BufferedReader(reader);
        this.separator = separator;
        this.quotechar = quotechar;
        this.skipLines = line;
    }

    public List<String[]> readAll() throws IOException {
        ArrayList<String[]> allElements = new ArrayList<String[]>();
        while (this.hasNext) {
            String[] nextLineAsTokens = this.readNext();
            if (nextLineAsTokens == null) continue;
            allElements.add(nextLineAsTokens);
        }
        return allElements;
    }

    public String[] readNext() throws IOException {
        String nextLine = this.getNextLine();
        return this.hasNext ? this.parseLine(nextLine) : null;
    }

    private String getNextLine() throws IOException {
        String nextLine;
        if (!this.linesSkiped) {
            for (int i2 = 0; i2 < this.skipLines; ++i2) {
                this.br.readLine();
            }
            this.linesSkiped = true;
        }
        if ((nextLine = this.br.readLine()) == null) {
            this.hasNext = false;
        }
        return this.hasNext ? nextLine : null;
    }

    public String[] parseLine(String nextLine) throws IOException {
        if (nextLine == null) {
            return null;
        }
        ArrayList<String> tokensOnThisLine = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        boolean inQuotes = false;
        do {
            if (inQuotes) {
                sb.append("\n");
                nextLine = this.getNextLine();
                if (nextLine == null) break;
            }
            for (int i2 = 0; i2 < nextLine.length(); ++i2) {
                char c2 = nextLine.charAt(i2);
                if (c2 == this.quotechar) {
                    if (inQuotes && nextLine.length() > i2 + 1 && nextLine.charAt(i2 + 1) == this.quotechar) {
                        sb.append(nextLine.charAt(i2 + 1));
                        ++i2;
                        continue;
                    }
                    boolean bl2 = inQuotes = !inQuotes;
                    if (i2 <= 2 || nextLine.charAt(i2 - 1) == this.separator || nextLine.length() <= i2 + 1 || nextLine.charAt(i2 + 1) == this.separator) continue;
                    sb.append(c2);
                    continue;
                }
                if (c2 == this.separator && !inQuotes) {
                    tokensOnThisLine.add(sb.toString());
                    sb = new StringBuffer();
                    continue;
                }
                sb.append(c2);
            }
        } while (inQuotes);
        tokensOnThisLine.add(sb.toString());
        return tokensOnThisLine.toArray(new String[0]);
    }

    public void close() throws IOException {
        this.br.close();
    }
}

