/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.sampledata;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class SampleDataJsonParser {
    private static final Logger LOG = Logger.getLogger(SampleDataJsonParser.class.getSimpleName());
    private static final Splitter PATH_SPLITTER = Splitter.on('/').omitEmptyStrings().trimResults();
    private static final Joiner NEW_LINE_JOINER = Joiner.on('\n');
    private final JsonObject myRootObject;

    private SampleDataJsonParser(JsonObject rootObject) {
        this.myRootObject = rootObject;
    }

    public static SampleDataJsonParser parse(Reader reader) {
        JsonParser parser = new JsonParser();
        try {
            return new SampleDataJsonParser(parser.parse(reader).getAsJsonObject());
        }
        catch (Throwable e2) {
            LOG.throwing("SampleDataJsonParser", "parse", e2);
            return null;
        }
    }

    public byte[] getContentFromPath(String path) {
        ImmutableList<String> pathItems = ImmutableList.copyOf(PATH_SPLITTER.splitToList(path));
        ArrayList<String> content = new ArrayList<String>();
        SampleDataJsonParser.visitElementAndGetContent(this.myRootObject, pathItems, content);
        return NEW_LINE_JOINER.join(content).getBytes(Charsets.UTF_8);
    }

    public Set<String> getPossiblePaths() {
        HashSet<String> paths2 = new HashSet<String>();
        SampleDataJsonParser.visitElementAndGetPath(this.myRootObject, "", paths2);
        return paths2;
    }

    static void visitElementAndGetPath(JsonElement name2, String pathSoFar, Set<String> pathOut) {
        if (name2 == null) {
            return;
        }
        if (name2.isJsonPrimitive()) {
            pathOut.add(pathSoFar);
        } else if (name2.isJsonArray()) {
            JsonArray array2 = name2.getAsJsonArray();
            for (int i2 = 0; i2 < array2.size(); ++i2) {
                SampleDataJsonParser.visitElementAndGetPath(array2.get(i2), pathSoFar, pathOut);
            }
        } else if (name2.isJsonObject()) {
            JsonObject object = name2.getAsJsonObject();
            object.entrySet().forEach(entry -> SampleDataJsonParser.visitElementAndGetPath((JsonElement)entry.getValue(), pathSoFar + "/" + (String)entry.getKey(), pathOut));
        }
    }

    static void visitElementAndGetContent(JsonElement name2, List<String> path, List<String> contentOut) {
        if (name2 == null) {
            return;
        }
        if (path.isEmpty()) {
            contentOut.add(name2.getAsString());
            return;
        }
        if (name2.isJsonArray()) {
            JsonArray array2 = name2.getAsJsonArray();
            for (int i2 = 0; i2 < array2.size(); ++i2) {
                SampleDataJsonParser.visitElementAndGetContent(array2.get(i2), path, contentOut);
            }
        } else if (name2.isJsonObject()) {
            JsonObject object = name2.getAsJsonObject();
            String pathItem = path.get(0);
            SampleDataJsonParser.visitElementAndGetContent(object.get(pathItem), path.subList(1, path.size()), contentOut);
        }
    }
}

