/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources.usage;

import com.android.ide.common.resources.ResourcesUtil;
import com.android.ide.common.resources.usage.ResourceId;
import com.android.ide.common.resources.usage.ResourceStore;
import com.android.ide.common.resources.usage.ResourceUsageModel;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.utils.SdkUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 =2\u00020\u0001:\u0001=B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\nJ\u0006\u0010$\u001a\u00020\u0007J\u0006\u0010%\u001a\u00020\u0007J\u0006\u0010&\u001a\u00020\u0007J\u0006\u0010'\u001a\u00020\u0007J\u0010\u0010(\u001a\u0004\u0018\u00010\n2\u0006\u0010)\u001a\u00020!J\"\u0010(\u001a\u0004\u0018\u00010\n2\b\u0010*\u001a\u0004\u0018\u00010\u00072\u0006\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u0007J\u0018\u0010-\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0/0.J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010+\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u0007J\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020\n012\u0006\u00102\u001a\u00020\u0007H\u0002J\u0014\u00103\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u00104\u001a\u00020\u0007J\u0014\u00105\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u00106\u001a\u00020\u0007J\u000e\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u0000J\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\n0\fJ\u000e\u0010;\u001a\u0002082\u0006\u0010)\u001a\u00020\u0007J\u000e\u0010<\u001a\u0002082\u0006\u0010)\u001a\u00020\u0007R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\n0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000eR\u001a\u0010\u0018\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001aR&\u0010\u001d\u001a\u001a\u0012\u0004\u0012\u00020\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\u001f0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\n0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/android/ide/common/resources/usage/ResourceStore;", "", "supportMultipackages", "", "(Z)V", "_discardAttributes", "", "", "_keepAttributes", "_resources", "Lcom/android/ide/common/resources/usage/ResourceUsageModel$Resource;", "discardAttributes", "", "getDiscardAttributes", "()Ljava/util/List;", "keepAttributes", "getKeepAttributes", "keepResources", "", "Lcom/android/ide/common/resources/usage/ResourceId;", "resourceById", "", "resources", "getResources", "safeMode", "getSafeMode", "()Z", "setSafeMode", "getSupportMultipackages", "typeToName", "Lcom/android/resources/ResourceType;", "Lcom/google/common/collect/LinkedListMultimap;", "valueToResource", "", "addResource", "resource", "dumpConfig", "dumpKeepResources", "dumpReferences", "dumpResourceModel", "getResource", "value", "packageName", "type", "name", "getResourceMaps", "", "Lcom/google/common/collect/ListMultimap;", "getResourcesForKeepOrDiscardPattern", "Lkotlin/sequences/Sequence;", "pattern", "getResourcesFromUrl", "possibleUrlReference", "getResourcesFromWebUrl", "webUrl", "merge", "", "other", "processToolsAttributes", "recordDiscardToolAttribute", "recordKeepToolAttribute", "Companion", "sdk-common"})
@SourceDebugExtension(value={"SMAP\nResourceStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceStore.kt\ncom/android/ide/common/resources/usage/ResourceStore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,633:1\n1360#2:634\n1446#2,5:635\n1855#2,2:640\n1855#2,2:642\n1549#2:644\n1620#2,3:645\n1855#2,2:648\n1855#2,2:650\n1855#2:652\n1855#2,2:653\n1856#2:655\n1855#2:656\n1855#2,2:657\n1856#2:659\n*S KotlinDebug\n*F\n+ 1 ResourceStore.kt\ncom/android/ide/common/resources/usage/ResourceStore\n*L\n159#1:634\n159#1:635,5\n219#1:640,2\n233#1:642,2\n277#1:644\n277#1:645,3\n320#1:648,2\n323#1:650,2\n328#1:652\n332#1:653,2\n328#1:655\n339#1:656\n342#1:657,2\n339#1:659\n*E\n"})
public final class ResourceStore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean supportMultipackages;
    @NotNull
    private final Map<ResourceId, ResourceUsageModel.Resource> resourceById;
    @NotNull
    private final List<ResourceUsageModel.Resource> _resources;
    @NotNull
    private final Map<ResourceType, LinkedListMultimap<String, ResourceUsageModel.Resource>> typeToName;
    @NotNull
    private final Map<Integer, ResourceUsageModel.Resource> valueToResource;
    @NotNull
    private final Set<ResourceId> keepResources;
    @NotNull
    private final List<String> _keepAttributes;
    @NotNull
    private final List<String> _discardAttributes;
    private boolean safeMode;
    private static final int TYPICAL_RESOURCE_COUNT = 200;

    public ResourceStore(boolean supportMultipackages) {
        this.supportMultipackages = supportMultipackages;
        LinkedHashMap linkedHashMap = Maps.newLinkedHashMapWithExpectedSize(200);
        Intrinsics.checkNotNullExpressionValue(linkedHashMap, "newLinkedHashMapWithExpe\u2026e(TYPICAL_RESOURCE_COUNT)");
        this.resourceById = linkedHashMap;
        ArrayList arrayList = Lists.newArrayListWithCapacity(200);
        Intrinsics.checkNotNullExpressionValue(arrayList, "newArrayListWithCapacity\u2026>(TYPICAL_RESOURCE_COUNT)");
        this._resources = arrayList;
        EnumMap enumMap = Maps.newEnumMap(ResourceType.class);
        Intrinsics.checkNotNullExpressionValue(enumMap, "newEnumMap(ResourceType::class.java)");
        this.typeToName = enumMap;
        HashMap hashMap = Maps.newHashMapWithExpectedSize(200);
        Intrinsics.checkNotNullExpressionValue(hashMap, "newHashMapWithExpectedSize(TYPICAL_RESOURCE_COUNT)");
        this.valueToResource = hashMap;
        HashSet hashSet = Sets.newHashSet();
        Intrinsics.checkNotNullExpressionValue(hashSet, "newHashSet()");
        this.keepResources = hashSet;
        ArrayList arrayList2 = Lists.newArrayList();
        Intrinsics.checkNotNullExpressionValue(arrayList2, "newArrayList()");
        this._keepAttributes = arrayList2;
        ArrayList arrayList3 = Lists.newArrayList();
        Intrinsics.checkNotNullExpressionValue(arrayList3, "newArrayList()");
        this._discardAttributes = arrayList3;
        this.safeMode = true;
    }

    public /* synthetic */ ResourceStore(boolean bl2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            bl2 = false;
        }
        this(bl2);
    }

    public final boolean getSupportMultipackages() {
        return this.supportMultipackages;
    }

    @NotNull
    public final List<ResourceUsageModel.Resource> getResources() {
        List<ResourceUsageModel.Resource> list2 = Collections.unmodifiableList(this._resources);
        Intrinsics.checkNotNullExpressionValue(list2, "unmodifiableList(_resources)");
        return list2;
    }

    @NotNull
    public final List<String> getKeepAttributes() {
        List<String> list2 = Collections.unmodifiableList(this._keepAttributes);
        Intrinsics.checkNotNullExpressionValue(list2, "unmodifiableList(_keepAttributes)");
        return list2;
    }

    @NotNull
    public final List<String> getDiscardAttributes() {
        List<String> list2 = Collections.unmodifiableList(this._discardAttributes);
        Intrinsics.checkNotNullExpressionValue(list2, "unmodifiableList(_discardAttributes)");
        return list2;
    }

    public final boolean getSafeMode() {
        return this.safeMode;
    }

    public final void setSafeMode(boolean bl2) {
        this.safeMode = bl2;
    }

    @Nullable
    public final ResourceUsageModel.Resource getResource(int value) {
        return this.valueToResource.get(value);
    }

    @Nullable
    public final ResourceUsageModel.Resource getResource(@Nullable String packageName, @NotNull ResourceType type, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)type, "type");
        Intrinsics.checkNotNullParameter(name2, "name");
        Preconditions.checkArgument(this.supportMultipackages || packageName == null, "In a single package mode packageName must be null.", new Object[0]);
        return this.resourceById.get(new ResourceId(type, name2, packageName));
    }

    @NotNull
    public final List<ResourceUsageModel.Resource> getResources(@NotNull ResourceType type, @NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)type, "type");
        Intrinsics.checkNotNullParameter(name2, "name");
        LinkedListMultimap<String, ResourceUsageModel.Resource> linkedListMultimap = this.typeToName.get((Object)type);
        if (linkedListMultimap == null) {
            return CollectionsKt.emptyList();
        }
        LinkedListMultimap<String, ResourceUsageModel.Resource> resourcesByName = linkedListMultimap;
        Collection collection = resourcesByName.get((Object)ResourcesUtil.resourceNameToFieldName(name2));
        Intrinsics.checkNotNullExpressionValue(collection, "resourcesByName[resourceNameToFieldName(name)]");
        return CollectionsKt.toList(collection);
    }

    @NotNull
    public final List<ResourceUsageModel.Resource> getResourcesFromUrl(@NotNull String possibleUrlReference) {
        Intrinsics.checkNotNullParameter(possibleUrlReference, "possibleUrlReference");
        ResourceUrl url = ResourceUrl.parse(possibleUrlReference);
        if (url == null || url.isFramework()) {
            return CollectionsKt.emptyList();
        }
        ResourceType resourceType = url.type;
        Intrinsics.checkNotNullExpressionValue((Object)resourceType, "url.type");
        String string2 = url.name;
        Intrinsics.checkNotNullExpressionValue(string2, "url.name");
        return this.getResources(resourceType, string2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ResourceUsageModel.Resource> getResourcesFromWebUrl(@NotNull String webUrl) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter(webUrl, "webUrl");
        String afterAndroidRes = StringsKt.substringAfter$default(webUrl, "android_res/", null, 2, null);
        String[] stringArray = new String[]{"/"};
        List parts = StringsKt.split$default((CharSequence)afterAndroidRes, stringArray, false, 2, 2, null);
        if (parts.size() < 2) {
            return CollectionsKt.emptyList();
        }
        String type = (String)parts.get(0);
        String namePart = (String)parts.get(1);
        ResourceFolderType resourceFolderType = ResourceFolderType.getFolderType(type);
        if (resourceFolderType == null) {
            return CollectionsKt.emptyList();
        }
        ResourceFolderType folderType = resourceFolderType;
        String name2 = StringsKt.substringBefore$default(namePart, '.', null, 2, null);
        List<ResourceType> list2 = FolderTypeRelationship.getRelatedResourceTypes(folderType);
        Intrinsics.checkNotNullExpressionValue(list2, "getRelatedResourceTypes(folderType)");
        Iterable iterable = list2;
        boolean $i$f$flatMap = false;
        void var10_10 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ResourceType it = (ResourceType)((Object)element$iv$iv);
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, "it");
            Iterable list$iv$iv = this.getResources(it, name2);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final ResourceUsageModel.Resource addResource(@NotNull ResourceUsageModel.Resource resource) {
        ResourceUsageModel.Resource resource2;
        Pair<Object, ResourceUsageModel.Resource> pair;
        Map<Object, ResourceUsageModel.Resource> map2;
        Intrinsics.checkNotNullParameter(resource, "resource");
        if (!this.supportMultipackages) {
            resource.packageName = null;
        }
        ResourceType resourceType = resource.type;
        Intrinsics.checkNotNullExpressionValue((Object)resourceType, "resource.type");
        String string2 = resource.name;
        Intrinsics.checkNotNullExpressionValue(string2, "resource.name");
        ResourceId id2 = new ResourceId(resourceType, string2, resource.packageName);
        ResourceUsageModel.Resource stored = this.resourceById.get(id2);
        if (stored == null) {
            map2 = this.resourceById;
            pair = TuplesKt.to(id2, resource);
            map2.put(pair.getFirst(), pair.getSecond());
            ((Collection)this._resources).add(resource);
            this.typeToName.computeIfAbsent(resource.type, addResource.updated.1.INSTANCE).put(resource.name, resource);
            if (resource.value != -1) {
                map2 = this.valueToResource;
                pair = TuplesKt.to(resource.value, resource);
                map2.put(pair.getFirst(), pair.getSecond());
            }
            resource2 = resource;
        } else {
            Preconditions.checkState(resource.value == -1 || stored.value == resource.value, "Resource value must be the same between addResource calls.", new Object[0]);
            if (resource.value != -1 && stored.value == -1) {
                stored.value = resource.value;
                map2 = this.valueToResource;
                pair = TuplesKt.to(stored.value, stored);
                map2.put((ResourceId)pair.getFirst(), pair.getSecond());
            }
            resource2 = stored;
        }
        ResourceUsageModel.Resource updated2 = resource2;
        return updated2;
    }

    @NotNull
    public final Collection<ListMultimap<String, ResourceUsageModel.Resource>> getResourceMaps() {
        return this.typeToName.values();
    }

    public final void recordKeepToolAttribute(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        Iterable<String> iterable = Splitter.on(',').omitEmptyStrings().trimResults().split(value);
        Intrinsics.checkNotNullExpressionValue(iterable, "on(',')\n            .omi\u2026            .split(value)");
        Iterable<String> $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        Iterator<String> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            String element$iv;
            String it = element$iv = iterator2.next();
            boolean bl2 = false;
            ((Collection)this._keepAttributes).add(it);
        }
    }

    public final void recordDiscardToolAttribute(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        Iterable<String> iterable = Splitter.on(',').omitEmptyStrings().trimResults().split(value);
        Intrinsics.checkNotNullExpressionValue(iterable, "on(',')\n            .omi\u2026            .split(value)");
        Iterable<String> $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        Iterator<String> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            String element$iv;
            String it = element$iv = iterator2.next();
            boolean bl2 = false;
            ((Collection)this._discardAttributes).add(it);
        }
    }

    @NotNull
    public final List<ResourceUsageModel.Resource> processToolsAttributes() {
        return CollectionsKt.minus((Iterable)SequencesKt.toList(SequencesKt.onEach(SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)this._keepAttributes), (Function1)new Function1<String, Sequence<? extends ResourceUsageModel.Resource>>(this){
            final /* synthetic */ ResourceStore this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Sequence<ResourceUsageModel.Resource> invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return ResourceStore.access$getResourcesForKeepOrDiscardPattern(this.this$0, it);
            }
        }), (Function1)new Function1<ResourceUsageModel.Resource, Unit>(this){
            final /* synthetic */ ResourceStore this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ResourceUsageModel.Resource it) {
                Intrinsics.checkNotNullParameter(it, "it");
                it.setReachable(true);
                Collection collection = ResourceStore.access$getKeepResources$p(this.this$0);
                ResourceType resourceType = it.type;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)resourceType), "it.type");
                String string2 = it.name;
                Intrinsics.checkNotNullExpressionValue(string2, "it.name");
                collection.add(new ResourceId(resourceType, string2, it.packageName));
            }
        })), SequencesKt.onEach(SequencesKt.flatMap(CollectionsKt.asSequence((Iterable)this._discardAttributes), (Function1)new Function1<String, Sequence<? extends ResourceUsageModel.Resource>>(this){
            final /* synthetic */ ResourceStore this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Sequence<ResourceUsageModel.Resource> invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return ResourceStore.access$getResourcesForKeepOrDiscardPattern(this.this$0, it);
            }
        }), processToolsAttributes.4.INSTANCE));
    }

    @NotNull
    public final String dumpConfig() {
        Function1[] function1Array = new Function1[]{dumpConfig.1.INSTANCE, dumpConfig.2.INSTANCE};
        return SequencesKt.joinToString$default(SequencesKt.map(SequencesKt.sortedWith(CollectionsKt.asSequence((Iterable)this._resources), ComparisonsKt.compareBy(function1Array)), (Function1)new Function1<ResourceUsageModel.Resource, String>(this){
            final /* synthetic */ ResourceStore this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull ResourceUsageModel.Resource r2) {
                Intrinsics.checkNotNullParameter(r2, "r");
                ResourceType resourceType = r2.type;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)resourceType), "r.type");
                String string2 = r2.name;
                Intrinsics.checkNotNullExpressionValue(string2, "r.name");
                ResourceId id2 = new ResourceId(resourceType, string2, r2.packageName);
                String[] stringArray = new String[2];
                String string3 = "remove";
                Object object = string3;
                int n2 = 0;
                String[] stringArray2 = stringArray;
                boolean $i$a$-takeUnless-ResourceStore$dumpConfig$3$actions$22 = false;
                boolean bl2 = r2.isReachable();
                stringArray2[n2] = !bl2 ? string3 : null;
                string3 = "no_obfuscate";
                object = this.this$0;
                String $i$a$-takeUnless-ResourceStore$dumpConfig$3$actions$22 = string3;
                n2 = 1;
                stringArray2 = stringArray;
                boolean bl3 = false;
                bl2 = ResourceStore.access$getKeepResources$p((ResourceStore)object).contains(id2);
                stringArray2[n2] = bl2 ? string3 : null;
                String actions = CollectionsKt.joinToString$default(CollectionsKt.listOfNotNull(stringArray), ",", null, null, 0, null, null, 62, null);
                return r2.type + "/" + r2.name + "#" + actions;
            }
        }), "\n", "", "\n", 0, null, null, 56, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String dumpKeepResources() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.keepResources;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResourceId resourceId = (ResourceId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getName());
        }
        return CollectionsKt.joinToString$default(CollectionsKt.sorted((List)destination$iv$iv), ",", null, null, 0, null, null, 62, null);
    }

    @NotNull
    public final String dumpReferences() {
        return SequencesKt.joinToString$default(SequencesKt.sorted(SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)this._resources), dumpReferences.1.INSTANCE), dumpReferences.2.INSTANCE)), "\n", "Resource Reference Graph:\n", "", 0, null, null, 56, null);
    }

    @NotNull
    public final String dumpResourceModel() {
        Function1[] function1Array = new Function1[]{dumpResourceModel.1.INSTANCE, dumpResourceModel.2.INSTANCE};
        return SequencesKt.joinToString$default(SequencesKt.flatMap(SequencesKt.sortedWith(CollectionsKt.asSequence((Iterable)this._resources), ComparisonsKt.compareBy(function1Array)), dumpResourceModel.3.INSTANCE), "\n", "", "\n", 0, null, null, 56, null);
    }

    private final Sequence<ResourceUsageModel.Resource> getResourcesForKeepOrDiscardPattern(String pattern) {
        Sequence<ResourceUsageModel.Resource> sequence;
        ResourceUrl url = ResourceUrl.parse(pattern);
        if (url == null || url.isFramework()) {
            return SequencesKt.emptySequence();
        }
        LinkedListMultimap<String, ResourceUsageModel.Resource> linkedListMultimap = this.typeToName.get((Object)url.type);
        if (linkedListMultimap == null) {
            return SequencesKt.emptySequence();
        }
        LinkedListMultimap<String, ResourceUsageModel.Resource> resources = linkedListMultimap;
        String string2 = url.name;
        Intrinsics.checkNotNullExpressionValue(string2, "url.name");
        if (!StringsKt.contains$default((CharSequence)string2, "*", false, 2, null)) {
            String string3 = url.name;
            Intrinsics.checkNotNullExpressionValue(string3, "url.name");
            if (!StringsKt.contains$default((CharSequence)string3, "?", false, 2, null)) {
                Collection collection = resources.get((Object)url.name);
                Intrinsics.checkNotNullExpressionValue(collection, "resources[url.name]");
                return CollectionsKt.asSequence(collection);
            }
        }
        try {
            String string4 = url.name;
            Intrinsics.checkNotNullExpressionValue(string4, "url.name");
            String string5 = SdkUtils.globToRegexp(ResourcesUtil.resourceNameToFieldName(string4));
            Intrinsics.checkNotNullExpressionValue(string5, "globToRegexp(resourceNameToFieldName(url.name))");
            String string6 = string5;
            Regex regexp = new Regex(string6);
            Collection collection = resources.entries();
            Intrinsics.checkNotNullExpressionValue(collection, "resources.entries()");
            sequence = SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence(collection), (Function1)new Function1<Map.Entry<String, ResourceUsageModel.Resource>, Boolean>(regexp){
                final /* synthetic */ Regex $regexp;
                {
                    this.$regexp = $regexp;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(Map.Entry<String, ResourceUsageModel.Resource> it) {
                    String string2 = it.getKey();
                    Intrinsics.checkNotNullExpressionValue(string2, "it.key");
                    return this.$regexp.matches(string2);
                }
            }), getResourcesForKeepOrDiscardPattern.2.INSTANCE);
        }
        catch (PatternSyntaxException e2) {
            sequence = SequencesKt.emptySequence();
        }
        return sequence;
    }

    public final void merge(@NotNull ResourceStore other) {
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        List<Comparable<Path>> list2;
        ResourceUsageModel.Resource existing;
        ResourceUsageModel.Resource r2;
        String it;
        Intrinsics.checkNotNullParameter(other, "other");
        Iterable $this$forEach$iv2 = other._discardAttributes;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            it = (String)element$iv;
            boolean bl2 = false;
            if (this._discardAttributes.contains(it)) continue;
            this._discardAttributes.add(it);
        }
        $this$forEach$iv2 = other._keepAttributes;
        $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            it = (String)element$iv;
            boolean bl3 = false;
            if (this._keepAttributes.contains(it)) continue;
            this._keepAttributes.add(it);
        }
        $this$forEach$iv2 = other._resources;
        $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            r2 = (ResourceUsageModel.Resource)element$iv;
            boolean bl4 = false;
            String string2 = r2.packageName;
            ResourceType resourceType = r2.type;
            Intrinsics.checkNotNullExpressionValue((Object)resourceType, "r.type");
            String string3 = r2.name;
            Intrinsics.checkNotNullExpressionValue(string3, "r.name");
            ResourceUsageModel.Resource resource = this.getResource(string2, resourceType, string3);
            if (resource == null) {
                resource = this.addResource(new ResourceUsageModel.Resource(r2.packageName, r2.type, r2.name, r2.value));
            }
            existing = resource;
            existing.mFlags |= r2.mFlags;
            List<Path> list3 = list2 = r2.declarations;
            if (list3 == null) continue;
            Intrinsics.checkNotNullExpressionValue(list3, "declarations");
            $this$forEach$iv = list2;
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                Path location = (Path)element$iv2;
                boolean bl5 = false;
                List<Path> locations = existing.declarations;
                if (locations != null && locations.contains(location)) continue;
                existing.addLocation(location);
            }
        }
        $this$forEach$iv2 = other._resources;
        $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            r2 = (ResourceUsageModel.Resource)element$iv;
            boolean bl6 = false;
            String string4 = r2.packageName;
            ResourceType resourceType = r2.type;
            Intrinsics.checkNotNullExpressionValue((Object)resourceType, "r.type");
            String string5 = r2.name;
            Intrinsics.checkNotNullExpressionValue(string5, "r.name");
            existing = this.getResource(string4, resourceType, string5);
            if (existing == null) continue;
            List<Comparable<Path>> list4 = list2 = r2.references;
            if (list4 == null) continue;
            Intrinsics.checkNotNullExpressionValue(list4, "references");
            $this$forEach$iv = list2;
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                ResourceUsageModel.Resource referenced = (ResourceUsageModel.Resource)element$iv2;
                boolean bl7 = false;
                String string6 = referenced.packageName;
                ResourceType resourceType2 = referenced.type;
                Intrinsics.checkNotNullExpressionValue((Object)resourceType2, "referenced.type");
                String string7 = referenced.name;
                Intrinsics.checkNotNullExpressionValue(string7, "referenced.name");
                ResourceUsageModel.Resource ref = this.getResource(string6, resourceType2, string7);
                if (ref == null) continue;
                existing.addReference(ref);
            }
        }
    }

    public ResourceStore() {
        this(false, 1, null);
    }

    public static final /* synthetic */ Sequence access$getResourcesForKeepOrDiscardPattern(ResourceStore $this, String pattern) {
        return $this.getResourcesForKeepOrDiscardPattern(pattern);
    }

    public static final /* synthetic */ Set access$getKeepResources$p(ResourceStore $this) {
        return $this.keepResources;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\fJ$\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112\u0006\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/ide/common/resources/usage/ResourceStore$Companion;", "", "()V", "TYPICAL_RESOURCE_COUNT", "", "deserialize", "Lcom/android/ide/common/resources/usage/ResourceStore;", "s", "", "serialize", "store", "includeValues", "", "serializeInto", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "sdk-common"})
    @SourceDebugExtension(value={"SMAP\nResourceStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceStore.kt\ncom/android/ide/common/resources/usage/ResourceStore$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,633:1\n1109#2,2:634\n215#3,2:636\n*S KotlinDebug\n*F\n+ 1 ResourceStore.kt\ncom/android/ide/common/resources/usage/ResourceStore$Companion\n*L\n513#1:634,2\n616#1:636,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String serialize(@NotNull ResourceStore store, boolean includeValues) {
            Intrinsics.checkNotNullParameter(store, "store");
            StringBuilder sb = new StringBuilder(2000);
            this.serializeInto(sb, store, includeValues);
            String string2 = sb.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "sb.toString()");
            return string2;
        }

        public static /* synthetic */ String serialize$default(Companion companion, ResourceStore resourceStore, boolean bl2, int n2, Object object) {
            if ((n2 & 2) != 0) {
                bl2 = true;
            }
            return companion.serialize(resourceStore, bl2);
        }

        public final void serializeInto(@NotNull StringBuilder sb, @NotNull ResourceStore store, boolean includeValues) {
            Intrinsics.checkNotNullParameter(sb, "sb");
            Intrinsics.checkNotNullParameter(store, "store");
            if (store.getSupportMultipackages()) {
                sb.append("P;");
            }
            Map storeTypeToName = store.typeToName;
            HashBiMap hashBiMap = HashBiMap.create(storeTypeToName.size());
            Intrinsics.checkNotNullExpressionValue(hashBiMap, "create(storeTypeToName.size)");
            BiMap referenceMap = hashBiMap;
            int nextId = 0;
            for (ResourceType type : storeTypeToName.keySet()) {
                LinkedListMultimap list2;
                if ((LinkedListMultimap)storeTypeToName.get((Object)type) == null) continue;
                for (ResourceUsageModel.Resource resource : list2.values()) {
                    ((Map)referenceMap).put(resource, nextId++);
                }
            }
            if (referenceMap.isEmpty()) {
                return;
            }
            ResourceType prev = null;
            boolean first2 = true;
            for (ResourceUsageModel.Resource resource : referenceMap.keySet()) {
                boolean includeValue;
                ResourceType type = resource.type;
                if (type != prev) {
                    prev = type;
                    if (!first2) {
                        sb.append(']');
                        sb.append(',');
                        first2 = true;
                    }
                    sb.append(type.getName());
                    sb.append('[');
                }
                if (first2) {
                    first2 = false;
                } else {
                    sb.append(',');
                }
                sb.append(resource.name);
                sb.append('(');
                sb.append(resource.flagString());
                boolean bl2 = includeValue = includeValues && resource.value != -1;
                if (store.getSupportMultipackages()) {
                    if (resource.packageName != null) {
                        sb.append(',');
                        sb.append(resource.packageName);
                    } else if (includeValue) {
                        sb.append(',');
                    }
                }
                if (includeValue) {
                    sb.append(',');
                    sb.append(Integer.toHexString(resource.value));
                }
                sb.append(')');
            }
            sb.append(']');
            sb.append(';');
            first2 = true;
            for (ResourceUsageModel.Resource resource : referenceMap.keySet()) {
                List<ResourceUsageModel.Resource> references = resource.references;
                if (references == null || !(!((Collection)references).isEmpty())) continue;
                if (first2) {
                    first2 = false;
                } else {
                    sb.append(',');
                }
                Intrinsics.checkNotNullExpressionValue(resource, "resource");
                sb.append(com.android.ide.common.resources.usage.ResourceStore$Companion.serializeInto$id(resource, referenceMap));
                for (ResourceUsageModel.Resource reference : references) {
                    sb.append('^');
                    Intrinsics.checkNotNullExpressionValue(reference, "reference");
                    sb.append(com.android.ide.common.resources.usage.ResourceStore$Companion.serializeInto$id(reference, referenceMap));
                }
            }
            sb.append(';');
            List $this$serializeInto_u24lambda_u240 = store._keepAttributes;
            boolean bl3 = false;
            if (!((Collection)$this$serializeInto_u24lambda_u240).isEmpty()) {
                CollectionsKt.joinTo$default($this$serializeInto_u24lambda_u240, sb, ",", null, null, 0, null, null, 124, null);
            }
            sb.append(';');
            List $this$serializeInto_u24lambda_u241 = store._discardAttributes;
            boolean bl4 = false;
            if (!((Collection)$this$serializeInto_u24lambda_u241).isEmpty()) {
                CollectionsKt.joinTo$default($this$serializeInto_u24lambda_u241, sb, ",", null, null, 0, null, null, 124, null);
            }
            sb.append(';');
        }

        public static /* synthetic */ void serializeInto$default(Companion companion, StringBuilder stringBuilder, ResourceStore resourceStore, boolean bl2, int n2, Object object) {
            if ((n2 & 4) != 0) {
                bl2 = true;
            }
            companion.serializeInto(stringBuilder, resourceStore, bl2);
        }

        @NotNull
        public final ResourceStore deserialize(@NotNull String s2) {
            int discardEnd;
            int keepEnd;
            Object object;
            char next;
            Intrinsics.checkNotNullParameter(s2, "s");
            if (((CharSequence)s2).length() == 0) {
                return new ResourceStore(false, 1, null);
            }
            int offset = 0;
            boolean supportMultiPackages = false;
            if (StringsKt.startsWith$default(s2, "P;", false, 2, null)) {
                supportMultiPackages = true;
                offset += 2;
            }
            ResourceStore resourceStore = new ResourceStore(supportMultiPackages);
            HashBiMap hashBiMap = HashBiMap.create(s2.length() / 10);
            Intrinsics.checkNotNullExpressionValue(hashBiMap, "create(s.length / 10)");
            BiMap referenceMap = hashBiMap;
            int nextId = 0;
            int length = s2.length();
            ResourceType type = ResourceType.SAMPLE_DATA;
            char[] cArray = new char[]{',', ')', '^', ';'};
            char[] delimiters = cArray;
            block0: while (offset < length && (next = s2.charAt(offset)) != ';') {
                ResourceType fromClassName;
                ResourceType resourceType;
                Object $this$first$iv2;
                int typeEnd;
                block20: {
                    String typeString;
                    boolean bl2;
                    typeEnd = StringsKt.indexOf$default((CharSequence)s2, '[', offset, false, 4, null);
                    boolean bl3 = bl2 = typeEnd != -1;
                    if (_Assertions.ENABLED && !bl2) {
                        String string2 = "Assertion failed";
                        throw new AssertionError((Object)string2);
                    }
                    Intrinsics.checkNotNullExpressionValue(s2.substring(offset, typeEnd), "substring(...)");
                    object = ResourceType.fromClassName(typeString);
                    if (object == null) {
                        $this$first$iv2 = ResourceType.values();
                        boolean $i$f$first = false;
                        int n2 = ((ResourceType[])$this$first$iv2).length;
                        for (int i2 = 0; i2 < n2; ++i2) {
                            ResourceType element$iv;
                            ResourceType it = element$iv = $this$first$iv2[i2];
                            boolean bl4 = false;
                            if (!Intrinsics.areEqual(it.getName(), typeString)) continue;
                            resourceType = element$iv;
                            break block20;
                        }
                        throw new NoSuchElementException("Array contains no element matching the predicate.");
                    }
                    resourceType = object;
                }
                type = fromClassName = resourceType;
                offset = typeEnd + 1;
                while (offset < length) {
                    String name2;
                    String flagString;
                    boolean $this$first$iv2;
                    boolean bl5;
                    boolean bl6 = bl5 = s2.charAt(offset) != ']';
                    if (_Assertions.ENABLED && !bl5) {
                        $this$first$iv2 = "Assertion failed";
                        throw new AssertionError($this$first$iv2);
                    }
                    int nameEnd = StringsKt.indexOf$default((CharSequence)s2, '(', offset, false, 4, null);
                    boolean bl7 = $this$first$iv2 = nameEnd != -1;
                    if (_Assertions.ENABLED && !$this$first$iv2) {
                        String $i$f$first = "Assertion failed";
                        throw new AssertionError((Object)$i$f$first);
                    }
                    Intrinsics.checkNotNullExpressionValue(s2.substring(offset, nameEnd), "substring(...)");
                    offset = nameEnd + 1;
                    int end = StringsKt.indexOfAny$default((CharSequence)s2, delimiters, offset, false, 4, null);
                    Intrinsics.checkNotNullExpressionValue(s2.substring(offset, end), "substring(...)");
                    int flags = ResourceUsageModel.Resource.stringToFlag(flagString);
                    String pkg = null;
                    if (supportMultiPackages && s2.charAt(end) == ',') {
                        offset = end + 1;
                        int packageEnd = StringsKt.indexOfAny$default((CharSequence)s2, delimiters, offset, false, 4, null);
                        if (packageEnd > offset) {
                            String string3 = s2.substring(offset, packageEnd);
                            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
                            pkg = string3;
                        }
                        end = packageEnd;
                    }
                    int value = 0;
                    if (s2.charAt(end) == ',') {
                        String valueString;
                        offset = end + 1;
                        int valueEnd = StringsKt.indexOf$default((CharSequence)s2, ')', offset, false, 4, null);
                        Intrinsics.checkNotNullExpressionValue(s2.substring(offset, valueEnd), "substring(...)");
                        value = Integer.parseUnsignedInt(valueString, 16);
                        offset = valueEnd + 1;
                    } else {
                        value = -1;
                        offset = end + 1;
                    }
                    ResourceUsageModel.Resource resource = new ResourceUsageModel.Resource(pkg, type, name2, value);
                    resource.mFlags = flags;
                    ((Map)referenceMap).put(resource, nextId++);
                    if (s2.charAt(offset++) == ',') continue;
                    if (s2.charAt(offset) != ',') continue block0;
                    ++offset;
                    continue block0;
                }
            }
            if (offset < length - 1) {
                BiMap inverse = referenceMap.inverse();
                ++offset;
                while (offset < length) {
                    String idString;
                    if (s2.charAt(offset) == ';') {
                        ++offset;
                        break;
                    }
                    int end = StringsKt.indexOfAny$default((CharSequence)s2, delimiters, offset, false, 4, null);
                    Intrinsics.checkNotNullExpressionValue(s2.substring(offset, end), "substring(...)");
                    int id2 = Integer.parseInt(idString, 16);
                    Object v2 = inverse.get(id2);
                    Intrinsics.checkNotNull(v2);
                    ResourceUsageModel.Resource resource = (ResourceUsageModel.Resource)v2;
                    offset = end + 1;
                    while (offset < length) {
                        String refIdString;
                        int refEnd = StringsKt.indexOfAny$default((CharSequence)s2, delimiters, offset, false, 4, null);
                        Intrinsics.checkNotNullExpressionValue(s2.substring(offset, refEnd), "substring(...)");
                        int ref = Integer.parseInt(refIdString, 16);
                        Object v3 = inverse.get(ref);
                        Intrinsics.checkNotNull(v3);
                        ResourceUsageModel.Resource reference = (ResourceUsageModel.Resource)v3;
                        resource.addReference(reference);
                        offset = refEnd + 1;
                        if (s2.charAt(offset - 1) != ',' && s2.charAt(offset - 1) != ';') continue;
                    }
                    if (s2.charAt(offset - 1) != ';') continue;
                }
            }
            if ((keepEnd = StringsKt.indexOf$default((CharSequence)s2, ';', offset, false, 4, null)) > offset) {
                String string4 = s2.substring(offset, keepEnd);
                Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
                String keep = string4;
                resourceStore.recordKeepToolAttribute(keep);
            }
            if ((discardEnd = StringsKt.indexOf$default((CharSequence)s2, ';', offset = keepEnd + 1, false, 4, null)) > offset) {
                String string5 = s2.substring(offset, discardEnd);
                Intrinsics.checkNotNullExpressionValue(string5, "substring(...)");
                String discard = string5;
                resourceStore.recordDiscardToolAttribute(discard);
            }
            Map $this$forEach$iv = referenceMap;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = (Map.Entry)object.next();
                boolean bl8 = false;
                ResourceUsageModel.Resource resource = (ResourceUsageModel.Resource)entry.getKey();
                Intrinsics.checkNotNullExpressionValue(resource, "resource");
                resourceStore.addResource(resource);
            }
            resourceStore.processToolsAttributes();
            return resourceStore;
        }

        private static final String serializeInto$id(ResourceUsageModel.Resource $this$serializeInto_u24id, BiMap<ResourceUsageModel.Resource, Integer> referenceMap) {
            Object v2 = referenceMap.get($this$serializeInto_u24id);
            Intrinsics.checkNotNull(v2);
            String string2 = Integer.toHexString(((Number)v2).intValue());
            Intrinsics.checkNotNullExpressionValue(string2, "toHexString(referenceMap[this]!!)");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

