/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.symbols;

import com.android.ide.common.resources.FileResourceNameValidator;
import com.android.ide.common.resources.MergingException;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.symbols.IdProvider;
import com.android.ide.common.symbols.ResourceDirectoryParseException;
import com.android.ide.common.symbols.ResourceExtraXmlParser;
import com.android.ide.common.symbols.ResourceValuesXmlParseException;
import com.android.ide.common.symbols.ResourceValuesXmlParser;
import com.android.ide.common.symbols.Symbol;
import com.android.ide.common.symbols.SymbolTable;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.utils.SdkUtils;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u001a:\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001aB\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\b\u0002\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013\u001a6\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u001a\u000e\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0007\u001a@\u0010\u001d\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000f2\u0016\u0010\u001e\u001a\u0012\u0012\b\u0012\u00060 j\u0002`!\u0012\u0004\u0012\u00020\u00010\u001f2\u0006\u0010\"\u001a\u00020\u00072\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$\u00a8\u0006&"}, d2={"addIfNotExisting", "", "builder", "Lcom/android/ide/common/symbols/SymbolTable$Builder;", "symbol", "Lcom/android/ide/common/symbols/Symbol;", "getNameWithoutExtensions", "", "filename", "parseResourceDirectory", "resourceDirectory", "Ljava/io/File;", "idProvider", "Lcom/android/ide/common/symbols/IdProvider;", "documentBuilder", "Ljavax/xml/parsers/DocumentBuilder;", "platformAttrSymbols", "Lcom/android/ide/common/symbols/SymbolTable;", "validation", "", "parseResourceFile", "maybeResourceFile", "folderResourceType", "Lcom/android/resources/ResourceFolderType;", "parseResourceSourceSetDirectory", "directory", "tablePackage", "shouldBeParsed", "directoryName", "parseAarZipEntry", "errorHandler", "Lkotlin/Function1;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "name", "content", "Lkotlin/Function0;", "Ljava/io/InputStream;", "sdk-common"})
@JvmName(name="ResourceDirectoryParser")
@SourceDebugExtension(value={"SMAP\nResourceDirectoryParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceDirectoryParser.kt\ncom/android/ide/common/symbols/ResourceDirectoryParser\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,379:1\n6442#2:380\n6442#2:381\n1855#3,2:382\n1855#3,2:384\n1855#3,2:386\n1855#3,2:388\n1855#3,2:390\n*S KotlinDebug\n*F\n+ 1 ResourceDirectoryParser.kt\ncom/android/ide/common/symbols/ResourceDirectoryParser\n*L\n87#1:380\n148#1:381\n150#1:382,2\n189#1:384,2\n228#1:386,2\n312#1:388,2\n345#1:390,2\n*E\n"})
public final class ResourceDirectoryParser {
    @NotNull
    public static final SymbolTable parseResourceSourceSetDirectory(@NotNull File directory, @NotNull IdProvider idProvider, @Nullable SymbolTable platformAttrSymbols, @Nullable String tablePackage, boolean validation) {
        DocumentBuilder documentBuilder;
        Intrinsics.checkNotNullParameter(directory, "directory");
        Intrinsics.checkNotNullParameter(idProvider, "idProvider");
        Preconditions.checkArgument(directory.isDirectory(), "!directory.isDirectory()", new Object[0]);
        SymbolTable.Builder builder = SymbolTable.Companion.builder();
        File[] fileArray = directory.listFiles();
        Intrinsics.checkNotNull(fileArray);
        File[] $this$sortedBy$iv = fileArray;
        boolean $i$f$sortedBy = false;
        List<File> resourceDirectories = ArraysKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a2, T b2) {
                File it = (File)a2;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (File)b2;
                Comparable comparable2 = comparable;
                bl2 = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getName()));
            }
        });
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e2) {
            throw new ResourceDirectoryParseException("Failed to instantiate DOM parser", e2);
        }
        DocumentBuilder documentBuilder2 = documentBuilder;
        for (File resourceDirectory : resourceDirectories) {
            if (!resourceDirectory.isDirectory()) {
                throw new ResourceDirectoryParseException("'" + resourceDirectory.getAbsolutePath() + "' is not a directory");
            }
            Intrinsics.checkNotNullExpressionValue(resourceDirectory, "resourceDirectory");
            Intrinsics.checkNotNullExpressionValue(documentBuilder2, "documentBuilder");
            ResourceDirectoryParser.parseResourceDirectory(resourceDirectory, builder, idProvider, documentBuilder2, platformAttrSymbols, validation);
        }
        if (tablePackage != null) {
            builder.tablePackage(tablePackage);
        }
        return builder.build();
    }

    public static /* synthetic */ SymbolTable parseResourceSourceSetDirectory$default(File file2, IdProvider idProvider, SymbolTable symbolTable, String string2, boolean bl2, int n2, Object object) {
        if ((n2 & 8) != 0) {
            string2 = null;
        }
        if ((n2 & 0x10) != 0) {
            bl2 = true;
        }
        return ResourceDirectoryParser.parseResourceSourceSetDirectory(file2, idProvider, symbolTable, string2, bl2);
    }

    private static final void parseResourceDirectory(File resourceDirectory, SymbolTable.Builder builder, IdProvider idProvider, DocumentBuilder documentBuilder, SymbolTable platformAttrSymbols, boolean validation) {
        boolean bl2 = resourceDirectory.isDirectory();
        if (_Assertions.ENABLED && !bl2) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        String string3 = resourceDirectory.getName();
        Intrinsics.checkNotNullExpressionValue(string3, "resourceDirectory.name");
        if (!ResourceDirectoryParser.shouldBeParsed(string3)) {
            return;
        }
        String directoryName = resourceDirectory.getName();
        ResourceFolderType folderResourceType = ResourceFolderType.getFolderType(directoryName);
        File[] fileArray = resourceDirectory.listFiles();
        Intrinsics.checkNotNull(fileArray);
        File[] $this$sortedBy$iv = fileArray;
        boolean $i$f$sortedBy = false;
        List<File> resourceFiles = ArraysKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a2, T b2) {
                File it = (File)a2;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (File)b2;
                Comparable comparable2 = comparable;
                bl2 = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getName()));
            }
        });
        Iterable $this$forEach$iv = resourceFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File it = (File)element$iv;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            ResourceFolderType resourceFolderType = folderResourceType;
            Intrinsics.checkNotNull((Object)resourceFolderType);
            ResourceDirectoryParser.parseResourceFile(it, resourceFolderType, builder, documentBuilder, platformAttrSymbols, idProvider, validation);
        }
    }

    public static final void parseResourceFile(@NotNull File maybeResourceFile, @NotNull ResourceFolderType folderResourceType, @NotNull SymbolTable.Builder builder, @NotNull DocumentBuilder documentBuilder, @Nullable SymbolTable platformAttrSymbols, @NotNull IdProvider idProvider, boolean validation) {
        Intrinsics.checkNotNullParameter(maybeResourceFile, "maybeResourceFile");
        Intrinsics.checkNotNullParameter((Object)folderResourceType, "folderResourceType");
        Intrinsics.checkNotNullParameter(builder, "builder");
        Intrinsics.checkNotNullParameter(documentBuilder, "documentBuilder");
        Intrinsics.checkNotNullParameter(idProvider, "idProvider");
        if (maybeResourceFile.isDirectory()) {
            return;
        }
        if (!maybeResourceFile.isFile()) {
            throw new ResourceDirectoryParseException("'" + maybeResourceFile.getAbsolutePath() + "' is not a file nor directory");
        }
        if (folderResourceType == ResourceFolderType.VALUES) {
            Document domTree = null;
            try {
                Document document = documentBuilder.parse(maybeResourceFile);
                Intrinsics.checkNotNullExpressionValue(document, "documentBuilder.parse(maybeResourceFile)");
                domTree = document;
                SymbolTable parsedXml = ResourceValuesXmlParser.parseValuesResource(domTree, idProvider, platformAttrSymbols, validation);
                Collection collection = parsedXml.getSymbols().values();
                Intrinsics.checkNotNullExpressionValue(collection, "parsedXml.symbols.values()");
                Iterable $this$forEach$iv = collection;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Symbol s2 = (Symbol)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue(s2, "s");
                    ResourceDirectoryParser.addIfNotExisting(builder, s2);
                }
            }
            catch (Exception e2) {
                throw new ResourceDirectoryParseException("Failed to parse XML resource file '" + maybeResourceFile.getAbsolutePath() + "'", e2);
            }
        }
        if (validation) {
            try {
                FileResourceNameValidator.validate(maybeResourceFile, folderResourceType);
            }
            catch (MergingException e3) {
                throw new ResourceDirectoryParseException("Failed file name validation for file " + maybeResourceFile.getAbsolutePath(), e3);
            }
        }
        String fileName = maybeResourceFile.getName();
        Intrinsics.checkNotNullExpressionValue(fileName, "fileName");
        String symbolName = ResourceDirectoryParser.getNameWithoutExtensions(fileName);
        ResourceType resourceType = FolderTypeRelationship.getNonIdRelatedResourceType(folderResourceType);
        Intrinsics.checkNotNullExpressionValue((Object)resourceType, "resourceType");
        ResourceDirectoryParser.addIfNotExisting(builder, Symbol.Companion.createSymbol$default(Symbol.Companion, resourceType, symbolName, idProvider, false, validation, 8, null));
        if (FolderTypeRelationship.isIdGeneratingFolderType(folderResourceType) && SdkUtils.endsWithIgnoreCase(fileName, ".xml")) {
            try {
                Document domTree = documentBuilder.parse(maybeResourceFile);
                Intrinsics.checkNotNullExpressionValue(domTree, "domTree");
                SymbolTable extraSymbols = ResourceExtraXmlParser.parseResourceForInlineResources(domTree, idProvider, validation);
                Collection collection = extraSymbols.getSymbols().values();
                Intrinsics.checkNotNullExpressionValue(collection, "extraSymbols.symbols.values()");
                Iterable $this$forEach$iv = collection;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Symbol s3 = (Symbol)element$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue(s3, "s");
                    ResourceDirectoryParser.addIfNotExisting(builder, s3);
                }
            }
            catch (Exception e4) {
                throw new ResourceDirectoryParseException("Failed to parse XML file '" + maybeResourceFile.getAbsolutePath() + "'", e4);
            }
        }
    }

    public static /* synthetic */ void parseResourceFile$default(File file2, ResourceFolderType resourceFolderType, SymbolTable.Builder builder, DocumentBuilder documentBuilder, SymbolTable symbolTable, IdProvider idProvider, boolean bl2, int n2, Object object) {
        if ((n2 & 0x20) != 0) {
            idProvider = IdProvider.Companion.constant();
        }
        ResourceDirectoryParser.parseResourceFile(file2, resourceFolderType, builder, documentBuilder, symbolTable, idProvider, bl2);
    }

    public static final boolean shouldBeParsed(@NotNull String directoryName) {
        Intrinsics.checkNotNullParameter(directoryName, "directoryName");
        if (!StringsKt.contains$default((CharSequence)directoryName, '-', false, 2, null)) {
            return true;
        }
        char[] cArray = new char[]{'-'};
        List configs = StringsKt.split$default((CharSequence)StringsKt.substringAfter$default(directoryName, '-', null, 2, null), cArray, false, 0, 6, null);
        FolderConfiguration folderConfiguration = FolderConfiguration.getConfigFromQualifiers(configs.iterator());
        if (folderConfiguration == null) {
            return false;
        }
        FolderConfiguration config = folderConfiguration;
        return config.getLocaleQualifier() == null;
    }

    public static final void parseAarZipEntry(@NotNull SymbolTable.Builder $this$parseAarZipEntry, @NotNull DocumentBuilder documentBuilder, @NotNull Function1<? super Exception, Unit> errorHandler, @NotNull String name2, @NotNull Function0<? extends InputStream> content) {
        block16: {
            SymbolTable e22;
            Document element$iv2;
            ResourceFolderType folderResourceType;
            int lastSlashPosition;
            block15: {
                SymbolTable e32;
                Document document;
                Intrinsics.checkNotNullParameter($this$parseAarZipEntry, "<this>");
                Intrinsics.checkNotNullParameter(documentBuilder, "documentBuilder");
                Intrinsics.checkNotNullParameter(errorHandler, "errorHandler");
                Intrinsics.checkNotNullParameter(name2, "name");
                Intrinsics.checkNotNullParameter(content, "content");
                if (!StringsKt.startsWith$default(name2, "res/", false, 2, null)) {
                    return;
                }
                int firstSlashPosition = StringsKt.indexOf$default((CharSequence)name2, '/', 0, false, 6, null);
                lastSlashPosition = StringsKt.lastIndexOf$default((CharSequence)name2, '/', 0, false, 6, null);
                if (lastSlashPosition == firstSlashPosition) {
                    errorHandler.invoke(new ResourceDirectoryParseException("Error parsing '" + name2 + "': Invalid resource path."));
                    return;
                }
                String string2 = name2.substring(firstSlashPosition + 1, lastSlashPosition);
                Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
                String directoryName = string2;
                if (!ResourceDirectoryParser.shouldBeParsed(directoryName)) {
                    return;
                }
                ResourceFolderType resourceFolderType = ResourceFolderType.getFolderType(directoryName);
                if (resourceFolderType == null) {
                    SymbolTable.Builder $this$parseAarZipEntry_u24lambda_u245 = $this$parseAarZipEntry;
                    boolean bl2 = false;
                    errorHandler.invoke(new ResourceDirectoryParseException("Error parsing '" + name2 + "': Invalid resource directory name '" + directoryName + "'"));
                    return;
                }
                folderResourceType = resourceFolderType;
                if (folderResourceType != ResourceFolderType.VALUES) break block15;
                try {
                    Document document2 = documentBuilder.parse(content.invoke());
                    Intrinsics.checkNotNullExpressionValue(document2, "{\n            documentBu\u2026arse(content())\n        }");
                    document = document2;
                }
                catch (SAXParseException e32) {
                    errorHandler.invoke(new ResourceDirectoryParseException("Error parsing '" + name2 + "'", e32));
                    return;
                }
                Document domTree = document;
                try {
                    e32 = ResourceValuesXmlParser.parseValuesResource$default(domTree, IdProvider.Companion.constant(), null, false, 8, null);
                }
                catch (ResourceValuesXmlParseException e4) {
                    errorHandler.invoke(new ResourceDirectoryParseException("Error parsing '" + name2 + "'", e4));
                    return;
                }
                SymbolTable parsedXml = e32;
                Collection collection = parsedXml.getSymbols().values();
                Intrinsics.checkNotNullExpressionValue(collection, "parsedXml.symbols.values()");
                Iterable $this$forEach$iv = collection;
                boolean $i$f$forEach = false;
                for (Object element$iv2 : $this$forEach$iv) {
                    Symbol s2 = (Symbol)element$iv2;
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue(s2, "s");
                    ResourceDirectoryParser.addIfNotExisting($this$parseAarZipEntry, s2);
                }
                break block16;
            }
            String string3 = name2.substring(lastSlashPosition + 1);
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
            String fileName = string3;
            String error = FileResourceNameValidator.getErrorTextForFileResource(fileName, folderResourceType);
            if (error != null) {
                errorHandler.invoke(new ResourceDirectoryParseException("Error parsing '" + name2 + "': " + error));
                return;
            }
            String symbolName = ResourceDirectoryParser.getNameWithoutExtensions(fileName);
            ResourceType resourceType = FolderTypeRelationship.getNonIdRelatedResourceType(folderResourceType);
            Intrinsics.checkNotNullExpressionValue((Object)resourceType, "resourceType");
            ResourceDirectoryParser.addIfNotExisting($this$parseAarZipEntry, Symbol.Companion.createSymbol$default(Symbol.Companion, resourceType, symbolName, IdProvider.Companion.constant(), false, false, 24, null));
            if (!FolderTypeRelationship.isIdGeneratingFolderType(folderResourceType) || !SdkUtils.endsWithIgnoreCase(fileName, ".xml")) break block16;
            try {
                Document document = documentBuilder.parse(content.invoke());
                Intrinsics.checkNotNullExpressionValue(document, "{\n                docume\u2026(content())\n            }");
                element$iv2 = document;
            }
            catch (SAXParseException e22) {
                errorHandler.invoke(new ResourceDirectoryParseException("Error parsing '" + name2 + "'", e22));
                return;
            }
            Document domTree = element$iv2;
            try {
                e22 = ResourceExtraXmlParser.parseResourceForInlineResources$default(domTree, IdProvider.Companion.constant(), false, 4, null);
            }
            catch (ResourceValuesXmlParseException e5) {
                errorHandler.invoke(new ResourceDirectoryParseException("Error parsing '" + name2 + "'", e5));
                return;
            }
            SymbolTable extraSymbols = e22;
            Collection collection = extraSymbols.getSymbols().values();
            Intrinsics.checkNotNullExpressionValue(collection, "extraSymbols.symbols.values()");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv3 : $this$forEach$iv) {
                Symbol s3 = (Symbol)element$iv3;
                boolean bl4 = false;
                Intrinsics.checkNotNullExpressionValue(s3, "s");
                ResourceDirectoryParser.addIfNotExisting($this$parseAarZipEntry, s3);
            }
        }
    }

    private static final String getNameWithoutExtensions(String filename) {
        String string2;
        int dotIndex = StringsKt.indexOf$default((CharSequence)filename, '.', 0, false, 6, null);
        if (dotIndex > 0) {
            String string3 = filename.substring(0, dotIndex);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
        } else {
            string2 = filename;
        }
        return string2;
    }

    private static final void addIfNotExisting(SymbolTable.Builder builder, Symbol symbol) {
        if (!builder.contains(symbol)) {
            builder.add(symbol);
        }
    }
}

