/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.symbols;

import com.android.SdkConstants;
import com.android.ide.common.symbols.IdProvider;
import com.android.ide.common.symbols.Symbol;
import com.android.ide.common.symbols.SymbolListVisitor;
import com.android.ide.common.symbols.SymbolTable;
import com.android.ide.common.symbols.SymbolTableBuilder;
import com.android.ide.common.xml.AndroidManifestParser;
import com.android.ide.common.xml.ManifestData;
import com.android.io.FileWrapper;
import com.android.resources.ResourceType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0092\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u000e\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0001\u001a\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0001\u001a(\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007\u001a$\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u001e\u001a\u001e\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u001eH\u0002\u001a\u001e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u001a\u000e\u0010#\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u000e\u0010#\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u0017\u001a6\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00012\u0006\u0010(\u001a\u00020&2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020&0*2\u0006\u0010+\u001a\u00020&2\b\b\u0002\u0010,\u001a\u00020-\u001a\u001c\u0010.\u001a\b\u0012\u0004\u0012\u00020\u000e0/2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0001\u001a\u000e\u00100\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u0017\u001a\u0014\u00101\u001a\b\u0012\u0004\u0012\u00020\u00010\u001e2\u0006\u00102\u001a\u00020\u0017\u001a\u0016\u00103\u001a\u00020&2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u0001\u001a\u001c\u00107\u001a\u00020\u00192\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u0001092\u0006\u0010:\u001a\u00020;\u001a\u000e\u0010<\u001a\u00020\u000e2\u0006\u0010=\u001a\u00020\u0001\u001a\u000e\u0010>\u001a\u00020\u00192\u0006\u0010:\u001a\u00020;\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"ANDROID_UNDERSCORE_PREFIX", "", "KEEP_RULE_PREFIX", "KEEP_RULE_SUFFIX", "NORMALIZED_VALUE_NAME_CHARS", "Lcom/google/common/base/CharMatcher;", "kotlin.jvm.PlatformType", "VALUE_ID_SPLITTER", "Lcom/google/common/base/Splitter;", "canonicalizeValueResourceName", "name", "failParseArrayLiteral", "", "size", "", "valuesString", "generateKeepRules", "", "manifest", "Lcom/android/ide/common/xml/ManifestData;", "isMainDex", "", "mergedResources", "Ljava/io/File;", "generateKeepRulesFromLayoutXmlFile", "", "layout", "documentBuilder", "Ljavax/xml/parsers/DocumentBuilder;", "rules", "Ljava/util/SortedSet;", "generateKeepRulesFromXmlNode", "node", "Lorg/w3c/dom/Element;", "generateMinifyKeepRules", "getPackageNameFromManifest", "manifestFile", "mergeAndRenumberSymbols", "Lcom/android/ide/common/symbols/SymbolTable;", "mainPackageName", "librarySymbols", "dependencySymbols", "", "platformSymbols", "idProvider", "Lcom/android/ide/common/symbols/IdProvider;", "parseArrayLiteral", "Lcom/google/common/collect/ImmutableList;", "parseManifest", "parseMinifiedKeepRules", "proguardRulesFile", "rTxtToSymbolTable", "inputStream", "Ljava/io/InputStream;", "packageName", "readAarRTxt", "lines", "", "visitor", "Lcom/android/ide/common/symbols/SymbolListVisitor;", "valueStringToInt", "valueString", "visitEmptySymbolTable", "sdk-common"})
@JvmName(name="SymbolUtils")
@SourceDebugExtension(value={"SMAP\nSymbolUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SymbolUtils.kt\ncom/android/ide/common/symbols/SymbolUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,616:1\n1855#2:617\n1855#2:618\n1856#2:626\n1856#2:627\n372#3,7:619\n*S KotlinDebug\n*F\n+ 1 SymbolUtils.kt\ncom/android/ide/common/symbols/SymbolUtils\n*L\n87#1:617\n88#1:618\n88#1:626\n87#1:627\n100#1:619,7\n*E\n"})
public final class SymbolUtils {
    private static final CharMatcher NORMALIZED_VALUE_NAME_CHARS = CharMatcher.anyOf(".:").precomputed();
    @NotNull
    private static final String ANDROID_UNDERSCORE_PREFIX = "android_";
    @NotNull
    private static final String KEEP_RULE_PREFIX = "-keep class ";
    @NotNull
    private static final String KEEP_RULE_SUFFIX = " { <init>(...); }";
    private static final Splitter VALUE_ID_SPLITTER = Splitter.on(',').trimResults();

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SymbolTable mergeAndRenumberSymbols(@NotNull String mainPackageName, @NotNull SymbolTable librarySymbols, @NotNull Collection<? extends SymbolTable> dependencySymbols, @NotNull SymbolTable platformSymbols, @NotNull IdProvider idProvider) {
        Intrinsics.checkNotNullParameter(mainPackageName, "mainPackageName");
        Intrinsics.checkNotNullParameter(librarySymbols, "librarySymbols");
        Intrinsics.checkNotNullParameter(dependencySymbols, "dependencySymbols");
        Intrinsics.checkNotNullParameter(platformSymbols, "platformSymbols");
        Intrinsics.checkNotNullParameter(idProvider, "idProvider");
        ArrayList<? extends SymbolTable> tables = new ArrayList<SymbolTable>(dependencySymbols.size() + 1);
        tables.add(librarySymbols);
        tables.addAll(dependencySymbols);
        HashMultimap newSymbolMap = HashMultimap.create();
        HashMap arrayToAttrs = new HashMap();
        Iterable $this$forEach$iv = tables;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SymbolTable table = (SymbolTable)element$iv;
            boolean bl2 = false;
            Collection collection = table.getSymbols().values();
            Intrinsics.checkNotNullExpressionValue(collection, "table.symbols.values()");
            Iterable $this$forEach$iv2 = collection;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Symbol symbol = (Symbol)element$iv2;
                boolean bl3 = false;
                Symbol symbol2 = symbol;
                if (symbol2 instanceof Symbol.AttributeSymbol) {
                    newSymbolMap.put((Object)ResourceType.ATTR, symbol.getCanonicalName());
                    continue;
                }
                if (symbol2 instanceof Symbol.NormalSymbol) {
                    newSymbolMap.put((Object)symbol.getResourceType(), symbol.getCanonicalName());
                    continue;
                }
                if (symbol2 instanceof Symbol.StyleableSymbol) {
                    Object object;
                    void $this$getOrPut$iv;
                    Map map2 = arrayToAttrs;
                    String key$iv = symbol.getCanonicalName();
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl4 = false;
                        Set answer$iv = new HashSet();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    ((Set)object).addAll((Collection)symbol.getChildren());
                    continue;
                }
                throw new IOException("Unexpected symbol " + symbol);
            }
        }
        SymbolTable.Builder tableBuilder = SymbolTable.Companion.builder().tablePackage(mainPackageName);
        HashMap<String, Symbol.AttributeSymbol> attrToValue = new HashMap<String, Symbol.AttributeSymbol>();
        for (ResourceType resourceType : newSymbolMap.keySet()) {
            ArrayList<String> symbolNames = Lists.newArrayList(newSymbolMap.get((Object)resourceType));
            Intrinsics.checkNotNullExpressionValue(symbolNames, "symbolNames");
            CollectionsKt.sort((List)symbolNames);
            for (String symbolName : symbolNames) {
                Intrinsics.checkNotNullExpressionValue((Object)resourceType, "resourceType");
                int value = idProvider.next(resourceType);
                Symbol newSymbol = null;
                if (resourceType == ResourceType.ATTR) {
                    Intrinsics.checkNotNullExpressionValue(symbolName, "symbolName");
                    newSymbol = Symbol.Companion.attributeSymbol$default(Symbol.Companion, symbolName, value, false, null, null, 24, null);
                    ((Map)attrToValue).put(symbolName, newSymbol);
                } else {
                    Intrinsics.checkNotNullExpressionValue(symbolName, "symbolName");
                    newSymbol = Symbol.Companion.normalSymbol$default(Symbol.Companion, resourceType, symbolName, value, null, symbolName, 8, null);
                }
                tableBuilder.add(newSymbol);
            }
        }
        arrayToAttrs.forEach(new BiConsumer(platformSymbols, attrToValue, tableBuilder){
            final /* synthetic */ SymbolTable $platformSymbols;
            final /* synthetic */ HashMap<String, Symbol.AttributeSymbol> $attrToValue;
            final /* synthetic */ SymbolTable.Builder $tableBuilder;
            {
                this.$platformSymbols = $platformSymbols;
                this.$attrToValue = $attrToValue;
                this.$tableBuilder = $tableBuilder;
            }

            public final void accept(@NotNull String arrayName, @NotNull Set<String> children2) {
                Intrinsics.checkNotNullParameter(arrayName, "arrayName");
                Intrinsics.checkNotNullParameter(children2, "children");
                List<String> attributes = CollectionsKt.sorted((Iterable)children2);
                ImmutableList.Builder<E> attributeValues = ImmutableList.builder();
                for (String attribute : attributes) {
                    Symbol.AttributeSymbol symbol;
                    if (StringsKt.startsWith$default(attribute, "android:", false, 2, null) || StringsKt.startsWith$default(attribute, "android_", false, 2, null)) {
                        String name2;
                        Intrinsics.checkNotNullExpressionValue(attribute.substring(SdkConstants.ANDROID_NS_NAME_PREFIX_LEN), "substring(...)");
                        Symbol platformSymbol = (Symbol)this.$platformSymbols.getSymbols().get((Object)((Object)ResourceType.ATTR), name2);
                        if (platformSymbol != null) {
                            attributeValues.add((Object)platformSymbol.getIntValue());
                            continue;
                        }
                    }
                    if ((symbol = this.$attrToValue.get(attribute)) != null) {
                        attributeValues.add((Object)symbol.getIntValue());
                        continue;
                    }
                    attributeValues.add((Object)0);
                }
                ImmutableCollection immutableCollection = attributeValues.build();
                Intrinsics.checkNotNullExpressionValue(immutableCollection, "attributeValues.build()");
                ImmutableList<E> immutableList = ImmutableList.copyOf((Collection)attributes);
                Intrinsics.checkNotNullExpressionValue(immutableList, "copyOf(attributes)");
                this.$tableBuilder.add(Symbol.Companion.styleableSymbol$default(Symbol.Companion, arrayName, (ImmutableList)immutableCollection, immutableList, null, arrayName, 8, null));
            }
        });
        return tableBuilder.build();
    }

    public static /* synthetic */ SymbolTable mergeAndRenumberSymbols$default(String string2, SymbolTable symbolTable, Collection collection, SymbolTable symbolTable2, IdProvider idProvider, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            idProvider = IdProvider.Companion.sequential();
        }
        return SymbolUtils.mergeAndRenumberSymbols(string2, symbolTable, collection, symbolTable2, idProvider);
    }

    @NotNull
    public static final String getPackageNameFromManifest(@NotNull File manifestFile) throws IOException {
        ManifestData manifestData;
        Intrinsics.checkNotNullParameter(manifestFile, "manifestFile");
        try {
            manifestData = AndroidManifestParser.parse(new FileWrapper(manifestFile));
        }
        catch (SAXException e2) {
            throw new IOException("Failed to parse android manifest XML file at path: '" + manifestFile.getAbsolutePath() + "'", e2);
        }
        catch (IOException e3) {
            throw new IOException("Failed to parse android manifest XML file at path: '" + manifestFile.getAbsolutePath() + "'", e3);
        }
        ManifestData manifestData2 = manifestData;
        String string2 = manifestData2.getPackage();
        Intrinsics.checkNotNullExpressionValue(string2, "manifestData.`package`");
        return string2;
    }

    @NotNull
    public static final String getPackageNameFromManifest(@NotNull ManifestData manifest) {
        Intrinsics.checkNotNullParameter(manifest, "manifest");
        String string2 = manifest.getPackage();
        Intrinsics.checkNotNullExpressionValue(string2, "manifest.`package`");
        return string2;
    }

    @NotNull
    public static final Set<String> generateMinifyKeepRules(@NotNull ManifestData manifest, @Nullable File mergedResources) {
        Intrinsics.checkNotNullParameter(manifest, "manifest");
        return SymbolUtils.generateKeepRules(manifest, false, mergedResources);
    }

    @VisibleForTesting
    @NotNull
    public static final Set<String> generateKeepRules(@NotNull ManifestData manifest, boolean isMainDex, @Nullable File mergedResources) {
        Intrinsics.checkNotNullParameter(manifest, "manifest");
        SortedSet rules = SetsKt.sortedSetOf(new String[0]);
        rules.add("# Generated by the gradle plugin");
        ManifestData.KeepClass[] keepClassArray = manifest.getKeepClasses();
        Intrinsics.checkNotNullExpressionValue(keepClassArray, "manifest.keepClasses");
        for (ManifestData.KeepClass keepClass : keepClassArray) {
            if (isMainDex) {
                String type;
                Intrinsics.checkNotNullExpressionValue(keepClass.getType(), "keepClass.type");
                String process = keepClass.getProcess();
                if (!(!Intrinsics.areEqual(type, "activity") && !Intrinsics.areEqual(type, "service") && !Intrinsics.areEqual(type, "provider") && !Intrinsics.areEqual(type, "receiver") || process != null && !(((CharSequence)process).length() == 0) && !StringsKt.startsWith$default(process, ":", false, 2, null))) continue;
            }
            rules.add(KEEP_RULE_PREFIX + keepClass.getName() + KEEP_RULE_SUFFIX);
        }
        if (mergedResources != null) {
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                File[] fileArray = mergedResources.listFiles();
                Intrinsics.checkNotNullExpressionValue(fileArray, "mergedResources.listFiles()");
                for (File typeDir : fileArray) {
                    File[] fileArray2;
                    if (!typeDir.isDirectory()) continue;
                    String string2 = typeDir.getName();
                    Intrinsics.checkNotNullExpressionValue(string2, "typeDir.name");
                    if (!StringsKt.startsWith$default(string2, "layout", false, 2, null)) continue;
                    Intrinsics.checkNotNullExpressionValue(typeDir.listFiles(), "typeDir.listFiles()");
                    for (File layoutXml : fileArray2) {
                        if (!layoutXml.isFile()) continue;
                        Intrinsics.checkNotNullExpressionValue(layoutXml, "layoutXml");
                        Intrinsics.checkNotNullExpressionValue(documentBuilder, "documentBuilder");
                        SymbolUtils.generateKeepRulesFromLayoutXmlFile(layoutXml, documentBuilder, rules);
                    }
                }
            }
            catch (ParserConfigurationException e2) {
                throw new IOException("Failed to read merged resources", e2);
            }
        }
        return rules;
    }

    public static final void generateKeepRulesFromLayoutXmlFile(@NotNull File layout, @NotNull DocumentBuilder documentBuilder, @NotNull SortedSet<String> rules) throws IOException {
        Intrinsics.checkNotNullParameter(layout, "layout");
        Intrinsics.checkNotNullParameter(documentBuilder, "documentBuilder");
        Intrinsics.checkNotNullParameter(rules, "rules");
        try {
            Document xmlDocument = documentBuilder.parse(layout);
            Element root = xmlDocument.getDocumentElement();
            if (root != null) {
                SymbolUtils.generateKeepRulesFromXmlNode(root, rules);
            }
        }
        catch (SAXException e2) {
            throw new IOException("Failed to parse XML resource file " + layout.getAbsolutePath(), e2);
        }
        catch (IOException e3) {
            throw new IOException("Failed to parse XML resource file " + layout.getAbsolutePath(), e3);
        }
    }

    private static final void generateKeepRulesFromXmlNode(Element node, SortedSet<String> rules) {
        String tag = node.getTagName();
        Intrinsics.checkNotNullExpressionValue(tag, "tag");
        if (StringsKt.contains$default((CharSequence)tag, ".", false, 2, null)) {
            rules.add(KEEP_RULE_PREFIX + tag + KEEP_RULE_SUFFIX);
        }
        for (Node current2 = node.getFirstChild(); current2 != null; current2 = current2.getNextSibling()) {
            if (current2.getNodeType() != 1) continue;
            SymbolUtils.generateKeepRulesFromXmlNode((Element)current2, rules);
        }
    }

    @NotNull
    public static final SortedSet<String> parseMinifiedKeepRules(@NotNull File proguardRulesFile) throws IOException {
        Intrinsics.checkNotNullParameter(proguardRulesFile, "proguardRulesFile");
        TreeSet<String> keepClasses = SetsKt.sortedSetOf(new String[0]);
        if (!proguardRulesFile.isFile()) {
            throw new IOException("Failed to parse proguard rules at path: " + proguardRulesFile.getAbsolutePath());
        }
        FilesKt.forEachLine$default(proguardRulesFile, null, new Function1<String, Unit>(keepClasses){
            final /* synthetic */ TreeSet<String> $keepClasses;
            {
                this.$keepClasses = $keepClasses;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (StringsKt.startsWith$default(it, "-keep class ", false, 2, null) && StringsKt.endsWith$default(it, " { <init>(...); }", false, 2, null)) {
                    this.$keepClasses.add(it);
                }
            }
        }, 1, null);
        return keepClasses;
    }

    @NotNull
    public static final ManifestData parseManifest(@NotNull File manifestFile) throws IOException {
        ManifestData manifestData;
        Intrinsics.checkNotNullParameter(manifestFile, "manifestFile");
        try {
            ManifestData manifestData2 = AndroidManifestParser.parse(new FileWrapper(manifestFile));
            Intrinsics.checkNotNullExpressionValue(manifestData2, "{\n        AndroidManifes\u2026pper(manifestFile))\n    }");
            manifestData = manifestData2;
        }
        catch (SAXException e2) {
            throw new IOException("Failed to parse android manifest XML file at path: '" + manifestFile.getAbsolutePath(), e2);
        }
        catch (IOException e3) {
            throw new IOException("Failed to parse android manifest XML file at path: '" + manifestFile.getAbsolutePath(), e3);
        }
        return manifestData;
    }

    @NotNull
    public static final String canonicalizeValueResourceName(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        String string2 = NORMALIZED_VALUE_NAME_CHARS.replaceFrom((CharSequence)name2, '_');
        Intrinsics.checkNotNullExpressionValue(string2, "NORMALIZED_VALUE_NAME_CHARS.replaceFrom(name, '_')");
        return string2;
    }

    public static final int valueStringToInt(@NotNull String valueString) {
        int n2;
        Intrinsics.checkNotNullParameter(valueString, "valueString");
        if (StringsKt.startsWith$default(valueString, "0x", false, 2, null)) {
            String string2 = valueString.substring(2);
            Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
            n2 = Integer.parseUnsignedInt(string2, 16);
        } else {
            n2 = Integer.parseInt(valueString);
        }
        return n2;
    }

    @NotNull
    public static final ImmutableList<Integer> parseArrayLiteral(int size, @NotNull String valuesString) {
        Intrinsics.checkNotNullParameter(valuesString, "valuesString");
        if (size == 0) {
            if (!StringsKt.isBlank(valuesString.subSequence(1, valuesString.length() - 1))) {
                SymbolUtils.failParseArrayLiteral(size, valuesString);
                throw new KotlinNothingValueException();
            }
            ImmutableList<Integer> immutableList = ImmutableList.of();
            Intrinsics.checkNotNullExpressionValue(immutableList, "of()");
            return immutableList;
        }
        ImmutableList.Builder ints = ImmutableList.builder();
        Iterator<String> values2 = VALUE_ID_SPLITTER.split(valuesString.subSequence(1, valuesString.length() - 1)).iterator();
        for (int i2 = 0; i2 < size; ++i2) {
            if (!values2.hasNext()) {
                SymbolUtils.failParseArrayLiteral(size, valuesString);
                throw new KotlinNothingValueException();
            }
            String value = values2.next();
            Intrinsics.checkNotNullExpressionValue(value, "value");
            if (StringsKt.startsWith$default(value, "android", false, 2, null)) {
                ints.add((Object)0);
                continue;
            }
            ints.add((Object)SymbolUtils.valueStringToInt(value));
        }
        if (values2.hasNext()) {
            SymbolUtils.failParseArrayLiteral(size, valuesString);
            throw new KotlinNothingValueException();
        }
        ImmutableCollection immutableCollection = ints.build();
        Intrinsics.checkNotNullExpressionValue(immutableCollection, "ints.build()");
        return immutableCollection;
    }

    @NotNull
    public static final Void failParseArrayLiteral(int size, @NotNull String valuesString) {
        Intrinsics.checkNotNullParameter(valuesString, "valuesString");
        throw new IOException("Values string " + valuesString + " should have " + size + " item(s).");
    }

    public static final void readAarRTxt(@NotNull Iterator<String> lines, @NotNull SymbolListVisitor visitor) throws IOException {
        Intrinsics.checkNotNullParameter(lines, "lines");
        Intrinsics.checkNotNullParameter(visitor, "visitor");
        visitor.visit();
        Object styleableChildPrefix = null;
        while (lines.hasNext()) {
            int end;
            int middle;
            int start;
            String line = lines.next();
            if (styleableChildPrefix != null && StringsKt.startsWith$default(line, styleableChildPrefix, false, 2, null)) {
                start = ((String)styleableChildPrefix).length() + 1;
                int end2 = StringsKt.indexOf$default((CharSequence)line, ' ', ((String)styleableChildPrefix).length(), false, 4, null);
                if (end2 == -1) continue;
                String string2 = line.substring(start, end2);
                Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
                visitor.child(string2);
                continue;
            }
            if (StringsKt.startsWith$default(line, "int styleable ", false, 2, null) || (start = StringsKt.indexOf$default((CharSequence)line, ' ', 0, false, 6, null) + 1) == 0 || (middle = StringsKt.indexOf$default((CharSequence)line, ' ', start, false, 4, null) + 1) == 0 || (end = StringsKt.indexOf$default((CharSequence)line, ' ', middle, false, 4, null) + 1) == 0) continue;
            visitor.symbol(line.subSequence(start, middle - 1), line.subSequence(middle, end - 1));
            if (StringsKt.startsWith$default(line, "int[] ", false, 2, null)) {
                String string3 = line.substring(middle, end - 1);
                Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
                styleableChildPrefix = "int styleable " + string3;
                continue;
            }
            styleableChildPrefix = null;
        }
        visitor.visitEnd();
    }

    public static final void visitEmptySymbolTable(@NotNull SymbolListVisitor visitor) {
        Intrinsics.checkNotNullParameter(visitor, "visitor");
        visitor.visit();
        visitor.visitEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final SymbolTable rTxtToSymbolTable(@NotNull InputStream inputStream, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter(inputStream, "inputStream");
        Intrinsics.checkNotNullParameter(packageName, "packageName");
        SymbolTableBuilder symbolTableBuilder = new SymbolTableBuilder(packageName);
        Closeable closeable = inputStream;
        Object object = Charsets.UTF_8;
        Object object2 = new InputStreamReader((InputStream)closeable, (Charset)object);
        int n2 = 8192;
        closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n2);
        object = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl2 = false;
            Iterator<String> iterator2 = it.lines().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, "it.lines().iterator()");
            SymbolUtils.readAarRTxt(iterator2, symbolTableBuilder);
            object2 = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally(closeable, (Throwable)object);
        }
        return symbolTableBuilder.getSymbolTable();
    }
}

