/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.util;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.ide.common.util.DeviceUtils;
import com.android.ide.common.util.Receiver;
import java.io.IOException;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0003\u001a\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0003\u001a\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\r*\u00020\u00062\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0007\u001a\u0012\u0010\u0010\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0007\"\u0015\u0010\b\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"MDNS_AUTO_CONNECT_TLS_REGEX", "Lkotlin/text/Regex;", "MDNS_UNENCRYPTED_SUFFIX", "", "isMdnsAutoConnectTls", "", "Lcom/android/ddmlib/IDevice;", "(Lcom/android/ddmlib/IDevice;)Z", "isMdnsAutoConnectUnencrypted", "areForSameDevice", "domainName", "serialNumber", "getLanguages", "", "timeOut", "Ljava/time/Duration;", "isSameAsDeviceWith", "key", "sdk-common"})
@JvmName(name="DeviceUtils")
public final class DeviceUtils {
    @NotNull
    private static final Regex MDNS_AUTO_CONNECT_TLS_REGEX = new Regex("adb-(.*)-.*\\._adb-tls-connect\\._tcp\\.?");
    @NotNull
    private static final String MDNS_UNENCRYPTED_SUFFIX = "_adb._tcp.";

    @JvmOverloads
    @NotNull
    public static final Set<String> getLanguages(@NotNull IDevice $this$getLanguages, @NotNull Duration timeOut) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        Intrinsics.checkNotNullParameter($this$getLanguages, "<this>");
        Intrinsics.checkNotNullParameter(timeOut, "timeOut");
        if ($this$getLanguages.getVersion().getApiLevel() < 21) {
            return SetsKt.emptySet();
        }
        Receiver receiver = new Receiver();
        $this$getLanguages.executeShellCommand("am get-config", (IShellOutputReceiver)receiver, timeOut.toMillis(), TimeUnit.MILLISECONDS);
        return SequencesKt.toSet(SequencesKt.flatMap(SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)receiver.getLines()), getLanguages.1.INSTANCE), getLanguages.2.INSTANCE), getLanguages.3.INSTANCE));
    }

    public static /* synthetic */ Set getLanguages$default(IDevice iDevice, Duration duration, int n2, Object object) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        if ((n2 & 1) != 0) {
            Duration duration2 = Duration.ZERO;
            Intrinsics.checkNotNullExpressionValue(duration2, "ZERO");
            duration = duration2;
        }
        return DeviceUtils.getLanguages(iDevice, duration);
    }

    public static final boolean isMdnsAutoConnectTls(@NotNull IDevice $this$isMdnsAutoConnectTls) {
        Intrinsics.checkNotNullParameter($this$isMdnsAutoConnectTls, "<this>");
        String string2 = $this$isMdnsAutoConnectTls.getSerialNumber();
        Intrinsics.checkNotNullExpressionValue(string2, "this.serialNumber");
        return DeviceUtils.isMdnsAutoConnectTls(string2);
    }

    public static final boolean isMdnsAutoConnectUnencrypted(@NotNull IDevice $this$isMdnsAutoConnectUnencrypted) {
        Intrinsics.checkNotNullParameter($this$isMdnsAutoConnectUnencrypted, "<this>");
        String string2 = $this$isMdnsAutoConnectUnencrypted.getSerialNumber();
        Intrinsics.checkNotNullExpressionValue(string2, "this.serialNumber");
        return DeviceUtils.isMdnsAutoConnectUnencrypted(string2);
    }

    public static final boolean isSameAsDeviceWith(@NotNull IDevice $this$isSameAsDeviceWith, @NotNull String key) {
        Intrinsics.checkNotNullParameter($this$isSameAsDeviceWith, "<this>");
        Intrinsics.checkNotNullParameter(key, "key");
        if (Intrinsics.areEqual($this$isSameAsDeviceWith.getSerialNumber(), key)) {
            return true;
        }
        if (DeviceUtils.isMdnsAutoConnectTls(key)) {
            String string2 = $this$isSameAsDeviceWith.getSerialNumber();
            Intrinsics.checkNotNullExpressionValue(string2, "serialNumber");
            if (DeviceUtils.isMdnsAutoConnectTls(string2)) {
                return false;
            }
            String string3 = $this$isSameAsDeviceWith.getSerialNumber();
            Intrinsics.checkNotNullExpressionValue(string3, "serialNumber");
            return DeviceUtils.areForSameDevice(key, string3);
        }
        String string4 = $this$isSameAsDeviceWith.getSerialNumber();
        Intrinsics.checkNotNullExpressionValue(string4, "serialNumber");
        if (!DeviceUtils.isMdnsAutoConnectTls(string4)) {
            return false;
        }
        String string5 = $this$isSameAsDeviceWith.getSerialNumber();
        Intrinsics.checkNotNullExpressionValue(string5, "serialNumber");
        return DeviceUtils.areForSameDevice(string5, key);
    }

    public static final boolean areForSameDevice(@NotNull String domainName, @NotNull String serialNumber) {
        Intrinsics.checkNotNullParameter(domainName, "domainName");
        Intrinsics.checkNotNullParameter(serialNumber, "serialNumber");
        boolean bl2 = DeviceUtils.isMdnsAutoConnectTls(domainName);
        if (_Assertions.ENABLED && !bl2) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        MatchResult matchResult = Regex.find$default(MDNS_AUTO_CONNECT_TLS_REGEX, domainName, 0, 2, null);
        Intrinsics.checkNotNull(matchResult);
        return Intrinsics.areEqual(matchResult.getGroupValues().get(1), serialNumber);
    }

    public static final boolean isMdnsAutoConnectTls(@NotNull String serialNumber) {
        Intrinsics.checkNotNullParameter(serialNumber, "serialNumber");
        return MDNS_AUTO_CONNECT_TLS_REGEX.matches(serialNumber);
    }

    public static final boolean isMdnsAutoConnectUnencrypted(@NotNull String serialNumber) {
        Intrinsics.checkNotNullParameter(serialNumber, "serialNumber");
        return StringsKt.endsWith$default(serialNumber, MDNS_UNENCRYPTED_SUFFIX, false, 2, null);
    }

    @JvmOverloads
    @NotNull
    public static final Set<String> getLanguages(@NotNull IDevice $this$getLanguages) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        Intrinsics.checkNotNullParameter($this$getLanguages, "<this>");
        return DeviceUtils.getLanguages$default($this$getLanguages, null, 1, null);
    }
}

