/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.util;

import com.android.ide.common.util.PathString;
import java.io.File;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u001e\n\u0002\b\u0003\u001a\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0006H\u0002\u001a\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0010\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u0006H\u0002\u001a(\u0010\u001b\u001a\u00020\u0015*\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00042\b\b\u0002\u0010\u001d\u001a\u00020\u00152\b\b\u0002\u0010\u001e\u001a\u00020\u0018H\u0002\u001a!\u0010\u001b\u001a\u00020\u0015*\u00020\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00180!H\u0082\b\u001a\n\u0010\"\u001a\u00020#*\u00020$\u001a\n\u0010\"\u001a\u00020#*\u00020%\u001a\u000e\u0010&\u001a\u0004\u0018\u00010#*\u0004\u0018\u00010$\u001a\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020#0(*\b\u0012\u0004\u0012\u00020$0)\u001a\u0014\u0010*\u001a\u00020\u0006*\u00020\u00062\u0006\u0010+\u001a\u00020\u0004H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\b\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\"\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"APK_URI", "Ljava/net/URI;", "JAR_URI", "NUL_CHAR", "", "PARENT", "", "SELF", "defaultFilesystemUri", "getDefaultFilesystemUri", "()Ljava/net/URI;", "uriCache", "Ljava/util/concurrent/ConcurrentHashMap;", "chooseSeparator", "c1", "c2", "createRootUri", "scheme", "detectSeparator", "path", "rootLength", "", "getUri", "isSeparator", "", "c", "prefixLength", "countUntil", "char", "startIndex", "ignoreCase", "Lkotlin/ranges/IntProgression;", "predicate", "Lkotlin/Function1;", "toPathString", "Lcom/android/ide/common/util/PathString;", "Ljava/io/File;", "Ljava/nio/file/Path;", "toPathStringOrNull", "toPathStrings", "", "", "withSeparator", "sep", "sdk-common"})
@JvmName(name="PathStringUtil")
@SourceDebugExtension(value={"SMAP\nPathString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathString.kt\ncom/android/ide/common/util/PathStringUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,871:1\n1549#2:872\n1620#2,3:873\n72#3,2:876\n1#4:878\n1#4:879\n*S KotlinDebug\n*F\n+ 1 PathString.kt\ncom/android/ide/common/util/PathStringUtil\n*L\n782#1:872\n782#1:873,3\n866#1:876,2\n866#1:878\n*E\n"})
public final class PathStringUtil {
    @NotNull
    public static final String PARENT = "..";
    @NotNull
    public static final String SELF = ".";
    public static final char NUL_CHAR = '\u0000';
    @NotNull
    private static final URI defaultFilesystemUri;
    @NotNull
    private static final ConcurrentHashMap<String, URI> uriCache;
    @NotNull
    private static final URI APK_URI;
    @NotNull
    private static final URI JAR_URI;

    @NotNull
    public static final PathString toPathString(@NotNull Path $this$toPathString) {
        Intrinsics.checkNotNullParameter($this$toPathString, "<this>");
        return new PathString($this$toPathString);
    }

    @NotNull
    public static final PathString toPathString(@NotNull File $this$toPathString) {
        Intrinsics.checkNotNullParameter($this$toPathString, "<this>");
        return new PathString($this$toPathString);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PathString> toPathStrings(@NotNull Collection<? extends File> $this$toPathStrings) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$toPathStrings, "<this>");
        Iterable $this$map$iv = $this$toPathStrings;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file2 = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(new PathString((File)it));
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final PathString toPathStringOrNull(@Nullable File $this$toPathStringOrNull) {
        File file2 = $this$toPathStringOrNull;
        return file2 != null ? PathStringUtil.toPathString(file2) : null;
    }

    @NotNull
    public static final URI getDefaultFilesystemUri() {
        return defaultFilesystemUri;
    }

    private static final boolean isSeparator(char c2) {
        return c2 == '/' || c2 == '\\';
    }

    private static final int prefixLength(String path) {
        int firstSlash = path.length();
        int n2 = path.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!PathStringUtil.isSeparator(path.charAt(i2))) continue;
            firstSlash = i2;
            break;
        }
        int firstColon = PathStringUtil.countUntil$default(path, ':', 0, false, 6, null);
        int prefixEnd = firstColon + 1;
        if (firstColon >= firstSlash) {
            if (firstSlash > 0) {
                return 0;
            }
            prefixEnd = 0;
        }
        while (prefixEnd < path.length() && PathStringUtil.isSeparator(path.charAt(prefixEnd))) {
            ++prefixEnd;
        }
        return prefixEnd;
    }

    private static final int countUntil(IntProgression $this$countUntil, Function1<? super Integer, Boolean> predicate) {
        boolean $i$f$countUntil = false;
        int result2 = 0;
        int item = $this$countUntil.getFirst();
        int n2 = $this$countUntil.getLast();
        int n3 = $this$countUntil.getStep();
        if (n3 > 0 && item <= n2 || n3 < 0 && n2 <= item) {
            while (true) {
                if (predicate.invoke((Integer)item).booleanValue()) {
                    return result2;
                }
                ++result2;
                if (item == n2) break;
                item += n3;
            }
        }
        return result2;
    }

    private static final int countUntil(String $this$countUntil, char c2, int startIndex, boolean ignoreCase) {
        int result2 = StringsKt.indexOf((CharSequence)$this$countUntil, c2, startIndex, ignoreCase);
        return result2 == -1 ? $this$countUntil.length() : result2;
    }

    static /* synthetic */ int countUntil$default(String string2, char c2, int n2, boolean bl2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        if ((n3 & 4) != 0) {
            bl2 = false;
        }
        return PathStringUtil.countUntil(string2, c2, n2, bl2);
    }

    private static final char detectSeparator(String path, int rootLength) {
        int startIndex;
        int n2 = path.length();
        for (int i2 = startIndex = RangesKt.coerceAtLeast(rootLength - 1, 0); i2 < n2; ++i2) {
            char c2 = path.charAt(i2);
            if (!PathStringUtil.isSeparator(c2)) continue;
            return c2;
        }
        return '\u0000';
    }

    private static final String withSeparator(String $this$withSeparator, char sep) {
        return sep == '\u0000' ? $this$withSeparator : StringsKt.replace$default(StringsKt.replace$default($this$withSeparator, '/', sep, false, 4, null), '\\', sep, false, 4, null);
    }

    private static final char chooseSeparator(char c1, char c2) {
        return c1 == '\u0000' ? (c2 == '\u0000' ? File.separatorChar : c2) : c1;
    }

    private static final URI getUri(String scheme) {
        URI uRI;
        String string2 = scheme;
        if (Intrinsics.areEqual(string2, defaultFilesystemUri.getScheme())) {
            uRI = defaultFilesystemUri;
        } else if (Intrinsics.areEqual(string2, APK_URI.getScheme())) {
            uRI = APK_URI;
        } else if (Intrinsics.areEqual(string2, JAR_URI.getScheme())) {
            uRI = JAR_URI;
        } else {
            ConcurrentMap $this$getOrPut$iv = uriCache;
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(scheme);
            if (object == null) {
                boolean bl2 = false;
                URI default$iv = PathStringUtil.createRootUri(scheme);
                boolean bl3 = false;
                object = $this$getOrPut$iv.putIfAbsent(scheme, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            Intrinsics.checkNotNullExpressionValue(object, "uriCache.getOrPut(scheme\u2026{ createRootUri(scheme) }");
            uRI = (URI)object;
        }
        return uRI;
    }

    private static final URI createRootUri(String scheme) {
        return new URI(scheme, "", "/", null);
    }

    public static final /* synthetic */ char access$detectSeparator(String path, int rootLength) {
        return PathStringUtil.detectSeparator(path, rootLength);
    }

    public static final /* synthetic */ URI access$getUri(String scheme) {
        return PathStringUtil.getUri(scheme);
    }

    public static final /* synthetic */ int access$prefixLength(String path) {
        return PathStringUtil.prefixLength(path);
    }

    public static final /* synthetic */ String access$withSeparator(String $receiver, char sep) {
        return PathStringUtil.withSeparator($receiver, sep);
    }

    public static final /* synthetic */ boolean access$isSeparator(char c2) {
        return PathStringUtil.isSeparator(c2);
    }

    public static final /* synthetic */ char access$chooseSeparator(char c1, char c2) {
        return PathStringUtil.chooseSeparator(c1, c2);
    }

    static {
        FileSystem it = FileSystems.getDefault();
        boolean bl2 = false;
        URI uRI = it.getPath(it.getSeparator(), new String[0]).toUri();
        Intrinsics.checkNotNullExpressionValue(uRI, "getDefault().let { it.ge\u2026h(it.separator) }.toUri()");
        defaultFilesystemUri = uRI;
        uriCache = new ConcurrentHashMap();
        APK_URI = PathStringUtil.createRootUri("apk");
        JAR_URI = PathStringUtil.createRootUri("jar");
    }
}

