/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import com.android.ide.common.vectordrawable.VdPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PathParser {
    private static final float[] EMPTY_FLOAT_ARRAY = new float[0];

    private PathParser() {
    }

    private static void extract(String s2, int start, boolean flagMode, ExtractFloatResult result2) {
        int currentIndex;
        boolean foundSeparator = false;
        result2.mExplicitSeparator = false;
        boolean secondDot = false;
        boolean isExponential = false;
        for (currentIndex = start; currentIndex < s2.length(); ++currentIndex) {
            boolean isPrevExponential = isExponential;
            isExponential = false;
            char currentChar = s2.charAt(currentIndex);
            switch (currentChar) {
                case ' ': 
                case ',': {
                    foundSeparator = true;
                    result2.mExplicitSeparator = true;
                    break;
                }
                case '-': {
                    if (currentIndex == start || isPrevExponential) break;
                    foundSeparator = true;
                    break;
                }
                case '.': {
                    if (secondDot) {
                        foundSeparator = true;
                        break;
                    }
                    secondDot = true;
                    break;
                }
                case 'E': 
                case 'e': {
                    isExponential = true;
                }
            }
            if (foundSeparator || flagMode && currentIndex > start) break;
        }
        result2.mEndPosition = currentIndex;
    }

    private static float[] getFloats(String s2, ParseMode parseMode) {
        char command2 = s2.charAt(0);
        if (command2 == 'z' || command2 == 'Z') {
            return EMPTY_FLOAT_ARRAY;
        }
        try {
            boolean arcCommand = command2 == 'a' || command2 == 'A';
            float[] results = new float[s2.length()];
            int count2 = 0;
            int startPosition = 1;
            ExtractFloatResult result2 = new ExtractFloatResult();
            int totalLength = s2.length();
            while (startPosition < totalLength) {
                boolean flagMode = parseMode == ParseMode.SVG && arcCommand && (count2 % 7 == 3 || count2 % 7 == 4);
                PathParser.extract(s2, startPosition, flagMode, result2);
                int endPosition = result2.mEndPosition;
                if (startPosition < endPosition) {
                    results[count2++] = Float.parseFloat(s2.substring(startPosition, endPosition));
                }
                if (result2.mExplicitSeparator) {
                    startPosition = endPosition + 1;
                    continue;
                }
                startPosition = endPosition;
            }
            if (arcCommand) {
                for (int i2 = 0; i2 < count2 - 1; i2 += 7) {
                    results[i2] = Math.abs(results[i2]);
                    results[i2 + 1] = Math.abs(results[i2 + 1]);
                }
            }
            return Arrays.copyOfRange(results, 0, count2);
        }
        catch (NumberFormatException e2) {
            throw new RuntimeException("Error in parsing \"" + s2 + "\"", e2);
        }
    }

    private static void addNode(List<VdPath.Node> list2, char cmd, float[] val) {
        list2.add(new VdPath.Node(cmd, val));
    }

    private static int nextStart(String s2, int end) {
        while (end < s2.length()) {
            char c2 = s2.charAt(end);
            if ('A' <= c2 && c2 <= 'Z' && c2 != 'E' || 'a' <= c2 && c2 <= 'z' && c2 != 'e') {
                return end;
            }
            ++end;
        }
        return end;
    }

    public static VdPath.Node[] parsePath(String value, ParseMode mode) {
        value = value.trim();
        ArrayList<VdPath.Node> list2 = new ArrayList<VdPath.Node>();
        int start = 0;
        int end = 1;
        while (end < value.length()) {
            end = PathParser.nextStart(value, end);
            String s2 = value.substring(start, end);
            char currentCommand = s2.charAt(0);
            float[] val = PathParser.getFloats(s2, mode);
            if (start == 0 && currentCommand != 'M' && currentCommand != 'm') {
                PathParser.addNode(list2, 'M', new float[2]);
            }
            PathParser.addNode(list2, currentCommand, val);
            start = end++;
        }
        if (end - start == 1 && start < value.length()) {
            PathParser.addNode(list2, value.charAt(start), EMPTY_FLOAT_ARRAY);
        }
        return list2.toArray(new VdPath.Node[0]);
    }

    private static class ExtractFloatResult {
        private int mEndPosition;
        private boolean mExplicitSeparator;

        private ExtractFloatResult() {
        }
    }

    public static enum ParseMode {
        SVG,
        ANDROID;

    }
}

