/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.vectordrawable;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"ALPHA_MASK", "", "getCoordinateFormat", "Ljava/text/NumberFormat;", "maxViewportSize", "", "parseColorValue", "color", "", "sdk-common"})
@JvmName(name="VdUtil")
@SourceDebugExtension(value={"SMAP\nVdUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VdUtil.kt\ncom/android/ide/common/vectordrawable/VdUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
public final class VdUtil {
    private static final int ALPHA_MASK = -16777216;

    @NotNull
    public static final NumberFormat getCoordinateFormat(float maxViewportSize) {
        DecimalFormat decimalFormat;
        int exponent = (int)Math.floor(Math.log10(maxViewportSize));
        int fractionalDigits = 4 - exponent;
        StringBuilder formatBuilder = new StringBuilder("#");
        if (fractionalDigits > 0) {
            if (fractionalDigits > 6) {
                fractionalDigits = 6;
            }
            formatBuilder.append('.');
            int n2 = fractionalDigits;
            for (int i2 = 0; i2 < n2; ++i2) {
                formatBuilder.append('#');
            }
        }
        DecimalFormat $this$getCoordinateFormat_u24lambda_u240 = decimalFormat = new DecimalFormat(formatBuilder.toString(), new DecimalFormatSymbols(Locale.ROOT));
        boolean bl2 = false;
        $this$getCoordinateFormat_u24lambda_u240.setRoundingMode(RoundingMode.HALF_UP);
        return decimalFormat;
    }

    public static final int parseColorValue(@NotNull String color) {
        int n2;
        Intrinsics.checkNotNullParameter(color, "color");
        if (!StringsKt.startsWith$default(color, "#", false, 2, null)) {
            boolean $i$a$-require-VdUtil$parseColorValue$22 = false;
            String $i$a$-require-VdUtil$parseColorValue$22 = "Invalid color value " + color;
            throw new IllegalArgumentException($i$a$-require-VdUtil$parseColorValue$22.toString());
        }
        switch (color.length()) {
            case 7: {
                String string2 = color.substring(1);
                Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
                n2 = Integer.parseUnsignedInt(string2, 16) | 0xFF000000;
                break;
            }
            case 9: {
                String string3 = color.substring(1);
                Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
                n2 = Integer.parseUnsignedInt(string3, 16);
                break;
            }
            case 4: {
                String string4 = color.substring(1);
                Intrinsics.checkNotNullExpressionValue(string4, "substring(...)");
                int v2 = Integer.parseUnsignedInt(string4, 16);
                n2 = (v2 >> 8 & 0xF) * 0x110000 | (v2 >> 4 & 0xF) * 4352 | (v2 & 0xF) * 17 | 0xFF000000;
                break;
            }
            case 5: {
                String string5 = color.substring(1);
                Intrinsics.checkNotNullExpressionValue(string5, "substring(...)");
                int v3 = Integer.parseUnsignedInt(string5, 16);
                n2 = (v3 >> 12 & 0xF) * 0x11000000 | (v3 >> 8 & 0xF) * 0x110000 | (v3 >> 4 & 0xF) * 4352 | (v3 & 0xF) * 17;
                break;
            }
            default: {
                n2 = -16777216;
            }
        }
        return n2;
    }
}

