/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.xml;

import com.google.common.base.Strings;
import java.util.Comparator;
import org.w3c.dom.Attr;

public enum XmlAttributeSortOrder {
    NO_SORTING("none"),
    ALPHABETICAL("alpha"),
    LOGICAL("logical");

    public final String key;
    private static final Comparator<Attr> SORTED_ORDER_COMPARATOR;
    private static final Comparator<Attr> ALPHABETICAL_COMPARATOR;

    private XmlAttributeSortOrder(String key) {
        this.key = key;
    }

    public Comparator<Attr> getAttributeComparator() {
        switch (this) {
            case NO_SORTING: {
                return null;
            }
            case ALPHABETICAL: {
                return ALPHABETICAL_COMPARATOR;
            }
        }
        return SORTED_ORDER_COMPARATOR;
    }

    public static int compareAttributes(String name1, String name2) {
        int priority2;
        int priority1 = XmlAttributeSortOrder.getAttributePriority(name1);
        if (priority1 != (priority2 = XmlAttributeSortOrder.getAttributePriority(name2))) {
            return priority1 - priority2;
        }
        return name1.compareTo(name2);
    }

    public static int compareAttributes(String prefix1, String name1, String prefix2, String name2) {
        int priority2;
        int priority1 = XmlAttributeSortOrder.getAttributePriority(name1);
        if (priority1 != (priority2 = XmlAttributeSortOrder.getAttributePriority(name2))) {
            return priority1 - priority2;
        }
        int namespaceDelta = Strings.nullToEmpty(prefix1).compareTo(Strings.nullToEmpty(prefix2));
        if (namespaceDelta != 0) {
            return namespaceDelta;
        }
        return name1.compareTo(name2);
    }

    private static int getAttributePriority(String name2) {
        if ("id".equals(name2)) {
            return 10;
        }
        if ("name".equals(name2)) {
            return 15;
        }
        if ("style".equals(name2)) {
            return 20;
        }
        if (name2.startsWith("layout_")) {
            if (name2.equals("layout_width")) {
                return 30;
            }
            if (name2.equals("layout_height")) {
                return 40;
            }
            return 50;
        }
        if ("color".equals(name2)) {
            return 100;
        }
        return 60;
    }

    static {
        SORTED_ORDER_COMPARATOR = new Comparator<Attr>(){

            @Override
            public int compare(Attr attr1, Attr attr2) {
                String prefix1 = attr1.getPrefix();
                String prefix2 = attr2.getPrefix();
                if ("xmlns".equals(prefix1)) {
                    if ("xmlns".equals(prefix2)) {
                        return 0;
                    }
                    return -1;
                }
                if ("xmlns".equals(attr2.getPrefix())) {
                    return 1;
                }
                String name1 = prefix1 != null ? attr1.getLocalName() : attr1.getName();
                String name2 = prefix2 != null ? attr2.getLocalName() : attr2.getName();
                return XmlAttributeSortOrder.compareAttributes(prefix1, name1, prefix2, name2);
            }
        };
        ALPHABETICAL_COMPARATOR = new Comparator<Attr>(){

            @Override
            public int compare(Attr attr1, Attr attr2) {
                if ("xmlns".equals(attr1.getPrefix())) {
                    if ("xmlns".equals(attr2.getPrefix())) {
                        return 0;
                    }
                    return -1;
                }
                if ("xmlns".equals(attr2.getPrefix())) {
                    return 1;
                }
                return attr1.getName().compareTo(attr2.getName());
            }
        };
    }
}

