/*
 * Decompiled with CFR 0.152.
 */
package com.android.instantapp.run;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.instantapp.run.InstantAppRunException;
import com.android.instantapp.run.PostOInstaller;
import com.android.instantapp.run.PreOSideLoader;
import com.android.instantapp.run.RunListener;
import com.android.instantapp.utils.DeviceUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class InstantAppSideLoader {
    private final String myPkgName;
    private final Installer myInstaller;
    private final RunListener myListener;
    private long myShellTimeout = 500L;

    public InstantAppSideLoader(String pkgName, File bundle) {
        this(pkgName, bundle, (RunListener)new RunListener.NullListener());
    }

    public InstantAppSideLoader(String pkgName, List<File> apks) {
        this(pkgName, apks, (RunListener)new RunListener.NullListener());
    }

    public InstantAppSideLoader(String pkgName, File bundle, RunListener listener) {
        this.myPkgName = pkgName;
        this.myInstaller = new PreOSideLoader(bundle, listener);
        this.myListener = listener;
    }

    public InstantAppSideLoader(String pkgName, List<File> apks, RunListener listener) {
        this.myPkgName = pkgName;
        this.myInstaller = new PostOInstaller(apks, listener);
        this.myListener = listener;
    }

    public void install(IDevice device) throws InstantAppRunException {
        this.install(device, 1);
    }

    public void install(IDevice device, int retries) throws InstantAppRunException {
        boolean success = false;
        while (!success) {
            try {
                this.tryToInstall(device);
                success = true;
            }
            catch (InstantAppRunException e2) {
                if (retries > 0 && this.prepareRetry(e2.getErrorType())) {
                    --retries;
                    this.myListener.logMessage("Retrying to side load instant app.", e2);
                    continue;
                }
                this.myListener.printMessage("Side loading instant app failed: " + e2.getMessage());
                this.myListener.logMessage("Side loading instant app failed.", e2);
                throw e2;
            }
        }
    }

    private void tryToInstall(IDevice device) throws InstantAppRunException {
        this.myListener.setProgress(0.0);
        if (DeviceUtils.isPostO(device)) {
            this.myListener.logMessage("PostO device.", null);
            assert (this.myInstaller instanceof PostOInstaller);
        } else {
            this.myListener.logMessage("PreO device.", null);
            assert (this.myInstaller instanceof PreOSideLoader);
        }
        if (!this.myListener.isCancelled()) {
            this.uninstallAppIfInstalled(device);
        }
        this.myListener.setProgress(0.2);
        if (!this.myListener.isCancelled()) {
            this.myListener.printMessage("Side loading instant app.");
            this.myListener.logMessage("Side loading instant app.", null);
            this.myInstaller.install(device);
        }
        this.myListener.setProgress(1.0);
    }

    private boolean prepareRetry(InstantAppRunException.ErrorType errorType) {
        switch (errorType) {
            case NO_GOOGLE_ACCOUNT: 
            case CANCELLED: {
                return false;
            }
            case READ_IAPK_TIMEOUT: {
                if (this.myInstaller instanceof PreOSideLoader) {
                    ((PreOSideLoader)this.myInstaller).increaseLogcatTimeout();
                }
                return true;
            }
            case SHELL_TIMEOUT: {
                this.myShellTimeout *= 2L;
                if (this.myInstaller instanceof PreOSideLoader) {
                    ((PreOSideLoader)this.myInstaller).increaseShellTimeout();
                }
                return true;
            }
            case READ_IAPK_FAILED: 
            case ADB_FAILURE: 
            case INSTALL_FAILED: 
            case UNKNOWN: {
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    void uninstallAppIfInstalled(IDevice device) throws InstantAppRunException {
        try {
            if (!InstantAppSideLoader.isEmpty(InstantAppSideLoader.executeShellCommand(device, "pm path " + this.myPkgName, false, this.myShellTimeout))) {
                this.myListener.logMessage("Non instant app was installed. Uninstalling it.", null);
                String result2 = device.uninstallPackage(this.myPkgName);
                if (result2 != null) {
                    throw new InstantAppRunException(InstantAppRunException.ErrorType.UNKNOWN, result2);
                }
            }
        }
        catch (InstallException e2) {
            throw new InstantAppRunException(InstantAppRunException.ErrorType.INSTALL_FAILED, "Failed uninstalling existing package " + this.myPkgName, e2);
        }
    }

    private static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    static String executeShellCommand(IDevice device, String command2, boolean rootRequired, long timeout) throws InstantAppRunException {
        CountDownLatch latch = new CountDownLatch(1);
        CollectingOutputReceiver receiver = new CollectingOutputReceiver(latch);
        try {
            if (rootRequired) {
                device.root();
            }
            device.executeShellCommand(command2, (IShellOutputReceiver)receiver);
            if (!latch.await(timeout, TimeUnit.MILLISECONDS)) {
                throw new InstantAppRunException(InstantAppRunException.ErrorType.SHELL_TIMEOUT, "Failed executing command \"" + command2 + "\".");
            }
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException | InterruptedException e2) {
            throw new InstantAppRunException(e2 instanceof InterruptedException ? InstantAppRunException.ErrorType.UNKNOWN : InstantAppRunException.ErrorType.ADB_FAILURE, "Failed executing command \"" + command2 + "\".", e2);
        }
        return receiver.getOutput();
    }

    static interface Installer {
        public void install(IDevice var1) throws InstantAppRunException;
    }
}

