/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib;

import android.os._Original_Build;
import com.android.tools.environment.Logger;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;

public class LayoutlibClassLoader
extends ClassLoader {
    private static final Logger LOG = Logger.getInstance(LayoutlibClassLoader.class);

    public LayoutlibClassLoader(@NotNull ClassLoader parent) {
        super(parent);
        LayoutlibClassLoader.generate(_Original_Build.class, (className, classBytes) -> this.defineClass((String)className, (byte[])classBytes, 0, ((byte[])classBytes).length));
    }

    @NotNull
    private static String toBinaryClassName(@NotNull String name2) {
        return name2.replace('.', '/');
    }

    @NotNull
    private static String toClassName(@NotNull String name2) {
        return name2.replace('/', '.');
    }

    @VisibleForTesting
    static void generate(@NotNull Class<?> originalBuildClass, @NotNull BiConsumer<String, byte[]> defineClass) {
        ClassLoader loader2 = originalBuildClass.getClassLoader();
        String originalBuildClassName = originalBuildClass.getName();
        final String originalBuildBinaryClassName = LayoutlibClassLoader.toBinaryClassName(originalBuildClassName);
        final LinkedList<String> pendingClasses = new LinkedList<String>();
        pendingClasses.push(originalBuildClassName);
        Remapper remapper = new Remapper(){

            @Override
            public String map(String typeName) {
                if (typeName.startsWith(originalBuildBinaryClassName)) {
                    return "android/os/Build" + typeName.substring(originalBuildBinaryClassName.length());
                }
                return typeName;
            }
        };
        while (!pendingClasses.isEmpty()) {
            String name2 = (String)pendingClasses.pop();
            String trimmedName = name2.startsWith(originalBuildClassName) ? name2.substring(originalBuildClassName.length()) : name2;
            String newName = "android.os.Build" + trimmedName;
            final String binaryName = LayoutlibClassLoader.toBinaryClassName(name2);
            try {
                InputStream is = loader2.getResourceAsStream(binaryName + ".class");
                try {
                    ClassWriter writer = new ClassWriter(0);
                    ClassReader reader = new ClassReader(is);
                    ClassRemapper classRemapper = new ClassRemapper(writer, remapper){

                        @Override
                        public void visitInnerClass(String name2, String outerName, String innerName, int access) {
                            if (outerName != null && outerName.startsWith(binaryName)) {
                                pendingClasses.push(LayoutlibClassLoader.toClassName(name2));
                            }
                            super.visitInnerClass(name2, outerName, innerName, access);
                        }
                    };
                    reader.accept(classRemapper, 0);
                    defineClass.accept(newName, writer.toByteArray());
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
            catch (IOException e2) {
                LOG.warn("Unable to define android.os.Build", e2);
            }
        }
    }
}

