/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.api;

import com.android.repository.api.ProgressIndicator;
import com.google.common.annotations.VisibleForTesting;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class DelegatingProgressIndicator
implements ProgressIndicator {
    protected Set<ProgressIndicator> mWrapped = ConcurrentHashMap.newKeySet();

    public DelegatingProgressIndicator(ProgressIndicator wrapped) {
        this.mWrapped.add(wrapped);
    }

    public void addDelegate(ProgressIndicator wrapped) {
        this.mWrapped.add(wrapped);
    }

    @Override
    public void setText(String s2) {
        this.mWrapped.forEach(progress -> progress.setText(s2));
    }

    @Override
    public boolean isCanceled() {
        return this.mWrapped.stream().anyMatch(ProgressIndicator::isCanceled);
    }

    @Override
    public void cancel() {
        this.mWrapped.forEach(ProgressIndicator::cancel);
    }

    @Override
    public void setCancellable(boolean cancellable2) {
        this.mWrapped.forEach(progress -> progress.setCancellable(cancellable2));
    }

    @Override
    public boolean isCancellable() {
        return this.mWrapped.stream().allMatch(ProgressIndicator::isCancellable);
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
        this.mWrapped.forEach(progress -> progress.setIndeterminate(indeterminate));
    }

    @Override
    public boolean isIndeterminate() {
        return this.mWrapped.stream().anyMatch(ProgressIndicator::isIndeterminate);
    }

    @Override
    public void setFraction(double v2) {
        this.mWrapped.forEach(progress -> progress.setFraction(v2));
    }

    @Override
    public double getFraction() {
        return this.mWrapped.iterator().next().getFraction();
    }

    @Override
    public void setSecondaryText(String s2) {
        this.mWrapped.forEach(progress -> progress.setSecondaryText(s2));
    }

    @Override
    public void logWarning(String s2) {
        this.mWrapped.forEach(progress -> progress.logWarning(s2));
    }

    @Override
    public void logWarning(String s2, Throwable e2) {
        this.mWrapped.forEach(progress -> progress.logWarning(s2, e2));
    }

    @Override
    public void logError(String s2) {
        this.mWrapped.forEach(progress -> progress.logError(s2));
    }

    @Override
    public void logError(String s2, Throwable e2) {
        this.mWrapped.forEach(progress -> progress.logError(s2, e2));
    }

    @Override
    public void logInfo(String s2) {
        this.mWrapped.forEach(progress -> progress.logInfo(s2));
    }

    @VisibleForTesting
    public Set<ProgressIndicator> getDelegates() {
        return this.mWrapped;
    }
}

