/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.manager;

import com.android.ProgressManagerAdapter;
import com.android.io.CancellableFileIo;
import com.android.repository.api.FallbackLocalRepoLoader;
import com.android.repository.api.License;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.Repository;
import com.android.repository.impl.manager.LocalRepoLoader;
import com.android.repository.impl.meta.CommonFactory;
import com.android.repository.impl.meta.LocalPackageImpl;
import com.android.repository.impl.meta.SchemaModuleUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import javax.xml.bind.JAXBException;

public final class LocalRepoLoaderImpl
implements LocalRepoLoader {
    public static final String PACKAGE_XML_FN = "package.xml";
    private static final int MAX_SCAN_DEPTH = 10;
    @VisibleForTesting
    static final String KNOWN_PACKAGES_HASH_FN = ".knownPackages";
    private static final ImmutableSet<String> RESOURCE_CACHE_DIRS = ImmutableSet.of("fonts", "icons", "skins");
    private Map<String, LocalPackage> mPackages = null;
    private Set<Path> mPackageRoots = null;
    private final Path mRoot;
    private final RepoManager mRepoManager;
    private final FallbackLocalRepoLoader mFallback;

    public LocalRepoLoaderImpl(Path root, RepoManager manager, FallbackLocalRepoLoader fallback) {
        this.mRoot = root;
        this.mRepoManager = manager;
        this.mFallback = fallback;
    }

    @Override
    public Map<String, LocalPackage> getPackages(ProgressIndicator progress) {
        if (this.mPackages == null) {
            Set<Path> possiblePackageDirs = this.collectPackages();
            this.mPackages = this.parsePackages(possiblePackageDirs, progress);
            if (!this.mPackages.isEmpty()) {
                this.writeHashFile(this.getLocalPackagesHash());
            }
        }
        return Collections.unmodifiableMap(this.mPackages);
    }

    @Override
    public boolean needsUpdate(long lastLocalRefreshMs, boolean deepCheck) {
        boolean needsUpdate = this.checkKnownPackagesUpdateTime(lastLocalRefreshMs);
        if (!needsUpdate && deepCheck) {
            needsUpdate = this.updateKnownPackageHashFileIfNecessary();
        }
        return needsUpdate;
    }

    private Map<String, LocalPackage> parsePackages(Collection<Path> possiblePackageDirs, ProgressIndicator progress) {
        HashMap<String, LocalPackage> result2 = Maps.newHashMap();
        for (Path packageDir : possiblePackageDirs) {
            Path packageXml = packageDir.resolve(PACKAGE_XML_FN);
            RepoPackage p2 = null;
            if (CancellableFileIo.exists(packageXml, new LinkOption[0])) {
                try {
                    p2 = this.parsePackage(packageXml, progress);
                }
                catch (Exception e2) {
                    ProgressManagerAdapter.throwIfCancellation(e2);
                    progress.logWarning("Found corrupted package.xml at " + packageXml);
                }
            }
            if ((p2 == null || p2.getDisplayName().startsWith("Unknown")) && this.mFallback != null) {
                p2 = this.mFallback.parseLegacyLocalPackage(packageDir, progress);
                if (p2 != null) {
                    this.writePackage((LocalPackage)p2, packageXml, progress);
                } else if (CancellableFileIo.exists(packageXml, new LinkOption[0])) {
                    progress.logWarning(String.format("Invalid package.xml found at %1$s and failed to parse using fallback.", packageXml));
                }
            }
            if (p2 == null) continue;
            this.addPackage((LocalPackage)p2, result2, progress);
        }
        return result2;
    }

    private Set<Path> collectPackages() {
        if (this.mPackageRoots == null) {
            TreeSet<Path> dirs = Sets.newTreeSet();
            this.collectPackages(dirs, this.mRoot, 0);
            this.mPackageRoots = dirs;
        }
        return this.mPackageRoots;
    }

    private void collectPackages(Collection<Path> collector2, Path root, int depth) {
        if (depth > 10) {
            return;
        }
        if (root != this.mRoot && CancellableFileIo.isDirectory(root, new LinkOption[0]) && root.getFileName().toString().startsWith(".")) {
            return;
        }
        Path packageXml = root.resolve(PACKAGE_XML_FN);
        if (CancellableFileIo.exists(packageXml, new LinkOption[0]) || this.mFallback != null && this.mFallback.shouldParse(root)) {
            collector2.add(root);
        } else {
            try (Stream<Path> contents = CancellableFileIo.list(root);){
                contents.filter(x$0 -> CancellableFileIo.isDirectory(x$0, new LinkOption[0])).filter(Predicates.in(this.resourceCachePaths()).negate()).forEach(f2 -> this.collectPackages(collector2, (Path)f2, depth + 1));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void addPackage(LocalPackage p2, Map<String, LocalPackage> collector2, ProgressIndicator progress) {
        Path actual;
        String filePath = p2.getPath().replace(';', File.separatorChar);
        Path desired = this.mRoot.resolve(filePath);
        if (!desired.equals(actual = p2.getLocation())) {
            progress.logWarning(String.format("Observed package id '%1$s' in inconsistent location '%2$s' (Expected '%3$s')", p2.getPath(), actual, desired));
            LocalPackage existing = collector2.get(p2.getPath());
            if (existing != null) {
                progress.logWarning(String.format("Already observed package id '%1$s' in '%2$s'. Skipping duplicate at '%3$s'", p2.getPath(), existing.getLocation(), actual));
                return;
            }
        }
        collector2.put(p2.getPath(), p2);
    }

    private void writePackage(LocalPackage p2, Path packageXml, ProgressIndicator progress) {
        LocalPackageImpl impl = LocalPackageImpl.create(p2);
        try (OutputStream fos = Files.newOutputStream(packageXml, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            Repository repo = impl.createFactory().createRepositoryType();
            repo.setLocalPackage(impl);
            License license = impl.getLicense();
            if (license != null) {
                repo.addLicense(license);
            }
            CommonFactory factory = p2.createFactory();
            SchemaModuleUtil.marshal(factory.generateRepository(repo), this.mRepoManager.getSchemaModules(), fos, this.mRepoManager.getResourceResolver(progress), progress);
        }
        catch (IOException e2) {
            progress.logInfo("Exception while marshalling " + packageXml + ". Probably the SDK is read-only");
        }
    }

    private LocalPackage parsePackage(Path packageXml, ProgressIndicator progress) throws JAXBException {
        Repository repo;
        try {
            progress.logVerbose("Parsing " + packageXml);
            try (InputStream stream = CancellableFileIo.newInputStream(packageXml, new OpenOption[0]);){
                repo = (Repository)SchemaModuleUtil.unmarshal(stream, this.mRepoManager.getSchemaModules(), false, progress, packageXml.getFileName().toString());
            }
        }
        catch (IOException e2) {
            progress.logError(String.format("XML file %s doesn't exist", packageXml), e2);
            return null;
        }
        if (repo == null) {
            progress.logWarning(String.format("Failed to parse %s", packageXml));
            return null;
        }
        LocalPackage p2 = repo.getLocalPackage();
        if (p2 == null) {
            progress.logWarning("Didn't find any local package in repository");
            return null;
        }
        p2.setInstalledPath(packageXml.getParent());
        return p2;
    }

    private Path getKnownPackagesHashFile(boolean create2) {
        Path f2 = this.mRoot.resolve(KNOWN_PACKAGES_HASH_FN);
        if (CancellableFileIo.notExists(f2, new LinkOption[0])) {
            if (create2) {
                try {
                    Files.createDirectories(f2.getParent(), new FileAttribute[0]);
                    Files.createFile(f2, new FileAttribute[0]);
                }
                catch (IOException e2) {
                    return null;
                }
            } else {
                return null;
            }
        }
        return f2;
    }

    private boolean updateKnownPackageHashFileIfNecessary() {
        Path knownPackagesHashFile = this.getKnownPackagesHashFile(false);
        if (knownPackagesHashFile != null) {
            byte[] localPackagesHash;
            byte[] buf = null;
            if (this.getLatestPackageUpdateTime() <= this.getLastModifiedTime(knownPackagesHashFile)) {
                try {
                    buf = CancellableFileIo.readAllBytes(knownPackagesHashFile);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!Arrays.equals(buf, localPackagesHash = this.getLocalPackagesHash())) {
                this.writeHashFile(localPackagesHash);
                return true;
            }
        } else {
            this.writeHashFile(this.getLocalPackagesHash());
            return true;
        }
        return false;
    }

    private long getLastModifiedTime(Path file2) {
        long knownPackagesModificationTime;
        try {
            knownPackagesModificationTime = CancellableFileIo.getLastModifiedTime(file2, new LinkOption[0]).toMillis();
        }
        catch (IOException e2) {
            knownPackagesModificationTime = 0L;
        }
        return knownPackagesModificationTime;
    }

    private void writeHashFile(byte[] buf) {
        Path knownPackagesHashFile = this.getKnownPackagesHashFile(true);
        if (knownPackagesHashFile != null) {
            try {
                Files.write(knownPackagesHashFile, buf, new OpenOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean checkKnownPackagesUpdateTime(long lastUpdate) {
        Path knownPackagesHashFile = this.getKnownPackagesHashFile(false);
        return knownPackagesHashFile == null || this.getLastModifiedTime(knownPackagesHashFile) > lastUpdate;
    }

    private byte[] getLocalPackagesHash() {
        Set<Path> dirs = this.collectPackages();
        Hasher digester = Hashing.md5().newHasher();
        for (Path f2 : dirs) {
            digester.putBytes(f2.toAbsolutePath().toString().getBytes(StandardCharsets.UTF_8));
        }
        return digester.hash().asBytes();
    }

    private long getLatestPackageUpdateTime() {
        long latest = 0L;
        for (Path f2 : this.collectPackages()) {
            long t2 = this.getLastModifiedTime(f2.resolve(PACKAGE_XML_FN));
            latest = Math.max(t2, latest);
        }
        return latest;
    }

    private ImmutableSet<Path> resourceCachePaths() {
        return RESOURCE_CACHE_DIRS.stream().map(this.mRoot::resolve).collect(ImmutableSet.toImmutableSet());
    }
}

