/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.meta;

import com.android.repository.Revision;
import com.android.repository.api.Checksum;
import com.android.repository.impl.meta.CommonFactory;
import com.android.repository.impl.meta.RevisionType;
import com.android.tools.analytics.CommonMetricsData;
import com.google.common.collect.ImmutableList;
import com.google.wireless.android.sdk.stats.ProductDetails;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlTransient;

@XmlTransient
public abstract class Archive {
    public static HostConfig sHostConfig = new HostConfig();

    public boolean isCompatible() {
        if (this.getHostOs() != null && !this.getHostOs().equals(Archive.sHostConfig.mOs)) {
            return false;
        }
        if (this.getJvmBits() != null && this.getJvmBits() != Archive.sHostConfig.mJvmBits) {
            return false;
        }
        if (this.getHostArch() != null && !this.getHostArch().equals(Archive.sHostConfig.mHostArch)) {
            return false;
        }
        return this.getMinJvmVersion() == null || this.getMinJvmVersion().toRevision().compareTo(Archive.sHostConfig.mJvmVersion) <= 0;
    }

    public abstract CompleteType getComplete();

    public void setComplete(CompleteType complete) {
    }

    protected Integer getHostBits() {
        return null;
    }

    public String getHostArch() {
        Integer bits = this.getHostBits();
        if (bits == null) {
            return null;
        }
        return bits == 32 ? "x86" : "x64";
    }

    public void setHostBits(Integer bits) {
    }

    public Integer getJvmBits() {
        return null;
    }

    public void setJvmBits(Integer bits) {
    }

    public String getHostOs() {
        return null;
    }

    public void setHostOs(String os) {
    }

    public RevisionType getMinJvmVersion() {
        return null;
    }

    public void setMinJvmVersion(RevisionType revision) {
    }

    public abstract CommonFactory createFactory();

    @XmlTransient
    public static final class HostConfig {
        private static final String OS_OVERRIDE_ENV_VAR = "REPO_OS_OVERRIDE";
        private final int mJvmBits;
        private final String mHostArch;
        private final String mOs;
        private final Revision mJvmVersion;

        public HostConfig() {
            this(HostConfig.detectOs());
        }

        public HostConfig(String os) {
            this.mOs = os;
            this.mJvmBits = HostConfig.detectJvmBits();
            this.mHostArch = HostConfig.detectHostArch();
            this.mJvmVersion = HostConfig.detectJvmRevision();
        }

        private static String detectOs() {
            String os = System.getenv(OS_OVERRIDE_ENV_VAR);
            if (os == null) {
                os = System.getProperty("os.name");
            }
            if (os.startsWith("Mac")) {
                os = "macosx";
            } else if (os.startsWith("Windows")) {
                os = "windows";
            } else if (os.startsWith("Linux")) {
                os = "linux";
            }
            return os;
        }

        private static int detectJvmBits() {
            ProductDetails.CpuArchitecture arch = CommonMetricsData.getJvmArchitecture();
            if (arch == ProductDetails.CpuArchitecture.X86) {
                return 32;
            }
            return 64;
        }

        private static String detectHostArch() {
            ProductDetails.CpuArchitecture arch = CommonMetricsData.getOsArchitecture();
            switch (arch) {
                case X86: {
                    return "x86";
                }
                case X86_64: {
                    return "x64";
                }
                case ARM: 
                case X86_ON_ARM: {
                    return "aarch64";
                }
            }
            return null;
        }

        private static Revision detectJvmRevision() {
            Revision minJvmVersion = null;
            String javav = System.getProperty("java.version");
            Pattern p2 = Pattern.compile("((\\d+)(\\.\\d+)?(\\.\\d+)?).*");
            Matcher m4 = p2.matcher(javav);
            if (m4.matches()) {
                minJvmVersion = Revision.parseRevision(m4.group(1));
            }
            return minJvmVersion;
        }
    }

    @Deprecated
    @XmlTransient
    public static abstract class PatchesType {
        @Deprecated
        public List<PatchType> getPatch() {
            return ImmutableList.of();
        }
    }

    @Deprecated
    @XmlTransient
    public static abstract class PatchType
    extends ArchiveFile {
        @Deprecated
        public abstract RevisionType getBasedOn();

        @Deprecated
        public void setBasedOn(RevisionType revision) {
        }
    }

    @XmlTransient
    public static abstract class CompleteType
    extends ArchiveFile {
    }

    public static abstract class ArchiveFile {
        public Checksum getTypedChecksum() {
            return Checksum.create(this.getLegacyChecksum(), "sha-1");
        }

        public void setTypedChecksum(Checksum checksum) {
            this.setLegacyChecksum(checksum.getValue());
        }

        protected String getLegacyChecksum() {
            throw new UnsupportedOperationException();
        }

        protected void setLegacyChecksum(String checksum) {
        }

        public abstract String getUrl();

        public void setUrl(String url) {
        }

        public abstract long getSize();

        public void setSize(long size) {
        }
    }
}

