/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.meta;

import com.android.repository.Revision;
import com.android.repository.api.Channel;
import com.android.repository.api.Checksum;
import com.android.repository.api.Dependency;
import com.android.repository.api.License;
import com.android.repository.api.Repository;
import com.android.repository.impl.meta.Archive;
import com.android.repository.impl.meta.LocalPackageImpl;
import com.android.repository.impl.meta.RemotePackageImpl;
import com.android.repository.impl.meta.RepoPackageImpl;
import com.android.repository.impl.meta.RevisionType;
import javax.xml.bind.JAXBElement;

public abstract class CommonFactory {
    public abstract Repository createRepositoryType();

    public abstract Archive createArchiveType();

    protected abstract RepoPackageImpl.Archives createArchivesType();

    public abstract LocalPackageImpl createLocalPackage();

    public abstract RemotePackageImpl createRemotePackage();

    protected abstract RevisionType createRevisionType();

    public abstract Channel createChannelType();

    public Checksum createChecksum(String checksum, String type) {
        Checksum result2 = this.createChecksumType();
        result2.setValue(checksum);
        result2.setType(type);
        return result2;
    }

    protected Checksum createChecksumType() {
        throw new UnsupportedOperationException();
    }

    public abstract JAXBElement<Repository> generateRepository(Repository var1);

    public Channel createChannelType(int id2) {
        Channel res = this.createChannelType();
        res.setId("channel-" + id2);
        return res;
    }

    public RevisionType createRevisionType(Revision revision) {
        RevisionType rt = this.createRevisionType();
        int[] components = revision.toIntArray(true);
        rt.setMajor(components[0]);
        if (components.length > 1) {
            rt.setMinor(components[1]);
        }
        if (components.length > 2) {
            rt.setMicro(components[2]);
        }
        if (components.length > 3) {
            rt.setPreview(components[3]);
        }
        return rt;
    }

    public abstract RepoPackageImpl.UsesLicense createLicenseRefType();

    public License createLicenseType(String value, String id2) {
        License l2 = this.createLicenseType();
        l2.setValue(value);
        l2.setId(id2);
        l2.setType("text");
        return l2;
    }

    public abstract License createLicenseType();

    public abstract Dependency createDependencyType();

    public Dependency createDependencyType(Revision minRevision, String path) {
        Dependency d2 = this.createDependencyType();
        if (minRevision != null) {
            d2.setMinRevision(this.createRevisionType(minRevision));
        }
        d2.setPath(path);
        return d2;
    }

    public abstract RepoPackageImpl.Dependencies createDependenciesType();

    public abstract Archive.CompleteType createCompleteType();

    public abstract RemotePackageImpl.ChannelRef createChannelRefType();
}

