/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.meta;

import com.android.repository.api.Dependency;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.Repository;
import com.android.repository.impl.meta.CommonFactory;
import com.android.repository.impl.meta.RepoPackageImpl;
import java.nio.file.Path;
import javax.xml.bind.annotation.XmlTransient;

@XmlTransient
public abstract class LocalPackageImpl
extends RepoPackageImpl
implements LocalPackage {
    @XmlTransient
    private Path mInstalledPath;

    @Override
    public Path getLocation() {
        return this.mInstalledPath;
    }

    @Override
    public void setInstalledPath(Path path) {
        this.mInstalledPath = path;
    }

    public static LocalPackageImpl create(RepoPackage repoPackage) {
        if (repoPackage instanceof LocalPackageImpl) {
            return (LocalPackageImpl)repoPackage;
        }
        CommonFactory factory = repoPackage.createFactory();
        LocalPackageImpl result2 = factory.createLocalPackage();
        result2.setVersion(repoPackage.getVersion());
        result2.setLicense(repoPackage.getLicense());
        result2.setPath(repoPackage.getPath());
        for (Dependency d2 : repoPackage.getAllDependencies()) {
            Dependency newDep = factory.createDependencyType();
            newDep.setPath(d2.getPath());
            newDep.setMinRevision(d2.getMinRevision());
            result2.addDependency(newDep);
        }
        result2.setObsolete(repoPackage.obsolete());
        result2.setTypeDetails(repoPackage.getTypeDetails());
        result2.setDisplayName(repoPackage.getDisplayName());
        return result2;
    }

    @Override
    public RepoPackageImpl asMarshallable() {
        return this;
    }

    @Override
    public void addTo(Repository repo) {
        repo.setLocalPackage(this);
    }
}

