/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.meta;

import com.android.repository.api.LocalPackage;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.util.RepoPackageUtilKt;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlTransient;

@XmlTransient
public final class RepositoryPackages {
    private Set<UpdatablePackage> mUpdatedPkgs = Sets.newTreeSet();
    private Set<RemotePackage> mNewPkgs = Sets.newTreeSet();
    private final long myTimestampMs;
    private Multimap<String, LocalPackage> mLocalPackagesByPrefix = TreeMultimap.create();
    private Multimap<String, RemotePackage> mRemotePackagesByPrefix = TreeMultimap.create();
    private Map<String, UpdatablePackage> mConsolidatedPkgs = Maps.newTreeMap();
    private Map<String, LocalPackage> mLocalPackages = Maps.newHashMap();
    private Map<String, RemotePackage> mRemotePackages = Maps.newTreeMap();
    private final Object mLock = new Object();

    public RepositoryPackages() {
        this.myTimestampMs = System.currentTimeMillis();
    }

    public RepositoryPackages(List<LocalPackage> localPkgs, List<RemotePackage> remotePkgs) {
        this();
        this.setLocalPkgInfos(localPkgs);
        this.setRemotePkgInfos(remotePkgs);
    }

    public long getTimestampMs() {
        return this.myTimestampMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<UpdatablePackage> getUpdatedPkgs() {
        Set<UpdatablePackage> result2 = this.mUpdatedPkgs;
        if (result2 == null) {
            Object object = this.mLock;
            synchronized (object) {
                this.computeUpdates();
                result2 = this.mUpdatedPkgs;
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<RemotePackage> getNewPkgs() {
        Set<RemotePackage> result2 = this.mNewPkgs;
        if (result2 == null) {
            Object object = this.mLock;
            synchronized (object) {
                this.computeUpdates();
                result2 = this.mNewPkgs;
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, UpdatablePackage> getConsolidatedPkgs() {
        Map<String, UpdatablePackage> result2 = this.mConsolidatedPkgs;
        if (result2 == null) {
            Object object = this.mLock;
            synchronized (object) {
                this.computeUpdates();
                result2 = this.mConsolidatedPkgs;
            }
        }
        return result2;
    }

    public Map<String, LocalPackage> getLocalPackages() {
        return this.mLocalPackages;
    }

    public Map<String, RemotePackage> getRemotePackages() {
        return this.mRemotePackages;
    }

    public Collection<LocalPackage> getLocalPackagesForPrefix(String pathPrefix) {
        return this.mLocalPackagesByPrefix.get(pathPrefix);
    }

    public Collection<RemotePackage> getRemotePackagesForPrefix(String pathPrefix) {
        return this.mRemotePackagesByPrefix.get(pathPrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocalPkgInfos(Collection<LocalPackage> packages) {
        Object object = this.mLock;
        synchronized (object) {
            this.mLocalPackages = RepositoryPackages.mapByPath(packages);
            this.invalidate();
            this.mLocalPackagesByPrefix = RepositoryPackages.computePackagePrefixes(this.mLocalPackages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRemotePkgInfos(Collection<RemotePackage> packages) {
        Object object = this.mLock;
        synchronized (object) {
            this.mRemotePackages = RepositoryPackages.mapByPath(packages);
            this.invalidate();
            this.mRemotePackagesByPrefix = RepositoryPackages.computePackagePrefixes(this.mRemotePackages);
        }
    }

    private static <T extends RepoPackage> Map<String, T> mapByPath(Collection<T> packages) {
        return ImmutableMap.copyOf(packages.stream().collect(Collectors.toMap(RepoPackage::getPath, Function.identity())));
    }

    private void invalidate() {
        this.mConsolidatedPkgs = null;
        this.mNewPkgs = null;
        this.mUpdatedPkgs = null;
    }

    private void computeUpdates() {
        TreeMap<String, UpdatablePackage> newConsolidatedPkgs = Maps.newTreeMap();
        HashSet<UpdatablePackage> updates = Sets.newHashSet();
        for (String path : this.mLocalPackages.keySet()) {
            LocalPackage local = this.mLocalPackages.get(path);
            UpdatablePackage updatable = new UpdatablePackage(local);
            newConsolidatedPkgs.put(path, updatable);
            if (!this.mRemotePackages.containsKey(path)) continue;
            updatable.setRemote(this.mRemotePackages.get(path));
            if (!updatable.isUpdate()) continue;
            updates.add(updatable);
        }
        HashSet<RemotePackage> news = Sets.newHashSet();
        for (String path : this.mRemotePackages.keySet()) {
            if (newConsolidatedPkgs.containsKey(path)) continue;
            RemotePackage remote = this.mRemotePackages.get(path);
            news.add(remote);
            UpdatablePackage updatable = new UpdatablePackage(remote);
            newConsolidatedPkgs.put(path, updatable);
        }
        this.mNewPkgs = news;
        this.mUpdatedPkgs = updates;
        this.mConsolidatedPkgs = newConsolidatedPkgs;
    }

    private static <P extends RepoPackage> Multimap<String, P> computePackagePrefixes(Map<String, ? extends P> packages) {
        TreeMultimap<String, RepoPackage> packagesByPrefix = TreeMultimap.create();
        for (Map.Entry<String, P> entry : packages.entrySet()) {
            String path = entry.getKey();
            RepoPackage p2 = (RepoPackage)entry.getValue();
            List<String> prefixes = RepoPackageUtilKt.getAllRepoPackagePrefixes(path);
            for (String prefix : prefixes) {
                packagesByPrefix.put(prefix, p2);
            }
        }
        return packagesByPrefix;
    }
}

