/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.meta;

import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.SchemaModule;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class SchemaModuleUtil {
    private static final Map<String, JAXBContext> CONTEXT_CACHE = Maps.newHashMap();
    private static final Map<List<SchemaModule.SchemaModuleVersion<?>>, Map<LSResourceResolver, Schema>> SCHEMA_CACHE = Maps.newHashMap();

    public static LSResourceResolver createResourceResolver(Set<SchemaModule<?>> modules, ProgressIndicator progress) {
        return new SchemaModuleResourceResolver(modules, progress);
    }

    private static JAXBContext getContext(Collection<SchemaModule<?>> possibleModules) {
        JAXBContext jc;
        block5: {
            ArrayList<String> packages = Lists.newArrayList();
            for (SchemaModule<?> module : possibleModules) {
                for (SchemaModule.SchemaModuleVersion<?> version : module.getNamespaceVersionMap().values()) {
                    packages.add(version.getObjectFactory().getPackage().getName());
                }
            }
            String key = Joiner.on(":").join(packages);
            jc = CONTEXT_CACHE.get(key);
            if (jc == null) {
                try {
                    jc = JAXBContext.newInstance(key, SchemaModuleUtil.class.getClassLoader());
                    CONTEXT_CACHE.put(key, jc);
                }
                catch (JAXBException e1) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError((Object)("Failed to create context!\n" + e1.toString()));
                }
            }
        }
        return jc;
    }

    @VisibleForTesting
    public static Schema getSchema(Collection<SchemaModule<?>> possibleModules, LSResourceResolver resourceResolver, final ProgressIndicator progress) {
        Schema schema;
        block7: {
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            if (resourceResolver != null) {
                sf.setResourceResolver(resourceResolver);
            }
            sf.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    progress.logWarning("Warning while creating schema:", exception);
                    throw exception;
                }

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    progress.logWarning("Error creating schema:", exception);
                    throw exception;
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    progress.logWarning("Fatal error creating schema:", exception);
                    throw exception;
                }
            });
            ArrayList<StreamSource> sources = Lists.newArrayList();
            ArrayList<SchemaModule.SchemaModuleVersion<?>> key = Lists.newArrayList();
            for (SchemaModule<?> module : possibleModules) {
                for (SchemaModule.SchemaModuleVersion<?> version : module.getNamespaceVersionMap().values()) {
                    key.add(version);
                    sources.add(new StreamSource(version.getXsd()));
                }
            }
            Map<LSResourceResolver, Schema> resolverSchemaCache = SCHEMA_CACHE.get(key);
            if (resolverSchemaCache == null) {
                resolverSchemaCache = Maps.newHashMap();
                SCHEMA_CACHE.put(key, resolverSchemaCache);
            }
            if ((schema = resolverSchemaCache.get(resourceResolver)) == null) {
                try {
                    schema = sf.newSchema(sources.toArray(new StreamSource[0]));
                    resolverSchemaCache.put(resourceResolver, schema);
                }
                catch (SAXException e2) {
                    if ($assertionsDisabled) break block7;
                    throw new AssertionError((Object)"Invalid schema found!");
                }
            }
        }
        return schema;
    }

    public static Object unmarshal(InputStream xml, Collection<SchemaModule<?>> possibleModules, boolean strict, ProgressIndicator progress, String fileDescription) throws JAXBException {
        Unmarshaller u2 = SchemaModuleUtil.setupUnmarshaller(xml, possibleModules, strict, progress, fileDescription);
        SAXSource source = SchemaModuleUtil.setupSource(xml, possibleModules, strict, progress);
        return ((JAXBElement)u2.unmarshal(source)).getValue();
    }

    private static Unmarshaller setupUnmarshaller(InputStream xml, Collection<SchemaModule<?>> possibleModules, boolean strict, ProgressIndicator progress, String fileDescription) throws JAXBException {
        JAXBContext context2 = SchemaModuleUtil.getContext(possibleModules);
        Unmarshaller u2 = context2.createUnmarshaller();
        u2.setEventHandler(SchemaModuleUtil.createValidationEventHandler(progress, strict, fileDescription));
        return u2;
    }

    private static SAXSource setupSource(InputStream xml, Collection<SchemaModule<?>> possibleModules, boolean strict, ProgressIndicator progress) throws JAXBException {
        XMLReader xr;
        SAXSource source = new SAXSource(new InputSource(xml));
        NamespaceFallbackFilter filter2 = new NamespaceFallbackFilter(possibleModules, strict, progress);
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        try {
            SAXParser sp = spf.newSAXParser();
            xr = sp.getXMLReader();
            xr.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (ParserConfigurationException | SAXException e2) {
            progress.logError("Error setting up parser", e2);
            throw new JAXBException(e2);
        }
        filter2.setParent(xr);
        source.setXMLReader(filter2);
        return source;
    }

    public static void marshal(JAXBElement element, Collection<SchemaModule<?>> possibleModules, OutputStream out, LSResourceResolver resourceResolver, ProgressIndicator progress) {
        JAXBContext context2 = SchemaModuleUtil.getContext(possibleModules);
        try {
            Marshaller marshaller = context2.createMarshaller();
            marshaller.setEventHandler(SchemaModuleUtil.createValidationEventHandler(progress, true, "N/A"));
            Schema schema = SchemaModuleUtil.getSchema(possibleModules, resourceResolver, progress);
            marshaller.setSchema(schema);
            marshaller.marshal((Object)element, out);
            out.close();
        }
        catch (IOException | JAXBException e2) {
            progress.logWarning("Error during marshal", e2);
        }
    }

    private static ValidationEventHandler createValidationEventHandler(ProgressIndicator progress, boolean strict, String fileDescription) {
        return event -> {
            String prefix = fileDescription + " parsing problem. ";
            if (event.getLinkedException() != null) {
                progress.logWarning(prefix + event.getMessage(), event.getLinkedException());
            } else {
                progress.logWarning(prefix + event.getMessage());
            }
            return !strict;
        };
    }

    private static class SchemaModuleResourceResolver
    implements LSResourceResolver {
        private final Set<SchemaModule<?>> mModules;
        private static DOMImplementationLS sLs;

        public SchemaModuleResourceResolver(Set<SchemaModule<?>> modules, ProgressIndicator progress) {
            this.mModules = modules;
            SchemaModuleResourceResolver.initLs(progress);
        }

        private static void initLs(ProgressIndicator progress) {
            if (sLs == null) {
                try {
                    DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
                    sLs = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
                }
                catch (Exception e2) {
                    progress.logError("Error during resolver creation: ", e2);
                }
            }
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            for (SchemaModule<?> ext : this.mModules) {
                SchemaModule.SchemaModuleVersion<?> version = ext.getNamespaceVersionMap().get(namespaceURI);
                if (version == null) continue;
                LSInput input2 = sLs.createLSInput();
                input2.setSystemId(version.getNamespace());
                input2.setByteStream(version.getXsd());
                return input2;
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SchemaModuleResourceResolver)) {
                return false;
            }
            SchemaModuleResourceResolver other = (SchemaModuleResourceResolver)obj;
            return other.mModules.equals(this.mModules);
        }

        public int hashCode() {
            return this.mModules.hashCode();
        }
    }

    private static class NamespaceFallbackFilter
    extends XMLFilterImpl {
        private Map<String, SchemaModule<?>> mPrefixMap = Maps.newHashMap();
        private ProgressIndicator mProgress;
        private boolean mStrict;
        private Map<String, String> mNewToOldMap = Maps.newHashMap();
        private static boolean mDidShowWarning = false;

        public NamespaceFallbackFilter(Collection<SchemaModule<?>> possibleModules, boolean strict, ProgressIndicator progress) {
            for (SchemaModule<?> module : possibleModules) {
                this.mPrefixMap.put(module.getNamespacePrefix(), module);
            }
            this.mProgress = progress;
            this.mStrict = strict;
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            int lastSlash;
            if (uri != null && (lastSlash = uri.lastIndexOf(47) + 1) > 0) {
                String namespacePrefix = uri.substring(0, lastSlash);
                try {
                    int version = Integer.parseInt(uri.substring(lastSlash));
                    SchemaModule<?> module = this.mPrefixMap.get(namespacePrefix);
                    if (module != null && module.getNamespaceVersionMap().size() < version) {
                        String oldUri = module.getLatestNamespace().intern();
                        if (!mDidShowWarning) {
                            mDidShowWarning = true;
                            this.mProgress.logWarning("This version only understands SDK XML versions up to " + module.getNamespaceVersionMap().size() + " but an SDK XML file of version " + version + " was encountered. This can happen if you use versions of Android Studio and the command-line tools that were released at different times.");
                        }
                        this.mNewToOldMap.put(uri, oldUri);
                        uri = oldUri;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            super.startPrefixMapping(prefix, uri);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            AttributesImpl newAtts = new AttributesImpl(atts);
            if (!this.mStrict && uri != null && this.mNewToOldMap.containsKey(uri)) {
                uri = this.mNewToOldMap.get(uri);
            }
            super.startElement(uri, localName, qName, newAtts);
        }
    }
}

