/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.io;

import com.android.io.CancellableFileIo;
import com.android.repository.api.ProgressIndicator;
import com.android.utils.PathUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public final class FileOpUtils {
    private static final boolean IS_WINDOWS = System.getProperty("os.name").startsWith("Windows");

    public static void recursiveCopy(Path src, Path dest, boolean merge, Predicate<Path> fileFilter, ProgressIndicator progress) throws IOException {
        if (CancellableFileIo.exists(dest, new LinkOption[0])) {
            if (!merge) {
                throw new IOException(dest + " already exists!");
            }
            if (CancellableFileIo.isDirectory(src, new LinkOption[0]) != CancellableFileIo.isDirectory(dest, new LinkOption[0])) {
                throw new IOException(String.format("%s already exists but %s a directory!", dest, CancellableFileIo.isDirectory(dest, new LinkOption[0]) ? "is" : "is not"));
            }
        }
        if (progress.isCanceled()) {
            throw new IOException("Operation cancelled");
        }
        if (fileFilter != null && !fileFilter.test(src)) {
            return;
        }
        if (CancellableFileIo.isDirectory(src, new LinkOption[0])) {
            Files.createDirectories(dest, new FileAttribute[0]);
            for (Path child : FileOpUtils.listFiles(src)) {
                Path newDest = dest.resolve(child.getFileName());
                FileOpUtils.recursiveCopy(child, newDest, merge, fileFilter, progress);
            }
        } else if (CancellableFileIo.isRegularFile(src, new LinkOption[0]) && !CancellableFileIo.exists(dest, new LinkOption[0])) {
            Files.copy(src, dest, new CopyOption[0]);
            if (!FileOpUtils.isWindows() && CancellableFileIo.isExecutable(src)) {
                FileOpUtils.setExecutablePermission(dest);
            }
        }
    }

    public static Path[] listFiles(Path file2) {
        Path[] pathArray;
        block8: {
            Stream<Path> children2 = CancellableFileIo.list(file2);
            try {
                pathArray = (Path[])children2.toArray(Path[]::new);
                if (children2 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (children2 != null) {
                        try {
                            children2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    return new Path[0];
                }
            }
            children2.close();
        }
        return pathArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void safeRecursiveOverwrite(Path src, Path dest, ProgressIndicator progress) throws IOException {
        Path destBackup;
        block26: {
            block27: {
                boolean success;
                block25: {
                    destBackup = FileOpUtils.getTempDir(dest, "backup");
                    success = false;
                    try {
                        if (!CancellableFileIo.exists(dest, new LinkOption[0])) break block25;
                        FileOpUtils.moveOrCopyAndDelete(dest, destBackup, progress);
                        if (CancellableFileIo.exists(dest, new LinkOption[0])) {
                            throw new IOException(String.format("Failed to move away or delete existing target file: %s%nMove it away manually and try again.", dest));
                        }
                        success = true;
                    }
                    catch (Throwable throwable) {
                        if (!success && CancellableFileIo.exists(destBackup, new LinkOption[0])) {
                            try {
                                FileOpUtils.recursiveCopy(destBackup, dest, true, null, progress);
                                PathUtils.deleteRecursivelyIfExists(destBackup);
                            }
                            catch (IOException e2) {
                                progress.logWarning(String.format("Failed to move original content of %s back into place! It should be available at %s", dest, destBackup), e2);
                            }
                        }
                        throw throwable;
                    }
                }
                if (!success && CancellableFileIo.exists(destBackup, new LinkOption[0])) {
                    try {
                        FileOpUtils.recursiveCopy(destBackup, dest, true, null, progress);
                        PathUtils.deleteRecursivelyIfExists(destBackup);
                    }
                    catch (IOException e3) {
                        progress.logWarning(String.format("Failed to move original content of %s back into place! It should be available at %s", dest, destBackup), e3);
                    }
                }
                success = false;
                try {
                    FileOpUtils.moveOrCopyAndDelete(src, dest, progress);
                    success = true;
                    if (success) break block26;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        block28: {
                            try {
                                PathUtils.deleteRecursivelyIfExists(dest);
                            }
                            catch (IOException exception) {
                                if (!CancellableFileIo.exists(dest, new LinkOption[0])) break block28;
                                Path toDelete = FileOpUtils.getTempDir(dest, "delete");
                                Files.move(dest, toDelete, new CopyOption[0]);
                                PathUtils.addRemovePathHook(toDelete);
                            }
                        }
                        try {
                            if (CancellableFileIo.exists(dest, new LinkOption[0])) {
                                FileOpUtils.recursiveCopy(destBackup, dest, true, null, progress);
                            } else {
                                FileOpUtils.moveOrCopyAndDelete(destBackup, dest, progress);
                            }
                        }
                        catch (IOException e4) {
                            progress.logWarning(String.format("Failed to move original content of %s back into place! It should be available at %s", dest, destBackup), e4);
                        }
                    }
                    throw throwable;
                }
                try {
                    PathUtils.deleteRecursivelyIfExists(dest);
                }
                catch (IOException exception) {
                    if (!CancellableFileIo.exists(dest, new LinkOption[0])) break block27;
                    Path toDelete = FileOpUtils.getTempDir(dest, "delete");
                    Files.move(dest, toDelete, new CopyOption[0]);
                    PathUtils.addRemovePathHook(toDelete);
                }
            }
            try {
                if (CancellableFileIo.exists(dest, new LinkOption[0])) {
                    FileOpUtils.recursiveCopy(destBackup, dest, true, null, progress);
                    break block26;
                }
                FileOpUtils.moveOrCopyAndDelete(destBackup, dest, progress);
            }
            catch (IOException e5) {
                progress.logWarning(String.format("Failed to move original content of %s back into place! It should be available at %s", dest, destBackup), e5);
            }
        }
        try {
            PathUtils.deleteRecursivelyIfExists(destBackup);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void moveOrCopyAndDelete(Path src, Path dest, ProgressIndicator progress) throws IOException {
        try {
            Files.move(src, dest, new CopyOption[0]);
        }
        catch (IOException ignore) {
            FileOpUtils.recursiveCopy(src, dest, true, null, progress);
            PathUtils.deleteRecursivelyIfExists(src);
        }
    }

    private static Path getTempDir(Path orig, String suffix) {
        Path result2 = orig.getFileSystem().getPath(orig + "." + suffix, new String[0]);
        int i2 = 1;
        while (CancellableFileIo.exists(result2, new LinkOption[0])) {
            try {
                PathUtils.deleteRecursivelyIfExists(result2);
                break;
            }
            catch (IOException iOException) {
                result2 = orig.getFileSystem().getPath(result2 + "-" + i2++, new String[0]);
            }
        }
        return result2;
    }

    public static Path getNewTempDir(String base, FileSystem fileSystem) {
        for (int i2 = 1; i2 < 100; ++i2) {
            Path rootTempDir = fileSystem.getPath(System.getProperty("java.io.tmpdir"), new String[0]);
            Path folder = rootTempDir.resolve(String.format(Locale.US, "%1$s%2$02d", base, i2));
            if (!CancellableFileIo.notExists(folder, new LinkOption[0])) continue;
            try {
                Files.createDirectories(folder, new FileAttribute[0]);
                return folder;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static File append(File base, String ... segments) {
        for (String segment : segments) {
            base = new File(base, segment);
        }
        return base;
    }

    public static String makeRelative(File baseDir, File toBeRelative) throws IOException {
        return FileOpUtils.makeRelativeImpl(baseDir.getCanonicalPath(), toBeRelative.getCanonicalPath(), File.separator);
    }

    @VisibleForTesting
    static String makeRelativeImpl(String path1, String path2, String dirSeparator) throws IOException {
        int start;
        if (FileOpUtils.isWindows()) {
            char drive2;
            char drive1 = path1.length() >= 2 && path1.charAt(1) == ':' ? path1.charAt(0) : (char)'\u0000';
            char c2 = drive2 = path2.length() >= 2 && path2.charAt(1) == ':' ? path2.charAt(0) : (char)'\u0000';
            if (drive1 != drive2) {
                throw new IOException("makeRelative: incompatible drive letters");
            }
        }
        String[] segments1 = path1.split(Pattern.quote(dirSeparator));
        String[] segments2 = path2.split(Pattern.quote(dirSeparator));
        int len1 = segments1.length;
        int len2 = segments2.length;
        int len = Math.min(len1, len2);
        for (start = 0; start < len && (!FileOpUtils.isWindows() || segments1[start].equalsIgnoreCase(segments2[start])) && (FileOpUtils.isWindows() || segments1[start].equals(segments2[start])); ++start) {
        }
        StringBuilder result2 = new StringBuilder();
        for (int i2 = start; i2 < len1; ++i2) {
            result2.append("..").append(dirSeparator);
        }
        while (start < len2) {
            result2.append(segments2[start]);
            if (++start >= len2) continue;
            result2.append(dirSeparator);
        }
        return result2.toString();
    }

    private FileOpUtils() {
    }

    public static boolean isWindows() {
        return IS_WINDOWS;
    }

    public static void setExecutablePermission(Path path) throws IOException {
        EnumSet<PosixFilePermission> permissions = EnumSet.copyOf(Files.getPosixFilePermissions(path, new LinkOption[0]));
        permissions.add(PosixFilePermission.OWNER_EXECUTE);
        permissions.add(PosixFilePermission.GROUP_EXECUTE);
        permissions.add(PosixFilePermission.OTHERS_EXECUTE);
        Files.setPosixFilePermissions(path, permissions);
    }

    public static File toFile(Path path) {
        if (path.getFileSystem() == FileSystems.getDefault()) {
            return path.toFile();
        }
        return new File(path.toString());
    }
}

