/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources;

import com.android.resources.ResourceEnum;

public enum HighDynamicRange implements ResourceEnum
{
    HIGHDR("highdr", "High Dynamic Range", "High Dynamic Range"),
    LOWDR("lowdr", "Low Dynamic Range", "Low Dynamic Range");

    private final String mValue;
    private final String mShortDisplayValue;
    private final String mLongDisplayValue;

    private HighDynamicRange(String value, String displayValue, String longDisplayValue) {
        this.mValue = value;
        this.mShortDisplayValue = displayValue;
        this.mLongDisplayValue = longDisplayValue;
    }

    public static HighDynamicRange getEnum(String value) {
        for (HighDynamicRange orient : HighDynamicRange.values()) {
            if (!orient.mValue.equals(value)) continue;
            return orient;
        }
        return null;
    }

    @Override
    public String getResourceValue() {
        return this.mValue;
    }

    @Override
    public String getShortDisplayValue() {
        return this.mShortDisplayValue;
    }

    @Override
    public String getLongDisplayValue() {
        return this.mLongDisplayValue;
    }

    public static int getIndex(HighDynamicRange value) {
        return value == null ? -1 : value.ordinal();
    }

    public static HighDynamicRange getByIndex(int index2) {
        HighDynamicRange[] values2 = HighDynamicRange.values();
        if (index2 >= 0 && index2 < values2.length) {
            return values2[index2];
        }
        return null;
    }

    @Override
    public boolean isFakeValue() {
        return false;
    }

    @Override
    public boolean isValidValueForDevice() {
        return true;
    }
}

