/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceType;
import java.io.Serializable;
import java.util.Objects;

public class ResourceUrl
implements Serializable {
    public final ResourceType type;
    public final String name;
    public final String namespace;
    public final UrlType urlType;
    public final boolean privateAccessOverride;

    public boolean isFramework() {
        return "android".equals(this.namespace);
    }

    public boolean isCreate() {
        return this.urlType == UrlType.CREATE;
    }

    public boolean isTheme() {
        return this.urlType == UrlType.THEME;
    }

    public boolean isPrivateAccessOverride() {
        return this.privateAccessOverride;
    }

    private ResourceUrl(ResourceType type, String name2, String namespace, UrlType urlType, boolean privateAccessOverride) {
        this.type = type;
        this.name = name2;
        this.namespace = namespace;
        this.urlType = urlType;
        this.privateAccessOverride = privateAccessOverride;
    }

    @Deprecated
    public static ResourceUrl create(ResourceType type, String name2, boolean framework) {
        return new ResourceUrl(type, name2, framework ? "android" : null, UrlType.NORMAL, false);
    }

    public static ResourceUrl create(String namespace, ResourceType type, String name2) {
        return new ResourceUrl(type, name2, namespace, UrlType.NORMAL, false);
    }

    public static ResourceUrl createThemeReference(String namespace, ResourceType type, String name2) {
        return new ResourceUrl(type, name2, namespace, UrlType.THEME, false);
    }

    public static ResourceUrl createAttrReference(String namespace, String name2) {
        return new ResourceUrl(ResourceType.ATTR, name2, namespace, UrlType.ATTR, false);
    }

    public static ResourceUrl parse(String url) {
        return ResourceUrl.parse(url, false);
    }

    public static ResourceUrl parse(String url, boolean defaultToFramework) {
        ResourceType type;
        UrlType urlType = UrlType.NORMAL;
        boolean privateAccessOverride = false;
        boolean isStyle = false;
        int currentIndex = 0;
        int length = url.length();
        if (currentIndex == length) {
            return null;
        }
        char currentChar = url.charAt(currentIndex);
        char themePrefix = "?".charAt(0);
        char resourcePrefix = "@".charAt(0);
        if (themePrefix == currentChar) {
            ++currentIndex;
            urlType = UrlType.THEME;
            isStyle = true;
        } else if (resourcePrefix == currentChar) {
            if (++currentIndex == length) {
                return null;
            }
            currentChar = url.charAt(currentIndex);
            if (currentChar == '+') {
                ++currentIndex;
                urlType = UrlType.CREATE;
            }
        }
        int prefixEnd = currentIndex;
        if (prefixEnd == 0) {
            return null;
        }
        if (currentIndex == length) {
            return null;
        }
        currentChar = url.charAt(currentIndex);
        if (currentChar == '*') {
            privateAccessOverride = true;
            ++currentIndex;
        }
        int tokenStart = currentIndex;
        int typeStart = -1;
        int typeEnd = -1;
        int namespaceStart = defaultToFramework ? 0 : -1;
        int namespaceEnd = -1;
        while ((typeStart == -1 || namespaceStart == -1) && currentIndex < length) {
            currentChar = url.charAt(currentIndex);
            switch (currentChar) {
                case '/': {
                    if (typeStart != -1) break;
                    typeStart = tokenStart;
                    typeEnd = currentIndex;
                    tokenStart = currentIndex + 1;
                    break;
                }
                case ':': {
                    if (namespaceStart != -1) break;
                    namespaceStart = tokenStart;
                    namespaceEnd = currentIndex;
                    if (namespaceStart == namespaceEnd) {
                        return null;
                    }
                    tokenStart = currentIndex + 1;
                    break;
                }
                case '[': {
                    while (']' != currentChar && currentIndex < length - 1) {
                        currentChar = url.charAt(++currentIndex);
                    }
                    break;
                }
            }
            ++currentIndex;
        }
        int nameStart = tokenStart;
        if (length <= nameStart) {
            return null;
        }
        String name2 = url.substring(nameStart, length);
        if (typeEnd > typeStart) {
            type = ResourceType.fromXmlValue(url.substring(typeStart, typeEnd));
            if (type == null) {
                return null;
            }
        } else if (isStyle) {
            type = ResourceType.ATTR;
        } else {
            return null;
        }
        String namespace = namespaceStart < namespaceEnd ? url.substring(namespaceStart, namespaceEnd) : (defaultToFramework ? "android" : null);
        return new ResourceUrl(type, name2, namespace, urlType, privateAccessOverride);
    }

    public static ResourceUrl parseAttrReference(String input2) {
        String name2;
        if (input2.isEmpty()) {
            return null;
        }
        if (input2.charAt(0) == '@' || input2.charAt(0) == '?') {
            return null;
        }
        boolean privateAccessOverride = false;
        int prefixEnd = 0;
        if (input2.charAt(0) == '*') {
            prefixEnd = 1;
            privateAccessOverride = true;
        }
        if (input2.indexOf(47, prefixEnd) >= 0) {
            return null;
        }
        String namespace = null;
        int colon = input2.indexOf(58, prefixEnd);
        if (colon < 0) {
            name2 = input2.substring(prefixEnd);
        } else {
            namespace = input2.substring(prefixEnd, colon);
            if (namespace.isEmpty()) {
                return null;
            }
            name2 = input2.substring(colon + 1);
        }
        if (name2.isEmpty()) {
            return null;
        }
        return new ResourceUrl(ResourceType.ATTR, name2, namespace, UrlType.ATTR, privateAccessOverride);
    }

    public static ResourceUrl parseStyleParentReference(String input2) {
        String name2;
        int slash;
        if (input2.isEmpty()) {
            return null;
        }
        boolean privateAccessOverride = false;
        int pos = 0;
        if (input2.charAt(pos) == '@' || input2.charAt(pos) == '?') {
            ++pos;
        }
        if (input2.startsWith("*", pos)) {
            ++pos;
            privateAccessOverride = true;
        }
        String namespace = null;
        int colon = input2.indexOf(58, pos);
        if (colon != -1) {
            namespace = input2.substring(pos, colon);
            if (namespace.isEmpty()) {
                return null;
            }
            pos = colon + 1;
        }
        if ((slash = input2.indexOf(47, pos)) != -1) {
            if (!input2.startsWith("style/", pos)) {
                return null;
            }
            pos = slash + 1;
        }
        if ((name2 = input2.substring(pos)).isEmpty()) {
            return null;
        }
        return new ResourceUrl(ResourceType.STYLE, name2, namespace, UrlType.NORMAL, privateAccessOverride);
    }

    public static boolean isNullOrEmpty(String url) {
        return url.equals("@null") || url.equals("@empty") || url.equals("@undefined");
    }

    public boolean hasValidName() {
        return ResourceUrl.isValidName(this.name, this.type);
    }

    public static boolean isValidName(String input2, ResourceType type) {
        if (input2.isEmpty()) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(input2.charAt(0))) {
            return false;
        }
        int n2 = input2.length();
        for (int i2 = 1; i2 < n2; ++i2) {
            char c2 = input2.charAt(i2);
            if (Character.isJavaIdentifierPart(c2) || c2 == '.' || type == ResourceType.SAMPLE_DATA && (c2 == '/' || c2 == '[' || c2 == ']' || c2 == ':')) continue;
            return false;
        }
        return true;
    }

    public ResourceReference resolve(ResourceNamespace contextNamespace, ResourceNamespace.Resolver resolver2) {
        ResourceNamespace resolvedNamespace = ResourceNamespace.fromNamespacePrefix(this.namespace, contextNamespace, resolver2);
        if (resolvedNamespace == null) {
            return null;
        }
        if (this.name.indexOf(58) >= 0 && this.type != ResourceType.SAMPLE_DATA) {
            return null;
        }
        return new ResourceReference(resolvedNamespace, this.type, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        switch (this.urlType) {
            case NORMAL: {
                sb.append("@");
                break;
            }
            case CREATE: {
                sb.append("@+");
                break;
            }
            case THEME: {
                sb.append("?");
                break;
            }
        }
        if (this.privateAccessOverride) {
            sb.append('*');
        }
        if (this.namespace != null) {
            sb.append(this.namespace);
            sb.append(':');
        }
        if (this.urlType != UrlType.ATTR) {
            sb.append(this.type.getName());
            sb.append('/');
        }
        sb.append(this.name);
        return sb.toString();
    }

    public String getQualifiedName() {
        if (this.namespace == null) {
            return this.name;
        }
        return this.namespace + ":" + this.name;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        ResourceUrl that = (ResourceUrl)o2;
        return this.urlType == that.urlType && this.type == that.type && Objects.equals(this.name, that.name) && Objects.equals(this.namespace, that.namespace);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.urlType, this.type, this.name, this.namespace});
    }

    public static enum UrlType {
        NORMAL,
        CREATE,
        THEME,
        ATTR;

    }
}

