/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources.aar;

import com.android.ProgressManagerAdapter;
import com.android.annotations.TestOnly;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.AndroidManifestPackageNameUtils;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.symbols.Symbol;
import com.android.ide.common.symbols.SymbolIo;
import com.android.ide.common.symbols.SymbolTable;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.resources.aar.AbstractAarResourceRepository;
import com.android.resources.aar.CachingData;
import com.android.resources.base.BasicResourceItem;
import com.android.resources.base.NamespaceResolver;
import com.android.resources.base.RepositoryConfiguration;
import com.android.resources.base.RepositoryLoader;
import com.android.resources.base.ResourceSerializationUtil;
import com.android.resources.base.ResourceSourceFileImpl;
import com.android.tools.environment.Logger;
import com.android.utils.Base128InputStream;
import com.android.utils.Base128OutputStream;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;

public class AarSourceResourceRepository
extends AbstractAarResourceRepository {
    static final String CACHE_FILE_FORMAT_VERSION = "3";
    private static final byte[] CACHE_FILE_HEADER = "Resource cache".getBytes(StandardCharsets.UTF_8);
    private static final Logger LOG = Logger.getInstance(AarSourceResourceRepository.class);
    protected final Path myResourceDirectoryOrFile;
    protected boolean myLoadedFromCache;
    private final String mySourceFileProtocol;
    private final String myResourcePathPrefix;
    private final String myResourceUrlPrefix;
    private final Supplier<String> myManifestPackageName;

    protected AarSourceResourceRepository(RepositoryLoader<? extends AarSourceResourceRepository> loader2, String libraryName) {
        super(loader2.getNamespace(), libraryName);
        this.myResourceDirectoryOrFile = loader2.getResourceDirectoryOrFile();
        this.mySourceFileProtocol = loader2.getSourceFileProtocol();
        this.myResourcePathPrefix = loader2.getResourcePathPrefix();
        this.myResourceUrlPrefix = loader2.getResourceUrlPrefix();
        this.myManifestPackageName = Suppliers.memoize(() -> {
            try {
                PathString manifestPath = this.getSourceFile("../AndroidManifest.xml", true);
                return AndroidManifestPackageNameUtils.getPackageNameFromManifestFile(manifestPath);
            }
            catch (FileNotFoundException e2) {
                return null;
            }
            catch (IOException e3) {
                LOG.error("Failed to read manifest AndroidManifest.xml for " + this.getDisplayName(), e3);
                return null;
            }
        });
    }

    public static AarSourceResourceRepository create(Path resourceDirectoryOrFile, String libraryName) {
        return AarSourceResourceRepository.create(resourceDirectoryOrFile, libraryName, null);
    }

    public static AarSourceResourceRepository create(Path resourceDirectoryOrFile, String libraryName, CachingData cachingData) {
        return AarSourceResourceRepository.create(resourceDirectoryOrFile, null, ResourceNamespace.RES_AUTO, libraryName, cachingData);
    }

    public static AarSourceResourceRepository create(PathString resourceFolderRoot, Collection<PathString> resourceFolderResources, String libraryName, CachingData cachingData) {
        Path resDir = resourceFolderRoot.toPath();
        Preconditions.checkArgument(resDir != null);
        return AarSourceResourceRepository.create(resDir, resourceFolderResources, ResourceNamespace.RES_AUTO, libraryName, cachingData);
    }

    private static AarSourceResourceRepository create(Path resourceDirectoryOrFile, Collection<PathString> resourceFilesAndFolders, ResourceNamespace namespace, String libraryName, CachingData cachingData) {
        Executor executor;
        Loader loader2 = new Loader(resourceDirectoryOrFile, resourceFilesAndFolders, namespace);
        AarSourceResourceRepository repository = new AarSourceResourceRepository(loader2, libraryName);
        if (cachingData != null && resourceFilesAndFolders == null && repository.loadFromPersistentCache(cachingData)) {
            return repository;
        }
        loader2.loadRepositoryContents(repository);
        repository.populatePublicResourcesMap();
        repository.freezeResources();
        if (cachingData != null && resourceFilesAndFolders == null && (executor = cachingData.getCacheCreationExecutor()) != null) {
            executor.execute(() -> repository.createPersistentCache(cachingData));
        }
        return repository;
    }

    @Override
    public Path getOrigin() {
        return this.myResourceDirectoryOrFile;
    }

    @TestOnly
    public static AarSourceResourceRepository createForTest(Path resourceDirectoryOrFile, ResourceNamespace namespace, String libraryName) {
        return AarSourceResourceRepository.create(resourceDirectoryOrFile, null, namespace, libraryName, null);
    }

    @Override
    public String getPackageName() {
        String packageName = this.myNamespace.getPackageName();
        return packageName == null ? this.myManifestPackageName.get() : packageName;
    }

    @Override
    public PathString getSourceFile(String relativeResourcePath, boolean forFileResource) {
        return new PathString(this.mySourceFileProtocol, this.myResourcePathPrefix + relativeResourcePath);
    }

    @Override
    public String getResourceUrl(String relativeResourcePath) {
        return this.myResourceUrlPrefix + relativeResourcePath;
    }

    private boolean loadFromPersistentCache(CachingData cachingData) {
        byte[] header = ResourceSerializationUtil.getCacheFileHeader(stream -> this.writeCacheHeaderContent(cachingData, stream));
        return this.loadFromPersistentCache(cachingData.getCacheFile(), header);
    }

    private void createPersistentCache(CachingData cachingData) {
        byte[] header = ResourceSerializationUtil.getCacheFileHeader(stream -> this.writeCacheHeaderContent(cachingData, stream));
        ResourceSerializationUtil.createPersistentCache(cachingData.getCacheFile(), header, stream -> this.writeToStream(stream, config -> true));
    }

    protected void writeCacheHeaderContent(CachingData cachingData, Base128OutputStream stream) throws IOException {
        stream.write(CACHE_FILE_HEADER);
        stream.writeString(CACHE_FILE_FORMAT_VERSION);
        stream.writeString(this.myResourceDirectoryOrFile.toString());
        stream.writeString(cachingData.getContentVersion());
        stream.writeString(cachingData.getCodeVersion());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadFromPersistentCache(Path cacheFile, byte[] fileHeader) {
        try (Base128InputStream stream = new Base128InputStream(cacheFile);){
            if (!stream.validateContents(fileHeader)) {
                boolean bl2 = false;
                return bl2;
            }
            this.loadFromStream(stream, Maps.newHashMapWithExpectedSize(1000), null);
            this.populatePublicResourcesMap();
            this.freezeResources();
            this.myLoadedFromCache = true;
            boolean bl3 = true;
            return bl3;
        }
        catch (NoSuchFileException e2) {
            return false;
        }
        catch (Throwable e3) {
            this.cleanupAfterFailedLoadingFromCache();
            ProgressManagerAdapter.throwIfCancellation(e3);
            LOG.warn("Failed to load resources from cache file " + cacheFile, e3);
            return false;
        }
    }

    protected void cleanupAfterFailedLoadingFromCache() {
        this.myResources.clear();
    }

    void writeToStream(Base128OutputStream stream, Predicate<FolderConfiguration> configFilter) throws IOException {
        ResourceSerializationUtil.writeResourcesToStream(this.myResources, stream, configFilter);
    }

    protected void loadFromStream(Base128InputStream stream, Map<String, String> stringCache, Map<NamespaceResolver, NamespaceResolver> namespaceResolverCache) throws IOException {
        ResourceSerializationUtil.readResourcesFromStream(stream, stringCache, namespaceResolverCache, this, this::addResourceItem);
    }

    @TestOnly
    boolean isLoadedFromCache() {
        return this.myLoadedFromCache;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + " for " + this.myResourceDirectoryOrFile;
    }

    private static class Loader
    extends RepositoryLoader<AarSourceResourceRepository> {
        private Set<String> myRTxtIds = ImmutableSet.of();

        Loader(Path resourceDirectoryOrFile, Collection<PathString> resourceFilesAndFolders, ResourceNamespace namespace) {
            super(resourceDirectoryOrFile, resourceFilesAndFolders, namespace);
        }

        @Override
        protected boolean loadIdsFromRTxt() {
            if (this.myZipFile == null) {
                Path rDotTxt = this.myResourceDirectoryOrFile.resolveSibling("R.txt");
                if (Files.exists(rDotTxt, new LinkOption[0])) {
                    try {
                        SymbolTable symbolTable = SymbolIo.readFromAaptNoValues(rDotTxt.toFile(), null);
                        this.myRTxtIds = Loader.computeIds(symbolTable);
                        return true;
                    }
                    catch (Exception e2) {
                        ProgressManagerAdapter.throwIfCancellation(e2);
                        LOG.warn("Failed to load id resources from " + rDotTxt, e2);
                    }
                }
            } else {
                ZipEntry zipEntry = this.myZipFile.getEntry("R.txt");
                if (zipEntry != null) {
                    boolean bl2;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(this.myZipFile.getInputStream(zipEntry), StandardCharsets.UTF_8));
                    try {
                        SymbolTable symbolTable = SymbolIo.readFromAaptNoValues(reader, "R.txt in " + this.myResourceDirectoryOrFile, null);
                        this.myRTxtIds = Loader.computeIds(symbolTable);
                        bl2 = true;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (Exception e3) {
                            ProgressManagerAdapter.throwIfCancellation(e3);
                            LOG.warn("Failed to load id resources from R.txt in " + this.myResourceDirectoryOrFile, e3);
                        }
                    }
                    reader.close();
                    return bl2;
                }
                return false;
            }
            return false;
        }

        @Override
        protected void finishLoading(AarSourceResourceRepository repository) {
            super.finishLoading(repository);
            this.createResourcesForRTxtIds(repository);
        }

        private void createResourcesForRTxtIds(AarSourceResourceRepository repository) {
            if (!this.myRTxtIds.isEmpty()) {
                RepositoryConfiguration configuration = this.getConfiguration(repository, ResourceItem.DEFAULT_CONFIGURATION);
                ResourceSourceFileImpl sourceFile = new ResourceSourceFileImpl(null, configuration);
                for (String name2 : this.myRTxtIds) {
                    this.addIdResourceItem(name2, sourceFile);
                }
                this.addValueFileResources();
            }
        }

        private static Set<String> computeIds(SymbolTable symbolTable) {
            return ((ImmutableMap)symbolTable.getSymbols().row((Object)ResourceType.ID)).values().stream().map(Symbol::getCanonicalName).collect(Collectors.toSet());
        }

        @Override
        protected void loadPublicResourceNames() {
            if (this.myZipFile == null) {
                Path file2 = this.myResourceDirectoryOrFile.resolveSibling("public.txt");
                try (BufferedReader reader = Files.newBufferedReader(file2);){
                    this.readPublicResourceNames(reader);
                }
                catch (NoSuchFileException e2) {
                    this.myDefaultVisibility = ResourceVisibility.PUBLIC;
                }
                catch (IOException e3) {
                    LOG.warn("Error reading " + file2, e3);
                }
            } else {
                ZipEntry zipEntry = this.myZipFile.getEntry("public.txt");
                if (zipEntry == null) {
                    this.myDefaultVisibility = ResourceVisibility.PUBLIC;
                } else {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.myZipFile.getInputStream(zipEntry), StandardCharsets.UTF_8));){
                        this.readPublicResourceNames(reader);
                    }
                    catch (IOException e4) {
                        LOG.warn("Error reading public.txt from " + this.myResourceDirectoryOrFile, e4);
                    }
                }
            }
        }

        @Override
        protected void addResourceItem(BasicResourceItem item, AarSourceResourceRepository repository) {
            repository.addResourceItem(item);
        }

        private void readPublicResourceNames(BufferedReader reader) throws IOException {
            String line;
            while ((line = reader.readLine()) != null) {
                ResourceType type;
                int delimiterPos = (line = line.trim()).indexOf(32);
                if (delimiterPos <= 0 || delimiterPos + 1 >= line.length() || (type = ResourceType.fromXmlTagName(line.substring(0, delimiterPos))) == null) continue;
                String name2 = line.substring(delimiterPos + 1);
                this.addPublicResourceName(type, name2);
            }
        }
    }
}

