/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources.aar;

import com.android.ProgressManagerAdapter;
import com.android.annotations.TestOnly;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.util.PathString;
import com.android.io.CancellableFileIo;
import com.android.resources.ResourceType;
import com.android.resources.aar.AarSourceResourceRepository;
import com.android.resources.aar.CachingData;
import com.android.resources.base.BasicResourceItem;
import com.android.resources.base.BasicResourceItemBase;
import com.android.resources.base.BasicValueResourceItemBase;
import com.android.resources.base.NamespaceResolver;
import com.android.resources.base.RepositoryConfiguration;
import com.android.resources.base.RepositoryLoader;
import com.android.resources.base.ResourceSerializationUtil;
import com.android.tools.environment.Logger;
import com.android.utils.Base128InputStream;
import com.android.utils.Base128OutputStream;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class FrameworkResourceRepository
extends AarSourceResourceRepository {
    private static final ResourceNamespace ANDROID_NAMESPACE = ResourceNamespace.ANDROID;
    private static final Map<String, String> LANGUAGE_TO_GROUP = ImmutableMap.of("rm", "it");
    private static final String RESOURCES_TABLE_PREFIX = "resources_";
    private static final String RESOURCE_TABLE_SUFFIX = ".bin";
    private static final String COMPILED_9PNG_EXTENSION = ".compiled.9.png";
    private static final Logger LOG = Logger.getInstance(FrameworkResourceRepository.class);
    private final Set<String> myLanguageGroups = new TreeSet<String>();
    private int myNumberOfLanguageGroupsLoadedFromCache;
    private final boolean myUseCompiled9Patches;

    private FrameworkResourceRepository(RepositoryLoader<FrameworkResourceRepository> loader2, boolean useCompiled9Patches) {
        super(loader2, null);
        this.myUseCompiled9Patches = useCompiled9Patches;
    }

    public static FrameworkResourceRepository create(Path resourceDirectoryOrFile, Set<String> languagesToLoad, CachingData cachingData, boolean useCompiled9Patches) {
        long start = LOG.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        Set<String> languageGroups = languagesToLoad == null ? null : FrameworkResourceRepository.getLanguageGroups(languagesToLoad);
        Loader loader2 = new Loader(resourceDirectoryOrFile, languageGroups);
        FrameworkResourceRepository repository = new FrameworkResourceRepository(loader2, useCompiled9Patches);
        repository.load(null, cachingData, loader2, languageGroups, loader2.myLoadedLanguageGroups);
        if (LOG.isDebugEnabled()) {
            String source = repository.getNumberOfLanguageGroupsLoadedFromOrigin() == 0 ? "cache" : (repository.myNumberOfLanguageGroupsLoadedFromCache == 0 ? resourceDirectoryOrFile.toString() : "cache and " + resourceDirectoryOrFile);
            LOG.debug("Loaded from " + source + " with " + (repository.myLanguageGroups.size() - 1) + " languages in " + (double)(System.currentTimeMillis() - start) / 1000.0 + " sec");
        }
        return repository;
    }

    public boolean containsLanguages(Set<String> languages) {
        for (String language : languages) {
            if (this.myLanguageGroups.contains(FrameworkResourceRepository.getLanguageGroup(language))) continue;
            return false;
        }
        return true;
    }

    public FrameworkResourceRepository loadMissingLanguages(Set<String> languagesToLoad, CachingData cachingData) {
        Set<String> languageGroups;
        Set<String> set = languageGroups = languagesToLoad == null ? null : FrameworkResourceRepository.getLanguageGroups(languagesToLoad);
        if (languageGroups != null && this.myLanguageGroups.containsAll(languageGroups)) {
            return this;
        }
        long start = LOG.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        Loader loader2 = new Loader(this, languageGroups);
        FrameworkResourceRepository newRepository = new FrameworkResourceRepository(loader2, this.myUseCompiled9Patches);
        newRepository.load(this, cachingData, loader2, languageGroups, loader2.myLoadedLanguageGroups);
        if (LOG.isDebugEnabled()) {
            String source = newRepository.getNumberOfLanguageGroupsLoadedFromOrigin() == this.getNumberOfLanguageGroupsLoadedFromOrigin() ? "cache" : (newRepository.myNumberOfLanguageGroupsLoadedFromCache == this.myNumberOfLanguageGroupsLoadedFromCache ? this.myResourceDirectoryOrFile.toString() : "cache and " + this.myResourceDirectoryOrFile);
            LOG.debug("Loaded " + (newRepository.myLanguageGroups.size() - this.myLanguageGroups.size()) + " additional languages from " + source + " in " + (double)(System.currentTimeMillis() - start) / 1000.0 + " sec");
        }
        return newRepository;
    }

    private void load(FrameworkResourceRepository sourceRepository, CachingData cachingData, Loader loader2, Set<String> languageGroups, Set<String> languageGroupsLoadedFromSourceRepositoryOrCache) {
        Executor executor;
        ImmutableSet<RepositoryConfiguration> configurationsToTakeOver;
        HashMap<String, String> stringCache = Maps.newHashMapWithExpectedSize(10000);
        HashMap<NamespaceResolver, NamespaceResolver> namespaceResolverCache = new HashMap<NamespaceResolver, NamespaceResolver>();
        Set<RepositoryConfiguration> set = configurationsToTakeOver = sourceRepository == null ? ImmutableSet.of() : this.copyFromRepository(sourceRepository, stringCache, namespaceResolverCache);
        if (!loader2.isLoadingFromZipArchive() && cachingData != null) {
            this.loadFromPersistentCache(cachingData, languageGroups, languageGroupsLoadedFromSourceRepositoryOrCache, stringCache, namespaceResolverCache);
        }
        this.myLanguageGroups.addAll(languageGroupsLoadedFromSourceRepositoryOrCache);
        if (languageGroups == null || !languageGroupsLoadedFromSourceRepositoryOrCache.containsAll(languageGroups)) {
            loader2.loadRepositoryContents(this);
        }
        this.myLoadedFromCache = this.myNumberOfLanguageGroupsLoadedFromCache == this.myLanguageGroups.size();
        this.populatePublicResourcesMap();
        this.freezeResources();
        this.takeOverConfigurations(configurationsToTakeOver);
        if (!loader2.isLoadingFromZipArchive() && cachingData != null && (executor = cachingData.getCacheCreationExecutor()) != null && !languageGroupsLoadedFromSourceRepositoryOrCache.containsAll(this.myLanguageGroups)) {
            executor.execute(() -> this.createPersistentCache(cachingData, languageGroupsLoadedFromSourceRepositoryOrCache));
        }
    }

    @Override
    public String getPackageName() {
        return ANDROID_NAMESPACE.getPackageName();
    }

    @Override
    public Set<ResourceType> getResourceTypes(ResourceNamespace namespace) {
        return namespace == ANDROID_NAMESPACE ? Sets.immutableEnumSet(this.myResources.keySet()) : ImmutableSet.of();
    }

    private Set<RepositoryConfiguration> copyFromRepository(FrameworkResourceRepository sourceRepository, Map<String, String> stringCache, Map<NamespaceResolver, NamespaceResolver> namespaceResolverCache) {
        Collection resourceMaps = sourceRepository.myResources.values();
        Set<RepositoryConfiguration> sourceConfigurations = Sets.newIdentityHashSet();
        for (ListMultimap resourceMap : resourceMaps) {
            for (ResourceItem item : resourceMap.values()) {
                this.addResourceItem(item);
                sourceConfigurations.add(((BasicResourceItemBase)item).getRepositoryConfiguration());
                if (item instanceof BasicValueResourceItemBase) {
                    ResourceNamespace.Resolver resolver2 = ((BasicValueResourceItemBase)item).getNamespaceResolver();
                    NamespaceResolver namespaceResolver = resolver2 == ResourceNamespace.Resolver.EMPTY_RESOLVER ? NamespaceResolver.EMPTY : (NamespaceResolver)resolver2;
                    namespaceResolverCache.put(namespaceResolver, namespaceResolver);
                }
                String name2 = item.getName();
                stringCache.put(name2, name2);
            }
        }
        this.myNumberOfLanguageGroupsLoadedFromCache += sourceRepository.myNumberOfLanguageGroupsLoadedFromCache;
        return sourceConfigurations;
    }

    private void loadFromPersistentCache(CachingData cachingData, Set<String> languagesToLoad, Set<String> loadedLanguages, Map<String, String> stringCache, Map<NamespaceResolver, NamespaceResolver> namespaceResolverCache) {
        CacheFileNameGenerator fileNameGenerator = new CacheFileNameGenerator(cachingData);
        Set<String> languages = languagesToLoad == null ? fileNameGenerator.getAllCacheFileLanguages() : languagesToLoad;
        for (String language : languages) {
            if (loadedLanguages.contains(language)) continue;
            Path cacheFile = fileNameGenerator.getCacheFile(language);
            try (Base128InputStream stream = new Base128InputStream(cacheFile);){
                byte[] header = ResourceSerializationUtil.getCacheFileHeader(s2 -> this.writeCacheHeaderContent(cachingData, language, s2));
                if (!stream.validateContents(header)) {
                    if (!language.isEmpty()) continue;
                    break;
                }
                this.loadFromStream(stream, stringCache, namespaceResolverCache);
                loadedLanguages.add(language);
                ++this.myNumberOfLanguageGroupsLoadedFromCache;
            }
            catch (NoSuchFileException e2) {
                if (!language.isEmpty()) continue;
                break;
            }
            catch (Throwable e3) {
                this.cleanupAfterFailedLoadingFromCache();
                loadedLanguages.clear();
                ProgressManagerAdapter.throwIfCancellation(e3);
                LOG.warn("Failed to load from cache file " + cacheFile.toString(), e3);
                break;
            }
        }
    }

    @Override
    protected void cleanupAfterFailedLoadingFromCache() {
        super.cleanupAfterFailedLoadingFromCache();
        this.myNumberOfLanguageGroupsLoadedFromCache = 0;
    }

    private void createPersistentCache(CachingData cachingData, Set<String> languagesToSkip) {
        CacheFileNameGenerator fileNameGenerator = new CacheFileNameGenerator(cachingData);
        for (String language : this.myLanguageGroups) {
            if (languagesToSkip.contains(language)) continue;
            Path cacheFile = fileNameGenerator.getCacheFile(language);
            byte[] header = ResourceSerializationUtil.getCacheFileHeader(stream -> this.writeCacheHeaderContent(cachingData, language, stream));
            ResourceSerializationUtil.createPersistentCache(cacheFile, header, stream -> this.writeToStream(stream, config -> language.equals(FrameworkResourceRepository.getLanguageGroup(config))));
        }
    }

    private void writeCacheHeaderContent(CachingData cachingData, String language, Base128OutputStream stream) throws IOException {
        this.writeCacheHeaderContent(cachingData, stream);
        stream.writeString(language);
    }

    static String getResourceTableNameForLanguage(String language) {
        return language.isEmpty() ? "resources.bin" : RESOURCES_TABLE_PREFIX + language + RESOURCE_TABLE_SUFFIX;
    }

    static String getLanguageGroup(FolderConfiguration config) {
        LocaleQualifier locale = config.getLocaleQualifier();
        return locale == null ? "" : FrameworkResourceRepository.getLanguageGroup(Strings.nullToEmpty(locale.getLanguage()));
    }

    private static String getLanguageGroup(String language) {
        return LANGUAGE_TO_GROUP.getOrDefault(language, language);
    }

    private static Set<String> getLanguageGroups(Set<String> languages) {
        TreeSet<String> result2 = new TreeSet<String>();
        result2.add("");
        for (String language : languages) {
            result2.add(FrameworkResourceRepository.getLanguageGroup(language));
        }
        return result2;
    }

    Set<String> getLanguageGroups() {
        TreeSet<String> languages = new TreeSet<String>();
        for (ListMultimap resourceMap : this.myResources.values()) {
            for (ResourceItem item : resourceMap.values()) {
                FolderConfiguration config = item.getConfiguration();
                languages.add(FrameworkResourceRepository.getLanguageGroup(config));
            }
        }
        return languages;
    }

    private int getNumberOfLanguageGroupsLoadedFromOrigin() {
        return this.myLanguageGroups.size() - this.myNumberOfLanguageGroupsLoadedFromCache;
    }

    @TestOnly
    int getNumberOfLanguageGroupsLoadedFromCache() {
        return this.myNumberOfLanguageGroupsLoadedFromCache;
    }

    private String updateResourcePath(String relativeResourcePath) {
        if (this.myUseCompiled9Patches && relativeResourcePath.endsWith(".9.png")) {
            return relativeResourcePath.substring(0, relativeResourcePath.length() - ".9.png".length()) + COMPILED_9PNG_EXTENSION;
        }
        return relativeResourcePath;
    }

    @Override
    public String getResourceUrl(String relativeResourcePath) {
        return super.getResourceUrl(this.updateResourcePath(relativeResourcePath));
    }

    @Override
    public PathString getSourceFile(String relativeResourcePath, boolean forFileResource) {
        return super.getSourceFile(this.updateResourcePath(relativeResourcePath), forFileResource);
    }

    private void takeOverConfigurations(Set<RepositoryConfiguration> sourceConfigurations) {
        for (RepositoryConfiguration configuration : sourceConfigurations) {
            configuration.transferOwnershipTo(this);
        }
    }

    private static class Loader
    extends RepositoryLoader<FrameworkResourceRepository> {
        private final List<String> myPublicFileNames = ImmutableList.of("public.xml", "public-final.xml", "public-staging.xml");
        private final Set<String> myLoadedLanguageGroups;
        private Set<String> myLanguageGroups;

        Loader(Path resourceDirectoryOrFile, Set<String> languageGroups) {
            super(resourceDirectoryOrFile, null, ANDROID_NAMESPACE);
            this.myLanguageGroups = languageGroups;
            this.myLoadedLanguageGroups = new TreeSet<String>();
        }

        Loader(FrameworkResourceRepository sourceRepository, Set<String> languageGroups) {
            super(sourceRepository.myResourceDirectoryOrFile, null, ANDROID_NAMESPACE);
            this.myLanguageGroups = languageGroups;
            this.myLoadedLanguageGroups = new TreeSet<String>(sourceRepository.myLanguageGroups);
        }

        @Override
        public List<String> getPublicXmlFileNames() {
            return this.myPublicFileNames;
        }

        @Override
        protected void loadFromZip(FrameworkResourceRepository repository) {
            try (ZipFile zipFile = new ZipFile(this.myResourceDirectoryOrFile.toFile());){
                if (this.myLanguageGroups == null) {
                    this.myLanguageGroups = Loader.readLanguageGroups(zipFile);
                }
                HashMap<String, String> stringCache = Maps.newHashMapWithExpectedSize(10000);
                HashMap<NamespaceResolver, NamespaceResolver> namespaceResolverCache = new HashMap<NamespaceResolver, NamespaceResolver>();
                for (String language : this.myLanguageGroups) {
                    if (this.myLoadedLanguageGroups.contains(language)) continue;
                    String entryName = FrameworkResourceRepository.getResourceTableNameForLanguage(language);
                    ZipEntry zipEntry = zipFile.getEntry(entryName);
                    if (zipEntry == null) {
                        if (!language.isEmpty()) continue;
                        throw new IOException("\"" + entryName + "\" not found in " + this.myResourceDirectoryOrFile.toString());
                    }
                    try (Base128InputStream stream = new Base128InputStream(zipFile.getInputStream(zipEntry));){
                        repository.loadFromStream(stream, stringCache, namespaceResolverCache);
                    }
                }
                repository.populatePublicResourcesMap();
                repository.freezeResources();
            }
            catch (Exception e2) {
                ProgressManagerAdapter.throwIfCancellation(e2);
                LOG.error("Failed to load resources from " + this.myResourceDirectoryOrFile.toString(), e2);
            }
        }

        private static Set<String> readLanguageGroups(ZipFile zipFile) {
            ImmutableSortedSet.Builder result2 = ImmutableSortedSet.naturalOrder();
            result2.add("");
            zipFile.stream().forEach(entry -> {
                String name2 = entry.getName();
                if (name2.startsWith(FrameworkResourceRepository.RESOURCES_TABLE_PREFIX) && name2.endsWith(FrameworkResourceRepository.RESOURCE_TABLE_SUFFIX) && name2.length() == FrameworkResourceRepository.RESOURCES_TABLE_PREFIX.length() + FrameworkResourceRepository.RESOURCE_TABLE_SUFFIX.length() + 2 && Character.isLetter(name2.charAt(FrameworkResourceRepository.RESOURCES_TABLE_PREFIX.length())) && Character.isLetter(name2.charAt(FrameworkResourceRepository.RESOURCES_TABLE_PREFIX.length() + 1))) {
                    result2.add(name2.substring(FrameworkResourceRepository.RESOURCES_TABLE_PREFIX.length(), FrameworkResourceRepository.RESOURCES_TABLE_PREFIX.length() + 2));
                }
            });
            return result2.build();
        }

        @Override
        public void loadRepositoryContents(FrameworkResourceRepository repository) {
            super.loadRepositoryContents(repository);
            Set<String> languageGroups = this.myLanguageGroups == null ? repository.getLanguageGroups() : this.myLanguageGroups;
            repository.myLanguageGroups.addAll(languageGroups);
        }

        @Override
        public boolean isIgnored(Path fileOrDirectory, BasicFileAttributes attrs) {
            if (fileOrDirectory.equals(this.myResourceDirectoryOrFile)) {
                return false;
            }
            if (super.isIgnored(fileOrDirectory, attrs)) {
                return true;
            }
            String fileName = fileOrDirectory.getFileName().toString();
            if (attrs.isDirectory()) {
                if (fileName.startsWith("values-mcc") || fileName.startsWith("raw") && (fileName.length() == "raw".length() || fileName.charAt("raw".length()) == '-')) {
                    return true;
                }
                if (this.myLanguageGroups != null || !this.myLoadedLanguageGroups.isEmpty()) {
                    FolderConfiguration config = FolderConfiguration.getConfigForFolder(fileName);
                    if (config == null) {
                        return true;
                    }
                    String language = FrameworkResourceRepository.getLanguageGroup(config);
                    if (this.myLanguageGroups != null && !this.myLanguageGroups.contains(language) || this.myLoadedLanguageGroups.contains(language)) {
                        return true;
                    }
                    this.myFolderConfigCache.put(config.getQualifierString(), config);
                }
            } else {
                if ((this.myPublicFileNames.contains(fileName) || fileName.equals("symbols.xml")) && "values".equals(new PathString(fileOrDirectory).getParentFileName())) {
                    return true;
                }
                if (fileName.endsWith(FrameworkResourceRepository.COMPILED_9PNG_EXTENSION)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        protected final void addResourceItem(BasicResourceItem item, FrameworkResourceRepository repository) {
            repository.addResourceItem(item);
        }

        @Override
        protected String getKeyForVisibilityLookup(String resourceName) {
            return resourceName;
        }
    }

    private static class CacheFileNameGenerator {
        private final Path myLanguageNeutralFile;
        private final String myPrefix;
        private final String mySuffix;

        CacheFileNameGenerator(CachingData cachingData) {
            this.myLanguageNeutralFile = cachingData.getCacheFile();
            String fileName = this.myLanguageNeutralFile.getFileName().toString();
            int dotPos = fileName.lastIndexOf(46);
            this.myPrefix = dotPos >= 0 ? fileName.substring(0, dotPos) : fileName;
            this.mySuffix = dotPos >= 0 ? fileName.substring(dotPos) : "";
        }

        Path getCacheFile(String language) {
            return language.isEmpty() ? this.myLanguageNeutralFile : this.myLanguageNeutralFile.resolveSibling(this.myPrefix + "_" + language + this.mySuffix);
        }

        String getLanguage(String cacheFileName) {
            if (!cacheFileName.startsWith(this.myPrefix) || !cacheFileName.endsWith(this.mySuffix)) {
                return null;
            }
            int baseLength = this.myPrefix.length() + this.mySuffix.length();
            if (cacheFileName.length() == baseLength) {
                return "";
            }
            if (cacheFileName.length() != baseLength + 3 || cacheFileName.charAt(this.myPrefix.length()) != '_') {
                return null;
            }
            String language = cacheFileName.substring(this.myPrefix.length() + 1, this.myPrefix.length() + 3);
            if (!CacheFileNameGenerator.isLowerCaseLatinLetter(language.charAt(0)) || !CacheFileNameGenerator.isLowerCaseLatinLetter(language.charAt(1))) {
                return null;
            }
            return language;
        }

        public Set<String> getAllCacheFileLanguages() {
            TreeSet<String> result2 = new TreeSet<String>();
            try (Stream<Path> stream = CancellableFileIo.list(this.myLanguageNeutralFile.getParent());){
                stream.forEach(file2 -> {
                    String language = this.getLanguage(file2.getFileName().toString());
                    if (language != null) {
                        result2.add(language);
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return result2;
        }

        private static boolean isLowerCaseLatinLetter(char c2) {
            return 'a' <= c2 && c2 <= 'z';
        }
    }
}

