/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources.base;

import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.StyleableResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.resources.base.BasicAttrResourceItem;
import com.android.resources.base.BasicResourceItemBase;
import com.android.resources.base.BasicValueResourceItemBase;
import com.android.resources.base.LoadableResourceRepository;
import com.android.resources.base.RepositoryConfiguration;
import com.android.resources.base.ResourceSourceFile;
import com.android.utils.Base128InputStream;
import com.android.utils.Base128OutputStream;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class BasicStyleableResourceItem
extends BasicValueResourceItemBase
implements StyleableResourceValue {
    private final List<AttrResourceValue> myAttrs;

    public BasicStyleableResourceItem(String name2, ResourceSourceFile sourceFile, ResourceVisibility visibility, List<AttrResourceValue> attrs) {
        super(ResourceType.STYLEABLE, name2, sourceFile, visibility);
        this.myAttrs = ImmutableList.copyOf(attrs);
    }

    @Override
    public List<AttrResourceValue> getAllAttributes() {
        return this.myAttrs;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BasicStyleableResourceItem other = (BasicStyleableResourceItem)obj;
        return this.myAttrs.equals(other.myAttrs);
    }

    @Override
    public void serialize(Base128OutputStream stream, Object2IntMap<String> configIndexes, Object2IntMap<ResourceSourceFile> sourceFileIndexes, Object2IntMap<ResourceNamespace.Resolver> namespaceResolverIndexes) throws IOException {
        super.serialize(stream, configIndexes, sourceFileIndexes, namespaceResolverIndexes);
        stream.writeInt(this.myAttrs.size());
        for (AttrResourceValue attr : this.myAttrs) {
            if (attr instanceof BasicAttrResourceItem && !attr.getFormats().isEmpty()) {
                attr = ((BasicAttrResourceItem)attr).createReference();
            }
            ((BasicValueResourceItemBase)((Object)attr)).serialize(stream, configIndexes, sourceFileIndexes, namespaceResolverIndexes);
        }
    }

    static BasicStyleableResourceItem deserialize(Base128InputStream stream, String name2, ResourceVisibility visibility, ResourceSourceFile sourceFile, ResourceNamespace.Resolver resolver2, List<RepositoryConfiguration> configurations, List<ResourceSourceFile> sourceFiles, List<ResourceNamespace.Resolver> namespaceResolvers) throws IOException {
        LoadableResourceRepository repository = sourceFile.getRepository();
        int n2 = stream.readInt();
        ArrayList<AttrResourceValue> attrs = n2 == 0 ? Collections.emptyList() : new ArrayList<AttrResourceValue>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            BasicResourceItemBase attrItem = BasicStyleableResourceItem.deserialize(stream, configurations, sourceFiles, namespaceResolvers);
            if (!(attrItem instanceof AttrResourceValue)) {
                throw Base128InputStream.StreamFormatException.invalidFormat();
            }
            AttrResourceValue attr = BasicStyleableResourceItem.getCanonicalAttr((AttrResourceValue)((Object)attrItem), repository);
            attrs.add(attr);
        }
        BasicStyleableResourceItem item = new BasicStyleableResourceItem(name2, sourceFile, visibility, attrs);
        item.setNamespaceResolver(resolver2);
        return item;
    }

    public static AttrResourceValue getCanonicalAttr(AttrResourceValue attr, ResourceRepository repository) {
        if (attr.getFormats().isEmpty()) {
            List<ResourceItem> items = repository.getResources(attr.getNamespace(), ResourceType.ATTR, attr.getName());
            for (ResourceItem item : items) {
                if (!(item instanceof AttrResourceValue) || !Objects.equals(((AttrResourceValue)((Object)item)).getDescription(), attr.getDescription()) || !Objects.equals(((AttrResourceValue)((Object)item)).getGroupName(), attr.getGroupName())) continue;
                return (AttrResourceValue)((Object)item);
            }
        }
        return attr;
    }
}

