/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources.base;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceType;
import com.android.resources.ResourceVisibility;
import com.android.resources.base.BasicTextValueResourceItem;
import com.android.resources.base.BasicValueResourceItemBase;
import com.android.resources.base.ResourceSourceFile;
import com.android.utils.Base128InputStream;
import com.android.utils.Base128OutputStream;
import com.android.utils.HashCodes;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.io.IOException;
import java.util.Objects;

public class BasicValueResourceItem
extends BasicValueResourceItemBase {
    private final String myValue;

    public BasicValueResourceItem(ResourceType type, String name2, ResourceSourceFile sourceFile, ResourceVisibility visibility, String value) {
        super(type, name2, sourceFile, visibility);
        this.myValue = value;
    }

    @Override
    public String getValue() {
        return this.myValue;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BasicValueResourceItem other = (BasicValueResourceItem)obj;
        return Objects.equals(this.myValue, other.myValue);
    }

    @Override
    public int hashCode() {
        return HashCodes.mix(super.hashCode(), Objects.hashCode(this.myValue));
    }

    @Override
    public void serialize(Base128OutputStream stream, Object2IntMap<String> configIndexes, Object2IntMap<ResourceSourceFile> sourceFileIndexes, Object2IntMap<ResourceNamespace.Resolver> namespaceResolverIndexes) throws IOException {
        super.serialize(stream, configIndexes, sourceFileIndexes, namespaceResolverIndexes);
        stream.writeString(this.myValue);
        String rawXmlValue = this.getRawXmlValue();
        stream.writeString(Objects.equals(rawXmlValue, this.myValue) ? null : rawXmlValue);
    }

    static BasicValueResourceItem deserialize(Base128InputStream stream, ResourceType resourceType, String name2, ResourceVisibility visibility, ResourceSourceFile sourceFile, ResourceNamespace.Resolver resolver2) throws IOException {
        String value = stream.readString();
        String rawXmlValue = stream.readString();
        BasicValueResourceItem item = rawXmlValue == null ? new BasicValueResourceItem(resourceType, name2, sourceFile, visibility, value) : new BasicTextValueResourceItem(resourceType, name2, sourceFile, visibility, value, rawXmlValue);
        item.setNamespaceResolver(resolver2);
        return item;
    }
}

