/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.NameDetails;
import com.android.sdklib.SdkVersionInfo;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a1\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\b\u001a1\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000b\u001a1\u0010\f\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\r\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000b\u001a1\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\r\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\b\u001a\u001e\u0010\u000f\u001a\u00020\u0001*\u00020\u00102\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u001a \u0010\u0011\u001a\u00020\n*\u00020\u00102\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u0007\u001a\u001e\u0010\u0012\u001a\u00020\n*\u00020\u00102\b\b\u0002\u0010\r\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u001a\u001e\u0010\u0013\u001a\u00020\u0001*\u00020\u00102\b\b\u0002\u0010\r\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\u0014"}, d2={"computeApiNameAndDetails", "Lcom/android/sdklib/NameDetails;", "apiLevel", "", "extensionLevel", "includeReleaseName", "", "includeCodeName", "(ILjava/lang/Integer;ZZ)Lcom/android/sdklib/NameDetails;", "computeFullApiName", "", "(ILjava/lang/Integer;ZZ)Ljava/lang/String;", "computeFullReleaseName", "includeApiLevel", "computeReleaseNameAndDetails", "getApiNameAndDetails", "Lcom/android/sdklib/AndroidVersion;", "getFullApiName", "getFullReleaseName", "getReleaseNameAndDetails", "sdklib"})
@JvmName(name="AndroidVersionUtils")
public final class AndroidVersionUtils {
    @JvmOverloads
    @NotNull
    public static final String getFullApiName(@NotNull AndroidVersion $this$getFullApiName, boolean includeReleaseName, boolean includeCodeName) {
        Intrinsics.checkNotNullParameter($this$getFullApiName, "<this>");
        if ($this$getFullApiName.getCodename() != null) {
            return "API " + $this$getFullApiName.getCodename() + " Preview";
        }
        return AndroidVersionUtils.computeFullApiName($this$getFullApiName.getApiLevel(), $this$getFullApiName.isBaseExtension() ? null : $this$getFullApiName.getExtensionLevel(), includeReleaseName, includeCodeName);
    }

    public static /* synthetic */ String getFullApiName$default(AndroidVersion androidVersion, boolean bl2, boolean bl3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bl2 = false;
        }
        if ((n2 & 2) != 0) {
            bl3 = false;
        }
        return AndroidVersionUtils.getFullApiName(androidVersion, bl2, bl3);
    }

    @NotNull
    public static final NameDetails getApiNameAndDetails(@NotNull AndroidVersion $this$getApiNameAndDetails, boolean includeReleaseName, boolean includeCodeName) {
        Intrinsics.checkNotNullParameter($this$getApiNameAndDetails, "<this>");
        if ($this$getApiNameAndDetails.getCodename() != null) {
            return new NameDetails("API " + $this$getApiNameAndDetails.getCodename() + " Preview", null);
        }
        return AndroidVersionUtils.computeApiNameAndDetails($this$getApiNameAndDetails.getApiLevel(), $this$getApiNameAndDetails.isBaseExtension() ? null : $this$getApiNameAndDetails.getExtensionLevel(), includeReleaseName, includeCodeName);
    }

    public static /* synthetic */ NameDetails getApiNameAndDetails$default(AndroidVersion androidVersion, boolean bl2, boolean bl3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bl2 = false;
        }
        if ((n2 & 2) != 0) {
            bl3 = false;
        }
        return AndroidVersionUtils.getApiNameAndDetails(androidVersion, bl2, bl3);
    }

    @NotNull
    public static final String getFullReleaseName(@NotNull AndroidVersion $this$getFullReleaseName, boolean includeApiLevel, boolean includeCodeName) {
        Intrinsics.checkNotNullParameter($this$getFullReleaseName, "<this>");
        if ($this$getFullReleaseName.getCodename() != null) {
            return "Android " + $this$getFullReleaseName.getCodename() + " Preview";
        }
        return AndroidVersionUtils.computeFullReleaseName($this$getFullReleaseName.getApiLevel(), $this$getFullReleaseName.isBaseExtension() ? null : $this$getFullReleaseName.getExtensionLevel(), includeApiLevel, includeCodeName);
    }

    public static /* synthetic */ String getFullReleaseName$default(AndroidVersion androidVersion, boolean bl2, boolean bl3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bl2 = false;
        }
        if ((n2 & 2) != 0) {
            bl3 = false;
        }
        return AndroidVersionUtils.getFullReleaseName(androidVersion, bl2, bl3);
    }

    @NotNull
    public static final NameDetails getReleaseNameAndDetails(@NotNull AndroidVersion $this$getReleaseNameAndDetails, boolean includeApiLevel, boolean includeCodeName) {
        Intrinsics.checkNotNullParameter($this$getReleaseNameAndDetails, "<this>");
        if ($this$getReleaseNameAndDetails.getCodename() != null) {
            return new NameDetails("Android " + $this$getReleaseNameAndDetails.getCodename() + " Preview", null);
        }
        return AndroidVersionUtils.computeReleaseNameAndDetails($this$getReleaseNameAndDetails.getApiLevel(), $this$getReleaseNameAndDetails.isBaseExtension() ? null : $this$getReleaseNameAndDetails.getExtensionLevel(), includeApiLevel, includeCodeName);
    }

    public static /* synthetic */ NameDetails getReleaseNameAndDetails$default(AndroidVersion androidVersion, boolean bl2, boolean bl3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bl2 = false;
        }
        if ((n2 & 2) != 0) {
            bl3 = false;
        }
        return AndroidVersionUtils.getReleaseNameAndDetails(androidVersion, bl2, bl3);
    }

    @NotNull
    public static final String computeFullApiName(int apiLevel, @Nullable Integer extensionLevel, boolean includeReleaseName, boolean includeCodeName) {
        NameDetails nameDetails = AndroidVersionUtils.computeApiNameAndDetails(apiLevel, extensionLevel, includeReleaseName, includeCodeName);
        if (nameDetails.getDetails() != null) {
            return nameDetails.getName() + " (" + nameDetails.getDetails() + ")";
        }
        return nameDetails.getName();
    }

    public static /* synthetic */ String computeFullApiName$default(int n2, Integer n3, boolean bl2, boolean bl3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            bl2 = false;
        }
        if ((n4 & 8) != 0) {
            bl3 = false;
        }
        return AndroidVersionUtils.computeFullApiName(n2, n3, bl2, bl3);
    }

    @NotNull
    public static final NameDetails computeApiNameAndDetails(int apiLevel, @Nullable Integer extensionLevel, boolean includeReleaseName, boolean includeCodeName) {
        String codeName;
        String string2;
        StringBuilder name2 = new StringBuilder("API " + apiLevel);
        if (extensionLevel != null) {
            name2.append(" ext. " + extensionLevel);
        }
        boolean useCodeName = false;
        useCodeName = includeCodeName;
        if (includeReleaseName) {
            String codeName2;
            String string3;
            String relName = SdkVersionInfo.getReleaseVersionString(apiLevel);
            if (relName == null) {
                String string4 = SdkVersionInfo.getCodeName(apiLevel);
                if (string4 != null) {
                    String string5;
                    String it = string5 = string4;
                    boolean bl2 = false;
                    useCodeName = false;
                    string3 = string5;
                } else {
                    string3 = null;
                }
            } else {
                string3 = codeName2 = null;
            }
            if ((string2 = relName) == null) {
                string2 = codeName2;
            }
        } else {
            string2 = null;
        }
        String releaseName = string2;
        String string6 = codeName = useCodeName ? SdkVersionInfo.getCodeName(apiLevel) : null;
        if (codeName == null && releaseName == null) {
            String string7 = name2.toString();
            Intrinsics.checkNotNullExpressionValue(string7, "name.toString()");
            return new NameDetails(string7, null);
        }
        StringBuilder details = new StringBuilder();
        if (codeName != null) {
            details.append("\"" + codeName + "\"");
            if (releaseName != null) {
                details.append("; ");
            }
        }
        if (releaseName != null) {
            details.append("Android " + releaseName);
        }
        String string8 = name2.toString();
        Intrinsics.checkNotNullExpressionValue(string8, "name.toString()");
        return new NameDetails(string8, details.toString());
    }

    public static /* synthetic */ NameDetails computeApiNameAndDetails$default(int n2, Integer n3, boolean bl2, boolean bl3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            bl2 = false;
        }
        if ((n4 & 8) != 0) {
            bl3 = false;
        }
        return AndroidVersionUtils.computeApiNameAndDetails(n2, n3, bl2, bl3);
    }

    @NotNull
    public static final String computeFullReleaseName(int apiLevel, @Nullable Integer extensionLevel, boolean includeApiLevel, boolean includeCodeName) {
        NameDetails nameDetails = AndroidVersionUtils.computeReleaseNameAndDetails(apiLevel, extensionLevel, includeApiLevel, includeCodeName);
        if (nameDetails.getDetails() != null) {
            return nameDetails.getName() + " (" + nameDetails.getDetails() + ")";
        }
        return nameDetails.getName();
    }

    public static /* synthetic */ String computeFullReleaseName$default(int n2, Integer n3, boolean bl2, boolean bl3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            bl2 = false;
        }
        if ((n4 & 8) != 0) {
            bl3 = false;
        }
        return AndroidVersionUtils.computeFullReleaseName(n2, n3, bl2, bl3);
    }

    @NotNull
    public static final NameDetails computeReleaseNameAndDetails(int apiLevel, @Nullable Integer extensionLevel, boolean includeApiLevel, boolean includeCodeName) {
        String resolvedCodeName;
        StringBuilder name2 = new StringBuilder();
        String releaseName = SdkVersionInfo.getReleaseVersionString(apiLevel);
        if (releaseName == null) {
            String knownCodeName = SdkVersionInfo.getCodeName(apiLevel);
            if (knownCodeName != null) {
                name2.append("Android " + knownCodeName);
                if (includeApiLevel) {
                    name2.append(" (API \"" + apiLevel + "\"");
                    if (extensionLevel != null) {
                        name2.append(" ext. " + extensionLevel);
                    }
                    name2.append(")");
                }
            } else {
                name2.append("Android API " + apiLevel);
                if (includeApiLevel && extensionLevel != null) {
                    name2.append(" ext. " + extensionLevel);
                }
            }
            String string2 = name2.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "name.toString()");
            return new NameDetails(string2, null);
        }
        name2.append("Android " + releaseName);
        String string3 = resolvedCodeName = includeCodeName ? SdkVersionInfo.getCodeName(apiLevel) : null;
        if (resolvedCodeName == null && !includeApiLevel) {
            String string4 = name2.toString();
            Intrinsics.checkNotNullExpressionValue(string4, "name.toString()");
            return new NameDetails(string4, null);
        }
        StringBuilder details = new StringBuilder();
        if (resolvedCodeName != null) {
            details.append("\"" + resolvedCodeName + "\"");
            if (includeApiLevel) {
                details.append("; ");
            }
        }
        if (includeApiLevel) {
            details.append("API " + apiLevel);
            if (extensionLevel != null) {
                details.append(" ext. " + extensionLevel);
            }
        }
        String string5 = name2.toString();
        Intrinsics.checkNotNullExpressionValue(string5, "name.toString()");
        return new NameDetails(string5, details.toString());
    }

    public static /* synthetic */ NameDetails computeReleaseNameAndDetails$default(int n2, Integer n3, boolean bl2, boolean bl3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            bl2 = false;
        }
        if ((n4 & 8) != 0) {
            bl3 = false;
        }
        return AndroidVersionUtils.computeReleaseNameAndDetails(n2, n3, bl2, bl3);
    }

    @JvmOverloads
    @NotNull
    public static final String getFullApiName(@NotNull AndroidVersion $this$getFullApiName, boolean includeReleaseName) {
        Intrinsics.checkNotNullParameter($this$getFullApiName, "<this>");
        return AndroidVersionUtils.getFullApiName$default($this$getFullApiName, includeReleaseName, false, 2, null);
    }

    @JvmOverloads
    @NotNull
    public static final String getFullApiName(@NotNull AndroidVersion $this$getFullApiName) {
        Intrinsics.checkNotNullParameter($this$getFullApiName, "<this>");
        return AndroidVersionUtils.getFullApiName$default($this$getFullApiName, false, false, 3, null);
    }
}

