/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.android.SdkConstants;
import com.android.io.CancellableFileIo;
import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.utils.ILogger;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BuildToolInfo {
    private final Revision mRevision;
    private final Path mPath;
    private final Map<PathId, String> mPaths = Maps.newEnumMap(PathId.class);

    public static BuildToolInfo fromStandardDirectoryLayout(Revision revision, Path path) {
        return new BuildToolInfo(revision, path);
    }

    public static BuildToolInfo fromLocalPackage(LocalPackage localPackage) {
        Preconditions.checkNotNull(localPackage, "localPackage");
        Preconditions.checkArgument(localPackage.getPath().contains("build-tools"), "%s package required.", (Object)"build-tools");
        return BuildToolInfo.fromStandardDirectoryLayout(localPackage.getVersion(), localPackage.getLocation());
    }

    public static BuildToolInfo modifiedLayout(Revision revision, Path mainPath, Path aapt, Path aidl, Path llmvRsCc, Path androidRs, Path androidRsClang, Path bccCompat, Path ldArm, Path ldArm64, Path ldX86, Path ldX86_64, Path ldMips, Path lld, Path zipAlign, Path aapt2) {
        BuildToolInfo result2 = new BuildToolInfo(revision, mainPath);
        result2.add(PathId.AAPT, aapt);
        result2.add(PathId.AIDL, aidl);
        result2.add(PathId.LLVM_RS_CC, llmvRsCc);
        result2.add(PathId.ANDROID_RS, androidRs);
        result2.add(PathId.ANDROID_RS_CLANG, androidRsClang);
        result2.add(PathId.ZIP_ALIGN, zipAlign);
        if (bccCompat != null) {
            result2.add(PathId.BCC_COMPAT, bccCompat);
        } else if (PathId.BCC_COMPAT.isPresentIn(revision)) {
            throw new IllegalArgumentException("BCC_COMPAT required in " + revision.toString());
        }
        if (ldArm != null) {
            result2.add(PathId.LD_ARM, ldArm);
        } else if (PathId.LD_ARM.isPresentIn(revision)) {
            throw new IllegalArgumentException("LD_ARM required in " + revision.toString());
        }
        if (ldArm64 != null) {
            result2.add(PathId.LD_ARM64, ldArm64);
        } else if (PathId.LD_ARM64.isPresentIn(revision)) {
            throw new IllegalArgumentException("LD_ARM64 required in " + revision.toString());
        }
        if (ldX86 != null) {
            result2.add(PathId.LD_X86, ldX86);
        } else if (PathId.LD_X86.isPresentIn(revision)) {
            throw new IllegalArgumentException("LD_X86 required in " + revision.toString());
        }
        if (ldX86_64 != null) {
            result2.add(PathId.LD_X86_64, ldX86_64);
        } else if (PathId.LD_X86_64.isPresentIn(revision)) {
            throw new IllegalArgumentException("LD_X86_64 required in " + revision.toString());
        }
        if (ldMips != null) {
            result2.add(PathId.LD_MIPS, ldMips);
        } else if (PathId.LD_MIPS.isPresentIn(revision)) {
            throw new IllegalArgumentException("LD_MIPS required in " + revision.toString());
        }
        if (lld != null) {
            result2.add(PathId.LLD, lld);
        } else if (PathId.LLD.isPresentIn(revision)) {
            throw new IllegalArgumentException("LLD required in " + revision.toString());
        }
        if (aapt2 != null) {
            result2.add(PathId.AAPT2, aapt2);
            result2.add(PathId.DAEMON_AAPT2, aapt2);
        } else if (PathId.AAPT2.isPresentIn(revision)) {
            throw new IllegalArgumentException("AAPT2 required in " + revision.toString());
        }
        return result2;
    }

    public static BuildToolInfo partial(Revision revision, Path location, Map<PathId, Path> paths2) {
        BuildToolInfo result2 = new BuildToolInfo(revision, location);
        paths2.forEach(result2::add);
        return result2;
    }

    private BuildToolInfo(Revision revision, Path path) {
        this.mRevision = revision;
        this.mPath = path;
        this.add(PathId.AAPT, SdkConstants.FN_AAPT);
        this.add(PathId.AAPT2, SdkConstants.FN_AAPT2);
        this.add(PathId.DAEMON_AAPT2, SdkConstants.FN_AAPT2);
        this.add(PathId.AIDL, SdkConstants.FN_AIDL);
        this.add(PathId.LLVM_RS_CC, SdkConstants.FN_RENDERSCRIPT);
        this.add(PathId.ANDROID_RS, SdkConstants.OS_FRAMEWORK_RS);
        this.add(PathId.ANDROID_RS_CLANG, SdkConstants.OS_FRAMEWORK_RS_CLANG);
        this.add(PathId.DEXDUMP, SdkConstants.FN_DEXDUMP);
        this.add(PathId.BCC_COMPAT, SdkConstants.FN_BCC_COMPAT);
        this.add(PathId.LD_ARM, SdkConstants.FN_LD_ARM);
        this.add(PathId.LD_ARM64, SdkConstants.FN_LD_ARM64);
        this.add(PathId.LD_X86, SdkConstants.FN_LD_X86);
        this.add(PathId.LD_X86_64, SdkConstants.FN_LD_X86_64);
        this.add(PathId.LD_MIPS, SdkConstants.FN_LD_MIPS);
        this.add(PathId.LLD, SdkConstants.FN_LLD);
        this.add(PathId.ZIP_ALIGN, SdkConstants.FN_ZIPALIGN);
        this.add(PathId.JACK, "jack.jar");
        this.add(PathId.JILL, "jill.jar");
        this.add(PathId.JACK_JACOCO_REPORTER, "jack-jacoco-reporter.jar");
        this.add(PathId.JACK_COVERAGE_PLUGIN, "jack-coverage-plugin.jar");
        this.add(PathId.SPLIT_SELECT, SdkConstants.FN_SPLIT_SELECT);
        this.add(PathId.CORE_LAMBDA_STUBS, "core-lambda-stubs.jar");
    }

    private void add(PathId id2, String leaf) {
        this.add(id2, this.mPath.resolve(leaf));
    }

    private void add(PathId id2, Path path) {
        Object str = path.toAbsolutePath().toString();
        if (CancellableFileIo.isDirectory(path, new LinkOption[0]) && ((String)str).charAt(((String)str).length() - 1) != File.separatorChar) {
            str = (String)str + File.separatorChar;
        }
        this.mPaths.put(id2, (String)str);
    }

    public Revision getRevision() {
        return this.mRevision;
    }

    public Path getLocation() {
        return this.mPath;
    }

    public String getPath(PathId pathId) {
        assert (pathId.isPresentIn(this.mRevision));
        return this.mPaths.get((Object)pathId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValid(ILogger log) {
        Map.Entry<PathId, String> entry;
        File f2;
        Path sourceProperties = this.mPath.resolve("source.properties");
        try (BufferedInputStream is = new BufferedInputStream(Files.newInputStream(sourceProperties, new OpenOption[0]));){
            Properties properties = new Properties();
            properties.load(is);
            String revision = properties.getProperty("Pkg.Revision");
            if (!this.mRevision.equals(Revision.parseRevision(revision))) {
                if (log != null) {
                    log.warning("Build-tool %1$s has inconsistent revision, expected %1$s but got %2$s in %3$s", this.mRevision.toString(), revision, this.mPath);
                }
                boolean bl2 = false;
                return bl2;
            }
        }
        catch (IOException | NumberFormatException e2) {
            if (log == null) return false;
            log.warning("Build-tool %1$s has corrupt source.properties at %2$s", this.mRevision.toString(), this.mPath);
            return false;
        }
        Iterator<Map.Entry<PathId, String>> iterator2 = this.mPaths.entrySet().iterator();
        do {
            if (!iterator2.hasNext()) return true;
        } while ((f2 = new File((entry = iterator2.next()).getValue())).exists() || !entry.getKey().isPresentIn(this.mRevision));
        if (log == null) return false;
        log.warning("Build-tool %1$s is missing %2$s at %3$s", new Object[]{this.mRevision.toString(), entry.getKey(), f2.getAbsolutePath()});
        return false;
    }

    @VisibleForTesting
    static Revision getCurrentJvmVersion() throws NumberFormatException {
        String javav = System.getProperty("java.version");
        Pattern p2 = Pattern.compile("((\\d+)(\\.\\d+)?(\\.\\d+)?).*");
        Matcher m4 = p2.matcher(javav);
        if (m4.matches()) {
            return Revision.parseRevision(m4.group(1));
        }
        return null;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("rev", this.mRevision).add("mPath", this.mPath).add("mPaths", this.getPathString()).toString();
    }

    private String getPathString() {
        StringBuilder sb = new StringBuilder("{");
        for (Map.Entry<PathId, String> entry : this.mPaths.entrySet()) {
            if (!entry.getKey().isPresentIn(this.mRevision)) continue;
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append((Object)entry.getKey()).append('=').append(entry.getValue());
        }
        sb.append('}');
        return sb.toString();
    }

    public static enum PathId {
        AAPT("1.0.0"),
        AIDL("1.0.0"),
        LLVM_RS_CC("1.0.0", "32.0.0"),
        ANDROID_RS("1.0.0", "32.0.0"),
        ANDROID_RS_CLANG("1.0.0", "32.0.0"),
        DEXDUMP("1.0.0"),
        BCC_COMPAT("18.1.0", "32.0.0"),
        LD_ARM("18.1.0", "30.0.0 rc4"),
        LD_X86("18.1.0", "30.0.0 rc4"),
        LD_MIPS("18.1.0", "30.0.0 rc4"),
        ZIP_ALIGN("19.1.0"),
        JACK("21.1.0", "28.0.0 rc1"),
        JILL("21.1.0", "28.0.0 rc1"),
        SPLIT_SELECT("22.0.0"),
        LD_ARM64("23.0.3", "30.0.0 rc4"),
        JACK_JACOCO_REPORTER("24.0.0", "28.0.0 rc1"),
        JACK_COVERAGE_PLUGIN("24.0.0", "28.0.0 rc1"),
        LD_X86_64("24.0.0", "30.0.0 rc4"),
        AAPT2("24.0.0 rc2"),
        LLD("29.0.3", "32.0.0"),
        DAEMON_AAPT2("26.0.2"),
        CORE_LAMBDA_STUBS("27.0.3");

        private final Revision minRevision;
        private final Revision removalRevision;

        private PathId(String minRevision) {
            this(minRevision, null);
        }

        private PathId(String minRevision, String removalRevision) {
            this.minRevision = Revision.parseRevision(minRevision);
            this.removalRevision = removalRevision != null ? Revision.parseRevision(removalRevision) : null;
        }

        public boolean isPresentIn(Revision revision) {
            return revision.compareTo(this.minRevision) >= 0 && (this.removalRevision == null || revision.compareTo(this.removalRevision) < 0);
        }
    }
}

