/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.devices;

import com.android.sdklib.devices.CameraLocation;

public class Camera {
    private CameraLocation mLocation;
    private boolean mAutofocus;
    private boolean mFlash;

    public Camera() {
        this(CameraLocation.BACK, true, true);
    }

    public Camera(CameraLocation location, boolean autofocus, boolean flash) {
        this.mLocation = location;
        this.mAutofocus = autofocus;
        this.mFlash = flash;
    }

    public CameraLocation getLocation() {
        return this.mLocation;
    }

    public void setLocation(CameraLocation location) {
        this.mLocation = location;
    }

    public boolean hasAutofocus() {
        return this.mAutofocus;
    }

    public void setAutofocus(boolean hasAutofocus) {
        this.mAutofocus = hasAutofocus;
    }

    public boolean hasFlash() {
        return this.mFlash;
    }

    public void setFlash(boolean flash) {
        this.mFlash = flash;
    }

    public Camera deepCopy() {
        Camera c2 = new Camera();
        c2.mLocation = this.mLocation;
        c2.mAutofocus = this.mAutofocus;
        c2.mFlash = this.mFlash;
        return c2;
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof Camera)) {
            return false;
        }
        Camera c2 = (Camera)o2;
        return this.mLocation == c2.mLocation && this.mAutofocus == c2.hasAutofocus() && this.mFlash == c2.hasFlash();
    }

    public int hashCode() {
        int hash = 17;
        hash = 31 * hash + this.mLocation.ordinal();
        hash = 31 * hash + (this.mAutofocus ? 1 : 0);
        hash = 31 * hash + (this.mFlash ? 1 : 0);
        return hash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Camera <mLocation=");
        sb.append((Object)this.mLocation);
        sb.append(", mAutofocus=");
        sb.append(this.mAutofocus);
        sb.append(", mFlash=");
        sb.append(this.mFlash);
        sb.append(">");
        return sb.toString();
    }
}

