/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.devices;

import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceParser;
import com.android.utils.ILogger;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.io.Closeables;
import java.io.InputStream;

public class DefaultDevices {
    private final ILogger mLog;
    private Table<String, String, Device> mDefaultDevices;

    public DefaultDevices(ILogger log) {
        this.mLog = log;
    }

    public synchronized boolean init() {
        if (this.mDefaultDevices != null) {
            return false;
        }
        InputStream stream = DefaultDevices.class.getResourceAsStream("devices.xml");
        try {
            assert (stream != null) : "devices.xml not bundled in sdklib.";
            this.mDefaultDevices = DeviceParser.parse(stream);
            boolean bl2 = true;
            return bl2;
        }
        catch (IllegalStateException e2) {
            this.mLog.error(e2, null, new Object[0]);
            this.mDefaultDevices = HashBasedTable.create();
        }
        catch (Exception e3) {
            this.mLog.error(e3, "Error reading default devices", new Object[0]);
            this.mDefaultDevices = HashBasedTable.create();
        }
        finally {
            Closeables.closeQuietly(stream);
        }
        return false;
    }

    public Device getDevice(String id2, String manufacturer) {
        return this.mDefaultDevices.get(id2, manufacturer);
    }

    public Table<String, String, Device> getDevices() {
        return this.mDefaultDevices;
    }
}

