/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.devices;

import com.android.dvlib.DeviceSchema;
import com.android.resources.ScreenRound;
import com.android.resources.UiMode;
import com.android.sdklib.devices.Camera;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Meta;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.Software;
import com.android.sdklib.devices.State;
import com.android.sdklib.devices.Storage;
import java.awt.Point;
import java.io.File;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DeviceWriter {
    public static final String LOCAL_NS = "d";
    public static final String PREFIX = "d:";

    private DeviceWriter() {
    }

    public static void writeToXml(OutputStream out, Collection<Device> devices) throws ParserConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element root = doc.createElement("d:devices");
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttribute("xmlns:d", DeviceSchema.NS_DEVICES_URI);
        doc.appendChild(root);
        for (Device device : devices) {
            String tagId;
            Element deviceNode = doc.createElement("d:device");
            root.appendChild(deviceNode);
            Element name2 = doc.createElement("d:name");
            String displayName = device.getDisplayName();
            name2.appendChild(doc.createTextNode(displayName));
            deviceNode.appendChild(name2);
            String deviceId = device.getId();
            if (!deviceId.equals(displayName)) {
                Element id2 = doc.createElement("d:id");
                id2.appendChild(doc.createTextNode(deviceId));
                deviceNode.appendChild(id2);
            }
            Element manufacturer = doc.createElement("d:manufacturer");
            manufacturer.appendChild(doc.createTextNode(device.getManufacturer()));
            deviceNode.appendChild(manufacturer);
            deviceNode.appendChild(DeviceWriter.generateMetaNode(device.getMeta(), doc));
            deviceNode.appendChild(DeviceWriter.generateHardwareNode(device.getDefaultHardware(), doc));
            for (Software software : device.getAllSoftware()) {
                deviceNode.appendChild(DeviceWriter.generateSoftwareNode(software, doc));
            }
            boolean deviceIsRound = false;
            for (State s2 : device.getAllStates()) {
                deviceNode.appendChild(DeviceWriter.generateStateNode(s2, doc, device.getDefaultHardware()));
                Screen theScreen = s2.getHardware().getScreen();
                if (theScreen == null || !ScreenRound.ROUND.equals(theScreen.getScreenRound())) continue;
                deviceIsRound = true;
            }
            TreeMap<String, String> treeMap = new TreeMap<String, String>(device.getBootProps());
            if (deviceIsRound) {
                treeMap.put("ro.emulator.circular", "true");
            }
            if ((tagId = device.getTagId()) != null) {
                Element e2 = doc.createElement("d:tag-id");
                e2.appendChild(doc.createTextNode(tagId));
                deviceNode.appendChild(e2);
            }
            if (treeMap.isEmpty()) continue;
            Element props = doc.createElement("d:boot-props");
            for (Map.Entry bootProp : treeMap.entrySet()) {
                Element prop = doc.createElement("d:boot-prop");
                Element propName = doc.createElement("d:prop-name");
                propName.appendChild(doc.createTextNode((String)bootProp.getKey()));
                Element propValue = doc.createElement("d:prop-value");
                propValue.appendChild(doc.createTextNode((String)bootProp.getValue()));
                prop.appendChild(propName);
                prop.appendChild(propValue);
                props.appendChild(prop);
            }
            deviceNode.appendChild(props);
        }
        Transformer tf = TransformerFactory.newInstance().newTransformer();
        tf.setOutputProperty("indent", "yes");
        tf.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        DOMSource source = new DOMSource(doc);
        StreamResult result2 = new StreamResult(out);
        tf.transform(source, result2);
    }

    private static Node generateMetaNode(Meta meta, Document doc) {
        Element m4 = doc.createElement("d:meta");
        if (meta.hasIconSixtyFour() || meta.hasIconSixteen()) {
            Element icons = doc.createElement("d:icons");
            m4.appendChild(icons);
            if (meta.hasIconSixtyFour()) {
                DeviceWriter.addElement(doc, icons, "sixty-four", meta.getIconSixtyFour().toString());
            }
            if (meta.hasIconSixteen()) {
                DeviceWriter.addElement(doc, icons, "sixteen", meta.getIconSixteen().toString());
            }
        }
        if (meta.hasFrame()) {
            Element frame = doc.createElement("d:frame");
            DeviceWriter.addElement(doc, frame, "path", meta.getFrame().toString());
            Point offset = meta.getFrameOffsetPortrait();
            DeviceWriter.addElement(doc, frame, "portrait-x-offset", Integer.toString(offset.x));
            DeviceWriter.addElement(doc, frame, "portrait-y-offset", Integer.toString(offset.y));
            offset = meta.getFrameOffsetLandscape();
            DeviceWriter.addElement(doc, frame, "landscape-x-offset", Integer.toString(offset.x));
            DeviceWriter.addElement(doc, frame, "landscape-y-offset", Integer.toString(offset.y));
        }
        return m4;
    }

    private static Element generateHardwareNode(Hardware hw, Document doc) {
        Screen s2 = hw.getScreen();
        Element hardware = doc.createElement("d:hardware");
        Element screen = doc.createElement("d:screen");
        hardware.appendChild(screen);
        DeviceWriter.addElement(doc, screen, "screen-size", s2.getSize().getResourceValue());
        DeviceWriter.addElement(doc, screen, "diagonal-length", String.format(Locale.US, "%.2f", s2.getDiagonalLength()));
        DeviceWriter.addElement(doc, screen, "pixel-density", s2.getPixelDensity().getResourceValue());
        DeviceWriter.addElement(doc, screen, "screen-ratio", s2.getRatio().getResourceValue());
        Element dimensions = doc.createElement("d:dimensions");
        screen.appendChild(dimensions);
        DeviceWriter.addElement(doc, dimensions, "x-dimension", Integer.toString(s2.getXDimension()));
        DeviceWriter.addElement(doc, dimensions, "y-dimension", Integer.toString(s2.getYDimension()));
        DeviceWriter.addElement(doc, screen, "xdpi", String.format(Locale.US, "%.2f", s2.getXdpi()));
        DeviceWriter.addElement(doc, screen, "ydpi", String.format(Locale.US, "%.2f", s2.getYdpi()));
        Element touch = doc.createElement("d:touch");
        screen.appendChild(touch);
        DeviceWriter.addElement(doc, touch, "multitouch", s2.getMultitouch().toString());
        DeviceWriter.addElement(doc, touch, "mechanism", s2.getMechanism().getResourceValue());
        DeviceWriter.addElement(doc, touch, "screen-type", s2.getScreenType().toString());
        DeviceWriter.addElement(doc, hardware, "networking", hw.getNetworking());
        DeviceWriter.addElement(doc, hardware, "sensors", hw.getSensors());
        DeviceWriter.addElement(doc, hardware, "mic", Boolean.toString(hw.hasMic()));
        for (Camera c2 : hw.getCameras()) {
            Element camera = doc.createElement("d:camera");
            hardware.appendChild(camera);
            DeviceWriter.addElement(doc, camera, "location", c2.getLocation().toString());
            DeviceWriter.addElement(doc, camera, "autofocus", Boolean.toString(c2.hasAutofocus()));
            DeviceWriter.addElement(doc, camera, "flash", Boolean.toString(c2.hasFlash()));
        }
        DeviceWriter.addElement(doc, hardware, "keyboard", hw.getKeyboard().getResourceValue());
        DeviceWriter.addElement(doc, hardware, "nav", hw.getNav().getResourceValue());
        Storage.Unit unit = hw.getRam().getAppropriateUnits();
        Element ram = DeviceWriter.addElement(doc, hardware, "ram", Long.toString(hw.getRam().getSizeAsUnit(unit)));
        ram.setAttribute("unit", unit.toString());
        DeviceWriter.addElement(doc, hardware, "buttons", hw.getButtonType().toString());
        DeviceWriter.addStorageElement(doc, hardware, "internal-storage", hw.getInternalStorage());
        DeviceWriter.addStorageElement(doc, hardware, "removable-storage", hw.getRemovableStorage());
        DeviceWriter.addElement(doc, hardware, "cpu", hw.getCpu());
        DeviceWriter.addElement(doc, hardware, "gpu", hw.getGpu());
        if (hw.getSupportedAbis().size() > 0) {
            DeviceWriter.addElement(doc, hardware, "abi", hw.getSupportedAbis().get(0).toString());
        }
        hw.getSupportedAbis().forEach(abi -> DeviceWriter.addElement(doc, hardware, "abis", abi.toString()));
        hw.getTranslatedAbis().forEach(abi -> DeviceWriter.addElement(doc, hardware, "translatedAbis", abi.toString()));
        StringBuilder sb = new StringBuilder();
        for (UiMode u2 : hw.getSupportedUiModes()) {
            sb.append('\n').append(u2.getResourceValue());
        }
        DeviceWriter.addElement(doc, hardware, "dock", sb.toString());
        DeviceWriter.addElement(doc, hardware, "power-type", hw.getChargeType().toString());
        File skinPath = hw.getSkinFile();
        if (skinPath != null) {
            String canonicalPath = skinPath.getPath().replace(File.separatorChar, '/');
            DeviceWriter.addElement(doc, hardware, "skin", canonicalPath);
        }
        return hardware;
    }

    private static Element generateSoftwareNode(Software sw, Document doc) {
        Element software = doc.createElement("d:software");
        Object apiVersion = "";
        if (sw.getMinSdkLevel() != 0) {
            apiVersion = (String)apiVersion + Integer.toString(sw.getMinSdkLevel());
        }
        apiVersion = (String)apiVersion + "-";
        if (sw.getMaxSdkLevel() != Integer.MAX_VALUE) {
            apiVersion = (String)apiVersion + Integer.toString(sw.getMaxSdkLevel());
        }
        DeviceWriter.addElement(doc, software, "api-level", (String)apiVersion);
        DeviceWriter.addElement(doc, software, "live-wallpaper-support", Boolean.toString(sw.hasLiveWallpaperSupport()));
        DeviceWriter.addElement(doc, software, "bluetooth-profiles", sw.getBluetoothProfiles());
        DeviceWriter.addElement(doc, software, "gl-version", sw.getGlVersion());
        DeviceWriter.addElement(doc, software, "gl-extensions", sw.getGlExtensions());
        DeviceWriter.addElement(doc, software, "status-bar", Boolean.toString(sw.hasStatusBar()));
        return software;
    }

    private static Element generateStateNode(State s2, Document doc, Hardware defaultHardware) {
        Element state = doc.createElement("d:state");
        state.setAttribute("name", s2.getName());
        if (s2.isDefaultState()) {
            state.setAttribute("default", Boolean.toString(s2.isDefaultState()));
        }
        DeviceWriter.addElement(doc, state, "description", s2.getDescription());
        DeviceWriter.addElement(doc, state, "screen-orientation", s2.getOrientation().getResourceValue());
        DeviceWriter.addElement(doc, state, "keyboard-state", s2.getKeyState().getResourceValue());
        DeviceWriter.addElement(doc, state, "nav-state", s2.getNavState().getResourceValue());
        if (!s2.getHardware().equals(defaultHardware)) {
            Element hardware = DeviceWriter.generateHardwareNode(s2.getHardware(), doc);
            NodeList children2 = hardware.getChildNodes();
            while (children2.getLength() > 0) {
                Node child = children2.item(0);
                state.appendChild(child);
            }
        }
        return state;
    }

    private static Element addElement(Document doc, Element parent, String tag, String content) {
        Element child = doc.createElement(PREFIX + tag);
        child.appendChild(doc.createTextNode(content));
        parent.appendChild(child);
        return child;
    }

    private static Element addElement(Document doc, Element parent, String tag, Collection<?> content) {
        StringBuilder sb = new StringBuilder();
        for (Object o2 : content) {
            sb.append('\n').append(o2.toString());
        }
        return DeviceWriter.addElement(doc, parent, tag, sb.toString());
    }

    private static Element addStorageElement(Document doc, Element parent, String tag, Collection<Storage> content) {
        Storage.Unit unit = Storage.Unit.TiB;
        for (Storage storage : content) {
            if (storage.getAppropriateUnits().getNumberOfBytes() >= unit.getNumberOfBytes()) continue;
            unit = storage.getAppropriateUnits();
        }
        StringBuilder sb = new StringBuilder();
        for (Storage storage3 : content) {
            sb.append('\n').append(storage3.getSizeAsUnit(unit));
        }
        Element element = DeviceWriter.addElement(doc, parent, tag, sb.toString());
        element.setAttribute("unit", unit.toString());
        return element;
    }
}

