/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.avd;

import com.android.io.CancellableFileIo;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.PathFileWrapper;
import com.android.sdklib.SystemImageTags;
import com.android.sdklib.internal.avd.AvdManager;
import com.android.sdklib.repository.IdDisplay;
import com.android.utils.ILogger;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public final class AvdInfo {
    private final String mName;
    private final Path mIniFile;
    private final Path mFolderPath;
    private final ImmutableMap<String, String> mProperties;
    private final ImmutableMap<String, String> mUserSettings;
    private final AvdStatus mStatus;
    private final ISystemImage mSystemImage;

    public AvdInfo(String name2, Path iniFile, Path folderPath, ISystemImage systemImage, Map<String, String> properties, Map<String, String> userSettings) {
        this(name2, iniFile, folderPath, systemImage, properties, userSettings, AvdStatus.OK);
    }

    public AvdInfo(String name2, Path iniFile, Path folderPath, ISystemImage systemImage, Map<String, String> properties, Map<String, String> userSettings, AvdStatus status) {
        this.mName = name2;
        this.mIniFile = iniFile;
        this.mFolderPath = folderPath;
        this.mSystemImage = systemImage;
        this.mProperties = properties == null ? ImmutableMap.of() : ImmutableMap.copyOf(properties);
        this.mUserSettings = userSettings == null ? ImmutableMap.of() : ImmutableMap.copyOf(Maps.filterValues(userSettings, Objects::nonNull));
        this.mStatus = status;
    }

    public String getId() {
        return this.mFolderPath.toString();
    }

    public String getName() {
        return this.mName;
    }

    public String getDisplayName() {
        String name2 = this.getProperties().get("avd.ini.displayname");
        return name2 == null ? this.mName.replace('_', ' ') : name2;
    }

    public Path getDataFolderPath() {
        return this.mFolderPath;
    }

    public IdDisplay getTag() {
        String id2 = this.getProperties().get("tag.id");
        if (id2 == null) {
            return SystemImageTags.DEFAULT_TAG;
        }
        String display = this.getProperties().get("tag.display");
        return IdDisplay.create(id2, display == null ? id2 : display);
    }

    public ImmutableList<IdDisplay> getTags() {
        String ids2 = this.getProperties().get("tag.ids");
        if (ids2 == null) {
            return ImmutableList.of(this.getTag());
        }
        String displays = Strings.nullToEmpty(this.getProperties().get("tag.displaynames"));
        return Streams.zip(Splitter.on(",").splitToStream(ids2), Stream.concat(Splitter.on(",").splitToStream(displays), Stream.generate(() -> "")), (id2, display) -> IdDisplay.create(id2, display.isEmpty() ? id2 : display)).collect(ImmutableList.toImmutableList());
    }

    public String getAbiType() {
        return this.getProperties().get("abi.type");
    }

    public boolean hasPlayStore() {
        String psString = this.mProperties.get("PlayStore.enabled");
        return "true".equalsIgnoreCase(psString) || "yes".equalsIgnoreCase(psString);
    }

    public AndroidVersion getAndroidVersion() {
        Map<String, String> properties = this.getProperties();
        String apiStr = properties.get("image.androidVersion.api");
        String codename = properties.get("image.androidVersion.codename");
        int api = 1;
        if (!Strings.isNullOrEmpty(apiStr)) {
            try {
                api = Integer.parseInt(apiStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String extStr = properties.get("image.androidVersion.extension");
        int extension = 1;
        if (!Strings.isNullOrEmpty(extStr)) {
            try {
                extension = Integer.parseInt(extStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String isBaseStr = properties.get("image.androidVersion.isBaseExtension");
        boolean isBase = true;
        if (!Strings.isNullOrEmpty(isBaseStr)) {
            isBase = Boolean.parseBoolean(isBaseStr);
        }
        return new AndroidVersion(api, codename, extension, isBase);
    }

    public String getCpuArch() {
        String cpuArch = this.mProperties.get("hw.cpu.arch");
        if (cpuArch != null) {
            return cpuArch;
        }
        return "arm";
    }

    public String getDeviceManufacturer() {
        String deviceManufacturer = this.mProperties.get("hw.device.manufacturer");
        if (deviceManufacturer != null && !deviceManufacturer.isEmpty()) {
            return deviceManufacturer;
        }
        return "";
    }

    public String getDeviceName() {
        String deviceName = this.mProperties.get("hw.device.name");
        if (deviceName != null && !deviceName.isEmpty()) {
            return deviceName;
        }
        return "";
    }

    public ISystemImage getSystemImage() {
        return this.mSystemImage;
    }

    public AvdStatus getStatus() {
        return this.mStatus;
    }

    public static Path getDefaultAvdFolder(AvdManager manager, String avdName, boolean unique) {
        Path base = manager.getBaseAvdFolder();
        Path result2 = base.resolve(avdName + ".avd");
        if (unique) {
            int suffix = 0;
            while (CancellableFileIo.exists(result2, new LinkOption[0])) {
                result2 = base.resolve(String.format("%s_%d%s", avdName, ++suffix, ".avd"));
            }
        }
        return result2;
    }

    public static Path getDefaultIniFile(AvdManager manager, String avdName) {
        Path avdRoot = manager.getBaseAvdFolder();
        return avdRoot.resolve(avdName + ".ini");
    }

    public Path getIniFile() {
        return this.mIniFile;
    }

    public static Path getConfigFile(Path path) {
        return path.resolve("config.ini");
    }

    public static Path getUserSettingsPath(Path dataFolder) {
        return dataFolder.resolve("user-settings.ini");
    }

    static Map<String, String> parseUserSettingsFile(Path dataFolder, ILogger logger) {
        Map<String, String> parsedSettings;
        PathFileWrapper settingsPath = new PathFileWrapper(AvdInfo.getUserSettingsPath(dataFolder));
        if (settingsPath.exists() && (parsedSettings = AvdManager.parseIniFile(settingsPath, logger)) != null) {
            return parsedSettings;
        }
        return new HashMap<String, String>();
    }

    public Map<String, String> getUserSettings() {
        return this.mUserSettings;
    }

    public Path getConfigFile() {
        return AvdInfo.getConfigFile(this.mFolderPath);
    }

    public String getProperty(String propertyName) {
        return this.mProperties.get(propertyName);
    }

    public Map<String, String> getProperties() {
        return this.mProperties;
    }

    public String getErrorMessage() {
        switch (this.mStatus) {
            case ERROR_PATH: {
                return String.format("Missing AVD 'path' property in %1$s", this.getIniFile());
            }
            case ERROR_CONFIG: {
                return String.format("Missing config.ini file in %1$s", this.mFolderPath);
            }
            case ERROR_PROPERTIES: {
                return String.format("Failed to parse properties from %1$s", this.getConfigFile());
            }
            case ERROR_IMAGE_DIR: 
            case ERROR_IMAGE_MISSING: {
                return String.format("Missing system image for %s%s %s.", SystemImageTags.DEFAULT_TAG.equals(this.getTag()) ? "" : this.getTag().getDisplay() + " ", this.getAbiType(), this.mName);
            }
            case ERROR_DEVICE_CHANGED: {
                return String.format("%1$s %2$s configuration has changed since AVD creation", this.mProperties.get("hw.device.manufacturer"), this.mProperties.get("hw.device.name"));
            }
            case ERROR_DEVICE_MISSING: {
                return String.format("%1$s %2$s no longer exists as a device", this.mProperties.get("hw.device.manufacturer"), this.mProperties.get("hw.device.name"));
            }
            case ERROR_CORRUPTED_INI: {
                return String.format("Corrupted AVD ini file: %1$s", this.getIniFile());
            }
            case OK: {
                return null;
            }
        }
        return null;
    }

    public boolean isSameMetadata(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        AvdInfo avdInfo = (AvdInfo)o2;
        return this.mName.equals(avdInfo.mName) && this.mUserSettings.equals(avdInfo.mUserSettings);
    }

    public AvdInfo copyMetadata(AvdInfo other) {
        return new AvdInfo(other.getName(), this.getIniFile(), this.getDataFolderPath(), this.getSystemImage(), this.getProperties(), other.getUserSettings(), this.getStatus());
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        AvdInfo avdInfo = (AvdInfo)o2;
        return this.mName.equals(avdInfo.mName) && this.mIniFile.equals(avdInfo.mIniFile) && this.mFolderPath.equals(avdInfo.mFolderPath) && this.mProperties.equals(avdInfo.mProperties) && this.mUserSettings.equals(avdInfo.mUserSettings) && this.mStatus == avdInfo.mStatus && Objects.equals(this.mSystemImage, avdInfo.mSystemImage);
    }

    public int hashCode() {
        int hashCode = this.mName.hashCode();
        hashCode = 31 * hashCode + this.mIniFile.hashCode();
        hashCode = 31 * hashCode + this.mFolderPath.hashCode();
        hashCode = 31 * hashCode + this.mProperties.hashCode();
        hashCode = 31 * hashCode + this.mUserSettings.hashCode();
        hashCode = 31 * hashCode + this.mStatus.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.mSystemImage);
        return hashCode;
    }

    public String toDebugString() {
        String separator = System.lineSeparator();
        return "mName = " + this.mName + separator + "mIniFile = " + this.mIniFile + separator + "mFolderPath = " + this.mFolderPath + separator + "mProperties = " + this.mProperties + separator + "mUserSettings = " + this.mUserSettings + separator + "mStatus = " + this.mStatus + separator + "mSystemImage = " + this.mSystemImage + separator;
    }

    public static enum AvdStatus {
        OK,
        ERROR_PATH,
        ERROR_CONFIG,
        ERROR_PROPERTIES,
        ERROR_IMAGE_DIR,
        ERROR_DEVICE_CHANGED,
        ERROR_DEVICE_MISSING,
        ERROR_IMAGE_MISSING,
        ERROR_CORRUPTED_INI;

    }
}

