/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository;

import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.SdkCommonFactory;
import com.google.common.collect.Comparators;
import java.util.Comparator;
import java.util.Locale;
import javax.xml.bind.annotation.XmlTransient;

@XmlTransient
public abstract class IdDisplay
implements Comparable<IdDisplay> {
    public static Comparator<Iterable<IdDisplay>> ID_DISPLAY_LIST_COMPARATOR = Comparators.lexicographical(Comparator.naturalOrder());

    public static IdDisplay create(String id2, String display) {
        SdkCommonFactory factory = AndroidSdkHandler.getCommonModule().createLatestFactory();
        IdDisplay result2 = factory.createIdDisplayType();
        result2.setId(id2);
        result2.setDisplay(display);
        return result2;
    }

    public abstract void setId(String var1);

    public abstract void setDisplay(String var1);

    public abstract String getId();

    public abstract String getDisplay();

    @Override
    public int compareTo(IdDisplay o2) {
        return this.getId().compareTo(o2.getId());
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof IdDisplay)) {
            return false;
        }
        return this.compareTo((IdDisplay)o2) == 0;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return String.format("%1$s [%2$s]", this.getId(), this.getDisplay());
    }

    public static String idToDisplay(String id2) {
        char c2;
        String name2 = id2.replaceAll("[^A-Za-z0-9]+", " ");
        name2 = name2.replaceAll(" +", " ");
        if (!(name2 = name2.trim()).isEmpty() && !Character.isUpperCase(c2 = name2.charAt(0))) {
            StringBuilder sb = new StringBuilder(name2);
            sb.replace(0, 1, String.valueOf(c2).toUpperCase(Locale.US));
            name2 = sb.toString();
        }
        return name2;
    }
}

