/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.legacy.remote.internal.archives;

import com.android.sdklib.repository.legacy.remote.RemotePkgInfo;
import com.android.sdklib.repository.legacy.remote.internal.archives.ArchFilter;
import com.android.sdklib.repository.legacy.remote.internal.archives.BitSize;
import com.android.sdklib.repository.legacy.remote.internal.archives.ChecksumType;
import com.android.sdklib.repository.legacy.remote.internal.archives.HostOs;
import java.util.Properties;

@Deprecated
public class Archive
implements Comparable<Archive> {
    private final String mUrl;
    private final long mSize;
    private final String mChecksum;
    private final ChecksumType mChecksumType = ChecksumType.SHA1;
    private final RemotePkgInfo mPackage;
    private final ArchFilter mArchFilter;

    public Archive(RemotePkgInfo pkg, ArchFilter archFilter, String url, long size, String checksum) {
        this.mPackage = pkg;
        this.mArchFilter = archFilter != null ? archFilter : new ArchFilter(null);
        this.mUrl = url == null ? null : url.trim();
        this.mSize = size;
        this.mChecksum = checksum;
    }

    void saveProperties(Properties props) {
        this.mArchFilter.saveProperties(props);
    }

    public RemotePkgInfo getParentPackage() {
        return this.mPackage;
    }

    public long getSize() {
        return this.mSize;
    }

    public String getChecksum() {
        return this.mChecksum;
    }

    public ChecksumType getChecksumType() {
        return this.mChecksumType;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public ArchFilter getArchFilter() {
        return this.mArchFilter;
    }

    public String getOsDescription() {
        BitSize hostBits;
        StringBuilder sb = new StringBuilder();
        HostOs hos = this.mArchFilter.getHostOS();
        sb.append(hos == null ? "any OS" : hos.getUiName());
        BitSize jvmBits = this.mArchFilter.getJvmBits();
        if (jvmBits != null) {
            sb.append(", JVM ").append(jvmBits.getSize()).append("-bits");
        }
        if ((hostBits = this.mArchFilter.getJvmBits()) != null) {
            sb.append(", Host ").append(hostBits.getSize()).append("-bits");
        }
        return sb.toString();
    }

    public String toString() {
        String s2 = this.getShortDescription();
        if (s2 != null) {
            return s2;
        }
        return super.toString();
    }

    public String getShortDescription() {
        return String.format("Archive for %1$s", this.getOsDescription());
    }

    public boolean isCompatible() {
        ArchFilter current2 = ArchFilter.getCurrent();
        return this.mArchFilter.isCompatibleWith(current2);
    }

    @Override
    public int compareTo(Archive rhs) {
        if (this.mPackage != null && rhs != null) {
            return this.mPackage.compareTo(rhs.getParentPackage());
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.mArchFilter == null ? 0 : this.mArchFilter.hashCode());
        result2 = 31 * result2 + (this.mChecksum == null ? 0 : this.mChecksum.hashCode());
        result2 = 31 * result2 + (this.mChecksumType == null ? 0 : this.mChecksumType.hashCode());
        result2 = 31 * result2 + (int)(this.mSize ^ this.mSize >>> 32);
        result2 = 31 * result2 + (this.mUrl == null ? 0 : this.mUrl.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Archive)) {
            return false;
        }
        Archive other = (Archive)obj;
        if (!this.mArchFilter.equals(other.mArchFilter)) {
            return false;
        }
        if (!this.mChecksum.equals(other.mChecksum)) {
            return false;
        }
        if (this.mChecksumType == null ? other.mChecksumType != null : !this.mChecksumType.equals((Object)other.mChecksumType)) {
            return false;
        }
        if (this.mSize != other.mSize) {
            return false;
        }
        return !(this.mUrl == null ? other.mUrl != null : !this.mUrl.equals(other.mUrl));
    }
}

