/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.tool.sdkmanager;

import com.android.repository.api.PackageOperation;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.sdklib.tool.sdkmanager.SdkAction;
import com.android.sdklib.tool.sdkmanager.SdkManagerCliSettings;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;

public abstract class SdkPackagesAction
extends SdkAction {
    private static final String PKG_FILE_ARG = "--package_file=";
    private List<String> mPackages = new ArrayList<String>();

    SdkPackagesAction(SdkManagerCliSettings settings) {
        super(settings);
    }

    protected boolean applyPackageOperation(PackageOperation operation, ProgressIndicator progress) {
        return operation.prepare(progress.createSubProgress(0.5)) && operation.complete(progress.createSubProgress(1.0));
    }

    @Override
    boolean consumeArgument(String arg2, ProgressIndicator progress) {
        if (arg2.startsWith(PKG_FILE_ARG)) {
            String packageFile = arg2.substring(PKG_FILE_ARG.length());
            try {
                for (String path : Files.readAllLines(this.mSettings.getFileSystem().getPath(packageFile, new String[0]))) {
                    String trimmed = path.trim();
                    if (trimmed.isEmpty()) continue;
                    this.mPackages.add(trimmed);
                }
            }
            catch (IOException e2) {
                progress.logWarning(String.format("Invalid package file \"%s\" threw exception:%n%s%n", packageFile, e2));
            }
        } else if (!arg2.startsWith("--")) {
            this.mPackages.add(arg2);
        } else {
            return false;
        }
        return true;
    }

    public List<String> getPaths(RepoManager mgr) {
        return this.mPackages;
    }
}

