/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.tool.sdkmanager;

import com.android.annotations.concurrency.Slow;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.Uninstaller;
import com.android.sdklib.repository.installer.SdkInstallerUtil;
import com.android.sdklib.tool.sdkmanager.SdkAction;
import com.android.sdklib.tool.sdkmanager.SdkManagerCli;
import com.android.sdklib.tool.sdkmanager.SdkManagerCliSettings;
import com.android.sdklib.tool.sdkmanager.SdkPackagesAction;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

class UninstallAction
extends SdkPackagesAction {
    private static final String ACTION_ARG = "--uninstall";

    private UninstallAction(SdkManagerCliSettings settings) {
        super(settings);
    }

    @Override
    @Slow
    public void execute(ProgressIndicator progress) throws SdkManagerCli.CommandFailedException {
        this.getRepoManager().loadSynchronously(0L, progress.createSubProgress(0.1), null, this.mSettings);
        List<String> paths2 = this.getPaths(this.getRepoManager());
        double progressMax = 0.1;
        double progressIncrement = 0.9 / (double)paths2.size();
        for (String path : paths2) {
            LocalPackage p2 = this.getRepoManager().getPackages().getLocalPackages().get(path);
            if (p2 == null) {
                progress.logWarning("Unable to find package " + path);
            } else {
                Uninstaller uninstaller = SdkInstallerUtil.findBestInstallerFactory(p2, this.getSdkHandler()).createUninstaller(p2, this.getRepoManager());
                if (!this.applyPackageOperation(uninstaller, progress.createSubProgress(progressMax += progressIncrement))) {
                    throw new SdkManagerCli.CommandFailedException();
                }
            }
            progress.setFraction(progressMax);
        }
        progress.setFraction(1.0);
    }

    public static void register(Map<String, Function<SdkManagerCliSettings, SdkAction>> argToFactory) {
        argToFactory.put(ACTION_ARG, UninstallAction::new);
    }
}

