/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer;

import com.android.tools.apk.analyzer.Archive;
import com.android.tools.apk.analyzer.ArchiveContext;
import com.android.tools.apk.analyzer.ArchiveEntry;
import com.android.tools.apk.analyzer.ArchiveNode;
import com.android.tools.apk.analyzer.InnerArchiveEntry;
import com.android.tools.apk.analyzer.internal.ApkArchive;
import com.android.tools.apk.analyzer.internal.AppBundleArchive;
import com.android.tools.apk.analyzer.internal.ArchiveManagerImpl;
import com.android.tools.apk.analyzer.internal.InstantAppBundleArchive;
import com.android.utils.ILogger;
import com.android.utils.NullLogger;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;

public class Archives {
    public static ArchiveContext open(Path path) throws IOException {
        return Archives.open(path, NullLogger.getLogger());
    }

    public static ArchiveContext open(Path path, ILogger logger) throws IOException {
        ArchiveManagerImpl archiveManager = new ArchiveManagerImpl(logger);
        return archiveManager.openArchive(path);
    }

    public static ArchiveEntry getFirstManifestArchiveEntry(ArchiveNode input2) {
        if (input2.getData().getArchive() instanceof ApkArchive) {
            Archive archive = input2.getData().getArchive();
            return Archives.getTopLevelManifestEntry(input2, archive);
        }
        if (input2.getData().getArchive() instanceof InstantAppBundleArchive) {
            return input2.getChildren().stream().map(node -> {
                if (node.getData() instanceof InnerArchiveEntry) {
                    ArchiveEntry innerEntry = ((InnerArchiveEntry)node.getData()).asArchiveEntry();
                    return Archives.getTopLevelManifestEntry(node, innerEntry.getArchive());
                }
                return null;
            }).filter(Objects::nonNull).findFirst().orElse(null);
        }
        if (input2.getData().getArchive() instanceof AppBundleArchive) {
            AppBundleArchive appBundleArchive = (AppBundleArchive)input2.getData().getArchive();
            ArchiveNode baseDir = Archives.getChild(input2, appBundleArchive.getContentRoot().resolve("base/"));
            if (baseDir == null) {
                return null;
            }
            ArchiveNode manifestDir = Archives.getChild(baseDir, baseDir.getData().getPath().resolve("manifest/"));
            if (manifestDir == null) {
                return null;
            }
            ArchiveNode manifest = Archives.getChild(manifestDir, manifestDir.getData().getPath().resolve("AndroidManifest.xml"));
            if (manifest == null) {
                return null;
            }
            return manifest.getData();
        }
        return null;
    }

    private static ArchiveNode getChild(ArchiveNode input2, Path path) {
        return input2.getChildren().stream().filter(node -> node.getData().getPath().equals(path)).findFirst().orElse(null);
    }

    private static ArchiveEntry getTopLevelManifestEntry(ArchiveNode input2, Archive archive) {
        Path path = archive.getContentRoot().resolve("AndroidManifest.xml");
        return input2.getChildren().stream().filter(x2 -> x2.getData().getPath().equals(path)).map(ArchiveNode::getData).findFirst().orElse(null);
    }
}

