/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.dex;

import com.android.tools.apk.analyzer.dex.tree.DexClassNode;
import com.android.tools.apk.analyzer.dex.tree.DexElementNode;
import com.android.tools.apk.analyzer.dex.tree.DexElementNodeFactory;
import com.android.tools.apk.analyzer.dex.tree.DexFieldNode;
import com.android.tools.apk.analyzer.dex.tree.DexMethodNode;
import com.android.tools.apk.analyzer.dex.tree.DexPackageNode;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedClassDef;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedField;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedMethod;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedMethodImplementation;
import com.android.tools.smali.dexlib2.dexbacked.reference.DexBackedFieldReference;
import com.android.tools.smali.dexlib2.dexbacked.reference.DexBackedMethodReference;
import com.android.tools.smali.dexlib2.dexbacked.reference.DexBackedTypeReference;
import com.android.tools.smali.dexlib2.iface.Annotation;
import com.android.tools.smali.dexlib2.iface.AnnotationElement;
import com.android.tools.smali.dexlib2.iface.instruction.DualReferenceInstruction;
import com.android.tools.smali.dexlib2.iface.instruction.Instruction;
import com.android.tools.smali.dexlib2.iface.instruction.ReferenceInstruction;
import com.android.tools.smali.dexlib2.iface.reference.FieldReference;
import com.android.tools.smali.dexlib2.iface.reference.MethodReference;
import com.android.tools.smali.dexlib2.iface.reference.Reference;
import com.android.tools.smali.dexlib2.iface.reference.TypeReference;
import com.android.tools.smali.dexlib2.iface.value.AnnotationEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.ArrayEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.EncodedValue;
import com.android.tools.smali.dexlib2.iface.value.EnumEncodedValue;
import com.android.tools.smali.dexlib2.iface.value.TypeEncodedValue;
import com.android.tools.smali.dexlib2.immutable.reference.ImmutableReference;
import com.android.tools.smali.dexlib2.immutable.reference.ImmutableReferenceFactory;
import com.android.tools.smali.dexlib2.immutable.reference.ImmutableTypeReference;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DexReferences {
    private final Multimap<Reference, ImmutableReference> referenceReferences = HashMultimap.create();
    public static final Comparator<DexElementNode> NODE_COMPARATOR = Comparator.comparing(o2 -> {
        if (o2 instanceof DexClassNode) {
            return o2.getName();
        }
        if (o2 instanceof DexMethodNode) {
            assert (o2.getReference() != null);
            return ((MethodReference)o2.getReference()).getDefiningClass() + " " + o2.getName();
        }
        if (o2 instanceof DexFieldNode) {
            assert (o2.getReference() != null);
            return ((FieldReference)o2.getReference()).getDefiningClass() + " " + o2.getName();
        }
        return "";
    });

    public DexReferences(DexBackedDexFile[] files2) {
        this.gatherBackReferences(files2);
    }

    private void gatherBackReferences(DexBackedDexFile[] files2) {
        HashMap<Reference, ImmutableReference> immutableReferencesBin = new HashMap<Reference, ImmutableReference>();
        for (DexBackedDexFile file2 : files2) {
            Object typeRef;
            int i2;
            HashMap<String, ImmutableTypeReference> typesByName = new HashMap<String, ImmutableTypeReference>();
            int m4 = file2.getTypeSection().size();
            for (i2 = 0; i2 < m4; ++i2) {
                ImmutableTypeReference immutableTypeRef = ImmutableTypeReference.of((TypeReference)new DexBackedTypeReference(file2, i2));
                typesByName.put(immutableTypeRef.getType(), immutableTypeRef);
            }
            m4 = file2.getMethodSection().size();
            for (i2 = 0; i2 < m4; ++i2) {
                DexBackedMethodReference methodReference = new DexBackedMethodReference(file2, i2);
                typeRef = (ImmutableReference)typesByName.get(methodReference.getReturnType());
                this.addReference((Reference)typeRef, (Reference)methodReference, immutableReferencesBin);
                for (CharSequence parameterType : methodReference.getParameterTypes()) {
                    typeRef = (ImmutableReference)typesByName.get(parameterType.toString());
                    this.addReference((Reference)typeRef, (Reference)methodReference, immutableReferencesBin);
                }
            }
            for (DexBackedClassDef classDef : file2.getClasses()) {
                ImmutableReference typeRef2 = (ImmutableReference)typesByName.get(classDef.getSuperclass());
                this.addReference((Reference)typeRef2, (Reference)classDef, immutableReferencesBin);
                for (String iface : classDef.getInterfaces()) {
                    typeRef2 = (ImmutableReference)typesByName.get(iface);
                    this.addReference((Reference)typeRef2, (Reference)classDef, immutableReferencesBin);
                }
                for (Annotation annotation : classDef.getAnnotations()) {
                    this.addAnnotation(immutableReferencesBin, typesByName, (Reference)classDef, annotation);
                }
                for (DexBackedMethod method : classDef.getMethods()) {
                    DexBackedMethodImplementation impl = method.getImplementation();
                    if (impl != null) {
                        for (Instruction instruction : impl.getInstructions()) {
                            Reference reference;
                            if (instruction instanceof ReferenceInstruction) {
                                reference = ((ReferenceInstruction)instruction).getReference();
                                this.addReferenceAndEnclosingClass(immutableReferencesBin, typesByName, (Reference)method, reference);
                            }
                            if (!(instruction instanceof DualReferenceInstruction)) continue;
                            reference = ((DualReferenceInstruction)instruction).getReference2();
                            this.addReferenceAndEnclosingClass(immutableReferencesBin, typesByName, (Reference)method, reference);
                        }
                    }
                    for (Annotation annotation : method.getAnnotations()) {
                        this.addAnnotation(immutableReferencesBin, typesByName, (Reference)method, annotation);
                    }
                }
                for (DexBackedField field : classDef.getFields()) {
                    for (Annotation annotation : field.getAnnotations()) {
                        this.addAnnotation(immutableReferencesBin, typesByName, (Reference)field, annotation);
                    }
                }
            }
            m4 = file2.getFieldSection().size();
            for (i2 = 0; i2 < m4; ++i2) {
                DexBackedFieldReference fieldRef = new DexBackedFieldReference(file2, i2);
                typeRef = (ImmutableReference)typesByName.get(fieldRef.getType());
                this.addReference((Reference)typeRef, (Reference)fieldRef, immutableReferencesBin);
            }
        }
    }

    private void addAnnotation(Map<Reference, ImmutableReference> immutableReferencesBin, Map<String, ImmutableTypeReference> typesByName, Reference ref, Annotation annotation) {
        ImmutableReference typeRef = (ImmutableReference)typesByName.get(annotation.getType());
        this.addReference((Reference)typeRef, ref, immutableReferencesBin);
        Set elements = annotation.getElements();
        for (AnnotationElement element : elements) {
            EncodedValue value = element.getValue();
            this.addEncodedValue(immutableReferencesBin, typesByName, ref, value);
        }
    }

    private void addEncodedValue(Map<Reference, ImmutableReference> immutableReferencesBin, Map<String, ImmutableTypeReference> typesByName, Reference ref, EncodedValue value) {
        if (value instanceof AnnotationEncodedValue) {
            ImmutableTypeReference typeRef = typesByName.get(((AnnotationEncodedValue)value).getType());
            this.addReference((Reference)typeRef, ref, immutableReferencesBin);
            for (AnnotationElement element : ((AnnotationEncodedValue)value).getElements()) {
                this.addEncodedValue(immutableReferencesBin, typesByName, ref, element.getValue());
            }
        } else if (value instanceof ArrayEncodedValue) {
            for (EncodedValue encodedValue : ((ArrayEncodedValue)value).getValue()) {
                this.addEncodedValue(immutableReferencesBin, typesByName, ref, encodedValue);
            }
        } else if (value instanceof EnumEncodedValue) {
            this.addReferenceAndEnclosingClass(immutableReferencesBin, typesByName, ref, (Reference)((EnumEncodedValue)value).getValue());
        } else if (value instanceof TypeEncodedValue) {
            ImmutableTypeReference typeRef = typesByName.get(((TypeEncodedValue)value).getValue());
            this.addReference((Reference)typeRef, ref, immutableReferencesBin);
        }
    }

    private void addReferenceAndEnclosingClass(Map<Reference, ImmutableReference> immutableReferencesBin, Map<String, ImmutableTypeReference> typesByName, Reference ref, Reference memberReference) {
        this.addReference(memberReference, ref, immutableReferencesBin);
        if (memberReference instanceof MethodReference) {
            this.addReference((Reference)typesByName.get(((MethodReference)memberReference).getDefiningClass()), ref, immutableReferencesBin);
        } else if (memberReference instanceof FieldReference) {
            this.addReference((Reference)typesByName.get(((FieldReference)memberReference).getDefiningClass()), ref, immutableReferencesBin);
        }
    }

    private void addReference(Reference ref1, Reference ref2, Map<Reference, ImmutableReference> immutableReferencesBin) {
        ImmutableReference immutableRef2;
        ImmutableReference immutableRef1 = immutableReferencesBin.get(ref1);
        if (immutableRef1 == null) {
            immutableRef1 = ImmutableReferenceFactory.of((Reference)ref1);
            immutableReferencesBin.put((Reference)immutableRef1, immutableRef1);
        }
        if ((immutableRef2 = immutableReferencesBin.get(ref2)) == null) {
            immutableRef2 = ImmutableReferenceFactory.of((Reference)ref2);
            immutableReferencesBin.put((Reference)immutableRef2, immutableRef2);
        }
        if (immutableRef1 instanceof TypeReference) {
            String definingType2 = null;
            if (immutableRef2 instanceof MethodReference) {
                definingType2 = ((MethodReference)immutableRef2).getDefiningClass();
            } else if (immutableRef2 instanceof FieldReference) {
                definingType2 = ((FieldReference)immutableRef2).getDefiningClass();
            }
            if (((TypeReference)immutableRef1).getType().equals(definingType2)) {
                return;
            }
        }
        this.referenceReferences.put((Reference)immutableRef1, immutableRef2);
    }

    public DexElementNode getReferenceTreeFor(Reference referenced) {
        return this.getReferenceTreeFor(referenced, false);
    }

    public DexElementNode getReferenceTreeFor(Reference referenced, boolean shallow) {
        DexElementNode rootNode = DexElementNodeFactory.from(ImmutableReferenceFactory.of((Reference)referenced));
        this.addReferencesForNode(rootNode, shallow);
        rootNode.sort(NODE_COMPARATOR);
        return rootNode;
    }

    public void addReferencesForNode(DexElementNode node, boolean shallow) {
        Reference referenced = node.getReference();
        node.removeAllChildren();
        Collection<ImmutableReference> references = this.referenceReferences.get(referenced);
        for (ImmutableReference ref : references) {
            if (!(ref instanceof MethodReference) && !(ref instanceof TypeReference) && !(ref instanceof FieldReference)) continue;
            boolean hasCycle = false;
            for (DexElementNode parentNode = node; parentNode != null; parentNode = parentNode.getParent()) {
                if (!ref.equals(parentNode.getReference())) continue;
                hasCycle = true;
            }
            if (hasCycle) continue;
            DexElementNode newNode = DexElementNodeFactory.from(ref);
            node.setAllowsChildren(true);
            node.add(newNode);
            if (!shallow) {
                this.addReferencesForNode(newNode, false);
                continue;
            }
            newNode.setAllowsChildren(true);
            newNode.add(new DexPackageNode("", null));
        }
    }

    public static boolean isAlreadyLoaded(DexElementNode node) {
        return node.getChildCount() != 1 || !(node.getFirstChild() instanceof DexPackageNode);
    }
}

