/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.dex;

import com.android.tools.apk.analyzer.dex.ProguardMappings;
import com.android.tools.apk.analyzer.dex.tree.DexClassNode;
import com.android.tools.apk.analyzer.dex.tree.DexElementNode;
import com.android.tools.apk.analyzer.dex.tree.DexFieldNode;
import com.android.tools.apk.analyzer.dex.tree.DexMethodNode;
import com.android.tools.apk.analyzer.dex.tree.DexPackageNode;
import com.android.tools.apk.analyzer.internal.SigUtils;
import com.android.tools.proguard.ProguardMap;
import com.android.tools.proguard.ProguardUsagesMap;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedClassDef;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedField;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedMethod;
import com.android.tools.smali.dexlib2.dexbacked.reference.DexBackedFieldReference;
import com.android.tools.smali.dexlib2.dexbacked.reference.DexBackedMethodReference;
import com.android.tools.smali.dexlib2.dexbacked.reference.DexBackedTypeReference;
import com.android.tools.smali.dexlib2.iface.reference.FieldReference;
import com.android.tools.smali.dexlib2.iface.reference.MethodReference;
import com.android.tools.smali.dexlib2.iface.reference.TypeReference;
import com.android.tools.smali.dexlib2.immutable.reference.ImmutableFieldReference;
import com.android.tools.smali.dexlib2.immutable.reference.ImmutableMethodReference;
import com.android.tools.smali.dexlib2.util.ReferenceUtil;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.tree.DefaultMutableTreeNode;

public class PackageTreeCreator {
    public static final String PARAMS_DELIMITER = ",";
    private final ProguardMap proguardMap;
    private final ProguardUsagesMap usagesMap;

    public PackageTreeCreator(ProguardMappings proguardMappings, boolean deobfuscateNames) {
        this.proguardMap = deobfuscateNames && proguardMappings != null ? proguardMappings.map : null;
        this.usagesMap = proguardMappings == null ? null : proguardMappings.usage;
    }

    private static Multimap<String, MethodReference> getAllMethodReferencesByClassName(DexBackedDexFile dexFile) {
        ArrayListMultimap<String, MethodReference> methodsByClass = ArrayListMultimap.create();
        int m4 = dexFile.getMethodSection().size();
        for (int i2 = 0; i2 < m4; ++i2) {
            DexBackedMethodReference methodRef = new DexBackedMethodReference(dexFile, i2);
            methodsByClass.put(methodRef.getDefiningClass(), (MethodReference)methodRef);
        }
        return methodsByClass;
    }

    private static Multimap<String, FieldReference> getAllFieldReferencesByClassName(DexBackedDexFile dexFile) {
        ArrayListMultimap<String, FieldReference> fieldsByClass = ArrayListMultimap.create();
        int m4 = dexFile.getFieldSection().size();
        for (int i2 = 0; i2 < m4; ++i2) {
            DexBackedFieldReference fieldRef = new DexBackedFieldReference(dexFile, i2);
            fieldsByClass.put(fieldRef.getDefiningClass(), (FieldReference)fieldRef);
        }
        return fieldsByClass;
    }

    private static Map<String, TypeReference> getAllTypeReferencesByClassName(DexBackedDexFile dexFile) {
        HashMap<String, TypeReference> typesByName = new HashMap<String, TypeReference>();
        int m4 = dexFile.getTypeSection().size();
        for (int i2 = 0; i2 < m4; ++i2) {
            DexBackedTypeReference typeRef = new DexBackedTypeReference(dexFile, i2);
            typesByName.put(typeRef.getType(), (TypeReference)typeRef);
        }
        return typesByName;
    }

    public DexPackageNode constructPackageTree(Map<Path, DexBackedDexFile> dexFiles) {
        DexPackageNode root = new DexPackageNode("root", null);
        for (Map.Entry<Path, DexBackedDexFile> dexFile : dexFiles.entrySet()) {
            this.constructPackageTree(root, dexFile.getKey(), dexFile.getValue());
        }
        return root;
    }

    public DexPackageNode constructPackageTree(DexBackedDexFile dexFile) {
        DexPackageNode root = new DexPackageNode("root", null);
        this.constructPackageTree(root, null, dexFile);
        return root;
    }

    public void constructPackageTree(DexPackageNode root, Path dexFilePath, DexBackedDexFile dexFile) {
        String cleanClassName;
        Object classNode;
        TypeReference typeRef;
        Multimap<String, MethodReference> methodRefsByClassName = PackageTreeCreator.getAllMethodReferencesByClassName(dexFile);
        Multimap<String, FieldReference> fieldRefsByClassName = PackageTreeCreator.getAllFieldReferencesByClassName(dexFile);
        Map<String, TypeReference> typeRefsByName = PackageTreeCreator.getAllTypeReferencesByClassName(dexFile);
        for (DexBackedClassDef dexBackedClassDef : dexFile.getClasses()) {
            for (DexBackedMethod method : dexBackedClassDef.getMethods()) {
                methodRefsByClassName.remove(dexBackedClassDef.getType(), method);
            }
            for (DexBackedField field : dexBackedClassDef.getFields()) {
                fieldRefsByClassName.remove(dexBackedClassDef.getType(), field);
            }
        }
        for (DexBackedClassDef dexBackedClassDef : dexFile.getClasses()) {
            typeRef = typeRefsByName.get(dexBackedClassDef.getType());
            String className = PackageTreeCreator.decodeClassName(dexBackedClassDef.getType(), this.proguardMap);
            classNode = root.getOrCreateClass("", className, typeRef);
            ((DefaultMutableTreeNode)classNode).setUserObject(dexFilePath);
            ((DexElementNode)classNode).setDefined(true);
            ((DexClassNode)classNode).setSize(((DexClassNode)classNode).getSize() + (long)dexBackedClassDef.getSize());
            this.addMethods((DexClassNode)classNode, dexBackedClassDef.getMethods(), dexFilePath);
            this.addFields((DexClassNode)classNode, dexBackedClassDef.getFields(), dexFilePath);
        }
        for (String string2 : methodRefsByClassName.keySet()) {
            typeRef = typeRefsByName.get(string2);
            cleanClassName = PackageTreeCreator.decodeClassName(string2, this.proguardMap);
            classNode = root.getOrCreateClass("", cleanClassName, typeRef);
            this.addMethods((DexClassNode)classNode, methodRefsByClassName.get(string2), dexFilePath);
        }
        for (String string3 : fieldRefsByClassName.keySet()) {
            typeRef = typeRefsByName.get(string3);
            cleanClassName = PackageTreeCreator.decodeClassName(string3, this.proguardMap);
            classNode = root.getOrCreateClass("", cleanClassName, typeRef);
            this.addFields((DexClassNode)classNode, fieldRefsByClassName.get(string3), dexFilePath);
        }
        if (this.usagesMap != null) {
            for (String string4 : this.usagesMap.getClasses()) {
                DexClassNode classNode2 = root.getOrCreateClass("", string4, null);
                classNode2.setDefined(false);
                classNode2.setRemoved(true);
            }
            Multimap<String, String> removedMethodsByClass = this.usagesMap.getMethodsByClass();
            for (String className : removedMethodsByClass.keySet()) {
                DexClassNode classNode3 = root.getOrCreateClass("", className, null);
                for (String removedMethodName : removedMethodsByClass.get(className)) {
                    DexMethodNode methodNode = new DexMethodNode(removedMethodName, null);
                    methodNode.setDefined(false);
                    methodNode.setRemoved(true);
                    classNode3.add(methodNode);
                }
            }
            Multimap<String, String> multimap = this.usagesMap.getFieldsByClass();
            for (String className : multimap.keySet()) {
                classNode = root.getOrCreateClass("", className, null);
                for (String removedFieldName : multimap.get(className)) {
                    DexFieldNode fieldNode = new DexFieldNode(removedFieldName, null);
                    fieldNode.setDefined(false);
                    fieldNode.setRemoved(true);
                    ((DefaultMutableTreeNode)classNode).add(fieldNode);
                }
            }
        }
        root.update();
        root.sort(Comparator.comparing(DexElementNode::getMethodReferencesCount).reversed());
    }

    private void addMethods(DexClassNode classNode, Iterable<? extends MethodReference> methodRefs, Path dexFilePath) {
        for (MethodReference methodReference : methodRefs) {
            DexMethodNode methodNode;
            String methodName = PackageTreeCreator.decodeMethodName(methodReference, this.proguardMap);
            String returnType = PackageTreeCreator.decodeClassName(methodReference.getReturnType(), this.proguardMap);
            String params = PackageTreeCreator.decodeMethodParams(methodReference, this.proguardMap);
            String methodSig = returnType + " " + methodName + params;
            if (methodSig.startsWith("void <init>") || methodSig.startsWith("void <clinit>")) {
                methodSig = methodName + params;
            }
            if ((methodNode = classNode.getChildByType(methodSig, DexMethodNode.class)) == null) {
                methodNode = new DexMethodNode(methodSig, ImmutableMethodReference.of((MethodReference)methodReference));
                classNode.add(methodNode);
            }
            if (methodReference instanceof DexBackedMethod) {
                methodNode.setDefined(true);
                methodNode.setUserObject(dexFilePath);
                methodNode.setSize(methodNode.getSize() + (long)((DexBackedMethod)methodReference).getSize());
                continue;
            }
            if (!(methodReference instanceof DexBackedMethodReference)) continue;
            methodNode.setSize(methodNode.getSize() + (long)((DexBackedMethodReference)methodReference).getSize());
        }
    }

    private void addFields(DexClassNode classNode, Iterable<? extends FieldReference> fieldRefs, Path dexFilePath) {
        for (FieldReference fieldReference : fieldRefs) {
            String fieldName = PackageTreeCreator.decodeFieldName(fieldReference, this.proguardMap);
            String fieldType = PackageTreeCreator.decodeClassName(fieldReference.getType(), this.proguardMap);
            String fieldSig = fieldType + " " + fieldName;
            DexFieldNode fieldNode = classNode.getChildByType(fieldSig, DexFieldNode.class);
            if (fieldNode == null) {
                fieldNode = new DexFieldNode(fieldSig, ImmutableFieldReference.of((FieldReference)fieldReference));
                classNode.add(fieldNode);
            }
            if (fieldReference instanceof DexBackedField) {
                fieldNode.setDefined(true);
                fieldNode.setUserObject(dexFilePath);
                fieldNode.setSize(fieldNode.getSize() + (long)((DexBackedField)fieldReference).getSize());
                continue;
            }
            if (!(fieldReference instanceof DexBackedFieldReference)) continue;
            fieldNode.setSize(fieldNode.getSize() + (long)((DexBackedFieldReference)fieldReference).getSize());
        }
    }

    public static String decodeFieldName(FieldReference fieldRef, ProguardMap proguardMap) {
        String fieldName = fieldRef.getName();
        if (proguardMap != null) {
            String className = PackageTreeCreator.decodeClassName(fieldRef.getDefiningClass(), proguardMap);
            fieldName = proguardMap.getFieldName(className, fieldName);
        }
        return fieldName;
    }

    public static String decodeMethodParams(MethodReference methodRef, ProguardMap proguardMap) {
        Stream<String> params = methodRef.getParameterTypes().stream().map(String::valueOf).map(SigUtils::signatureToName);
        if (proguardMap != null) {
            params = params.map(proguardMap::getClassName);
        }
        return "(" + params.collect(Collectors.joining(PARAMS_DELIMITER)) + ")";
    }

    public static String decodeMethodName(MethodReference methodRef, ProguardMap proguardMap) {
        if (proguardMap != null) {
            String className = proguardMap.getClassName(SigUtils.signatureToName(methodRef.getDefiningClass()));
            String methodName = methodRef.getName();
            String sigWithoutName = ReferenceUtil.getMethodDescriptor((MethodReference)methodRef, (boolean)true).substring(methodName.length());
            ProguardMap.Frame frame = proguardMap.getFrame(className, methodName, sigWithoutName, null, -1);
            return frame.methodName;
        }
        return methodRef.getName();
    }

    public static String decodeClassName(String className, ProguardMap proguardMap) {
        className = SigUtils.signatureToName(className);
        if (proguardMap != null) {
            className = proguardMap.getClassName(className);
        }
        return className;
    }
}

