/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.internal;

import com.android.tools.apk.analyzer.ApkSizeCalculator;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteStreams;
import com.google.common.io.CountingOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Map;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class GzipSizeCalculator
implements ApkSizeCalculator {
    public static final String VIRTUAL_ENTRY_NAME = "";

    private static void verify(Path apk) {
        try {
            ZipFile zf = new ZipFile(apk.toFile());
            zf.close();
        }
        catch (IOException e2) {
            throw new IllegalArgumentException("Cannot open apk: ", e2);
        }
    }

    @Override
    public long getFullApkDownloadSize(Path apk) {
        GzipSizeCalculator.verify(apk);
        CountingOutputStream out = new CountingOutputStream(ByteStreams.nullOutputStream());
        try (MaxGzipOutputStream zos = new MaxGzipOutputStream(out);){
            Files.copy(apk, zos);
            zos.flush();
        }
        catch (IOException e2) {
            return -1L;
        }
        return out.getCount();
    }

    @Override
    public long getFullApkRawSize(Path apk) {
        GzipSizeCalculator.verify(apk);
        try {
            return Files.size(apk);
        }
        catch (IOException e2) {
            Logger.getLogger(GzipSizeCalculator.class.getName()).severe("Error obtaining size of the APK: " + e2.toString());
            return -1L;
        }
    }

    @Override
    public Map<String, Long> getDownloadSizePerFile(Path apk) {
        GzipSizeCalculator.verify(apk);
        try {
            Path rezippedApk = Files.createTempFile("analyzer", ".zip", new FileAttribute[0]);
            GzipSizeCalculator.reCompressWithZip(apk, rezippedApk);
            Map<String, Long> compressedSizePerFile = GzipSizeCalculator.getCompressedSizePerFile(rezippedApk);
            Files.delete(rezippedApk);
            return compressedSizePerFile;
        }
        catch (IOException e2) {
            String msg = "Error while re-compressing apk to determine file by file download sizes: " + e2.toString();
            Logger.getLogger(GzipSizeCalculator.class.getName()).severe(msg);
            return ImmutableMap.of();
        }
    }

    @Override
    public Map<String, Long> getRawSizePerFile(Path apk) {
        GzipSizeCalculator.verify(apk);
        return GzipSizeCalculator.getCompressedSizePerFile(apk);
    }

    private static Map<String, Long> getCompressedSizePerFile(Path apk) {
        ImmutableMap.Builder<String, Long> sizes = new ImmutableMap.Builder<String, Long>();
        try (ZipFile zf = new ZipFile(apk.toFile());){
            Enumeration<? extends ZipEntry> entries2 = zf.entries();
            while (entries2.hasMoreElements()) {
                ZipEntry zipEntry = entries2.nextElement();
                if (GzipSizeCalculator.isVirtualEntry(zipEntry) || zipEntry.isDirectory()) continue;
                sizes.put("/" + zipEntry.getName(), zipEntry.getCompressedSize());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sizes.build();
    }

    private static void reCompressWithZip(Path from2, Path to) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(new BufferedInputStream(Files.newInputStream(from2, new OpenOption[0])));
             MaxZipOutputStream zos = new MaxZipOutputStream(new BufferedOutputStream(Files.newOutputStream(to, new OpenOption[0])));){
            ZipEntry ze;
            while ((ze = zis.getNextEntry()) != null) {
                if (GzipSizeCalculator.isVirtualEntry(ze)) continue;
                ZipEntry compressedZe = new ZipEntry(ze.getName());
                compressedZe.setMethod(8);
                compressedZe.setTime(ze.getTime());
                zos.putNextEntry(compressedZe);
                ByteStreams.copy(zis, zos);
            }
        }
    }

    public static boolean isVirtualEntry(ZipEntry e2) {
        return VIRTUAL_ENTRY_NAME.equals(e2.getName());
    }

    private static final class MaxGzipOutputStream
    extends GZIPOutputStream {
        public MaxGzipOutputStream(OutputStream out) throws IOException {
            super(out);
            this.def.setLevel(9);
        }
    }

    private static final class MaxZipOutputStream
    extends ZipOutputStream {
        public MaxZipOutputStream(OutputStream out) throws IOException {
            super(out);
            this.def.setLevel(9);
        }
    }
}

