/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.internal;

import com.google.common.collect.Iterators;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class ProguardMappingFiles {
    private static final String EXT = ".txt";
    private static final String MAPPING_BASE = "mapping";
    private static final String USAGE_BASE = "usage";
    private static final String SEEDS_BASE = "seeds";
    private static final String MAPPING_FILENAME = "mapping.txt";
    private static final String USAGE_FILENAME = "usage.txt";
    private static final String SEEDS_FILENAME = "seeds.txt";
    public final Path mappingFile;
    public final Path seedsFile;
    public final Path usageFile;

    public ProguardMappingFiles(Path mappingFile, Path seedsFile, Path usageFile) {
        this.mappingFile = mappingFile;
        this.seedsFile = seedsFile;
        this.usageFile = usageFile;
    }

    public static ProguardMappingFiles from(Path[] paths2) throws IOException {
        if (paths2.length == 0) {
            return new ProguardMappingFiles(null, null, null);
        }
        if (paths2.length > 1) {
            for (Path path : paths2) {
                if (!Files.isDirectory(path, new LinkOption[0])) continue;
                throw new IllegalArgumentException("Please select a folder or 1 to 3 files for loading Proguard mappings.");
            }
        }
        Path[] filesToCheck = null;
        if (Files.isDirectory(paths2[0], new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(paths2[0], "*{mapping,usage,seeds}*.txt");){
                filesToCheck = Iterators.toArray(stream.iterator(), Path.class);
            }
        } else {
            filesToCheck = paths2;
        }
        Path mappingFile = null;
        Path seedsFile = null;
        Path usageFile = null;
        for (Path file2 : filesToCheck) {
            if (mappingFile == null && file2.getFileName().toString().equals(MAPPING_FILENAME)) {
                mappingFile = file2;
            }
            if (seedsFile == null && file2.getFileName().toString().equals(SEEDS_FILENAME)) {
                seedsFile = file2;
            }
            if (usageFile != null || !file2.getFileName().toString().equals(USAGE_FILENAME)) continue;
            usageFile = file2;
        }
        if (mappingFile == null || usageFile == null || seedsFile == null) {
            for (Path file2 : filesToCheck) {
                if (mappingFile == null && file2.getFileName().toString().contains(MAPPING_BASE)) {
                    mappingFile = file2;
                } else if (usageFile == null && file2.getFileName().toString().contains(SEEDS_BASE)) {
                    usageFile = file2;
                } else if (seedsFile == null && file2.getFileName().toString().contains(USAGE_BASE)) {
                    seedsFile = file2;
                }
                if (mappingFile != null && usageFile != null && seedsFile != null) break;
            }
        }
        return new ProguardMappingFiles(mappingFile, seedsFile, usageFile);
    }
}

