/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.dom.attrs;

import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.tools.environment.Logger;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.text.StringsKt;

public final class AttributeDefinition
implements Cloneable {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final ResourceReference myAttr;
    private final String myLibraryName;
    private String myGlobalDescription;
    private String myGroupName;
    private Map<String, Integer> myValueMappings = Collections.emptyMap();
    private Map<String, String> myValueDescriptions = Collections.emptyMap();
    private Set<AttributeFormat> myFormats;
    private Map<ResourceReference, String> myDescriptionsInStyleableContexts;

    public AttributeDefinition(ResourceNamespace namespace, String name2) {
        this(namespace, name2, null, null);
    }

    public AttributeDefinition(ResourceNamespace namespace, String name2, String libraryName, Collection<AttributeFormat> formats) {
        assert (name2.indexOf(58) < 0);
        this.myAttr = ResourceReference.attr(namespace, name2);
        this.myLibraryName = libraryName;
        this.myFormats = formats == null || formats.isEmpty() ? EnumSet.noneOf(AttributeFormat.class) : EnumSet.copyOf(formats);
    }

    public AttributeDefinition(AttributeDefinition other) {
        this.myAttr = other.myAttr;
        this.myLibraryName = other.myLibraryName;
        this.myGlobalDescription = other.myGlobalDescription;
        this.myGroupName = other.myGroupName;
        this.myValueMappings = other.myValueMappings;
        this.myValueDescriptions = other.myValueDescriptions;
        this.myFormats = EnumSet.copyOf(other.myFormats);
        this.myDescriptionsInStyleableContexts = other.myDescriptionsInStyleableContexts == null ? null : new HashMap<ResourceReference, String>(other.myDescriptionsInStyleableContexts);
    }

    public Integer getValueMapping(String flagName) {
        return this.myValueMappings.get(flagName);
    }

    public ResourceReference getResourceReference() {
        return this.myAttr;
    }

    public String getName() {
        return this.myAttr.getName();
    }

    public String getLibraryName() {
        return this.myLibraryName;
    }

    public Set<AttributeFormat> getFormats() {
        return Collections.unmodifiableSet(this.myFormats);
    }

    public String getGroupName() {
        return this.myGroupName;
    }

    public String[] getValues() {
        return this.myValueMappings.isEmpty() ? EMPTY_STRING_ARRAY : this.myValueMappings.keySet().toArray(EMPTY_STRING_ARRAY);
    }

    public String getDescription(ResourceReference parentStyleable) {
        String description = parentStyleable == null || this.myDescriptionsInStyleableContexts == null ? null : this.myDescriptionsInStyleableContexts.get(parentStyleable);
        return description == null ? this.myGlobalDescription : description;
    }

    @Deprecated
    public String getDescriptionByParentStyleableName(String parentStyleable) {
        if (parentStyleable == null || this.myDescriptionsInStyleableContexts == null) {
            return this.myGlobalDescription;
        }
        String description = this.myDescriptionsInStyleableContexts.get(ResourceReference.styleable(ResourceNamespace.TODO(), parentStyleable));
        if (description == null) {
            description = this.myDescriptionsInStyleableContexts.get(ResourceReference.styleable(ResourceNamespace.ANDROID, parentStyleable));
        }
        return description == null ? this.myGlobalDescription : description;
    }

    public String getValueDescription(String value) {
        return this.myValueDescriptions.get(value);
    }

    public boolean isAttributeDeprecated() {
        return this.myGlobalDescription != null && StringsKt.contains((CharSequence)this.myGlobalDescription, "deprecated", true);
    }

    public boolean isValueDeprecated(String value) {
        String description = this.getValueDescription(value);
        return description != null && StringsKt.contains((CharSequence)description, "deprecated", true);
    }

    void addFormats(Collection<AttributeFormat> formats) {
        this.myFormats.addAll(formats);
    }

    public void setValueMappings(Map<String, Integer> valueMappings) {
        if (!this.myValueMappings.isEmpty() && !this.myValueMappings.equals(valueMappings)) {
            AttributeDefinition.getLog().warn("An attempt to redefine value mappings of " + this.myAttr.getQualifiedName());
        }
        this.myValueMappings = Collections.unmodifiableMap(valueMappings);
    }

    void setValueDescriptions(Map<String, String> valueDescriptions) {
        if (!this.myValueDescriptions.isEmpty() && !this.myValueDescriptions.equals(valueDescriptions)) {
            AttributeDefinition.getLog().warn("An attempt to redefine value descriptions of " + this.myAttr.getQualifiedName());
        }
        this.myValueDescriptions = Collections.unmodifiableMap(valueDescriptions);
    }

    void setGroupName(String groupName) {
        this.myGroupName = groupName;
    }

    void setDescription(String description, ResourceReference parentStyleable) {
        if (parentStyleable == null || this.myGlobalDescription == null) {
            this.myGlobalDescription = description;
        }
        if (parentStyleable != null) {
            if (this.myDescriptionsInStyleableContexts == null) {
                this.myDescriptionsInStyleableContexts = new HashMap<ResourceReference, String>(3);
            }
            this.myDescriptionsInStyleableContexts.put(parentStyleable, description);
        }
    }

    public String toString() {
        return this.myAttr.getQualifiedName() + " [" + this.myFormats + "]";
    }

    private static Logger getLog() {
        return Logger.getInstance(AttributeDefinition.class);
    }
}

